/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.RuntimePlatform;
import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import java.awt.AlphaComposite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;

public class WmiClipboardManager {
    private static final Point DRAG_IMAGE_OFFSET = new Point(5, 5);
    private static final FlavorMap DEFAULT_FLAVOR_MAP = new MathDocumentFlavorMap();
    private static final String MAC_NO_DROP_CURSOR_RESOURCE = "com/maplesoft/mathdoc/controller/edit/resources/mac_no_drop.tiff";
    private static Cursor MAC_NO_DROP = null;
    private static final String RESOURCE_PATH = "com/maplesoft/mathdoc/controller/edit/resources/Edit";
    private WmiResourcePackage bundle = WmiResourcePackage.getResourcePackage("com/maplesoft/mathdoc/controller/edit/resources/Edit");
    private static WmiMathDocumentView dragDoc = null;
    private static WmiPositionMarker dropLocation = null;
    private static boolean forceCopy = false;
    private static boolean isDragAndDropOperation = false;
    private DragSource dragSource = null;
    private DropTarget dropTarget = null;
    private DragGestureListener dragListener = null;
    DropTargetListener dropListener = null;
    DragGestureRecognizer dragGestureRecognizer = null;
    private boolean dragArmed = false;
    protected WmiMathDocumentView docView;

    private static Cursor createMacNoDropCursor() {
        Cursor c = null;
        if (RuntimePlatform.isMac()) {
            try {
                InputStream is = ResourceLoader.getResourceAsStream(MAC_NO_DROP_CURSOR_RESOURCE);
                MemoryCacheSeekableStream ss = new MemoryCacheSeekableStream(is);
                RenderedOp rendered = JAI.create((String)"stream", (Object)ss);
                BufferedImage buffy = new BufferedImage(rendered.getWidth(), rendered.getHeight(), 2);
                Graphics2D g2 = buffy.createGraphics();
                g2.drawRenderedImage((RenderedImage)rendered, new AffineTransform());
                g2.dispose();
                c = Toolkit.getDefaultToolkit().createCustomCursor(buffy, new Point(4, 4), "no drop");
            }
            catch (NoClassDefFoundError ncdfe) {
                c = Cursor.getDefaultCursor();
            }
            catch (Throwable t) {
                c = Cursor.getDefaultCursor();
            }
        }
        return c;
    }

    public WmiClipboardManager(WmiMathDocumentView docView) {
        this.docView = docView;
        if (!GraphicsEnvironment.isHeadless()) {
            this.dragSource = this.createDragSource();
            this.dropTarget = this.createDropTarget();
        }
    }

    public void release() {
        if (this.dragSource != null) {
            DragSourceListener[] listeners = this.dragSource.getDragSourceListeners();
            if (listeners != null) {
                int i = 0;
                while (i < listeners.length) {
                    this.dragSource.removeDragSourceListener(listeners[i]);
                    ++i;
                }
            }
            this.dragSource = null;
        }
        this.dragListener = null;
        if (this.dragGestureRecognizer != null) {
            this.dragGestureRecognizer.setComponent(null);
            this.dragGestureRecognizer = null;
        }
        if (this.dropTarget != null) {
            this.dropTarget.removeDropTargetListener(this.dropListener);
            this.dropTarget.setComponent(null);
            this.dropTarget = null;
            this.dropListener = null;
        }
        this.docView = null;
    }

    public Transferable createTransferable(boolean copySematics) {
        Transferable transfer = null;
        if (this.docView != null) {
            WmiSelection selection = this.docView.getSelection();
            WmiPositionMarker marker = this.docView.getPositionMarker();
            transfer = this.createTransferable(selection, marker, copySematics);
        }
        return transfer;
    }

    protected Transferable createTransferable(WmiSelection selection, WmiPositionMarker marker, boolean copySemantics) {
        Transferable transfer = null;
        return transfer;
    }

    public boolean paste() {
        boolean success = false;
        if (this.docView != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable t = clipboard.getContents(null);
            success = this.paste(t);
        }
        return success;
    }

    public boolean paste(Transferable t) {
        boolean success = false;
        return success;
    }

    protected boolean processDragOver(DropTargetDragEvent event) {
        return false;
    }

    public void armDragAndDrop(boolean state) {
        this.dragArmed = state;
    }

    public boolean isEnabled() {
        return this.dragArmed;
    }

    public DragSource createDragSource() {
        this.dragListener = new MathDocumentDragListener();
        DragSource source = DragSource.getDefaultDragSource();
        this.dragGestureRecognizer = source.createDefaultDragGestureRecognizer(this.docView, 3, this.dragListener);
        return source;
    }

    public DropTarget createDropTarget() {
        this.dropListener = new MathDocumentDropListener();
        DropTarget target = new DropTarget(this.docView, 3, this.dropListener, true, null);
        return target;
    }

    public FlavorMap getFlavorMap() {
        return DEFAULT_FLAVOR_MAP;
    }

    protected int determineOrdering(WmiPositionMarker marker, WmiSelection selection) {
        WmiHighlightPainter painter;
        int ordering = 0;
        WmiHighlightPainter wmiHighlightPainter = painter = selection != null ? selection.getSelectionHighlighter() : null;
        if (painter != null) {
            Rectangle selectionBounds = painter.getBounds();
            Rectangle markerBounds = marker.getBounds();
            int xpos = markerBounds.x + markerBounds.width / 2;
            if (marker instanceof WmiMathCaret) {
                WmiMathCaret mathCaret = (WmiMathCaret)marker;
                xpos = mathCaret.getUprightBottom();
            }
            int ypos = markerBounds.y + markerBounds.height / 2;
            int left = painter.getLeftBoundary(ypos);
            int right = painter.getRightBoundary(ypos);
            ordering = left > xpos ? -1 : (right < xpos && right >= 0 ? 1 : (left < 0 || right < 0 ? (ypos < selectionBounds.y ? -1 : 1) : 0));
        }
        return ordering;
    }

    protected void handleFileListDrop(DropTargetDropEvent dtde) {
    }

    public boolean isActiveDragAndDrop() {
        return isDragAndDropOperation;
    }

    public static Cursor getMoveCursor() {
        return DragSource.DefaultMoveDrop;
    }

    public static Cursor getCopyCursor() {
        return DragSource.DefaultCopyDrop;
    }

    public static Cursor getNoDropCursor() {
        Cursor c = DragSource.DefaultMoveNoDrop;
        if (RuntimePlatform.isMac()) {
            if (MAC_NO_DROP == null) {
                MAC_NO_DROP = WmiClipboardManager.createMacNoDropCursor();
            }
            c = MAC_NO_DROP;
        }
        return c;
    }

    protected class MathDocumentDragListener
    implements DragGestureListener,
    DragSourceListener {
        protected MathDocumentDragListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            if (WmiClipboardManager.this.isEnabled()) {
                Cursor cursor;
                Transferable t;
                block10: {
                    t = null;
                    dropLocation = null;
                    forceCopy = false;
                    WmiModel model = WmiClipboardManager.this.docView.getModel();
                    cursor = WmiClipboardManager.getMoveCursor();
                    try {
                        try {
                            WmiModelLock.readLock(model, true);
                            dragDoc = WmiClipboardManager.this.docView;
                            t = WmiClipboardManager.this.createTransferable(false);
                            WmiSelection selection = WmiClipboardManager.this.docView.getSelection();
                            if (selection != null && selection.isReadOnly()) {
                                cursor = WmiClipboardManager.getCopyCursor();
                                forceCopy = true;
                            }
                        }
                        catch (WmiNoReadAccessException nrae) {
                            WmiErrorLog.log(nrae);
                            WmiModelLock.readUnlock(model);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        WmiModelLock.readUnlock(model);
                        throw throwable;
                    }
                    WmiModelLock.readUnlock(model);
                }
                if (t != null) {
                    isDragAndDropOperation = true;
                    if (DragSource.isDragImageSupported()) {
                        Image img = this.createDragImage();
                        event.startDrag(RuntimePlatform.isWindows() ? null : cursor, img, DRAG_IMAGE_OFFSET, t, this);
                    } else {
                        event.startDrag(RuntimePlatform.isWindows() ? null : cursor, t, this);
                    }
                }
            }
        }

        public Image createDragImage() {
            BufferedImage image = null;
            if (WmiClipboardManager.this.docView != null) {
                WmiSelection selection = WmiClipboardManager.this.docView.getSelection();
                WmiHighlightPainter painter = selection != null ? selection.getSelectionHighlighter() : null;
                Rectangle selectionBounds = painter != null ? painter.getBounds() : null;
                Rectangle windowBounds = WmiClipboardManager.this.docView.getVisibleRegion();
                if (selectionBounds != null) {
                    int w = selectionBounds.width < windowBounds.width ? selectionBounds.width : windowBounds.width;
                    int h = selectionBounds.height < windowBounds.height ? selectionBounds.height : windowBounds.height;
                    image = new BufferedImage(w, h, 2);
                    Graphics2D g = (Graphics2D)((Image)image).getGraphics();
                    g.setComposite(AlphaComposite.getInstance(3, 0.7f));
                    g.translate(-selectionBounds.x, -selectionBounds.y);
                    WmiClipboardManager.this.docView.setSelection(null);
                    WmiPositionMarker saveMarker = WmiClipboardManager.this.docView.getPositionMarker();
                    WmiModel model = WmiClipboardManager.this.docView.getModel();
                    try {
                        WmiModelLock.readLock(model, true);
                        WmiClipboardManager.this.docView.setPositionMarker(null);
                        WmiClipboardManager.this.docView.paint(g);
                        WmiClipboardManager.this.docView.setSelection(selection);
                        WmiClipboardManager.this.docView.setPositionMarker(saveMarker);
                    }
                    finally {
                        WmiModelLock.readUnlock(model);
                    }
                    g.dispose();
                }
            }
            return image;
        }

        @Override
        public void dragEnter(DragSourceDragEvent event) {
        }

        @Override
        public void dragOver(DragSourceDragEvent event) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent event) {
        }

        @Override
        public void dragExit(DragSourceEvent event) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            block8: {
                if (event.getDropSuccess() && event.getDropAction() != 1 && event.getDropAction() != 0) {
                    WmiSelection selection;
                    if (dropLocation == null && (selection = WmiClipboardManager.this.docView.getSelection()) != null) {
                        selection.deleteSelection();
                    }
                } else {
                    WmiModel model = WmiClipboardManager.this.docView.getModel();
                    try {
                        try {
                            WmiModelLock.readLock(model, true);
                            WmiClipboardManager.this.docView.setSelection(null);
                        }
                        catch (Exception e) {
                            WmiErrorLog.log(e);
                            WmiModelLock.readUnlock(model);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        WmiModelLock.readUnlock(model);
                        throw throwable;
                    }
                    WmiModelLock.readUnlock(model);
                }
            }
            isDragAndDropOperation = false;
        }
    }

    public class MathDocumentDropListener
    implements DropTargetListener {
        protected WmiPositionMarker marker = null;

        protected boolean acceptOrRejectDrag(DropTargetDragEvent event) {
            boolean accept = false;
            if (this.canGrabFocus()) {
                if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    accept = true;
                } else {
                    Point pt = event.getLocation();
                    accept = this.acceptOrRejectDrag(pt);
                }
            }
            return accept;
        }

        protected boolean canGrabFocus() {
            Container c = WmiClipboardManager.this.docView;
            while (!(c instanceof Window)) {
                c = c.getParent();
            }
            return c.isDisplayable() && c.isFocusable() && c.isEnabled();
        }

        private boolean acceptOrRejectDrag(Point pt) {
            boolean accept = false;
            boolean locked = false;
            if (this.canGrabFocus()) {
                WmiMathDocumentModel docModel = (WmiMathDocumentModel)WmiClipboardManager.this.docView.getModel();
                try {
                    try {
                        if (!WmiModelLock.ownsWriteLock(docModel)) {
                            locked = WmiModelLock.readLock(docModel, true);
                        }
                        if (!docModel.isReadOnly()) {
                            this.updateMarkerPosition(pt);
                            if (this.marker != null) {
                                WmiModel model;
                                WmiPositionedView view = this.marker.getView();
                                WmiSelection selection = WmiClipboardManager.this.docView.getSelection();
                                WmiModel wmiModel = model = view != null ? view.getModel() : null;
                                if (docModel.isMutableModel(model)) {
                                    accept = true;
                                }
                            }
                        }
                    }
                    catch (WmiNoReadAccessException e) {
                        WmiErrorLog.log(e);
                        if (locked) {
                            WmiModelLock.readUnlock(docModel);
                        }
                    }
                }
                finally {
                    if (locked) {
                        WmiModelLock.readUnlock(docModel);
                    }
                }
            }
            return accept;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            int type;
            DropTargetContext c = event.getDropTargetContext();
            int n = type = forceCopy ? 1 : 3;
            if (this.acceptOrRejectDrag(event)) {
                event.acceptDrag(type);
                WmiClipboardManager.this.docView.setCursor(WmiClipboardManager.getMoveCursor());
            } else {
                event.rejectDrag();
                WmiClipboardManager.this.docView.setCursor(WmiClipboardManager.getNoDropCursor());
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            DropTargetContext c = event.getDropTargetContext();
            WmiClipboardManager.this.docView.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            if (this.acceptOrRejectDrag(event)) {
                int type = event.getDropAction();
                if (dragDoc != WmiClipboardManager.this.docView || forceCopy) {
                    type = 1;
                }
                if (!WmiClipboardManager.this.processDragOver(event)) {
                    DropTargetContext c = event.getDropTargetContext();
                    Cursor cursor = null;
                    switch (type) {
                        case 2: 
                        case 3: {
                            cursor = WmiClipboardManager.getMoveCursor();
                            break;
                        }
                        case 1: {
                            cursor = WmiClipboardManager.getCopyCursor();
                            break;
                        }
                        default: {
                            cursor = Cursor.getDefaultCursor();
                        }
                    }
                    WmiClipboardManager.this.docView.setCursor(cursor);
                    event.acceptDrag(type);
                }
            } else {
                DropTargetContext c = event.getDropTargetContext();
                Cursor cursor = WmiClipboardManager.getNoDropCursor();
                WmiClipboardManager.this.docView.setCursor(cursor);
                event.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            dropLocation = null;
            Transferable t = event.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrop(3);
                WmiClipboardManager.this.handleFileListDrop(event);
            } else if (this.acceptOrRejectDrag(event.getLocation())) {
                int type = event.getDropAction();
                if (forceCopy) {
                    type = 1;
                }
                event.acceptDrop(type);
                if (type != 1 && dragDoc == WmiClipboardManager.this.docView) {
                    this.updateMarkerPosition(event.getLocation());
                    dropLocation = this.marker;
                    boolean success = this.dropMove(t, dropLocation);
                    event.dropComplete(success);
                } else {
                    boolean success = false;
                    if (t != null && this.marker != null) {
                        block12: {
                            WmiModel model = WmiClipboardManager.this.docView.getModel();
                            try {
                                try {
                                    WmiModelLock.writeLock(model, true);
                                    WmiClipboardManager.this.docView.setSelection(null);
                                    this.updateMarkerPosition(event.getLocation());
                                    success = WmiClipboardManager.this.paste(t);
                                }
                                catch (Exception e) {
                                    WmiErrorLog.log(e);
                                    WmiModelLock.writeUnlock(model);
                                    break block12;
                                }
                            }
                            catch (Throwable throwable) {
                                WmiModelLock.writeUnlock(model);
                                throw throwable;
                            }
                            WmiModelLock.writeUnlock(model);
                        }
                        event.dropComplete(success);
                    }
                }
                WmiClipboardManager.this.docView.setCursor(Cursor.getDefaultCursor());
            }
            dragDoc = null;
            forceCopy = false;
        }

        private boolean dropMove(Transferable t, WmiPositionMarker dropLocation) {
            boolean success = false;
            WmiMathDocumentModel docModel = (WmiMathDocumentModel)WmiClipboardManager.this.docView.getModel();
            WmiSelection selection = WmiClipboardManager.this.docView.getSelection();
            int ordering = WmiClipboardManager.this.determineOrdering(dropLocation, selection);
            try {
                try {
                    WmiModelLock.writeLock(docModel, true);
                    String undoName = WmiClipboardManager.this.bundle.getStringForKey("edit.dragndrop.undo");
                    docModel.startUndoableEdit(undoName);
                    boolean isPasteAtCaret = WmiClipboardManager.this.docView.getPositionMarker() instanceof WmiCaret;
                    if (!isPasteAtCaret || ordering > 0) {
                        WmiClipboardManager.this.docView.setSelection(null);
                        WmiClipboardManager.this.docView.setPositionMarker(dropLocation);
                        success = WmiClipboardManager.this.paste(t);
                        if (selection != null && success) {
                            selection.deleteSelection();
                        }
                    } else if (ordering < 0) {
                        WmiPositionedView dropView = dropLocation.getView();
                        int dropOffset = dropLocation.getOffset();
                        if (selection != null) {
                            selection.deleteSelection();
                        }
                        WmiClipboardManager.this.docView.setSelection(null);
                        dropView.setPositionMarker(dropOffset);
                        success = WmiClipboardManager.this.paste(t);
                    }
                    docModel.update(null);
                    docModel.endUndoableEdit();
                }
                catch (Exception e) {
                    WmiErrorLog.log(e);
                    success = false;
                    WmiModelLock.writeUnlock(docModel);
                }
            }
            finally {
                WmiModelLock.writeUnlock(docModel);
            }
            return success;
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }

        protected void updateMarkerPosition(Point p) {
            WmiViewPosition pos = WmiViewUtil.findNearestView(WmiClipboardManager.this.docView, p);
            if (pos != null) {
                WmiPositionedView view = pos.getView();
                int offset = pos.getOffset();
                WmiModel model = view.getModel();
                try {
                    this.marker = WmiClipboardManager.this.docView.getPositionMarker();
                    if (this.marker != null) {
                        WmiClipboardManager.this.docView.repaint(this.marker.getBounds());
                    }
                    WmiModelLock.readLock(model, true);
                    view.setPositionMarker(offset);
                    this.marker = WmiClipboardManager.this.docView.getPositionMarker();
                    if (this.marker != null) {
                        Rectangle bounds = this.marker.getBounds();
                        WmiClipboardManager.this.docView.repaint(bounds);
                    }
                }
                finally {
                    WmiModelLock.readUnlock(model);
                }
            }
        }
    }

    protected static class MathDocumentFlavorMap
    implements FlavorMap {
        protected MathDocumentFlavorMap() {
        }

        public Map getFlavorsForNatives(String[] names) {
            HashMap<String, DataFlavor> m = new HashMap<String, DataFlavor>(2);
            DataFlavor flavor = DataFlavor.stringFlavor;
            m.put(flavor.getMimeType(), flavor);
            flavor = DataFlavor.javaFileListFlavor;
            m.put(flavor.getMimeType(), flavor);
            return m;
        }

        public Map getNativesForFlavors(DataFlavor[] names) {
            HashMap<DataFlavor, String> m = new HashMap<DataFlavor, String>(2);
            DataFlavor flavor = DataFlavor.stringFlavor;
            m.put(DataFlavor.stringFlavor, flavor.getMimeType());
            flavor = DataFlavor.javaFileListFlavor;
            m.put(DataFlavor.stringFlavor, flavor.getMimeType());
            return m;
        }
    }
}

