/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.components.WmiComboBox;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class WmiCommandProxy
extends WmiCommand {
    protected String commandClassName;
    protected String documentTypeTag;
    protected int type;
    protected boolean isBackground;
    protected boolean isUpdate;
    protected int lockType;
    protected int ignorableModifier;
    protected String resourcePath;
    protected boolean isConsuming;
    protected boolean needsInstance;
    static boolean doneSubclassCheck;
    private WmiCommand instance;

    private boolean matches(Method m1, Method m2) {
        Class<?>[] p2;
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        Class<?>[] p1 = m1.getParameterTypes();
        if (p1.length != (p2 = m2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < p1.length) {
            if (p1[i] != p2[i]) {
                return false;
            }
            ++i;
        }
        return m1.getReturnType() == m2.getReturnType();
    }

    private void subclassCheck() {
        Method[] proxyMethods = WmiCommandProxy.class.getDeclaredMethods();
        HashMap myMethods = new HashMap();
        int i = 0;
        while (i < proxyMethods.length) {
            String key = proxyMethods[i].getName();
            if (!myMethods.containsKey(key)) {
                myMethods.put(key, new LinkedList());
            }
            LinkedList choices = (LinkedList)myMethods.get(key);
            choices.add(proxyMethods[i]);
            ++i;
        }
        Method[] baseMethods = WmiCommand.class.getDeclaredMethods();
        int i2 = 0;
        while (i2 < baseMethods.length) {
            int mod = baseMethods[i2].getModifiers();
            if (!(Modifier.isAbstract(mod) || Modifier.isFinal(mod) || Modifier.isNative(mod) || Modifier.isPrivate(mod) || Modifier.isStatic(mod))) {
                String key = baseMethods[i2].getName();
                boolean found = false;
                if (myMethods.containsKey(key)) {
                    LinkedList choices = (LinkedList)myMethods.get(key);
                    for (Method candidate : choices) {
                        if (!this.matches(candidate, baseMethods[i2])) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    throw new Error("WmiCommandProxy is missing an implementation of " + baseMethods[i2]);
                }
            }
            ++i2;
        }
    }

    private WmiCommandProxy(WmiCommand instance) {
        super(instance.getName(), false, false);
        if (!doneSubclassCheck) {
            this.subclassCheck();
            doneSubclassCheck = true;
        }
        this.instance = instance;
        this.commandClassName = instance.getClass().toString();
    }

    public static WmiCommandProxy getProxyForCommand(WmiCommand cmd) {
        if (cmd instanceof WmiCommandProxy) {
            return (WmiCommandProxy)cmd;
        }
        return new WmiCommandProxy(cmd);
    }

    public WmiCommandProxy(String commandClassName, String name, String documentTypeTag, int type, boolean isBackground, boolean isUpdate, int lockType, int ignorableModifier, String resourcePath, boolean isConsuming) {
        super(name, false);
        if (!doneSubclassCheck) {
            this.subclassCheck();
            doneSubclassCheck = true;
        }
        this.commandClassName = commandClassName;
        this.documentTypeTag = documentTypeTag;
        this.type = type;
        this.isBackground = isBackground;
        this.isUpdate = isUpdate;
        this.lockType = lockType;
        this.ignorableModifier = ignorableModifier;
        this.resourcePath = resourcePath;
        this.isConsuming = isConsuming;
    }

    public WmiCommandProxy(String name, String cname, WmiResourcePackage bundle) {
        super(name, false, true, bundle);
        this.needsInstance = true;
        this.commandClassName = cname;
        this.documentTypeTag = this.getResource(9);
        if (!doneSubclassCheck) {
            this.subclassCheck();
            doneSubclassCheck = true;
        }
    }

    @Override
    public String getDocumentTypeTag() {
        if (this.instance != null) {
            this.documentTypeTag = this.getInstance().getDocumentTypeTag();
        }
        if (this.documentTypeTag == null) {
            return super.getDocumentTypeTag();
        }
        return this.documentTypeTag;
    }

    @Override
    public int getType() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().getType();
        }
        return this.type;
    }

    @Override
    public boolean isBackgroundTask() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().isBackgroundTask();
        }
        return this.isBackground;
    }

    @Override
    public boolean isUpdateCommand() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().isUpdateCommand();
        }
        return this.isUpdate;
    }

    @Override
    public boolean isSelected() {
        return this.getInstance().isSelected();
    }

    @Override
    public boolean isSelected(WmiMathDocumentView view) {
        return this.getInstance().isSelected(view);
    }

    @Override
    public int lockTypeRequired() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().lockTypeRequired();
        }
        return this.lockType;
    }

    @Override
    public boolean isEnabled(WmiView view) {
        return this.getInstance().isEnabled(view);
    }

    @Override
    public boolean waitsForInputLock() {
        return this.getInstance().waitsForInputLock();
    }

    @Override
    public boolean isInputEnabled() {
        return this.getInstance().isInputEnabled();
    }

    @Override
    public boolean shouldConsumeEvent() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().shouldConsumeEvent();
        }
        return this.isConsuming;
    }

    @Override
    protected int getIgnorableModifier() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().getIgnorableModifier();
        }
        return this.ignorableModifier;
    }

    @Override
    public void comboBoxItemLoader(WmiComboBox box, WmiModel forModel) {
        this.getInstance().comboBoxItemLoader(box, forModel);
    }

    @Override
    public void updateComboBoxSelection(WmiComboBox box, WmiModel model) {
        this.getInstance().updateComboBoxSelection(box, model);
    }

    @Override
    public void updateComboBoxSelection(WmiComboBox box, WmiView view) {
        this.getInstance().updateComboBoxSelection(box, view);
    }

    @Override
    public AbstractButton createButton(int buttonIconSize) {
        return this.getInstance().createButton(buttonIconSize);
    }

    @Override
    public AbstractButton createButton(int buttonIconSize, int preferredSize) {
        return this.getInstance().createButton(buttonIconSize, preferredSize);
    }

    @Override
    protected String getResourcePath() {
        if (this.instance != null || this.needsInstance) {
            return this.getInstance().getResourcePath();
        }
        return this.resourcePath;
    }

    @Override
    public void doCommand(ActionEvent event) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this.getInstance().doCommand(event);
    }

    @Override
    public JMenuItem createMenuItem() {
        return this.getInstance().createMenuItem();
    }

    @Override
    public JMenuItem createMenuItem(String itemText) {
        return this.getInstance().createMenuItem(itemText);
    }

    @Override
    public JMenuItem createMenuItem(String itemText, String altText) {
        return this.getInstance().createMenuItem(itemText, altText);
    }

    @Override
    public JMenuItem createMenuItem(JMenu menu) {
        return this.getInstance().createMenuItem(menu);
    }

    @Override
    public void addMenuListeners(JMenu menu, JMenuItem item) {
        this.getInstance().addMenuListeners(menu, item);
    }

    /*
     * Loose catch block
     */
    public WmiCommand getInstance() {
        if (this.instance == null) {
            boolean oldFlag = WmiCommand.isAutoRegisterEnabled();
            try {
                try {
                    WmiCommand.setAutoRegister(false);
                    Class<?> clazz = Class.forName(this.commandClassName);
                    this.instance = (WmiCommand)clazz.newInstance();
                }
                catch (IllegalAccessException iae) {
                    WmiErrorLog.log(iae);
                    WmiCommand.setAutoRegister(oldFlag);
                }
                catch (ClassNotFoundException cnfe) {
                    WmiErrorLog.log(cnfe);
                    WmiCommand.setAutoRegister(oldFlag);
                }
                catch (InstantiationException ie) {
                    WmiErrorLog.log(ie);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    WmiCommand.setAutoRegister(oldFlag);
                }
            }
            finally {
                WmiCommand.setAutoRegister(oldFlag);
            }
        }
        return this.instance;
    }

    @Override
    public boolean canQueue(String cmdName) {
        return this.getInstance().canQueue(cmdName);
    }
}

