/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class WmiDefaultKeyListener
implements KeyListener {
    private static boolean treatTabsAsChars;
    protected static final String DELETE_COMMAND = "edit.delete";
    protected static final String BACKSPACE_COMMAND = "edit.backspace";
    private static final char[] CODE_TO_CHAR_MAPPING;
    private char lastDeadKey = '\u0000';
    private boolean gotKeyTyped = false;

    static {
        WmiDefaultKeyListener.loadCommandsFromBundle("com/maplesoft/mathdoc/controller/navigation/resources/Navigation");
        WmiDefaultKeyListener.loadCommandsFromBundle("com/maplesoft/mathdoc/controller/edit/resources/Edit");
        WmiDefaultKeyListener.loadCommandsFromBundle("com/maplesoft/mathdoc/controller/insert/resources/Insert");
        treatTabsAsChars = false;
        char[] cArray = new char[16];
        cArray[0] = 96;
        cArray[1] = 180;
        cArray[2] = 94;
        cArray[3] = 126;
        cArray[4] = 713;
        cArray[5] = 728;
        cArray[6] = 729;
        cArray[7] = 168;
        cArray[8] = 730;
        cArray[9] = 733;
        cArray[10] = 711;
        cArray[11] = 184;
        cArray[12] = 731;
        CODE_TO_CHAR_MAPPING = cArray;
    }

    private static void loadCommandsFromBundle(String bundleName) {
        WmiResourcePackage bundle = WmiResourcePackage.getResourcePackage(bundleName);
        bundle.instantiateClasses();
    }

    protected WmiSelection getSelection(WmiView reference) {
        WmiModel model = reference.getModel();
        WmiSelection selection = null;
        try {
            WmiModelLock.readLock(model, true);
            WmiMathDocumentView docView = reference.getDocumentView();
            selection = docView.getSelection();
        }
        finally {
            WmiModelLock.readUnlock(model);
        }
        return selection;
    }

    protected boolean processChar(KeyEvent e, WmiView view) {
        boolean consume = true;
        if (!view.getDocumentView().getInputLock().isLocked()) {
            char ch = e.getKeyChar();
            if (ch == '\u007f') {
                WmiCommand.invokeCommand(DELETE_COMMAND);
            } else if (ch == '\b') {
                WmiCommand.invokeCommand(BACKSPACE_COMMAND);
            } else {
                consume = false;
            }
        }
        return consume;
    }

    protected KeyEvent mapFromInternationalKeyboard(KeyEvent e) {
        if (RuntimeLocale.isJapanese() && e.isShiftDown()) {
            boolean isShortcut;
            boolean bl = isShortcut = RuntimePlatform.isMac() ? e.isMetaDown() : e.isControlDown();
            if (isShortcut) {
                char altChar = '\u0000';
                int altCode = 0;
                if (e.getKeyChar() == '-' || e.getKeyCode() == 45) {
                    altChar = '=';
                    altCode = 61;
                }
                if (altChar != '\u0000') {
                    e.consume();
                    Object s = e.getSource();
                    Component source = null;
                    source = s instanceof WmiView ? ((WmiView)s).getDocumentView() : (s instanceof Component ? (Component)s : WmiMathDocumentView.getActiveDocumentView());
                    e = new KeyEvent(source, e.getID(), e.getWhen(), e.getModifiers() & 0xFFFFFFFE, altCode, altChar);
                    e.setSource(s);
                }
            }
        }
        return e;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        WmiCommandProxy command;
        if (!e.isConsumed() && !WmiDefaultKeyListener.isInputLocked(e) && (command = WmiCommand.getCommandProxy(e = this.mapFromInternationalKeyboard(e))) != null) {
            command.actionPerformed(new ActionEvent(e.getSource(), e.getModifiers(), command.toString()));
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (RuntimePlatform.isUnix()) {
            int code = e.getKeyCode();
            if (this.isDeadKey(code) && !this.gotKeyTyped) {
                char c = this.mapKeyCode(code);
                if (c == this.lastDeadKey) {
                    Component comp = null;
                    if (e.getSource() instanceof Component) {
                        comp = (Component)e.getSource();
                    } else if (e.getSource() instanceof WmiView) {
                        comp = ((WmiView)e.getSource()).getDocumentView();
                    }
                    KeyEvent e2 = new KeyEvent(comp, 400, e.getWhen(), e.getModifiers(), 0, this.lastDeadKey, 0);
                    e2.setSource(e.getSource());
                    this.keyTyped(e2);
                    this.lastDeadKey = '\u0000';
                } else {
                    this.lastDeadKey = c;
                }
            } else {
                this.lastDeadKey = '\u0000';
            }
        }
        this.notifyKeyReleased(e);
    }

    protected boolean isDeadKey(int code) {
        return 128 <= code && code <= 143;
    }

    protected char mapKeyCode(int code) {
        return CODE_TO_CHAR_MAPPING[code - 128];
    }

    protected void notifyKeyTyped(KeyEvent e) {
        this.gotKeyTyped = true;
    }

    protected void notifyKeyReleased(KeyEvent e) {
        this.gotKeyTyped = false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        WmiCommandProxy command = WmiCommand.getCommandProxy(e);
        if (command != null) {
            command.actionPerformed(new ActionEvent(e.getSource(), e.getModifiers(), command.toString()));
            e.consume();
        }
        if (!(e.isConsumed() || e.isControlDown() || e.isMetaDown() || !RuntimePlatform.isMac() && e.isAltDown())) {
            if (e.getKeyChar() == '\t' && !this.treatTabsAsChars()) {
                String commandName = e.isShiftDown() ? "focus.cycle.reverse" : "focus.cycle.forward";
                WmiCommand.invokeCommand(commandName);
                e.consume();
            } else {
                WmiMathDocumentView docView;
                WmiPositionMarker marker;
                Component srcComp;
                Container parent;
                Object source = e.getSource();
                WmiPositionedView view = null;
                if (source instanceof WmiPositionedView) {
                    view = (WmiPositionedView)source;
                } else if (source instanceof Component && (parent = (srcComp = (Component)source).getParent()) instanceof WmiMathDocumentView && (marker = (docView = (WmiMathDocumentView)parent).getPositionMarker()) != null) {
                    view = marker.getView();
                }
                if (view != null && view.getDocumentView() != null && !view.getDocumentView().getInputLock().isLocked() && this.processChar(e, view)) {
                    e.consume();
                }
            }
        }
        this.notifyKeyTyped(e);
    }

    protected static boolean isInputLocked(KeyEvent e) {
        Component srcComp;
        Container parent;
        boolean result = false;
        Object source = e.getSource();
        WmiMathDocumentView view = null;
        if (source instanceof WmiView) {
            view = ((WmiView)source).getDocumentView();
        } else if (source instanceof Component && (parent = (srcComp = (Component)source).getParent()) instanceof WmiMathDocumentView) {
            view = (WmiMathDocumentView)parent;
        }
        if (view != null) {
            result = view.getInputLock().isLocked();
        }
        return result;
    }

    protected boolean treatTabsAsChars() {
        return treatTabsAsChars;
    }

    public static void treatTabsAsChars(boolean set) {
        treatTabsAsChars = set;
    }
}

