/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiAbstractViewFactory;
import com.maplesoft.mathdoc.controller.WmiController;
import com.maplesoft.mathdoc.controller.WmiControllerBuilder;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewBuilder;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class WmiHashedViewFactory
extends WmiAbstractViewFactory {
    private HashMap viewMap;
    private HashMap controllerMap;

    @Override
    public WmiController getController(WmiView view) {
        WmiController controller = null;
        if (view != null) {
            WmiModel model = view.getModel();
            if (model != null) {
                WmiModelTag tag = model.getTag();
                WmiControllerBuilder builder = (WmiControllerBuilder)this.controllerMap.get(tag);
                if (builder != null) {
                    controller = builder.createController();
                }
            } else {
                throw new IllegalArgumentException("getController() received a view with a null model:" + view);
            }
        }
        return controller;
    }

    @Override
    protected void initialize() {
        this.viewMap = new HashMap();
        this.controllerMap = new HashMap();
    }

    @Override
    public void addViewMapping(WmiModelTag tag, WmiViewBuilder builder) {
        this.viewMap.put(tag, builder);
    }

    @Override
    public void addViewMapping(WmiModelTag tag, Constructor c) {
        this.viewMap.put(tag, c);
    }

    @Override
    public void addControllerMapping(WmiModelTag tag, WmiControllerBuilder builder) {
        this.controllerMap.put(tag, builder);
    }

    @Override
    protected Object getBuilder(WmiModelTag tag) {
        return this.viewMap.get(tag);
    }
}

