/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiAbstractViewFactory;
import com.maplesoft.mathdoc.controller.WmiController;
import com.maplesoft.mathdoc.controller.WmiControllerBuilder;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewBuilder;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class WmiIndexedViewFactory
extends WmiAbstractViewFactory {
    private ArrayList viewList;
    private ArrayList controllerList;

    @Override
    protected void initialize() {
        this.viewList = new ArrayList();
        this.controllerList = new ArrayList();
    }

    @Override
    protected Object getBuilder(WmiModelTag tag) {
        int id = tag.getID();
        Object builder = null;
        if (id >= 0 && id < this.viewList.size()) {
            builder = this.viewList.get(id);
        }
        return builder;
    }

    @Override
    public WmiController getController(WmiView view) {
        WmiControllerBuilder builder;
        WmiModelTag tag;
        int id;
        WmiModel model;
        WmiController controller = null;
        WmiModel wmiModel = model = view != null ? view.getModel() : null;
        if (model != null && (id = (tag = model.getTag()).getID()) < this.controllerList.size() && (builder = (WmiControllerBuilder)this.controllerList.get(id)) != null) {
            controller = builder.createController();
        }
        return controller;
    }

    @Override
    public void addViewMapping(WmiModelTag tag, WmiViewBuilder builder) {
        this.insert(this.viewList, tag, builder);
    }

    @Override
    public void addViewMapping(WmiModelTag tag, Constructor c) {
        this.insert(this.viewList, tag, c);
    }

    @Override
    public void addControllerMapping(WmiModelTag tag, WmiControllerBuilder builder) {
        assert (builder != null) : "invalid builder for " + tag;
        this.insert(this.controllerList, tag, builder);
    }

    private void insert(ArrayList list, WmiModelTag tag, Object value) {
        int id = tag.getID();
        int i = list.size();
        while (i <= id) {
            list.add(null);
            ++i;
        }
        list.set(id, value);
    }

    @Override
    public WmiViewFactory copyFactory() {
        WmiIndexedViewFactory factory = (WmiIndexedViewFactory)super.copyFactory();
        factory.viewList = (ArrayList)this.viewList.clone();
        factory.controllerList = (ArrayList)this.controllerList.clone();
        return factory;
    }

    @Override
    public void releaseFactory() {
        if (this.viewList != null) {
            this.viewList.clear();
            this.viewList = null;
        }
        if (this.controllerList != null) {
            this.controllerList.clear();
            this.controllerList = null;
        }
        super.releaseFactory();
    }
}

