/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.insert.WmiInsertTokenCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPathInterval;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputContext;
import java.awt.im.InputMethodHighlight;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

public class WmiInputMethodRequestHandler
implements InputMethodRequests,
InputMethodListener {
    private static String undoInsertText = null;
    private static String undoDeleteText = null;
    private static Map twoDEditorKeys = null;
    private static boolean IM_DEBUG = false;
    private WmiMathDocumentView docView;
    private WmiTextModel insertModel = null;
    private int insertOffset = 0;
    private WmiCompositeModel parentModel = null;
    private int parentIndex = -1;
    private int select = -1;
    private WmiComposedModel composedModel = null;
    private boolean isMath = false;
    private WmiModel leftChild = null;
    private WmiModel rightChild = null;

    static {
        try {
            WmiResourcePackage rb = WmiResourcePackage.getResourcePackage("com.maplesoft.mathdoc.view.resources.View");
            undoInsertText = rb.getStringForKey("InsertText.undo");
            undoDeleteText = rb.getStringForKey("DeleteText.undo");
        }
        catch (MissingResourceException e) {
            WmiErrorLog.log(e);
        }
        WmiInputMethodRequestHandler.initialize2DEditorKeys();
    }

    private static void initialize2DEditorKeys() {
        twoDEditorKeys = new HashMap();
        twoDEditorKeys.put(new Character('\uff3e'), "Insert.Msup");
        twoDEditorKeys.put(new Character('\uff3f'), "Insert.Msub");
        twoDEditorKeys.put(new Character('\uff0f'), "Insert.Mfrac");
        twoDEditorKeys.put(new Character('^'), "Insert.Msup");
        twoDEditorKeys.put(new Character('_'), "Insert.Msub");
        twoDEditorKeys.put(new Character('/'), "Insert.Mfrac");
        twoDEditorKeys.put(new Character('\u201d'), new Character('\"'));
        twoDEditorKeys.put(new Character('\uff1c'), new Character('<'));
        twoDEditorKeys.put(new Character('\uff1e'), new Character('>'));
        twoDEditorKeys.put(new Character('\uff1f'), new Character('?'));
        twoDEditorKeys.put(new Character('\uff1a'), new Character(':'));
        twoDEditorKeys.put(new Character('\uff1b'), new Character(';'));
        twoDEditorKeys.put(new Character('\u300c'), new Character('['));
        twoDEditorKeys.put(new Character('\u300d'), new Character(']'));
        twoDEditorKeys.put(new Character('\u300e'), new Character('{'));
        twoDEditorKeys.put(new Character('\u300f'), new Character('}'));
        twoDEditorKeys.put(new Character('\\'), new Character('\\'));
        twoDEditorKeys.put(new Character('\uff5c'), new Character('|'));
        twoDEditorKeys.put(new Character('\uff40'), new Character('`'));
        twoDEditorKeys.put(new Character('\uff01'), new Character('!'));
        twoDEditorKeys.put(new Character('\uff05'), new Character('%'));
        twoDEditorKeys.put(new Character('\uff06'), new Character('&'));
        twoDEditorKeys.put(new Character('\uff0a'), new Character('*'));
        twoDEditorKeys.put(new Character('\uff08'), new Character('('));
        twoDEditorKeys.put(new Character('\uff09'), new Character(')'));
        twoDEditorKeys.put(new Character('\uff1d'), new Character('='));
        twoDEditorKeys.put(new Character('\uff0b'), new Character('+'));
        twoDEditorKeys.put(new Character('\uff10'), new Character('0'));
        twoDEditorKeys.put(new Character('\uff11'), new Character('1'));
        twoDEditorKeys.put(new Character('\uff12'), new Character('2'));
        twoDEditorKeys.put(new Character('\uff13'), new Character('3'));
        twoDEditorKeys.put(new Character('\uff14'), new Character('4'));
        twoDEditorKeys.put(new Character('\uff15'), new Character('5'));
        twoDEditorKeys.put(new Character('\uff16'), new Character('6'));
        twoDEditorKeys.put(new Character('\uff17'), new Character('7'));
        twoDEditorKeys.put(new Character('\uff18'), new Character('8'));
        twoDEditorKeys.put(new Character('\uff19'), new Character('9'));
    }

    public WmiInputMethodRequestHandler(WmiMathDocumentView view) {
        this.docView = view;
    }

    private String printAttributes(AttributedCharacterIterator.Attribute[] att) {
        String s = "null";
        if (IM_DEBUG && att != null) {
            StringBuffer buffy = new StringBuffer();
            buffy.append('[');
            int i = 0;
            while (i < att.length) {
                buffy.append(att[i]);
                if (i < att.length - 1) {
                    buffy.append(',');
                }
                ++i;
            }
            buffy.append(']');
            s = buffy.toString();
        }
        return s;
    }

    private void imlog(String s) {
        if (IM_DEBUG) {
            System.out.println(s);
        }
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo offset) {
        int index = offset != null ? offset.getCharIndex() : 0;
        Rectangle caretBounds = null;
        WmiCaret caret = this.docView.getCaret();
        if (caret != null) {
            caretBounds = caret.getBounds();
            Point pt = this.docView.getLocationOnScreen();
            caretBounds.x += pt.x;
            caretBounds.y += pt.y;
        } else if (this.composedModel != null) {
            caretBounds = this.composedModel.getCaretBounds(index);
        }
        if (caretBounds == null) {
            caretBounds = new Rectangle();
        }
        if (IM_DEBUG) {
            System.out.println("getTextLocation returning [" + caretBounds.x + "," + caretBounds.y + "," + caretBounds.width + "," + caretBounds.height + "]");
        }
        return caretBounds;
    }

    @Override
    public TextHitInfo getLocationOffset(int x, int y) {
        this.imlog("*** getLocationOffset(" + x + "," + y + ")");
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        this.imlog("*** getInsertPositionOffset()");
        return 0;
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        if (IM_DEBUG) {
            System.out.println("*** getCommittedText(" + beginIndex + "," + endIndex + "," + this.printAttributes(attributes) + ")");
        }
        return null;
    }

    @Override
    public int getCommittedTextLength() {
        this.imlog("*** getCommittedTextLength()");
        return 0;
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        if (IM_DEBUG) {
            System.out.println("*** cancelLatestCommittedText(" + this.printAttributes(attributes) + ")");
        }
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        if (IM_DEBUG) {
            System.out.println("*** getSelectedText(" + this.printAttributes(attributes) + ")");
        }
        return null;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        boolean editable;
        WmiCaret caret;
        block29: {
            caret = this.docView.getCaret();
            editable = false;
            if (WmiModelLock.readLock(this.docView.getModel(), true)) {
                try {
                    try {
                        editable = caret != null && !caret.isReadOnly();
                    }
                    catch (WmiNoReadAccessException e) {
                        WmiErrorLog.log(e);
                        WmiModelLock.readUnlock(this.docView.getModel());
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    WmiModelLock.readUnlock(this.docView.getModel());
                    throw throwable;
                }
                WmiModelLock.readUnlock(this.docView.getModel());
            }
        }
        if (editable) {
            if (this.insertModel == null) {
                WmiPositionedView view = caret.getView();
                WmiModel model = view != null ? view.getModel() : null;
                this.isMath = model instanceof WmiMathModel;
            }
            int committed = event.getCommittedCharacterCount();
            AttributedCharacterIterator it = event.getText();
            Object equivalent = null;
            if (this.isMath) {
                if (it != null) {
                    char c = it.last();
                    equivalent = twoDEditorKeys.get(new Character(c));
                }
                if (equivalent != null) {
                    this.commitComposedText();
                    InputContext context = this.docView.getInputContext();
                    if (context != null) {
                        context.endComposition();
                    }
                    event.consume();
                    if (committed > 0) {
                        this.insert2DMathEquivalent(equivalent);
                    }
                }
            }
            if (!event.isConsumed()) {
                if (this.composedModel == null && committed > 0) {
                    if (this.isMath) {
                        WmiInsertTokenCommand.insertComposedText(this.getText(event), this.docView, undoInsertText);
                    } else {
                        this.textInsert(event);
                    }
                    event.consume();
                } else {
                    if (this.isMath && this.composedModel == null && it != null) {
                        WmiInsertTokenCommand.createComposedText(this.docView, undoInsertText);
                        this.beginEdit();
                    }
                    if (WmiModelLock.writeLock(this.docView.getModel(), true)) {
                        try {
                            try {
                                this.updateComposedText(event);
                            }
                            catch (WmiNoReadAccessException nrae) {
                                WmiErrorLog.log(nrae);
                                WmiModelLock.writeUnlock(this.docView.getModel());
                            }
                            catch (WmiNoWriteAccessException nwae) {
                                WmiErrorLog.log(nwae);
                                WmiModelLock.writeUnlock(this.docView.getModel());
                            }
                        }
                        finally {
                            WmiModelLock.writeUnlock(this.docView.getModel());
                        }
                    }
                }
            }
        } else {
            event.consume();
            InputContext context = this.docView.getInputContext();
            if (context != null) {
                context.endComposition();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void insert2DMathEquivalent(Object equivalent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void textInsert(InputMethodEvent event) {
        WmiPositionedView view;
        WmiCaret caret = this.docView.getCaret();
        WmiSelection selection = this.docView.getSelection();
        if (selection != null) {
            selection.replaceSelection(this.getText(event));
        } else if (caret != null && (view = caret.getView()) instanceof WmiTextView) {
            int offset = caret.getOffset();
            ((WmiTextView)view).insertString(this.getText(event), offset);
        }
    }

    private String getText(InputMethodEvent event) {
        String contents = null;
        AttributedCharacterIterator it = event.getText();
        char ch = it.first();
        int committed = event.getCommittedCharacterCount();
        if (committed == 1) {
            contents = Character.toString(ch);
        } else {
            StringBuffer sb = new StringBuffer();
            while (ch != '\uffff') {
                sb.append(ch);
                ch = it.next();
            }
            contents = sb.toString();
        }
        return contents;
    }

    private void updateComposedText(InputMethodEvent event) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int caretPos;
        TextHitInfo caretInfo = event.getCaret();
        int n = caretPos = caretInfo != null ? caretInfo.getCharIndex() : 0;
        if (RuntimePlatform.isMac() && RuntimePlatform.isJava15()) {
            ++caretPos;
        }
        AttributedCharacterIterator it = event.getText();
        int committed = event.getCommittedCharacterCount();
        boolean reset = true;
        if (it != null) {
            if (this.insertModel == null) {
                this.setupInsertModel();
            }
            if (this.insertModel != null) {
                this.beginEdit();
                if (this.composedModel == null) {
                    this.composedModel = new WmiComposedModel(this.insertModel.getDocument(), this.insertModel, this.insertOffset);
                } else {
                    this.composedModel.removeComposedTextFromParent();
                    this.composedModel.reset(false);
                }
            }
            this.composedModel.setPositionMarker(caretPos);
            if (this.insertModel != null && this.parentIndex >= 0) {
                reset = this.composedModel.update(it, committed);
                try {
                    int insertCount = this.composedModel.getChildCount();
                    int insertPos = this.parentIndex;
                    int i = 0;
                    while (i < insertCount) {
                        WmiTextModel child = (WmiTextModel)this.composedModel.getChild(i);
                        if (child.getText().length() > 0) {
                            this.parentModel.addChild(child, insertPos);
                            ++insertPos;
                        }
                        ++i;
                    }
                    if (!reset) {
                        WmiMathDocumentModel doc = this.composedModel.getDocument();
                        doc.update(undoInsertText);
                    }
                }
                catch (WmiModelIndexOutOfBoundsException e) {
                    WmiErrorLog.log(e);
                }
                catch (WmiNoUpdateAccessException e) {
                    WmiErrorLog.log(e);
                }
            }
            this.composedModel.updateCaretPosition();
            if (this.select != -1) {
                WmiTextModel child = null;
                child = (WmiTextModel)this.composedModel.getChild(this.select);
                WmiInputMethodPathInterval selection = new WmiInputMethodPathInterval(this.docView);
                selection.updateSelection(child, 0, child, child.getText().length());
                this.docView.setSelection(selection);
                this.select = -1;
            } else {
                this.docView.setSelection(null);
            }
        } else if (this.composedModel != null) {
            this.composedModel.removeComposedTextFromParent();
            this.composedModel.reset(true);
        }
        if (reset) {
            this.commitComposedText();
        }
        event.consume();
    }

    public void commitComposedText() {
        if (this.composedModel != null) {
            this.composedModel.finalCommit();
            WmiUndoManager undo = this.composedModel.getDocument().getUndoManager();
            undo.endEdit();
        }
        this.insertModel = null;
        this.parentModel = null;
        this.leftChild = null;
        this.rightChild = null;
        this.composedModel = null;
        this.parentIndex = -1;
        this.insertOffset = 0;
        this.select = -1;
    }

    private void setupInsertModel() {
        WmiCaret caret;
        WmiPositionedView view;
        WmiSelection selection = this.docView.getSelection();
        if (selection != null) {
            selection.deleteSelection();
        }
        if ((view = (caret = this.docView.getCaret()).getView()) instanceof WmiTextView) {
            this.insertModel = (WmiTextModel)view.getModel();
            this.insertOffset = caret.getOffset() + ((WmiTextView)view).getStartOffset();
        }
    }

    private void beginEdit() {
        WmiMathDocumentModel doc = (WmiMathDocumentModel)this.docView.getModel();
        WmiUndoManager undo = doc.getUndoManager();
        undo.beginEdit(undoInsertText);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
        this.imlog("*** caretPositionChanged");
    }

    public boolean isActive() {
        return this.insertModel != null;
    }

    static /* synthetic */ boolean access$11(WmiInputMethodRequestHandler wmiInputMethodRequestHandler) {
        return wmiInputMethodRequestHandler.isMath;
    }

    static /* synthetic */ String access$12() {
        return undoInsertText;
    }

    protected class WmiComposedModel
    extends WmiAbstractArrayCompositeModel {
        private WmiFontAttributeSet composedAttributes;
        private WmiFontAttributeSet convertedSelectedAttributes;
        private WmiFontAttributeSet convertedUnselectedAttributes;
        private WmiTextModel prefixModel;
        private WmiTextModel suffixModel;
        private WmiTextModel originalModel;
        private int caretPositionIndex;
        private boolean reset;

        private WmiComposedModel(WmiMathDocumentModel doc, WmiTextModel reference, int offset) {
            super(doc);
            this.composedAttributes = null;
            this.convertedSelectedAttributes = null;
            this.convertedUnselectedAttributes = null;
            this.prefixModel = null;
            this.suffixModel = null;
            this.originalModel = null;
            this.caretPositionIndex = 0;
            this.reset = false;
            this.initialize(reference, offset);
        }

        /*
         * Loose catch block
         */
        private void initialize(WmiTextModel model, int offset) {
            this.originalModel = model;
            WmiMathDocumentModel doc = this.originalModel.getDocument();
            try {
                try {
                    WmiModelLock.writeLock(doc, true);
                    WmiFontAttributeSet attr = (WmiFontAttributeSet)this.originalModel.getAttributesForRead();
                    this.composedAttributes = (WmiFontAttributeSet)attr.copyAttributes();
                    this.convertedSelectedAttributes = (WmiFontAttributeSet)attr.copyAttributes();
                    this.convertedUnselectedAttributes = (WmiFontAttributeSet)attr.copyAttributes();
                    WmiInputMethodRequestHandler.this.parentModel = this.originalModel.getParent();
                    this.composedAttributes.setExtendedStyle(256);
                    this.convertedSelectedAttributes.setExtendedStyle(1536);
                    this.convertedUnselectedAttributes.setExtendedStyle(512);
                    String str = this.getTextContents(this.originalModel);
                    String prefix = str.substring(0, offset);
                    String suffix = str.substring(offset);
                    this.prefixModel = this.createTextModel(prefix, this.originalModel, attr);
                    this.suffixModel = this.createTextModel(suffix, this.originalModel, attr);
                    this.appendChild(this.prefixModel);
                    this.appendChild(this.suffixModel);
                    WmiInputMethodRequestHandler.this.parentIndex = WmiInputMethodRequestHandler.this.parentModel.indexOf(this.originalModel);
                    if (WmiInputMethodRequestHandler.this.parentIndex > 0) {
                        WmiInputMethodRequestHandler.this.leftChild = WmiInputMethodRequestHandler.this.parentModel.getChild(WmiInputMethodRequestHandler.this.parentIndex - 1);
                    } else {
                        WmiInputMethodRequestHandler.this.leftChild = null;
                    }
                    if (WmiInputMethodRequestHandler.this.parentIndex < WmiInputMethodRequestHandler.this.parentModel.getChildCount() - 1) {
                        WmiInputMethodRequestHandler.this.rightChild = WmiInputMethodRequestHandler.this.parentModel.getChild(WmiInputMethodRequestHandler.this.parentIndex + 1);
                    } else {
                        WmiInputMethodRequestHandler.this.rightChild = null;
                    }
                    if (WmiInputMethodRequestHandler.this.parentIndex >= 0) {
                        WmiInputMethodRequestHandler.this.parentModel.removeChild(WmiInputMethodRequestHandler.this.parentIndex);
                    }
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    WmiModelLock.writeUnlock(doc);
                }
                catch (WmiNoWriteAccessException e) {
                    WmiErrorLog.log(e);
                    WmiModelLock.writeUnlock(doc);
                }
                catch (WmiModelIndexOutOfBoundsException e) {
                    WmiErrorLog.log(e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    WmiModelLock.writeUnlock(doc);
                }
            }
            finally {
                WmiModelLock.writeUnlock(doc);
            }
        }

        private String getTextContents(WmiTextModel textModel) throws WmiNoReadAccessException {
            return textModel.getText();
        }

        protected void reset(boolean deletedAllText) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            this.reset = deletedAllText;
            try {
                int currentLength = this.getChildCount();
                if (currentLength > 2) {
                    this.removeChildren(1, currentLength - 2);
                }
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        }

        protected void removeComposedTextFromParent() throws WmiNoReadAccessException, WmiNoWriteAccessException {
            if (WmiInputMethodRequestHandler.this.parentModel != null && WmiInputMethodRequestHandler.this.parentIndex >= 0) {
                try {
                    int currentLength = this.getChildCount();
                    if (currentLength > 0) {
                        int firstIndex = 0;
                        if (WmiInputMethodRequestHandler.this.leftChild != null) {
                            firstIndex = WmiInputMethodRequestHandler.this.parentModel.indexOf(WmiInputMethodRequestHandler.this.leftChild) + 1;
                        }
                        int length = WmiInputMethodRequestHandler.this.rightChild != null ? WmiInputMethodRequestHandler.this.parentModel.indexOf(WmiInputMethodRequestHandler.this.rightChild) - firstIndex : WmiInputMethodRequestHandler.this.parentModel.getChildCount() - firstIndex;
                        WmiInputMethodRequestHandler.this.parentModel.removeChildren(firstIndex, length);
                    }
                }
                catch (WmiModelIndexOutOfBoundsException e) {
                    WmiErrorLog.log(e);
                }
            }
        }

        protected WmiTextModel createTextModel(String contents, WmiModel model, WmiFontAttributeSet attr) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            return new WmiTextModel(WmiInputMethodRequestHandler.this.parentModel.getDocument(), contents, attr);
        }

        protected boolean update(AttributedCharacterIterator it, int committed) {
            boolean finalCommit = it.getEndIndex() == committed;
            char ch = it.first();
            int runLimit = it.getRunLimit();
            Map<AttributedCharacterIterator.Attribute, Object> charAttributes = it.getAttributes();
            InputMethodHighlight highlight = null;
            boolean isSelected = false;
            boolean isConverted = false;
            boolean composing = false;
            StringBuffer sb = new StringBuffer();
            int pos = 0;
            int insertPos = 1;
            while (ch != '\uffff') {
                sb.append(ch);
                charAttributes = it.getAttributes();
                highlight = (InputMethodHighlight)charAttributes.get(TextAttribute.INPUT_METHOD_HIGHLIGHT);
                if (highlight != null) {
                    isConverted = highlight.getState() == 1;
                    isSelected = highlight.isSelected();
                }
                ch = it.next();
                if (++pos < runLimit) continue;
                if (sb.length() > 0 && pos >= committed) {
                    if (pos == committed) {
                        this.commitText(sb.toString());
                    } else if (pos > committed) {
                        this.addChild(sb.toString(), insertPos++, isSelected, isConverted);
                    }
                    if (!isSelected && !isConverted) {
                        composing = true;
                    }
                    if (isSelected) {
                        this.setPositionMarker(pos);
                    }
                    if (isSelected && !isConverted) {
                        WmiInputMethodRequestHandler.this.select = insertPos - 1;
                    }
                    sb.setLength(0);
                }
                runLimit = it.getRunLimit();
            }
            if (sb.length() > 0) {
                this.addChild(sb.toString(), insertPos, isSelected, isConverted);
            }
            if (!composing || WmiInputMethodRequestHandler.this.select != -1) {
                this.setPositionMarker(it.getEndIndex());
            }
            return finalCommit;
        }

        /*
         * Loose catch block
         */
        protected void commitText(String str) {
            if (WmiModelLock.writeLock(this, true)) {
                try {
                    try {
                        this.prefixModel.appendText(str);
                        this.setPositionMarker(0);
                    }
                    catch (WmiNoWriteAccessException e) {
                        WmiErrorLog.log(e);
                        WmiModelLock.writeUnlock(this);
                    }
                    catch (WmiModelIndexOutOfBoundsException e) {
                        WmiErrorLog.log(e);
                        WmiModelLock.writeUnlock(this);
                    }
                    catch (WmiNoReadAccessException e) {
                        WmiErrorLog.log(e);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        WmiModelLock.writeUnlock(this);
                    }
                }
                finally {
                    WmiModelLock.writeUnlock(this);
                }
            }
        }

        /*
         * Loose catch block
         */
        protected void addChild(String str, int insertPos, boolean isSelected, boolean isConverted) {
            WmiFontAttributeSet attr = null;
            attr = isConverted ? (isSelected ? this.convertedSelectedAttributes : this.convertedUnselectedAttributes) : this.composedAttributes;
            if (WmiModelLock.writeLock(this, true)) {
                try {
                    try {
                        WmiTextModel model = this.createTextModel(str, this.originalModel, attr);
                        this.addChild(model, insertPos);
                    }
                    catch (WmiNoReadAccessException e) {
                        WmiErrorLog.log(e);
                        WmiModelLock.writeUnlock(this);
                    }
                    catch (WmiNoWriteAccessException e) {
                        WmiErrorLog.log(e);
                        WmiModelLock.writeUnlock(this);
                    }
                    catch (WmiModelIndexOutOfBoundsException e) {
                        WmiErrorLog.log(e);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        WmiModelLock.writeUnlock(this);
                    }
                }
                finally {
                    WmiModelLock.writeUnlock(this);
                }
            }
        }

        protected void setPositionMarker(int pos) {
            this.caretPositionIndex = pos;
        }

        protected void updateCaretPosition() {
            block10: {
                if (WmiModelLock.readLock(this, true)) {
                    try {
                        try {
                            int size = this.getChildCount() - 1;
                            if (size <= 1) {
                                this.setPositionMarker(this.prefixModel, this.prefixModel.getLength());
                                break block10;
                            }
                            int sum = 0;
                            int i = 1;
                            while (i < size) {
                                WmiTextModel child = (WmiTextModel)this.getChild(i);
                                int childLength = this.getTextContents(child).length();
                                if ((sum += childLength) >= this.caretPositionIndex) {
                                    int offset = this.caretPositionIndex - (sum - childLength);
                                    if (offset < 0) {
                                        Toolkit.getDefaultToolkit().beep();
                                        offset = 0;
                                    }
                                    this.setPositionMarker(child, offset);
                                    break;
                                }
                                ++i;
                            }
                        }
                        catch (WmiNoReadAccessException e) {
                            WmiErrorLog.log(e);
                            WmiModelLock.readUnlock(this);
                        }
                    }
                    finally {
                        WmiModelLock.readUnlock(this);
                    }
                }
            }
        }

        protected void setPositionMarker(WmiModel model, int offset) throws WmiNoReadAccessException {
            WmiCaret caret = WmiInputMethodRequestHandler.this.docView.getCaret();
            if (caret != null) {
                caret.updateMarkerPosition(model, offset);
            } else {
                caret = new WmiCaret(WmiInputMethodRequestHandler.this.docView);
                caret.updateMarkerPosition(model, offset);
            }
        }

        protected int getCaretPositionIndex() {
            return this.caretPositionIndex;
        }

        protected Rectangle getCaretBounds(int pos) {
            Rectangle bounds = null;
            try {
                try {
                    WmiModelLock.readLock(this, true);
                    int size = this.getChildCount();
                    WmiTextModel child = null;
                    int tally = 0;
                    int i = 0;
                    while (i < size) {
                        child = (WmiTextModel)this.getChild(i);
                        int childLength = child.getLength();
                        if (tally + childLength >= pos) {
                            int offset = pos - tally;
                            WmiView view = WmiViewUtil.modelToView(WmiInputMethodRequestHandler.this.docView, child, offset);
                            if (view instanceof WmiTextView) {
                                WmiTextView textView = (WmiTextView)view;
                                Point pt = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)view);
                                int h = textView.getHorizontalOffset(offset -= textView.getStartOffset());
                                int v = pt.y;
                                pt = WmiInputMethodRequestHandler.this.docView.getLocationOnScreen();
                                bounds = new Rectangle(h += pt.x, v += pt.y, 1, ((WmiPositionedView)view).getHeight());
                            }
                        }
                        tally += childLength;
                        ++i;
                    }
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    WmiModelLock.readUnlock(this);
                }
            }
            finally {
                WmiModelLock.readUnlock(this);
            }
            return bounds;
        }

        /*
         * Exception decompiling
         */
        protected void finalCommit() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public WmiModelTag getTag() {
            return WmiModelTag.COMPOSED;
        }

        @Override
        public boolean isVisible() {
            return true;
        }
    }

    protected static class WmiInputMethodPathInterval
    extends WmiViewPathInterval {
        private WmiInputMethodPathInterval(WmiMathDocumentView view) {
            super(view);
        }

        @Override
        public boolean hideCaret() {
            return false;
        }
    }
}

