/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiClipboardManager;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.controller.WmiController;
import com.maplesoft.mathdoc.controller.WmiDataActionEvent;
import com.maplesoft.mathdoc.controller.WmiInputMethodRequestHandler;
import com.maplesoft.mathdoc.controller.WmiMouseInputAdapter;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.edit.WmiMathDocumentEditUnixCopy;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiContainerView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionInView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.im.InputMethodRequests;
import java.util.EventListener;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class WmiMathDocumentMouseListener
extends WmiMouseInputAdapter
implements MouseWheelListener {
    public static final int MOUSE_DRAGGED = 0;
    public static final int MOUSE_MOVED = 1;
    public static final int MOUSE_CLICKED = 2;
    public static final int MOUSE_PRESSED = 3;
    public static final int MOUSE_RELEASED = 4;
    public static final int MOUSE_ENTERED = 5;
    public static final int MOUSE_EXITED = 6;
    public static final int MOUSE_WHEEL_MOVED = 7;
    protected WmiMathDocumentView rootView = null;
    private WmiView currentViewUnderMouse = null;
    private MousePathHierarchy viewHierarchyUnderMouse = new MousePathHierarchy();
    private WmiView mouseDragView = null;
    private WmiController mouseDragController = null;
    private Point lastMousePoint = null;
    private boolean mouseDown = false;
    private WmiModel dndModel = null;
    private Point mouseLocInDndView = null;
    private Autoscroller scroller = null;
    private boolean autoscrollEnabledOnNextDrag = false;
    private boolean autoscroll = true;
    private boolean mouseDragViewToReceiveMove = false;
    private static boolean selectionMade = false;

    static {
        if (RuntimePlatform.isUnix()) {
            new WmiMathDocumentEditUnixCopy();
        }
    }

    public WmiMathDocumentMouseListener(WmiMathDocumentView newRootView) {
        this.rootView = newRootView;
    }

    protected void saveMousePoint(MouseEvent e) {
        this.lastMousePoint = e.getPoint();
    }

    public Point getLastMousePoint() {
        return this.lastMousePoint;
    }

    public WmiView getDragSourceView() {
        return this.mouseDragView;
    }

    public WmiView getDropTargetView() {
        return this.mouseDown ? this.currentViewUnderMouse : this.getDragSourceView();
    }

    public void notifyDragAndDropComplete(WmiModel model, Point mouseLocInView) {
        if (this.currentViewUnderMouse != null) {
            this.dndModel = model;
            this.mouseLocInDndView = mouseLocInView;
            this.mouseDragView = null;
        }
    }

    public void setDispatchInhibit(boolean state) {
    }

    public void setMouseDragView(WmiView view) {
        this.mouseDragView = view;
    }

    public void setDragViewToReceiveMove(boolean b) {
        this.mouseDragViewToReceiveMove = b;
    }

    public void setAutoscroll(boolean scroll) {
        this.autoscroll = scroll;
    }

    public boolean isAutoscrollEnabled() {
        return this.autoscroll;
    }

    public boolean isDragAndDropArmed() {
        boolean armed = false;
        WmiClipboardManager manager = this.rootView.getClipboardManager();
        armed = manager != null ? manager.isEnabled() : false;
        return armed;
    }

    protected void armDragAndDrop(boolean enabled) {
        WmiClipboardManager manager = this.rootView.getClipboardManager();
        if (manager != null) {
            manager.armDragAndDrop(enabled);
        }
    }

    protected Object getListenerFromViewAndEventType(WmiView view, int dispatchType) {
        EventListener listener = null;
        if (!this.rootView.getInputLock().isLocked()) {
            WmiController controller;
            WmiController wmiController = controller = this.mouseDragController != null ? this.mouseDragController : this.rootView.getViewFactory().getController(view);
            if (controller != null) {
                if (dispatchType == 7) {
                    listener = controller.getMouseWheelListener();
                } else if (dispatchType >= 2) {
                    listener = controller.getMouseListener();
                } else if (dispatchType <= 1) {
                    listener = controller.getMouseMotionListener();
                }
            }
        }
        return listener;
    }

    protected void dispatchToView(WmiView view, MouseEvent e, int dispatchType) {
        Object listener = this.getListenerFromViewAndEventType(view, dispatchType);
        if (listener != null) {
            Object saveSource = e.getSource();
            e.setSource(view);
            switch (dispatchType) {
                case 0: {
                    this.initiateAutoscroll((WmiPositionedView)view, e);
                    ((MouseMotionListener)listener).mouseDragged(e);
                    break;
                }
                case 1: {
                    ((MouseMotionListener)listener).mouseMoved(e);
                    break;
                }
                case 2: {
                    ((MouseListener)listener).mouseClicked(e);
                    break;
                }
                case 3: {
                    if (this.mouseDragViewToReceiveMove && this.mouseDragView != null && this.mouseDragView != view) {
                        WmiView oldFocus = this.mouseDragView;
                        this.mouseDragView = null;
                        this.mouseDragViewToReceiveMove = false;
                        this.rootView.notifyViewLostFocus(oldFocus);
                    }
                    this.autoscrollEnabledOnNextDrag = true;
                    ((MouseListener)listener).mousePressed(e);
                    break;
                }
                case 4: {
                    this.autoscrollEnabledOnNextDrag = false;
                    this.cancelAutoscroller();
                    ((MouseListener)listener).mouseReleased(e);
                    break;
                }
                case 5: {
                    this.autoscrollEnabledOnNextDrag = e.getButton() == 1 && !e.isPopupTrigger();
                    ((MouseListener)listener).mouseEntered(e);
                    break;
                }
                case 6: {
                    this.autoscrollEnabledOnNextDrag = false;
                    this.cancelAutoscroller();
                    ((MouseListener)listener).mouseExited(e);
                    break;
                }
                case 7: {
                    ((MouseWheelListener)listener).mouseWheelMoved((MouseWheelEvent)e);
                }
            }
            e.setSource(saveSource);
        }
        if (dispatchType == 4) {
            if (!this.mouseDragViewToReceiveMove) {
                this.mouseDragView = null;
            }
            this.mouseDragController = null;
        }
    }

    private void initiateAutoscroll(WmiPositionedView view, MouseEvent event) {
        this.cancelAutoscroller();
        if (this.autoscrollEnabledOnNextDrag && this.autoscroll) {
            this.scroller = Autoscroller.createAutoscroller(this, view, event);
        }
    }

    private void cancelAutoscroller() {
        if (this.scroller != null) {
            this.scroller.reset();
            this.scroller = null;
        }
    }

    protected WmiView findView(WmiView view, int x, int y) {
        WmiPositionedView child = null;
        WmiView found = null;
        boolean doLock = false;
        if (view instanceof WmiPositionedView) {
            WmiModel model = null;
            try {
                model = view.getModel();
                if (model != null) {
                    if (!WmiModelLock.ownsWriteLock(model)) {
                        doLock = WmiModelLock.readLock(model, true);
                    }
                    child = ((WmiPositionedView)view).getChildView(new Point(x -= ((WmiPositionedView)view).getHorizontalOffset(), y -= ((WmiPositionedView)view).getVerticalOffset()));
                }
            }
            finally {
                if (doLock) {
                    WmiModelLock.readUnlock(model);
                }
            }
            found = child != null ? this.findView(child, x, y) : view;
        }
        return found;
    }

    protected void findViewAndDispatch(WmiView view, MouseEvent e, int dispatchType, int depth) {
        WmiPositionedView child = null;
        int x = 0;
        int y = 0;
        boolean dispatchInhibit = this.rootView.getInputLock().isLocked();
        if (dispatchInhibit) {
            if (e.getID() == 501) {
                Toolkit.getDefaultToolkit().beep();
            }
            e.consume();
        }
        if (!dispatchInhibit && view instanceof WmiPositionedView) {
            if (dispatchType == 1) {
                this.viewHierarchyUnderMouse.setView(e, (WmiPositionedView)view, depth);
            }
            x = ((WmiPositionedView)view).getHorizontalOffset();
            y = ((WmiPositionedView)view).getVerticalOffset();
            e.translatePoint(-x, -y);
            child = ((WmiPositionedView)view).getChildView(e.getPoint());
            if (child != null) {
                this.findViewAndDispatch(child, e, dispatchType, depth + 1);
            } else if (dispatchType == 1) {
                this.viewHierarchyUnderMouse.exitViews(e, depth + 1);
            }
            if (!e.isConsumed()) {
                this.dispatchToView(view, e, dispatchType);
            }
            e.translatePoint(x, y);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        try {
            WmiPositionedView srcView;
            boolean resetDndModel;
            this.consumeOnActiveInputMethod(e);
            boolean bl = resetDndModel = this.dndModel != null;
            if (!e.isConsumed() && !this.isDragAndDropArmed()) {
                this.saveMousePoint(e);
                srcView = this.findEventSourceView(e);
                WmiPositionedView targetView = (WmiPositionedView)this.mouseDragView;
                if (!e.isConsumed()) {
                    block18: {
                        this.currentViewUnderMouse = this.findView(this.rootView, e.getX(), e.getY());
                        if (this.dndModel != null && WmiModelLock.readLock(this.dndModel, true)) {
                            try {
                                try {
                                    this.mouseDragView = WmiViewUtil.modelToView(this.rootView, this.dndModel, 0);
                                }
                                catch (WmiNoReadAccessException nrae) {
                                    WmiErrorLog.log(nrae);
                                    WmiModelLock.readUnlock(this.dndModel);
                                    break block18;
                                }
                            }
                            catch (Throwable throwable) {
                                WmiModelLock.readUnlock(this.dndModel);
                                throw throwable;
                            }
                            WmiModelLock.readUnlock(this.dndModel);
                        }
                    }
                    if (targetView == null || targetView.getModel() == null) {
                        this.findViewAndDispatch(srcView, e, 0, 0);
                        this.mouseDragView = null;
                    } else {
                        int x = 0;
                        int y = 0;
                        if (targetView != null) {
                            Point pt = WmiViewUtil.containerRelativeOffset(targetView);
                            x = pt.x;
                            y = pt.y;
                            e.translatePoint(-x, -y);
                        }
                        if (this.dndModel != null && targetView instanceof WmiContainerView) {
                            WmiContainerView container = (WmiContainerView)((Object)targetView);
                            container.setPositionMarker(0);
                            Point savePoint = e.getPoint();
                            e.translatePoint(-savePoint.x + this.mouseLocInDndView.x, -savePoint.y + this.mouseLocInDndView.y);
                            container.onMousePressed(e);
                            e.translatePoint(savePoint.x - this.mouseLocInDndView.x, savePoint.y - this.mouseLocInDndView.y);
                        }
                        this.dispatchToView(targetView, e, 0);
                        e.translatePoint(x, y);
                    }
                }
            }
            if (resetDndModel) {
                this.dndModel = null;
            }
            if (!e.isConsumed() && this.dndModel == null && (e.getModifiers() & 0x10) != 0) {
                if (!this.isDragAndDropArmed()) {
                    WmiMathDocumentMouseListener.updateSelection(e);
                } else {
                    srcView = this.findEventSourceView(e);
                    srcView.getDocumentView().setCursor(WmiClipboardManager.getMoveCursor());
                }
            }
        }
        catch (Exception ex) {
            WmiErrorLog.log(ex);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        try {
            WmiPositionedView srcView;
            this.saveMousePoint(e);
            WmiPositionedView wmiPositionedView = srcView = this.mouseDragViewToReceiveMove && this.mouseDragView != null ? (WmiPositionedView)this.mouseDragView : this.findEventSourceView(e);
            if (this.mouseDragViewToReceiveMove && this.mouseDragView != null) {
                Point p = WmiViewUtil.getAbsoluteOffset(srcView);
                e.translatePoint(-p.x, -p.y);
            }
            this.findViewAndDispatch(srcView, e, 1, 0);
        }
        catch (Exception ex) {
            WmiErrorLog.log(ex);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            this.consumeOnActiveInputMethod(e);
            if (!e.isConsumed()) {
                this.saveMousePoint(e);
                WmiPositionedView srcView = this.findEventSourceView(e);
                int count = e.getClickCount();
                if (this.enableDragOperation(e) && count == 1) {
                    this.findViewAndDispatch(srcView, e, 3, 0);
                    if (!e.isConsumed() && WmiMathDocumentMouseListener.isCaretPlacingEvent(e)) {
                        if (!e.isShiftDown()) {
                            WmiMathDocumentMouseListener.snapToNearestView(e);
                        } else {
                            WmiMathDocumentMouseListener.updateSelection(e);
                        }
                    }
                }
                this.findViewAndDispatch(srcView, e, 2, 0);
                if (!e.isConsumed()) {
                    WmiCommandProxy command;
                    Transferable trans;
                    Toolkit tk;
                    Clipboard buffer;
                    if (e.getButton() == 1) {
                        if (count > 1) {
                            WmiMathDocumentMouseListener.snapToNearestView(e);
                            WmiPositionMarker marker = this.rootView.getPositionMarker();
                            WmiPositionedView view = marker != null ? marker.getView() : null;
                            WmiCommandProxy command2 = null;
                            if (count == 2) {
                                command2 = WmiCommand.getCommandProxy("select.word");
                            } else if (count == 3) {
                                command2 = WmiCommand.getCommandProxy("select.paragraph");
                            }
                            if (command2 != null && view != null) {
                                ActionEvent event = new ActionEvent(view, 0, null);
                                command2.actionPerformed(event);
                                e.consume();
                            }
                        }
                    } else if (e.getButton() == 2 && count == 1 && RuntimePlatform.isUnix() && (buffer = (tk = Toolkit.getDefaultToolkit()).getSystemSelection()) != null && (trans = buffer.getContents(null)) != null && (command = WmiCommand.getCommandProxy("MathDoc.Edit.Paste")) != null && ((WmiCommand)command).isEnabled(this.rootView)) {
                        WmiDataActionEvent event = new WmiDataActionEvent((Object)this.rootView, 0, null, trans);
                        command.actionPerformed(event);
                        e.consume();
                    }
                }
                if (!e.isConsumed()) {
                    if (this.rootView.isBelowDocument(e.getY()) && WmiMathDocumentMouseListener.isCaretPlacingEvent(e)) {
                        WmiCommand.invokeCommand("move.document.end");
                    }
                    e.consume();
                }
            }
        }
        catch (Exception ex) {
            WmiErrorLog.log(ex);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            this.consumeOnActiveInputMethod(e);
            this.mouseDown = true;
            this.rootView.notifyMousePressed(e);
            if (!e.isConsumed()) {
                WmiPositionedView srcView = this.findEventSourceView(e);
                this.saveMousePoint(e);
                if (this.enableDragOperation(e)) {
                    this.armDragAndDrop(true);
                } else {
                    this.armDragAndDrop(false);
                    this.findViewAndDispatch(srcView, e, 3, 0);
                    if (!e.isConsumed()) {
                        if (WmiMathDocumentMouseListener.isPopupTrigger(e)) {
                            this.rootView.notifyPopupRequest(this.rootView, e);
                            e.consume();
                        } else if (WmiMathDocumentMouseListener.isCaretPlacingEvent(e)) {
                            WmiMathDocumentMouseListener.snapToNearestView(e);
                            WmiMathDocumentMouseListener.updateSelection(e);
                            e.consume();
                        } else if (WmiMathDocumentMouseListener.isHighlightChangingEvent(e)) {
                            WmiMathDocumentMouseListener.updateSelection(e);
                            e.consume();
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            WmiErrorLog.log(ex);
        }
    }

    protected boolean enableDragOperation(MouseEvent e) {
        boolean enabled = false;
        boolean resizeCursor = false;
        Cursor c = this.rootView.getCursor();
        if (c.equals(Cursor.getPredefinedCursor(10))) {
            resizeCursor = true;
        }
        enabled = this.rootView.isInHighlight(e);
        return enabled;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (RuntimePlatform.isUnix() && selectionMade) {
            WmiCommand.invokeCommand("MathDoc.Edit.UnixCopy");
        }
        try {
            this.consumeOnActiveInputMethod(e);
            this.currentViewUnderMouse = null;
            this.mouseDown = false;
            boolean dragHappening = this.isDragAndDropArmed();
            this.armDragAndDrop(false);
            if (!e.isConsumed()) {
                this.saveMousePoint(e);
                WmiPositionedView srcView = this.findEventSourceView(e);
                if (this.mouseDragView == null) {
                    this.findViewAndDispatch(srcView, e, 4, 0);
                } else {
                    int x = 0;
                    int y = 0;
                    if (this.mouseDragView instanceof WmiPositionedView) {
                        Point pt = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)this.mouseDragView);
                        x = pt.x;
                        y = pt.y;
                        e.translatePoint(-x, -y);
                    }
                    this.dispatchToView(this.mouseDragView, e, 4);
                    e.translatePoint(x, y);
                }
                if (!e.isConsumed() && WmiMathDocumentMouseListener.isPopupTrigger(e)) {
                    this.rootView.notifyPopupRequest(this.rootView, e);
                    e.consume();
                }
                if (!e.isConsumed() && dragHappening && srcView != null) {
                    WmiSelection selection = srcView.getDocumentView().getSelection();
                    WmiMathDocumentMouseListener.snapToNearestView(e);
                }
            }
            if (this.dndModel != null) {
                this.dndModel = null;
                this.mouseLocInDndView = null;
            }
        }
        catch (Exception ex) {
            WmiErrorLog.log(ex);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.saveMousePoint(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.saveMousePoint(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        JScrollPane scrollPane;
        this.consumeOnActiveInputMethod(e);
        this.findViewAndDispatch(this.rootView, e, 7, 0);
        if (!e.isConsumed() && (scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.rootView)) != null) {
            scrollPane.dispatchEvent(e);
        }
    }

    private WmiPositionedView findEventSourceView(MouseEvent e) {
        WmiPositionedView base = this.rootView;
        if (e != null) {
            Object evtSrc = e.getSource();
            base = evtSrc instanceof WmiPositionedView ? (WmiPositionedView)evtSrc : this.rootView;
        }
        return base;
    }

    private void consumeOnActiveInputMethod(MouseEvent e) {
        InputMethodRequests input = this.rootView.getInputMethodRequests();
        if (input instanceof WmiInputMethodRequestHandler && ((WmiInputMethodRequestHandler)input).isActive()) {
            e.consume();
        }
    }

    public static void updateSelection(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        Object view = e.getSource();
        if (!(view instanceof WmiPositionedView)) {
            return;
        }
        WmiMathDocumentView docView = ((WmiView)view).getDocumentView();
        if (docView == null) {
            return;
        }
        Point pt = e.getPoint();
        Point viewPos = WmiViewUtil.containerRelativeOffset((WmiPositionedView)view);
        viewPos.x += pt.x;
        viewPos.y += pt.y;
        WmiViewFactory factory = docView.getViewFactory();
        WmiViewPosition pos = WmiViewUtil.findNearestView((WmiPositionedView)view, viewPos);
        WmiPositionedView updateView = null;
        int offset = 0;
        if (pos != null && factory != null) {
            updateView = pos.getView();
            offset = pos.getOffset();
            factory.updateSelection(updateView, offset);
            WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
            boolean locked = false;
            try {
                Rectangle bounds;
                WmiHighlightPainter painter;
                locked = WmiModelLock.readLock(docModel, true);
                WmiSelection selection = docView.getSelection();
                WmiHighlightPainter wmiHighlightPainter = painter = selection != null ? selection.getSelectionHighlighter() : null;
                if (painter != null && ((bounds = painter.getBounds()) == null || bounds.width <= 1)) {
                    docView.setSelection(null);
                    updateView.setPositionMarker(offset);
                }
                selectionMade = selection != null;
            }
            finally {
                if (locked) {
                    WmiModelLock.readUnlock(docModel);
                }
            }
        }
    }

    public static void snapToNearestView(MouseEvent e) {
        WmiViewPosition pos = WmiMathDocumentMouseListener.getNearestViewPosition(e, null);
        if (pos != null && pos.snapToPosition()) {
            e.consume();
        }
    }

    public static void snapToNearestView(MouseEvent e, WmiView view) {
        WmiViewPosition pos = WmiMathDocumentMouseListener.getNearestViewPosition(e, view);
        if (pos != null && pos.snapToPosition()) {
            e.consume();
        }
    }

    public static WmiViewPosition getNearestViewPosition(MouseEvent e, WmiView view) {
        WmiPositionInView pinv = WmiViewUtil.getPositionInView(e, view);
        WmiViewPosition pos = WmiViewUtil.findNearestView(pinv.getView(), pinv.getPosition());
        return pos;
    }

    protected static class Autoscroller
    implements Runnable {
        private static final int SCROLL_DELAY = 100;
        private WmiMathDocumentView docView = null;
        private boolean shutdown = false;
        private Point offset = null;
        private WmiMathDocumentMouseListener listener = null;

        private Autoscroller(WmiMathDocumentMouseListener listener, WmiMathDocumentView docView, Point pt) {
            this.listener = listener;
            this.docView = docView;
            Rectangle r = docView.getVisibleRegion();
            this.offset = r != null ? new Point(pt.x - r.x, pt.y - r.y) : pt;
        }

        protected static Autoscroller createAutoscroller(WmiMathDocumentMouseListener listener, WmiPositionedView view, MouseEvent event) {
            Autoscroller autoscroller = null;
            Point pt = event.getPoint();
            Point posOffset = WmiViewUtil.getAbsoluteOffset(view);
            posOffset.x += pt.x;
            posOffset.y += pt.y;
            boolean enabled = false;
            WmiMathDocumentView currDocView = view.getDocumentView();
            if (currDocView != null) {
                Insets insets = currDocView.getAutoscrollInsets();
                if (posOffset.x < insets.left || posOffset.x > insets.right) {
                    enabled = true;
                }
                if (posOffset.y < insets.top || posOffset.y > insets.bottom) {
                    enabled = true;
                }
            }
            if (enabled) {
                autoscroller = new Autoscroller(listener, currDocView, posOffset);
                Thread t = new Thread((Runnable)autoscroller, "autoscroll" + autoscroller.hashCode());
                t.start();
            }
            return autoscroller;
        }

        public void reset() {
            this.shutdown = true;
        }

        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    final Rectangle r = this.docView.getVisibleRegion();
                    final Point pt = r != null ? new Point(this.offset.x + r.x, this.offset.y + r.y) : this.offset;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Autoscroller.this.docView.autoscroll(pt);
                            Rectangle postScrollBounds = Autoscroller.this.docView.getVisibleRegion();
                            if (postScrollBounds != null && (postScrollBounds.x != r.x || postScrollBounds.y != r.y)) {
                                MouseEvent event = new MouseEvent(Autoscroller.this.docView, 506, System.currentTimeMillis(), 0, ((Autoscroller)Autoscroller.this).offset.x + postScrollBounds.x, ((Autoscroller)Autoscroller.this).offset.y + postScrollBounds.y, 0, false);
                                if (!Autoscroller.this.shutdown) {
                                    Autoscroller.this.listener.findViewAndDispatch(Autoscroller.this.docView, event, 0, 0);
                                }
                            }
                        }
                    });
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException e) {
                WmiErrorLog.log(e);
            }
        }
    }

    protected class MousePathHierarchy {
        private static final int ARRAY_GROWBY = 10;
        private WmiPositionedView[] hierarchy = null;

        protected MousePathHierarchy() {
        }

        public void setView(MouseEvent event, WmiPositionedView view, int depth) {
            if (this.hierarchy == null || depth >= this.hierarchy.length) {
                WmiPositionedView[] newArray = new WmiPositionedView[depth + 10];
                if (this.hierarchy != null) {
                    System.arraycopy(this.hierarchy, 0, newArray, 0, this.hierarchy.length);
                }
                this.hierarchy = newArray;
            }
            if (view != this.hierarchy[depth]) {
                this.exitViews(event, depth);
                this.enterView(event, view, depth);
            }
        }

        public void exitViews(MouseEvent event, int depth) {
            Point base = null;
            if (this.hierarchy != null && depth < this.hierarchy.length) {
                WmiPositionedView view = this.hierarchy[depth];
                base = view != null ? WmiViewUtil.getAbsoluteOffset(view) : new Point(0, 0);
                int i = this.hierarchy.length - 1;
                while (i >= depth) {
                    view = this.hierarchy[i];
                    if (view != null) {
                        Point pos = WmiViewUtil.getAbsoluteOffset(view);
                        int dx = pos.x - base.x;
                        int dy = pos.y - base.y;
                        event.translatePoint(-dx, -dy);
                        WmiMathDocumentMouseListener.this.dispatchToView(view, event, 6);
                        event.translatePoint(dx, dy);
                        this.hierarchy[i] = null;
                    }
                    --i;
                }
            }
        }

        public void enterView(MouseEvent event, WmiPositionedView view, int depth) {
            this.hierarchy[depth] = view;
            WmiMathDocumentMouseListener.this.dispatchToView(view, event, 5);
        }
    }
}

