/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.components.WmiContextManager;
import com.maplesoft.mathdoc.controller.Wmi2DEntryMode;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiKeyBinder;
import com.maplesoft.mathdoc.controller.WmiTextKeyListener;
import com.maplesoft.mathdoc.controller.insert.WmiInsertWrapFenceCommand;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.RuntimePlatform;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.KeyStroke;

public class WmiMathKeyListener
extends WmiTextKeyListener {
    private static final HashMap TAG_TO_BINDING = new HashMap();
    private static final WmiKeyBinder DEFAULT_BINDER = new WmiKeyBinder();
    private static final HashSet IGNORE_PRESSED = new HashSet();

    static {
        int modifierMask = RuntimePlatform.isMac() ? 4 : 2;
        WmiMathKeyListener.setupInsertCharacters();
        WmiMathKeyListener.setupMainKeyboardMap(modifierMask);
        WmiMathKeyListener.setupI18nKeyboardMap(modifierMask);
        IGNORE_PRESSED.add(KeyStroke.getKeyStroke(new Character('\t'), 1));
    }

    private static void setupInsertCharacters() {
        WmiInsertDispatch inserter = new WmiInsertDispatch();
        DEFAULT_BINDER.registerBindingOverRange('\u0000', '\b', inserter);
        DEFAULT_BINDER.registerBindingOverRange('\n', '\u007f', inserter);
        DEFAULT_BINDER.registerBindingOverRange('\u00c0', '\u00d6', inserter);
        DEFAULT_BINDER.registerBindingOverRange('\u00d8', '\u00f6', inserter);
        DEFAULT_BINDER.registerBindingOverRange('\u00f8', '\u0236', inserter);
        DEFAULT_BINDER.registerBindingOverRange('\u0370', '\u050f', inserter);
        DEFAULT_BINDER.registerBinding('\"', (WmiKeyBinder.WmiDispatchOperation)inserter);
    }

    private static void setupMainKeyboardMap(int modifierMask) {
        new WmiInsertWrapFenceCommand("Insert.Fence.Wrap.Paren", false, "(", ")");
        new WmiInsertWrapFenceCommand("Insert.Fence.Wrap.Square", false, "[", "]");
        new WmiInsertWrapFenceCommand("Insert.Fence.Wrap.Curly", false, "{", "}");
        new WmiInsertWrapFenceCommand("Insert.Fence.Wrap.Abs", false, "|", "|");
        DEFAULT_BINDER.registerBinding('_', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Msub"));
        DEFAULT_BINDER.registerBinding('^', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Msup"));
        DEFAULT_BINDER.registerBinding('/', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Mfrac"));
        if (RuntimePlatform.isMac()) {
            KeyStroke k = KeyStroke.getKeyStroke(222, modifierMask | 1);
            DEFAULT_BINDER.registerBinding(k, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Mover"));
            DEFAULT_BINDER.registerBinding('\'', modifierMask, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Munder"));
        } else {
            DEFAULT_BINDER.registerBinding('\"', modifierMask | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Mover"));
            DEFAULT_BINDER.registerBinding('\'', modifierMask, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Munder"));
        }
        DEFAULT_BINDER.registerBinding('/', modifierMask, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("move.math.baseline"));
        int entityListModifier = modifierMask;
        if (!RuntimePlatform.isWindows()) {
            entityListModifier |= 1;
        }
        DEFAULT_BINDER.registerBinding(' ', entityListModifier, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Entitylist"));
        DEFAULT_BINDER.registerBinding(82, modifierMask | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Tablerow"));
        DEFAULT_BINDER.registerBinding(67, modifierMask | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Tablecolumn"));
        DEFAULT_BINDER.registerBinding(92, modifierMask | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Tablecolumn"));
        DEFAULT_BINDER.registerBinding('^', modifierMask, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presup"));
        DEFAULT_BINDER.registerBinding(54, modifierMask | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presup"));
        DEFAULT_BINDER.registerBinding('_', modifierMask, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presub"));
        DEFAULT_BINDER.registerBinding(45, modifierMask | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presub"));
        DEFAULT_BINDER.registerBinding('\b', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("edit.backspace"));
        DEFAULT_BINDER.registerBinding('\u007f', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("edit.delete"));
        DEFAULT_BINDER.registerBinding('\t', (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("focus.cycle.forward"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(new Character('\t'), 0), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("focus.cycle.forward"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(new Character('\t'), 1), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("focus.cycle.reverse"));
        DEFAULT_BINDER.registerBinding(9, 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("focus.cycle.reverse"));
        DEFAULT_BINDER.registerBinding('G', modifierMask, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("edit.greek.toggle"));
        DEFAULT_BINDER.registerBinding(71, modifierMask | 1, (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("edit.greek.toggle"));
    }

    private static void setupI18nKeyboardMap(int modifierMask) {
        int cmdAltMask = modifierMask | 8;
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(79, cmdAltMask), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Mover"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(85, cmdAltMask), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Munder"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(80, cmdAltMask), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presup"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(66, cmdAltMask), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("Insert.Presub"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(76, cmdAltMask), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("move.math.baseline"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(75, cmdAltMask), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("scope.out"));
        DEFAULT_BINDER.registerBinding(KeyStroke.getKeyStroke(74, cmdAltMask), (WmiKeyBinder.WmiDispatchOperation)new WmiCommandDispatch("scope.in"));
    }

    public WmiKeyBinder getDefaultBindings() {
        return DEFAULT_BINDER;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Wmi2DEntryMode oldMode = this.getMode(e);
        boolean handled = false;
        WmiView sourceView = null;
        if (!e.isConsumed()) {
            Object source;
            if (this.acceptKeyPressed(e) && (source = e.getSource()) instanceof WmiView && (handled = DEFAULT_BINDER.dispatch(e, sourceView = (WmiView)source))) {
                e.consume();
            }
            if (!handled) {
                super.keyPressed(e);
            }
        }
        if (e.isConsumed()) {
            WmiMathDocumentView docView;
            this.resetMode(e, oldMode);
            if (sourceView != null && (docView = sourceView.getDocumentView()) != null) {
                docView.saveLastHorizontalPosition();
            }
        } else if (RuntimePlatform.isMac_10_2() && e.getKeyCode() != 127 && e.getKeyCode() != 8 && e.getKeyCode() != 9) {
            this.keyTyped(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Wmi2DEntryMode oldMode = this.getMode(e);
        boolean handled = false;
        if (RuntimePlatform.isUnix() && !e.isConsumed()) {
            if (e.getKeyCode() == 32) {
                if (e.isControlDown() || e.isMetaDown() || e.isShiftDown()) {
                    Object source = e.getSource();
                    if (source instanceof WmiView && (handled = DEFAULT_BINDER.dispatch(e, (WmiView)source))) {
                        e.consume();
                    }
                    if (!handled) {
                        super.keyPressed(e);
                    }
                }
            } else if (this.isDeadKey(e.getKeyCode())) {
                super.keyReleased(e);
            }
        }
        if (e.isConsumed()) {
            this.resetMode(e, oldMode);
        }
        this.notifyKeyReleased(e);
    }

    protected boolean checkModifiers(KeyEvent e) {
        return !e.isControlDown() && !e.isMetaDown() && (!e.isAltDown() || RuntimePlatform.isMac());
    }

    @Override
    public void keyTyped(KeyEvent e) {
        Wmi2DEntryMode oldMode = this.getMode(e);
        boolean handled = false;
        if (!e.isConsumed() && this.checkModifiers(e) && e.getKeyChar() != '\u001b') {
            Object source = e.getSource();
            if (source instanceof WmiView && (handled = DEFAULT_BINDER.dispatch(e, (WmiView)source))) {
                e.consume();
            }
            if (!handled) {
                super.keyPressed(e);
            }
        }
        if (e.isConsumed()) {
            this.resetMode(e, oldMode);
        }
        this.notifyKeyTyped(e);
    }

    private boolean acceptKeyPressed(KeyEvent e) {
        KeyStroke ks;
        boolean accept;
        boolean bl = accept = e.isControlDown() || e.isMetaDown() || e.isShiftDown();
        if (accept && IGNORE_PRESSED.contains(ks = KeyStroke.getKeyStroke(new Character(e.getKeyChar()), e.getModifiers()))) {
            accept = false;
        }
        return accept;
    }

    @Override
    protected boolean finalKeyDispatch(KeyEvent event, WmiView view, WmiCaret caret, WmiSelection selection, boolean editable) {
        WmiKeyBinder binder;
        WmiModel model;
        boolean success = false;
        if (view != null && (model = view.getModel()) != null && (binder = (WmiKeyBinder)TAG_TO_BINDING.get(model.getTag())) != null) {
            success = binder.dispatch(event, view);
        }
        if (!success) {
            success = DEFAULT_BINDER.dispatch(event, view);
        }
        if (!success) {
            success = super.finalKeyDispatch(event, view, caret, selection, editable);
        }
        return success;
    }

    private Wmi2DEntryMode getMode(KeyEvent e) {
        WmiMathDocumentView docView;
        WmiContextManager ctxMgr;
        Wmi2DEntryMode mode = WmiContextManager.EM_STANDARD;
        Object source = e.getSource();
        if (source instanceof WmiView && (ctxMgr = (docView = ((WmiView)source).getDocumentView()).getContextManager()) != null) {
            mode = ctxMgr.getEntryMode();
        }
        return mode;
    }

    private void resetMode(KeyEvent e, Wmi2DEntryMode oldMode) {
        Object source;
        if (!oldMode.equals(WmiContextManager.EM_STANDARD) && (source = e.getSource()) instanceof WmiView) {
            WmiMathDocumentView docView = ((WmiView)source).getDocumentView();
            WmiContextManager ctxMgr = docView.getContextManager();
            ctxMgr.updateEntryMode(WmiContextManager.EM_STANDARD);
        }
    }

    @Override
    protected boolean treatTabsAsChars() {
        return false;
    }

    public static class WmiCommandDispatch
    implements WmiKeyBinder.WmiDispatchOperation {
        String command = null;

        public WmiCommandDispatch(String command) {
            this.command = command;
        }

        @Override
        public boolean dispatch(KeyEvent event, WmiView view) {
            WmiCommand.invokeCommand(this.command);
            return true;
        }
    }

    private static class WmiGreekKeyboardMapper {
        private static final HashMap GREEK_CHARS = new HashMap();

        static {
            WmiGreekKeyboardMapper.addCharGreekMapping('a', "&alpha;");
            WmiGreekKeyboardMapper.addCharGreekMapping('b', "&beta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('c', "&psi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('d', "&delta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('e', "&varepsilon;");
            WmiGreekKeyboardMapper.addCharGreekMapping('f', "&phi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('g', "&gamma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('h', "&eta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('i', "&iota;");
            WmiGreekKeyboardMapper.addCharGreekMapping('j', "&varphi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('k', "&kappa;");
            WmiGreekKeyboardMapper.addCharGreekMapping('l', "&lambda;");
            WmiGreekKeyboardMapper.addCharGreekMapping('m', "&mu;");
            WmiGreekKeyboardMapper.addCharGreekMapping('n', "&nu;");
            WmiGreekKeyboardMapper.addCharGreekMapping('o', "&omicron;");
            WmiGreekKeyboardMapper.addCharGreekMapping('p', "&pi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('q', "&chi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('r', "&rho;");
            WmiGreekKeyboardMapper.addCharGreekMapping('s', "&sigma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('t', "&tau;");
            WmiGreekKeyboardMapper.addCharGreekMapping('u', "&upsilon;");
            WmiGreekKeyboardMapper.addCharGreekMapping('v', "&varpi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('w', "&omega;");
            WmiGreekKeyboardMapper.addCharGreekMapping('x', "&xi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('y', "&theta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('z', "&zeta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('A', "&Alpha;");
            WmiGreekKeyboardMapper.addCharGreekMapping('B', "&Beta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('C', "&Psi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('D', "&Delta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('E', "&epsilon;");
            WmiGreekKeyboardMapper.addCharGreekMapping('F', "&Phi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('G', "&Gamma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('H', "&Eta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('I', "&digamma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('J', "J");
            WmiGreekKeyboardMapper.addCharGreekMapping('K', "&varkappa;");
            WmiGreekKeyboardMapper.addCharGreekMapping('L', "&Lambda;");
            WmiGreekKeyboardMapper.addCharGreekMapping('M', "&Mu;");
            WmiGreekKeyboardMapper.addCharGreekMapping('N', "&Nu;");
            WmiGreekKeyboardMapper.addCharGreekMapping('O', "&Omicron;");
            WmiGreekKeyboardMapper.addCharGreekMapping('P', "&Pi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('Q', "Q");
            WmiGreekKeyboardMapper.addCharGreekMapping('R', "&Rho;");
            WmiGreekKeyboardMapper.addCharGreekMapping('S', "&Sigma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('T', "&varsigma;");
            WmiGreekKeyboardMapper.addCharGreekMapping('U', "&Upsilon;");
            WmiGreekKeyboardMapper.addCharGreekMapping('V', "V");
            WmiGreekKeyboardMapper.addCharGreekMapping('W', "&Omega;");
            WmiGreekKeyboardMapper.addCharGreekMapping('X', "&Xi;");
            WmiGreekKeyboardMapper.addCharGreekMapping('Y', "&Theta;");
            WmiGreekKeyboardMapper.addCharGreekMapping('Z', "&vartheta;");
        }

        private WmiGreekKeyboardMapper() {
        }

        public static String getGreekEntity(char c) {
            Character character = new Character(c);
            String entity = (String)GREEK_CHARS.get(character);
            return entity;
        }

        private static void addCharGreekMapping(char c, String entity) {
            Character character = new Character(c);
            GREEK_CHARS.put(character, entity);
        }
    }

    public static class WmiInsertDispatch
    implements WmiKeyBinder.WmiDispatchOperation {
        /*
         * Exception decompiling
         */
        @Override
        public boolean dispatch(KeyEvent event, WmiView view) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

