/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiClipboardManager;
import com.maplesoft.mathdoc.controller.edit.WmiMathMLTransfer;
import com.maplesoft.mathdoc.controller.edit.WmiTransfer;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentHierarchyValidator;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiBoundsMarker;
import com.maplesoft.mathdoc.view.WmiMathMLDocumentView;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

public class WmiMathMLClipboardManager
extends WmiClipboardManager {
    public static final String RESOURCES = "com.maplesoft.mathdoc.controller.edit.resources.Edit";

    public WmiMathMLClipboardManager(WmiMathMLDocumentView docView) {
        super(docView);
    }

    public WmiMathMLClipboardManager(WmiMathMLEditorDocumentView docView) {
        super(docView);
    }

    @Override
    protected Transferable createTransferable(WmiSelection selection, WmiPositionMarker marker, boolean copySemantics) {
        WmiTransfer transfer = null;
        if (selection != null) {
            transfer = WmiMathMLTransfer.createTransferable(selection);
        } else if (marker instanceof WmiBoundsMarker) {
            transfer = WmiMathMLTransfer.createTransferable((WmiBoundsMarker)marker);
        }
        return transfer;
    }

    @Override
    public boolean paste(Transferable t) {
        boolean success = false;
        if (this.docView != null) {
            WmiMathMLDocumentView mathmlDocView = (WmiMathMLDocumentView)this.docView;
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String value = (String)t.getTransferData(DataFlavor.stringFlavor);
                    int startIndex = value.indexOf("<math");
                    int endIndex = value.indexOf("</math>");
                    if (startIndex != -1 && endIndex != -1 && endIndex > startIndex) {
                        success = this.pasteMathML(mathmlDocView, t);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    WmiErrorLog.log(e);
                }
                catch (IOException e) {
                    WmiErrorLog.log(e);
                }
            }
        }
        return success;
    }

    protected boolean pasteMathML(WmiMathMLDocumentView target, Transferable t) {
        boolean success = false;
        try {
            String mathml = (String)t.getTransferData(DataFlavor.stringFlavor);
            WmiTransferModel composite = new WmiTransferModel((WmiMathDocumentModel)this.docView.getModel());
            int startIndex = mathml.indexOf("<math");
            int endIndex = mathml.indexOf("</math>");
            mathml = mathml.substring(startIndex, endIndex + "</math>".length());
            WmiMathMLImportParser parser = new WmiMathMLImportParser();
            parser.parse(new StringReader(mathml), (WmiCompositeModel)composite, 0);
            WmiMathDocumentModel targetModel = (WmiMathDocumentModel)target.getModel();
            WmiPositionMarker marker = target.getPositionMarker();
            WmiSelection selection = target.getSelection();
            WmiPositionedView view = null;
            int offset = 0;
            boolean compoundEdit = false;
            if (selection != null) {
                compoundEdit = true;
                targetModel.startUndoableEdit(null);
                selection.deleteSelection();
                marker = target.getPositionMarker();
            }
            if (marker != null) {
                view = marker.getView();
                offset = marker.getOffset();
            }
            if (view != null) {
                success = this.insertMathMLModel(composite, targetModel, view, offset);
            }
            if (compoundEdit) {
                targetModel.endUndoableEdit();
            }
            return success;
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        catch (WmiNoWriteAccessException nwae) {
            WmiErrorLog.log(nwae);
        }
        catch (WmiModelIndexOutOfBoundsException miobe) {
            WmiErrorLog.log(miobe);
        }
        catch (WmiParseException pe) {
            WmiErrorLog.log(pe);
        }
        catch (UnsupportedFlavorException e) {
            WmiErrorLog.log(e);
        }
        catch (IOException e) {
            WmiErrorLog.log(e);
        }
        return success;
    }

    public boolean insertMathMLModel(WmiCompositeModel composite, WmiMathDocumentModel targetModel, WmiView view, int offset) {
        boolean success = false;
        try {
            WmiParagraphModel p = (WmiParagraphModel)composite.getChild(0);
            WmiMathWrapperModel w = (WmiMathWrapperModel)p.getChild(0);
            WmiModel[] children = new WmiModel[w.getChildCount()];
            int i = 0;
            while (i < w.getChildCount()) {
                children[i] = w.getChild(i);
                ++i;
            }
            WmiMathDocumentHierarchyValidator validator = targetModel.getModelHierarchyValidator();
            WmiModel parent = view.getModel();
            while (parent != null && !validator.isValid(parent, children)) {
                parent = parent.getParent();
            }
            if (parent instanceof WmiCompositeModel) {
                if (view instanceof WmiTextView) {
                    offset += ((WmiTextView)view).getStartOffset();
                }
                if (view != null) {
                    WmiModel model = view.getModel();
                    while (model != parent) {
                        if ((offset = WmiModelUtil.splitModel(model, offset)) < 0) break;
                        model = model.getParent();
                    }
                }
                if (offset >= 0) {
                    ((WmiCompositeModel)parent).addChildren(children, offset);
                    composite.getDocument().update(null);
                    success = true;
                }
            }
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        catch (WmiNoWriteAccessException nwae) {
            WmiErrorLog.log(nwae);
        }
        catch (WmiNoUpdateAccessException nuae) {
            WmiErrorLog.log(nuae);
        }
        catch (WmiModelIndexOutOfBoundsException miobe) {
            WmiErrorLog.log(miobe);
        }
        return success;
    }
}

