/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiMathDocumentMouseListener;
import com.maplesoft.mathdoc.controller.WmiMouseInputAdapter;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiMathActionAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathActionModel;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.MouseEvent;

public class WmiMathMouseListener
extends WmiMouseInputAdapter {
    @Override
    public void mouseClicked(MouseEvent event) {
        this.findAndPerformAction(event, 2);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.findAndPerformAction(event, 0);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.findAndPerformAction(event, 5);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.findAndPerformAction(event, 6);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        WmiView view = (WmiView)event.getSource();
        if (!this.findAndPerformAction(event, 3) && !event.isConsumed() && !WmiMathMouseListener.isPopupTrigger(event) && WmiMathMouseListener.isConditionalCaretPlacingEvent(event)) {
            if (!event.isShiftDown()) {
                WmiMathDocumentMouseListener.snapToNearestView(event);
            } else {
                WmiMathDocumentMouseListener.updateSelection(event);
            }
        }
        view.getDocumentView().saveLastHorizontalPosition();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.findAndPerformAction(event, 4);
    }

    private boolean isValidAction(String action, MouseEvent event, int type) {
        boolean actionValid = false;
        if (action != null && WmiMathActionModel.actionTable.isKnownAction(action)) {
            String triggerType = this.categorizeTriggerEvent(event, type);
            actionValid = WmiMathActionModel.actionTable.isTrigger(action, triggerType);
        }
        return actionValid;
    }

    private String categorizeTriggerEvent(MouseEvent event, int id) {
        StringBuffer eventType = new StringBuffer();
        if (event.getButton() == 1 && event.getClickCount() == 2) {
            eventType.append("double-click");
        } else {
            eventType.append(event.getButton());
            eventType.append("-");
            String actionType = null;
            if (id == 2) {
                actionType = "click";
            } else if (id == 3) {
                actionType = "press";
            } else if (id == 4) {
                actionType = "release";
            } else if (id == 1) {
                actionType = "move";
            } else if (id == 5) {
                actionType = "enter";
            } else if (id == 6) {
                actionType = "exit";
            } else if (id == 0) {
                actionType = "drag";
            }
            eventType.append(actionType);
            eventType.append("-");
            eventType.append(event.getClickCount());
        }
        return eventType.toString();
    }

    private String findAction(WmiMathActionModel actionModel) throws WmiNoReadAccessException {
        String actionType = null;
        if (actionModel != null) {
            WmiMathActionAttributeSet atts = (WmiMathActionAttributeSet)actionModel.getAttributesForRead();
            actionType = (String)atts.getAttribute("actiontype");
        }
        return actionType;
    }

    private void performAction(String action, MouseEvent event, WmiMathActionModel model, int type) {
        WmiMathActionModel.WmiMathActionCommand command = WmiMathActionModel.actionTable.getActionCode(action);
        command.execute(event, model, type);
    }

    protected boolean findAndPerformAction(MouseEvent event, int type) {
        String action;
        WmiMathActionModel actionModel;
        boolean actionFoundAndPerformed;
        block7: {
            actionFoundAndPerformed = false;
            WmiView view = (WmiView)event.getSource();
            actionModel = null;
            action = null;
            if (WmiModelLock.readLock(view.getModel().getDocument(), true)) {
                try {
                    try {
                        actionModel = this.findActionModel(event);
                        action = this.findAction(actionModel);
                    }
                    catch (WmiNoReadAccessException e) {
                        WmiErrorLog.log(e);
                        WmiModelLock.readUnlock(view.getModel().getDocument());
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    WmiModelLock.readUnlock(view.getModel().getDocument());
                    throw throwable;
                }
                WmiModelLock.readUnlock(view.getModel().getDocument());
            }
        }
        if (this.isValidAction(action, event, type)) {
            this.performAction(action, event, actionModel, type);
            actionFoundAndPerformed = true;
            event.consume();
        }
        return actionFoundAndPerformed;
    }

    private WmiMathActionModel findActionModel(MouseEvent event) throws WmiNoReadAccessException {
        WmiMathActionModel actModel = null;
        Object source = event.getSource();
        if (source instanceof WmiView) {
            WmiModel model = ((WmiView)source).getModel();
            while (!(model instanceof WmiMathActionModel) && model != null) {
                if (model == null) continue;
                model = model.getParent();
            }
            if (model != null) {
                actModel = (WmiMathActionModel)model;
            }
        }
        return actModel;
    }
}

