/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller;

import com.maplesoft.mathdoc.controller.WmiMouseInputAdapter;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMetatagWrapperModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.WmiSearchVisitor;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class WmiParagraphMouseListener
extends WmiMouseInputAdapter
implements MouseListener,
MouseMotionListener {
    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!e.isConsumed()) {
            Object source = e.getSource();
            WmiMathDocumentView docView = null;
            if (source instanceof WmiView) {
                docView = ((WmiView)source).getDocumentView();
            }
            if (docView != null) {
                Cursor c;
                Cursor targetCursor = Cursor.getPredefinedCursor(2);
                if (docView != null && !(c = docView.getCursor()).equals(targetCursor)) {
                    docView.setCursor(targetCursor);
                }
                e.consume();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.processMetadataVisibility(e, true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.processMetadataVisibility(e, false);
    }

    protected void processMetadataVisibility(MouseEvent e, boolean visible) {
        boolean processMetadata = false;
        WmiMathDocumentView docView = WmiViewUtil.getDocumentView(e.getSource());
        WmiMathDocumentModel docModel = null;
        if (docView != null) {
            docModel = (WmiMathDocumentModel)docView.getModel();
        }
        if (docModel != null && docModel.getMetadataManager().getDecoratorVisibility() == 1) {
            processMetadata = true;
        }
        if (processMetadata) {
            WmiModel rootMdl = ((WmiView)e.getSource()).getModel();
            MetatagVisibilitySelector sel = new MetatagVisibilitySelector(visible);
            boolean locked = WmiModelLock.readLock(rootMdl.getDocument(), false);
            if (locked) {
                block9: {
                    try {
                        try {
                            WmiModelUtil.visitModels(rootMdl, sel, WmiModelTag.METATAG_WRAPPER);
                        }
                        catch (WmiNoReadAccessException nrae) {
                            WmiErrorLog.log(nrae);
                            WmiModelLock.readUnlock(rootMdl.getDocument());
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        WmiModelLock.readUnlock(rootMdl.getDocument());
                        throw throwable;
                    }
                    WmiModelLock.readUnlock(rootMdl.getDocument());
                }
                docView.repaint();
            }
        }
    }

    protected class MetatagVisibilitySelector
    implements WmiSearchVisitor {
        private boolean selectorSetting;

        public MetatagVisibilitySelector(boolean setting) {
            this.selectorSetting = setting;
        }

        @Override
        public int visitMatch(Object match) {
            WmiMetatagWrapperModel mtw = (WmiMetatagWrapperModel)match;
            mtw.setDecoratorVisible(this.selectorSetting);
            return 1;
        }
    }
}

