/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.edit.WmiCustomDeleteHandler;
import com.maplesoft.mathdoc.controller.edit.WmiMathDeleteUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentHierarchyValidator;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashSet;

public abstract class WmiAbstractDelete
extends WmiCommand {
    private static final String RESOURCE_LOCATION = "com.maplesoft.mathdoc.controller.edit.resources.Edit";
    protected static final int DIRECTION_RIGHT = 1;
    protected static final int DIRECTION_LEFT = -1;
    private static final HashSet SELECT_MODEL_ONLY_TAGS = new HashSet();

    protected WmiAbstractDelete(String name) {
        super(name);
    }

    protected WmiAbstractDelete(String name, boolean replace) {
        super(name, replace);
    }

    public static void registerSelectModelOnlyTag(WmiModelTag tag) {
        SELECT_MODEL_ONLY_TAGS.add(tag);
    }

    /*
     * Loose catch block
     */
    @Override
    public void doCommand(ActionEvent event) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success;
        block15: {
            WmiCustomDeleteHandler handler;
            WmiMathDocumentModel docModel;
            WmiMathDocumentView docView = WmiAbstractDelete.getDocumentView(event);
            success = false;
            String undo = this.getResource(5);
            if (WmiMathDeleteUtil.isMathSelectionDelete(docView)) {
                success = WmiMathDeleteUtil.deleteMathSelection(docView, undo);
            }
            if (!success && WmiMathDeleteUtil.isMathDelete(docView)) {
                success = WmiMathDeleteUtil.deleteInMath(docView, undo, this.getDirection());
            }
            if (!success) {
                docModel = (WmiMathDocumentModel)docView.getModel();
                docModel.revertPendingUpdates();
                success = this.delete(docView);
            }
            if (!success && (handler = (docModel = (WmiMathDocumentModel)docView.getModel()).getCustomDeleteHandler()) != null) {
                WmiModelLock.writeLock(docModel, true);
                try {
                    success = handler.deleteAtMarkerPosition(docView, this.getDirection());
                    if (success) {
                        docModel.update(this.getResource(5));
                    }
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    WmiModelLock.writeUnlock(docModel);
                    break block15;
                }
                catch (WmiNoWriteAccessException e) {
                    WmiErrorLog.log(e);
                    break block15;
                }
                catch (WmiNoUpdateAccessException e) {
                    WmiErrorLog.log(e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    WmiModelLock.writeUnlock(docModel);
                    break block15;
                }
                {
                    finally {
                        WmiModelLock.writeUnlock(docModel);
                    }
                }
                WmiModelLock.writeUnlock(docModel);
            }
        }
        if (!success) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public boolean delete(WmiMathDocumentView docView) throws WmiNoReadAccessException {
        boolean success = false;
        if (docView != null) {
            WmiSelection selection = docView.getSelection();
            if (selection != null) {
                success = this.deleteSelection(docView);
            } else {
                WmiPositionMarker marker = docView.getPositionMarker();
                if (marker != null) {
                    success = this.deleteAtMarkerPosition(docView, true);
                }
            }
        }
        return success;
    }

    /*
     * Loose catch block
     */
    private boolean deleteAtMarkerPosition(WmiMathDocumentView docView, boolean recursive) {
        boolean success = false;
        WmiPositionMarker marker = docView.getPositionMarker();
        if (marker != null) {
            WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
            WmiModelLock.writeLock(docModel, true);
            try {
                try {
                    WmiPositionedView view = marker.getView();
                    int offset = marker.getOffset();
                    WmiModel model = view.getModel();
                    if (!(marker instanceof WmiCaret)) {
                        success = this.deleteView(view);
                    } else if (model instanceof WmiMathModel) {
                        WmiCompositeModel wrapper;
                        if (WmiMathDeleteUtil.isEmptyMath(model) && (wrapper = WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH)) != null) {
                            success = this.removeEmptyModel(docView, wrapper);
                        }
                        if (!success) {
                            success = this.deleteAtMathBoundary(docView, recursive);
                        }
                    } else if (view instanceof WmiTextView) {
                        success = this.deleteInText((WmiTextView)view, offset, recursive);
                    }
                    if (success) {
                        docModel.update(this.getResource(5));
                    }
                }
                catch (WmiNoWriteAccessException e) {
                    WmiErrorLog.log(e);
                    WmiModelLock.writeUnlock(docModel);
                }
                catch (WmiNoUpdateAccessException e) {
                    WmiErrorLog.log(e);
                    WmiModelLock.writeUnlock(docModel);
                }
                catch (WmiNoReadAccessException e) {
                    WmiErrorLog.log(e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    WmiModelLock.writeUnlock(docModel);
                }
            }
            finally {
                WmiModelLock.writeUnlock(docModel);
            }
        }
        return success;
    }

    private boolean deleteView(WmiView view) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentView docView;
        boolean success = false;
        WmiModel model = view.getModel();
        if (model != null && (docView = view.getDocumentView()) != null) {
            this.removeEmptyModel(docView, model);
            success = true;
        }
        return success;
    }

    private boolean deleteInText(WmiTextView textView, int offset, boolean recursive) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success;
        block10: {
            success = false;
            WmiModel model = textView.getModel();
            WmiMathDocumentView docView = textView.getDocumentView();
            if (docView == null) {
                return false;
            }
            WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
            if (model instanceof WmiTextModel && docModel.isMutableModel(model)) {
                WmiTextModel textModel = (WmiTextModel)model;
                offset = offset < 0 ? textModel.getLength() : (offset += textView.getStartOffset());
                if (this.getDirection() < 0) {
                    success = --offset >= 0;
                } else {
                    boolean bl = success = offset < textModel.getLength();
                }
                if (success) {
                    try {
                        textModel.deleteText(offset, 1);
                        if (textModel.getLength() == 0) {
                            if (!this.removeEmptyModel(docView, textModel)) {
                                docView.setPendingPosition(new WmiModelPosition(textModel, 0));
                            }
                            break block10;
                        }
                        docView.setPendingPosition(new WmiModelPosition(textModel, offset));
                    }
                    catch (WmiModelIndexOutOfBoundsException e) {
                        WmiErrorLog.log(e);
                        success = false;
                    }
                } else {
                    success = this.deleteAtTextBoundary(docView, textModel, recursive);
                }
            }
        }
        return success;
    }

    private boolean deleteAtTextBoundary(WmiMathDocumentView docView, WmiTextModel model, boolean recursive) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success = false;
        WmiPositionMarker oldMarker = docView.getPositionMarker();
        WmiPositionedView oldView = oldMarker.getView();
        int oldOffset = oldMarker.getOffset();
        String commandName = this.getDirection() < 0 ? "move.left" : "move.right";
        WmiCommand moveCommand = WmiCommand.getCommandInstance(commandName);
        ActionEvent event = new ActionEvent(docView, 0, commandName);
        moveCommand.doCommand(event);
        WmiPositionMarker marker = docView.getPositionMarker();
        if (marker != null) {
            WmiPositionedView newView = marker.getView();
            WmiModel newModel = newView.getModel();
            WmiCompositeModel newParagraph = WmiModelUtil.findAncestorOfClass(newModel, WmiParagraphModel.class);
            WmiCompositeModel oldParagraph = WmiModelUtil.findAncestorOfClass(model, WmiParagraphModel.class);
            if (newParagraph != null && oldParagraph != null && newParagraph != oldParagraph) {
                success = this.conditionalParagraphMerge(docView, oldParagraph, newParagraph, newModel);
            } else if (newParagraph == oldParagraph && newModel != model) {
                if (model.getLength() == 0) {
                    this.removeEmptyModel(docView, model);
                }
                if (recursive) {
                    success = this.deleteAtMarkerPosition(docView, false);
                }
            }
        }
        if (!success && oldView != null) {
            oldView.setPositionMarker(oldOffset);
        }
        return success;
    }

    private boolean deleteAtMathBoundary(WmiMathDocumentView docView, boolean recursive) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel newModel;
        boolean success = false;
        WmiPositionMarker oldMarker = docView.getPositionMarker();
        WmiPositionedView oldView = oldMarker.getView();
        int oldOffset = oldMarker.getOffset();
        String commandName = this.getDirection() < 0 ? "move.left" : "move.right";
        WmiCommand moveCommand = WmiCommand.getCommandInstance(commandName);
        ActionEvent event = new ActionEvent(docView, 0, commandName);
        moveCommand.doCommand(event);
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiPositionedView newView = marker != null ? marker.getView() : null;
        WmiModel wmiModel = newModel = newView != null ? newView.getModel() : null;
        if (newModel != null) {
            WmiCompositeModel oldWrapper = WmiModelUtil.findAncestorOfTag(oldView.getModel(), WmiModelTag.MATH);
            WmiCompositeModel newWrapper = WmiModelUtil.findAncestorOfTag(newModel, WmiModelTag.MATH);
            if (oldWrapper != null && newWrapper != oldWrapper && recursive) {
                WmiCompositeModel oldParagraph = WmiModelUtil.findAncestorOfClass(oldView.getModel(), WmiParagraphModel.class);
                WmiCompositeModel newParagraph = WmiModelUtil.findAncestorOfClass(newModel, WmiParagraphModel.class);
                if (newParagraph == oldParagraph) {
                    success = this.deleteAtMarkerPosition(docView, false);
                } else if (newParagraph != null && oldParagraph != null && newParagraph != oldParagraph) {
                    success = this.conditionalParagraphMerge(docView, oldParagraph, newParagraph, newModel);
                }
            }
        }
        if (!success) {
            if (oldMarker != marker) {
                docView.setPositionMarker(oldMarker);
            } else {
                oldView.setPositionMarker(oldOffset);
            }
        }
        return success;
    }

    private boolean conditionalParagraphMerge(WmiMathDocumentView docView, WmiCompositeModel oldParagraph, WmiCompositeModel newParagraph, WmiModel newModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success = oldParagraph != null && newParagraph != null;
        WmiMathDocumentModel docModel = oldParagraph != null ? oldParagraph.getDocument() : null;
        WmiMathDocumentHierarchyValidator validator = docModel != null ? docModel.getModelHierarchyValidator() : null;
        success &= validator != null & oldParagraph != null && validator.hasPostDeletePermission(oldParagraph.getTag());
        while (success && oldParagraph.getParent() != newParagraph.getParent()) {
            oldParagraph = oldParagraph.getParent();
            newParagraph = newParagraph.getParent();
            if (oldParagraph == null || newParagraph == null) {
                success = false;
            }
            if (oldParagraph.getTag() != newParagraph.getTag()) {
                success = false;
            }
            if (!validator.hasPostDeletePermission(oldParagraph.getTag())) {
                success = false;
            }
            if (!oldParagraph.isDeletionBoundary()) continue;
            success = false;
        }
        if (success) {
            success = this.mergeParagraphs(docView, oldParagraph, newParagraph, newModel, this.getDirection());
        }
        return success;
    }

    private boolean mergeParagraphs(WmiMathDocumentView docView, WmiCompositeModel oldParagraph, WmiCompositeModel newParagraph, WmiModel newModel, int direction) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success = false;
        int size = oldParagraph.getChildCount();
        int i = size - 1;
        while (i >= 0) {
            WmiModel child = oldParagraph.getChild(i);
            if (child != newModel && child instanceof WmiTextModel && ((WmiTextModel)child).getLength() == 0) {
                try {
                    oldParagraph.removeChild(i);
                }
                catch (WmiModelIndexOutOfBoundsException e) {
                    WmiErrorLog.log(e);
                }
            }
            --i;
        }
        WmiCompositeModel target = null;
        WmiCompositeModel source = null;
        if (direction < 0) {
            target = newParagraph;
            source = oldParagraph;
        } else {
            target = oldParagraph;
            source = newParagraph;
        }
        size = source.getChildCount();
        WmiModel[] kids = new WmiModel[size];
        int i2 = 0;
        while (i2 < size) {
            kids[i2] = source.getChild(i2);
            ++i2;
        }
        int insertIndex = target.getChildCount();
        WmiModel lhs = insertIndex > 0 ? target.getChild(insertIndex - 1) : null;
        WmiModel rhs = size > 0 ? source.getChild(0) : null;
        try {
            source.removeChildren(0, size);
            target.addChildren(kids, insertIndex);
            WmiCompositeModel parent = source.getParent();
            parent.removeChild(source);
            if (lhs != null && rhs != null && lhs.getTag() == rhs.getTag()) {
                WmiMathDocumentHierarchyValidator validator;
                WmiMathDocumentModel docModel = lhs.getDocument();
                WmiMathDocumentHierarchyValidator wmiMathDocumentHierarchyValidator = validator = docModel != null ? docModel.getModelHierarchyValidator() : null;
                if (validator.hasPostDeletePermission(lhs.getTag())) {
                    if (lhs instanceof WmiCompositeModel) {
                        this.mergeParagraphs(docView, (WmiCompositeModel)lhs, (WmiCompositeModel)rhs, newModel, 1);
                    } else if (lhs instanceof WmiTextModel) {
                        this.mergeText(docView, (WmiTextModel)lhs, (WmiTextModel)rhs);
                    }
                }
            }
            success = true;
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        return success;
    }

    private void mergeText(WmiMathDocumentView docView, WmiTextModel target, WmiTextModel source) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel parent;
        int index;
        WmiFontAttributeSet sourceAttr;
        WmiFontAttributeSet targetAttr = (WmiFontAttributeSet)target.getAttributes();
        if (targetAttr.equals(sourceAttr = (WmiFontAttributeSet)source.getAttributes()) && (index = (parent = target.getParent()).indexOf(source)) >= 0) {
            int caretPos = target.getLength();
            docView.setPendingPosition(new WmiModelPosition(target, caretPos));
            try {
                target.appendText(source.getText());
                parent.removeChild(index);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        }
    }

    private boolean removeEmptyModel(WmiMathDocumentView docView, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success = false;
        WmiCompositeModel parent = model.getParent();
        if (parent != null) {
            WmiMathDocumentModel docModel;
            WmiMathDocumentHierarchyValidator validator;
            int size = parent.getChildCount();
            if (size == 1 && model.getTag() != WmiModelTag.TEXT && !(model instanceof WmiMathModel) && (validator = (docModel = model.getDocument()).getModelHierarchyValidator()).isValid(parent.getTag(), WmiModelTag.TEXT)) {
                try {
                    WmiAttributeSet set = parent.getAttributesForRead();
                    WmiTextModel placeholder = new WmiTextModel(docModel);
                    placeholder.addAttributes(set);
                    parent.replaceChild(placeholder, 0);
                    docView.setPendingPosition(new WmiModelPosition(placeholder, 0));
                    success = true;
                }
                catch (WmiModelIndexOutOfBoundsException e) {
                    WmiErrorLog.log(e);
                }
            }
            if (size > 1) {
                try {
                    int index = parent.indexOf(model);
                    int offset = -1;
                    if (index > 0) {
                        --index;
                    } else {
                        offset = 0;
                    }
                    parent.removeChild(model);
                    success = true;
                    if (docView != null) {
                        docView.setPendingPosition(new WmiModelPosition(parent.getChild(index), offset));
                    }
                }
                catch (WmiModelIndexOutOfBoundsException e) {
                    WmiErrorLog.log(e);
                }
            }
        }
        return success;
    }

    private boolean deleteSelection(WmiMathDocumentView docView) throws WmiNoReadAccessException {
        boolean success = false;
        WmiSelection selection = docView.getSelection();
        if (selection != null) {
            WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
            WmiCustomDeleteHandler handler = docModel.getCustomDeleteHandler();
            if (handler != null) {
                try {
                    success = handler.deleteSelection(docView);
                }
                catch (WmiNoWriteAccessException e) {
                    WmiErrorLog.log(e);
                }
            }
            if (!success && WmiAbstractDelete.isDeleteableSelection(selection, false)) {
                selection.deleteSelection();
                success = true;
            }
        }
        return success;
    }

    @Override
    public boolean isEnabled(WmiView view) {
        return true;
    }

    protected abstract boolean canSelectNext(int var1, int var2);

    protected abstract int getDirection();

    @Override
    protected String getResourcePath() {
        return RESOURCE_LOCATION;
    }

    public static boolean isDeleteableSelection(WmiSelection selection, boolean strictReadOnly) throws WmiNoReadAccessException {
        boolean isDeletable = true;
        WmiMathDocumentView docView = selection.getSourceDocument();
        WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
        WmiModel[] models = new WmiModel[2];
        int[] offsets = new int[2];
        selection.getModelInterval(models, offsets);
        if (models[0] != null && models[1] != null) {
            WmiModel boundary;
            boolean isEndMutable;
            WmiModel boundary2;
            isDeletable = false;
            WmiModel startModel = models[0];
            WmiModel endModel = models[1];
            int startOffset = offsets[0];
            int endOffset = offsets[1];
            boolean isStartMutable = docModel.isMutableModel(startModel);
            if (!isStartMutable && (boundary2 = WmiAbstractDelete.getMutableDeletionBoundary(startModel, startOffset, -1)) != null) {
                WmiCompositeModel parent = boundary2.getParent();
                isStartMutable = docModel.isMutableModel(parent);
            }
            if (!(isEndMutable = docModel.isMutableModel(endModel)) && (boundary = WmiAbstractDelete.getMutableDeletionBoundary(endModel, endOffset, 1)) != null) {
                WmiCompositeModel parent = boundary.getParent();
                isEndMutable = docModel.isMutableModel(parent);
            }
            isDeletable = isStartMutable && isEndMutable;
        }
        return isDeletable;
    }

    /*
     * Unable to fully structure code
     */
    private static WmiModel getMutableDeletionBoundary(WmiModel reference, int offset, int direction) throws WmiNoReadAccessException {
        block5: {
            boundary = reference;
            docModel = reference.getDocument();
            if (direction == -1 && offset != 0) {
                return null;
            }
            if (direction != 1 || offset < 0) ** GOTO lbl22
            if (!(reference instanceof WmiTextModel)) break block5;
            if (offset < ((WmiTextModel)reference).getLength()) {
                return null;
            }
            ** GOTO lbl22
        }
        return null;
lbl-1000:
        // 1 sources

        {
            parent = boundary.getParent();
            index = parent.indexOf(boundary);
            if (direction == -1 && index > 0 && !docModel.isMutableModel(parent)) {
                boundary = null;
                break;
            }
            if (direction == 1 && index >= 0 && index < parent.getChildCount() - 1 && !docModel.isMutableModel(parent)) {
                boundary = null;
                break;
            }
            boundary = parent;
            if (boundary.isDeletionBoundary()) break;
lbl22:
            // 3 sources

            ** while (!docModel.isMutableModel((WmiModel)boundary))
        }
lbl23:
        // 4 sources

        return boundary;
    }
}

