/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.util.WmiSearchVisitor;
import java.awt.event.ActionEvent;

public class WmiDiscardParsedMeaningCommand
extends WmiCommand {
    private static final String RESOURCE_LOCATION = "com.maplesoft.mathdoc.controller.edit.resources.Edit";

    public WmiDiscardParsedMeaningCommand() {
        super("edit.discardmeaning");
    }

    @Override
    public boolean isEnabled(WmiView view) {
        WmiMathDocumentView docView;
        boolean isEnabled = false;
        WmiMathDocumentView wmiMathDocumentView = docView = view != null ? view.getDocumentView() : null;
        if (docView != null) {
            WmiPositionMarker marker = docView.getPositionMarker();
            if (WmiModelLock.readLock(view.getModel(), false)) {
                try {
                    try {
                        WmiMathWrapperModel model = this.getMathWrapper(marker);
                        if (model != null && !marker.isReadOnly()) {
                            isEnabled = true;
                        }
                    }
                    catch (WmiNoReadAccessException nra) {
                        WmiErrorLog.log(nra);
                        WmiModelLock.readUnlock(view.getModel());
                    }
                }
                finally {
                    WmiModelLock.readUnlock(view.getModel());
                }
            }
        }
        return isEnabled;
    }

    private WmiMathWrapperModel getMathWrapper(WmiPositionMarker marker) throws WmiNoReadAccessException {
        WmiModel modelAtView;
        WmiPositionedView viewAtMarker;
        WmiMathWrapperModel model = null;
        if (marker != null && (viewAtMarker = marker.getView()) != null && (modelAtView = viewAtMarker.getModel()) != null) {
            model = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag(modelAtView, WmiModelTag.MATH);
        }
        return model;
    }

    public static void discardSemantics(WmiMathWrapperModel wrapper) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        wrapper.discardSemantics();
    }

    public static void discardAllSemantics(WmiModel doc) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModelUtil.visitModels(doc, (WmiSearchVisitor)new DiscardSemanticsVisitor(), WmiModelTag.MATH, WmiModelTag.MATH);
    }

    @Override
    public void doCommand(ActionEvent event) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentView docView = WmiDiscardParsedMeaningCommand.getDocumentView(event);
        if (docView != null && this.isEnabled(docView)) {
            WmiPositionMarker marker = docView.getPositionMarker();
            WmiMathWrapperModel model = null;
            model = this.getMathWrapper(marker);
            if (model != null) {
                WmiDiscardParsedMeaningCommand.discardSemantics(model);
                try {
                    model.getDocument().update(this.getResource(5));
                }
                catch (WmiNoUpdateAccessException nua) {
                    WmiErrorLog.log(nua);
                }
            }
        }
    }

    @Override
    protected String getResourcePath() {
        return RESOURCE_LOCATION;
    }

    private static class DiscardSemanticsVisitor
    implements WmiSearchVisitor {
        private DiscardSemanticsVisitor() {
        }

        @Override
        public int visitMatch(Object match) {
            int res = 0;
            if (match instanceof WmiMathWrapperModel) {
                WmiMathWrapperModel wrapper = (WmiMathWrapperModel)match;
                WmiMathDocumentModel doc = wrapper.getDocument();
                try {
                    if (doc.isMutableModel(wrapper)) {
                        WmiDiscardParsedMeaningCommand.discardSemantics(wrapper);
                    }
                }
                catch (WmiNoReadAccessException nrae) {
                    WmiErrorLog.log(nrae);
                }
                catch (WmiNoWriteAccessException nwae) {
                    WmiErrorLog.log(nwae);
                }
                res = 1;
            }
            return res;
        }
    }
}

