/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.edit.WmiTransfer;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLPresentationFormatter;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiMathMLDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiSelection;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.StringReader;
import java.io.StringWriter;

public class WmiMathMLTransfer
extends WmiTransfer
implements Transferable,
ClipboardOwner {
    public static final DataFlavor MATHML_STRING_FLAVOR = new DataFlavor("application/x-java-maple-mathml;class=java.lang.String", "MathML");
    public static final DataFlavor MATHML_IMAGE_FLAVOR = new DataFlavor("application/x-java-maple-mathml-image", "MathML Image");

    private WmiMathMLTransfer() {
    }

    public static WmiTransfer createTransferable(WmiSelection selection) {
        WmiMathMLTransfer transfer = null;
        WmiModel[] models = new WmiModel[2];
        int[] offsets = new int[2];
        if (selection.getModelInterval(models, offsets)) {
            WmiMathMLDocumentView mathDocView = (WmiMathMLDocumentView)selection.getSourceDocument();
            transfer = WmiMathMLTransfer.createCompositeModelTransferable(models[0], offsets[0], models[1], offsets[1], mathDocView);
        }
        return transfer;
    }

    private static WmiMathMLTransfer createCompositeModelTransferable(WmiModel startModel, int startIndex, WmiModel endModel, int endIndex, WmiMathMLDocumentView mathDocView) {
        WmiMathMLTransfer transfer = null;
        WmiCompositeModel parent = startModel.getDocument();
        WmiTransferModel transferModel = null;
        WmiMathDocumentModel docModel = null;
        try {
            WmiModelPath startPath = new WmiModelPath(startModel);
            WmiModelPath endPath = new WmiModelPath(endModel);
            if (startPath.depth() == 0 || endPath.depth() == 0) {
                return null;
            }
            try {
                int startDepth = startPath.depth();
                int endDepth = endPath.depth();
                int minDepth = startDepth < endDepth ? startDepth : endDepth;
                int depth = 0;
                while (depth < minDepth) {
                    WmiModel child;
                    int peek = startPath.peek(depth);
                    if (peek != endPath.peek(depth) || !((child = parent.getChild(peek)) instanceof WmiCompositeModel) || child == startModel) break;
                    parent = (WmiCompositeModel)child;
                    ++depth;
                }
                if (WmiMathMLTransfer.isValidTransferModelRoot(parent)) {
                    transferModel = new WmiTransferModel(parent, startPath.peek(depth), endPath.peek(depth));
                    if (parent instanceof WmiMathModel) {
                        transferModel.setSemantics(((WmiMathModel)((Object)parent)).getSemantics());
                    }
                    WmiMathMLTransfer.trimStartPath(transferModel, startPath, depth, startIndex);
                    WmiMathMLTransfer.trimEndPath(transferModel, endPath, depth, endIndex, startIndex);
                    transfer = new WmiMathMLTransfer();
                    StringWriter writer = new StringWriter();
                    WmiMathMLPresentationFormatter formatter = new WmiMathMLPresentationFormatter(mathDocView);
                    if (startPath.equals(endPath)) {
                        WmiModel m = parent.getChild(startPath.peek(depth));
                        formatter.format(writer, m);
                    } else {
                        formatter.format(writer, transferModel);
                    }
                    String mathml = writer.toString();
                    if (!mathml.startsWith("<math")) {
                        mathml = "<math xmlns='http://www.w3.org/1998/Math/MathML'>" + mathml + "</math>";
                    }
                    transfer.addDataFlavor(DataFlavor.stringFlavor, mathml);
                    WmiTransferMathMLView docView = new WmiTransferMathMLView();
                    docModel = (WmiMathDocumentModel)docView.getModel();
                    WmiMathMLImportParser parser = new WmiMathMLImportParser();
                    StringReader reader = new StringReader(mathml);
                    WmiModelLock.writeLock(docModel, true);
                    parser.parse(reader, (WmiCompositeModel)docModel, 0);
                    docModel.update(null);
                    int height = docView.getHeight();
                    int width = docView.getWidth();
                    BufferedImage image = new BufferedImage(width, height, 2);
                    Graphics2D g = image.createGraphics();
                    docView.draw(g, new WmiRenderPath(docView), new Rectangle(0, 0, width, height));
                    transfer.addDataFlavor(DataFlavor.imageFlavor, image);
                    g.dispose();
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
            catch (WmiParseException e) {
                WmiErrorLog.log(e);
            }
            catch (WmiNoUpdateAccessException e) {
                WmiErrorLog.log(e);
            }
            catch (WmiFormatException e) {
                WmiErrorLog.log(e);
            }
        }
        finally {
            if (docModel != null) {
                WmiModelLock.writeUnlock(docModel);
            }
        }
        return transfer;
    }

    protected static class WmiTransferMathMLView
    extends WmiMathMLDocumentView {
        private static final int EQUATION_WIDTH = 400;

        protected WmiTransferMathMLView() {
        }

        @Override
        public int getBreakWidth() {
            return 400;
        }
    }
}

