/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsert2DMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiDefaultPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.event.ActionEvent;

public class WmiToggleEditMode
extends WmiCommand {
    private static final String RESOURCE_LOCATION = "com.maplesoft.mathdoc.controller.edit.resources.Edit";

    public WmiToggleEditMode() {
        super("edit.mode.toggle");
    }

    public WmiToggleEditMode(String name) {
        super(name);
    }

    public WmiToggleEditMode(String name, boolean replace) {
        super(name, replace);
    }

    @Override
    protected String getResourcePath() {
        return RESOURCE_LOCATION;
    }

    @Override
    public boolean isEnabled(WmiView view) {
        boolean enabledNow = false;
        WmiModel model = null;
        if (view != null) {
            WmiPositionedView viewAtMarker;
            WmiMathDocumentView docView = view.getDocumentView();
            WmiPositionMarker marker = docView.getPositionMarker();
            boolean isInContainer = false;
            if (marker != null && (viewAtMarker = marker.getView()) != null) {
                WmiScrollableContainerView container = WmiViewUtil.findEnclosingContainer(viewAtMarker);
                if (container != null && !container.isDocumentView()) {
                    isInContainer = true;
                } else {
                    model = viewAtMarker.getModel();
                }
            }
            enabledNow = !isInContainer && (model instanceof WmiMathModel || model instanceof WmiTextModel) && docView.getSelection() == null;
        }
        return enabledNow;
    }

    @Override
    public void doCommand(ActionEvent e) throws WmiNoReadAccessException, WmiNoWriteAccessException {
    }

    protected WmiModel fetchModel(ActionEvent e) {
        WmiMathDocumentView docView = WmiToggleEditMode.getDocumentView(e);
        WmiModel model = null;
        WmiPositionMarker marker = null;
        WmiPositionedView view = null;
        if (docView != null && (marker = docView.getPositionMarker()) != null && (view = marker.getView()) != null) {
            model = view.getModel();
        }
        return model;
    }

    protected WmiModel toggleIntoMathMode(WmiModel model, WmiMathDocumentModel doc, WmiMathDocumentView docView) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        WmiMathModel newRow;
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiModelPosition mpos = marker.getModelPosition();
        int positionOffset = mpos.getOffset();
        WmiMathWrapperModel wrapperInserted = WmiInsert2DMathCommand.insert2DMath(model, positionOffset, doc);
        WmiModel leafModel = null;
        if (wrapperInserted != null && wrapperInserted.getChildCount() > 0 && (newRow = (WmiMathModel)wrapperInserted.getChild(0)) != null && newRow instanceof WmiCompositeModel) {
            leafModel = ((WmiCompositeModel)((Object)newRow)).getChild(0);
        }
        doc.update(this.getResource(5));
        this.updateCaretPosition(leafModel, marker);
        return leafModel;
    }

    protected WmiModel toggleBackToTextMode(WmiModel model, WmiMathDocumentModel doc, WmiMathDocumentView docView) throws WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        WmiModel targetModel = null;
        WmiMathWrapperModel wrapper = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH);
        try {
            if (wrapper != null && wrapper.isEmptyMath()) {
                WmiPositionMarker marker = docView.getPositionMarker();
                WmiCompositeModel wrapperParent = wrapper.getParent();
                int wrapperIndex = wrapperParent.indexOf(wrapper);
                int parentLength = wrapperParent.getChildCount();
                int beforeIndex = wrapperIndex - 1;
                int afterIndex = wrapperIndex + 1;
                boolean removePerformed = false;
                if (beforeIndex >= 0 && afterIndex < parentLength) {
                    WmiModel beforeModel = wrapperParent.getChild(beforeIndex);
                    WmiModel afterModel = wrapperParent.getChild(afterIndex);
                    if (beforeModel instanceof WmiTextModel && afterModel instanceof WmiTextModel) {
                        removePerformed = this.textRemovalWithJoin(targetModel, wrapper, wrapperParent, doc, beforeModel, afterModel, docView);
                    }
                }
                if (!removePerformed) {
                    int newCaretIndex = wrapperParent.indexOf(wrapper);
                    targetModel = wrapperParent.getChild(newCaretIndex);
                    if (wrapperParent.getChildCount() < 2) {
                        this.addEmptyTextModel(wrapperParent, docView, true);
                    } else if (wrapperIndex == parentLength - 1) {
                        WmiTextModel destModel = null;
                        int destOffset = 0;
                        WmiModel leftSibling = wrapperParent.getChild(wrapperIndex - 1);
                        if (leftSibling instanceof WmiTextModel) {
                            destModel = (WmiTextModel)leftSibling;
                            destOffset = destModel.getLength();
                            this.updateCaretPosition(destModel, marker, destOffset);
                        } else {
                            destModel = this.addEmptyTextModel(wrapperParent, docView, false);
                        }
                        if (destModel != null) {
                            this.positionCaret(docView, destModel, destOffset);
                        }
                    } else {
                        this.addEmptyTextModel(wrapperParent, wrapperIndex, docView, true);
                    }
                    wrapperParent.removeChild(wrapper);
                    doc.update(this.getResource(5));
                }
            } else if (wrapper != null && this.advanceToNextModel(wrapper, docView)) {
                doc.update(this.getResource(5));
            }
        }
        catch (WmiModelIndexOutOfBoundsException miob) {
            WmiErrorLog.log(miob);
        }
        return targetModel;
    }

    protected boolean textRemovalWithJoin(WmiModel targetModel, WmiMathWrapperModel wrapper, WmiCompositeModel wrapperParent, WmiMathDocumentModel doc, WmiModel beforeModel, WmiModel afterModel, WmiMathDocumentView docView) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        boolean removePerformed = false;
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiAttributeSet befAtts = beforeModel.getAttributes();
        if (befAtts.equals(afterModel.getAttributes())) {
            WmiTextModel replacement = new WmiTextModel(doc, ((WmiTextModel)beforeModel).getText(), (WmiFontAttributeSet)befAtts);
            replacement.appendText(((WmiTextModel)afterModel).getText());
            int replaceIndex = wrapperParent.indexOf(wrapper);
            int caretTargetIndex = ((WmiTextModel)beforeModel).getLength();
            WmiModel[] replacements = new WmiModel[]{replacement};
            wrapperParent.replaceChildren(replacements, replaceIndex - 1, 3);
            doc.update(this.getResource(5));
            this.updateCaretPosition(replacement, marker, caretTargetIndex);
            removePerformed = true;
            targetModel = replacement;
        }
        return removePerformed;
    }

    protected boolean advanceToNextModel(WmiModel model, WmiMathDocumentView docView) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiCompositeModel parent;
        boolean needsUpdate = false;
        if (model != null && (parent = model.getParent()) != null) {
            int wrapperIndex = parent.indexOf(model);
            int parentLength = parent.getChildCount();
            WmiPositionMarker marker = docView.getPositionMarker();
            if (WmiModelUtil.isLeftmostPosition(marker.getModelPosition())) {
                WmiModel leftSibling;
                WmiTextModel textModel = null;
                if (wrapperIndex > 0 && (leftSibling = parent.getChild(wrapperIndex - 1)) instanceof WmiTextModel) {
                    textModel = (WmiTextModel)leftSibling;
                }
                if (textModel == null) {
                    textModel = this.addEmptyTextModel(parent, wrapperIndex, docView, false);
                }
                int newOffset = textModel.getLength();
                this.positionCaret(docView, textModel, newOffset);
                needsUpdate = true;
            } else {
                int targetIndex = wrapperIndex + 1;
                if (targetIndex < parentLength) {
                    WmiModel nextModel = parent.getChild(targetIndex);
                    if (nextModel instanceof WmiTextModel) {
                        this.updateCaretPosition(nextModel, marker);
                    } else {
                        this.addEmptyTextModel(parent, targetIndex, docView, true);
                        needsUpdate = true;
                    }
                } else {
                    this.addEmptyTextModel(parent, docView, true);
                    needsUpdate = true;
                }
            }
        }
        return needsUpdate;
    }

    protected void updateCaretPosition(WmiModel leafModel, WmiPositionMarker marker) throws WmiNoReadAccessException {
        this.updateCaretPosition(leafModel, marker, 0);
    }

    protected void updateCaretPosition(WmiModel leafModel, WmiPositionMarker marker, int targetIndex) throws WmiNoReadAccessException {
        WmiPositionedView view = marker.getView();
        if (view != null && marker != null && leafModel != null) {
            marker.updateMarkerPosition(leafModel, targetIndex);
            WmiMathDocumentView docView = view.getDocumentView();
            if (docView != null && (marker = docView.getPositionMarker()) != null) {
                marker.show();
            }
        }
    }

    protected WmiTextModel addEmptyTextModel(WmiCompositeModel parent, WmiMathDocumentView docView, boolean reposition) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        return this.addEmptyTextModel(parent, -1, docView, reposition);
    }

    protected WmiTextModel addEmptyTextModel(WmiCompositeModel parent, int index, WmiMathDocumentView docView, boolean reposition) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiTextModel filler = this.createTextFillModel(parent);
        if (index < 0) {
            parent.appendChild(filler);
        } else {
            parent.addChild(filler, index);
        }
        if (reposition) {
            this.positionCaret(docView, filler, 0);
        }
        return filler;
    }

    protected WmiTextModel createTextFillModel(WmiCompositeModel parent) throws WmiNoReadAccessException {
        WmiFontAttributeSet attrs = new WmiFontAttributeSet();
        attrs.addAttributes(parent.getAttributes());
        return new WmiTextModel(parent.getDocument(), "", attrs);
    }

    protected void positionCaret(WmiMathDocumentView docView, WmiModel model, int offset) {
        WmiModelPosition mdlPos = new WmiModelPosition(model, offset);
        WmiDefaultPositionUpdateHandler posHdlr = new WmiDefaultPositionUpdateHandler(docView, mdlPos);
        docView.setPendingPositionUpdateHandler(posHdlr);
    }
}

