/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.components.WmiContextManager;
import com.maplesoft.mathdoc.controller.Wmi2DEntryMode;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.event.ActionEvent;

public abstract class WmiToggleEntryModeCommand
extends WmiCommand {
    private static final String RESOURCE_LOCATION = "com.maplesoft.mathdoc.controller.edit.resources.Edit";

    protected WmiToggleEntryModeCommand(String name) {
        super(name);
    }

    @Override
    public void doCommand(ActionEvent event) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentView docView = WmiToggleEntryModeCommand.getDocumentView(event);
        if (docView != null && this.isEnabled(docView)) {
            WmiContextManager ctxMgr = docView.getContextManager();
            Wmi2DEntryMode entryMode = ctxMgr.getEntryMode();
            if (!entryMode.equals(this.getEntryMode())) {
                ctxMgr.updateEntryMode(this.getEntryMode());
            } else {
                ctxMgr.updateEntryMode(WmiContextManager.EM_STANDARD);
            }
        }
    }

    protected abstract Wmi2DEntryMode getEntryMode();

    @Override
    protected String getResourcePath() {
        return RESOURCE_LOCATION;
    }

    @Override
    public boolean isEnabled(WmiView view) {
        WmiPositionMarker marker;
        boolean enabled = false;
        WmiMathDocumentView docView = view.getDocumentView();
        if (docView != null && (marker = docView.getPositionMarker()) != null) {
            WmiModelPosition modelPos;
            WmiScrollableContainerView container;
            boolean isInSubcontainer = false;
            WmiPositionedView markerView = marker.getView();
            if (markerView != null && (container = WmiViewUtil.findEnclosingContainer(markerView)) != null) {
                boolean bl = isInSubcontainer = !container.isDocumentView();
            }
            if (!isInSubcontainer && (modelPos = marker.getModelPosition()).getModel() instanceof WmiMathModel) {
                enabled = true;
            }
        }
        return enabled;
    }
}

