/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.edit;

import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiBoundsMarker;
import com.maplesoft.mathdoc.view.WmiSelection;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class WmiTransfer
implements Transferable,
ClipboardOwner {
    private ArrayList flavors = null;
    private ArrayList data = null;
    private static HashSet invalidTransferModelTags = new HashSet();
    private static HashSet selfreturningTransferModelTags;

    static {
        invalidTransferModelTags.add(WmiModelTag.MATH_TABLE_ROW);
        invalidTransferModelTags.add(WmiModelTag.MATH_TABLE_ROW);
        selfreturningTransferModelTags = new HashSet();
    }

    protected WmiTransfer() {
    }

    protected void addDataFlavor(DataFlavor flavor, Object value) {
        if (this.flavors == null) {
            this.flavors = new ArrayList();
            this.data = new ArrayList();
        }
        this.flavors.add(flavor);
        this.data.add(value);
    }

    public static WmiTransfer createTransferable(WmiSelection selection) {
        return null;
    }

    public static WmiTransfer createTransferable(WmiBoundsMarker marker) {
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] f = null;
        if (this.flavors != null) {
            f = new DataFlavor[this.flavors.size()];
            int i = 0;
            while (i < this.flavors.size()) {
                f[i] = (DataFlavor)this.flavors.get(i);
                ++i;
            }
        }
        return f;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        boolean supported = false;
        if (this.flavors != null) {
            int i = 0;
            while (i < this.flavors.size()) {
                DataFlavor f = (DataFlavor)this.flavors.get(i);
                if (f != null && f.equals(flavor)) {
                    supported = true;
                    break;
                }
                ++i;
            }
        }
        return supported;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        Object transfer = null;
        if (this.flavors != null && this.data != null) {
            int i = 0;
            while (i < this.flavors.size()) {
                DataFlavor f = (DataFlavor)this.flavors.get(i);
                if (f != null && f.equals(flavor)) {
                    transfer = this.data.get(i);
                    break;
                }
                ++i;
            }
        }
        return transfer;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transfer) {
    }

    protected static void trimStartPath(WmiTransferModel transferModel, WmiModelPath path, int depth, int index) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int limit = path.depth();
        WmiModel child = transferModel.getFirstChild();
        if (!(child instanceof WmiMathWrapperModel)) {
            WmiTransferModel childTransfer;
            int lastChild;
            while (++depth < limit) {
                int bounds = path.peek(depth);
                if (!(child instanceof WmiCompositeModel)) break;
                lastChild = ((WmiCompositeModel)child).getChildCount() - 1;
                childTransfer = new WmiTransferModel((WmiCompositeModel)child, bounds, lastChild);
                if (child instanceof WmiMathModel) {
                    childTransfer.setSemantics(((WmiMathModel)child).getSemantics());
                }
                transferModel.replaceFirstChild(childTransfer);
                transferModel = childTransfer;
                child = transferModel.getFirstChild();
                if (child instanceof WmiMathWrapperModel) break;
            }
            if (!(child instanceof WmiMathModel)) {
                if (child instanceof WmiTextModel && index > 0) {
                    String text = ((WmiTextModel)child).getText();
                    WmiTextModel textFragment = new WmiTextModel(child.getDocument(), text.substring(index), (WmiFontAttributeSet)child.getAttributesForRead());
                    transferModel.replaceFirstChild(textFragment);
                } else if (child instanceof WmiCompositeModel) {
                    int start = index == -1 ? 0 : index;
                    lastChild = ((WmiCompositeModel)child).getChildCount() - 1;
                    childTransfer = new WmiTransferModel((WmiCompositeModel)child, start, lastChild);
                    if (child instanceof WmiMathModel) {
                        childTransfer.setSemantics(((WmiMathModel)child).getSemantics());
                    }
                    transferModel.replaceFirstChild(childTransfer);
                }
            } else if (child instanceof WmiAbstractMathTokenModel) {
                if (index > 0) {
                    WmiAbstractMathTokenModel mathToken = (WmiAbstractMathTokenModel)child;
                    WmiTextModel newModel = WmiTransfer.normalizeMathTextModel(mathToken, index, true);
                    newModel.setParent(mathToken.getParent());
                    transferModel.replaceFirstChild(newModel);
                }
            } else if (child instanceof WmiMathModel && index == -1) {
                transferModel.trim(0);
            }
        }
    }

    protected static void trimEndPath(WmiTransferModel transferModel, WmiModelPath path, int depth, int index, int startIndex) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int limit = path.depth();
        WmiModel child = transferModel.getLastChild();
        if (!(child instanceof WmiMathWrapperModel)) {
            while (++depth < limit) {
                int bounds = path.peek(depth);
                if (!(child instanceof WmiCompositeModel)) break;
                WmiTransferModel childTransfer = new WmiTransferModel((WmiCompositeModel)child, 0, bounds);
                if (child instanceof WmiMathModel) {
                    childTransfer.setSemantics(((WmiMathModel)child).getSemantics());
                }
                transferModel.replaceLastChild(childTransfer);
                transferModel = childTransfer;
                child = transferModel.getLastChild();
                if (child instanceof WmiMathWrapperModel) break;
            }
            if (!(child instanceof WmiMathModel)) {
                if (child instanceof WmiTextModel) {
                    String text = ((WmiTextModel)child).getText();
                    if (index < text.length()) {
                        WmiTextModel textFragment = new WmiTextModel(child.getDocument(), text.substring(0, index), (WmiFontAttributeSet)child.getAttributesForRead());
                        transferModel.replaceLastChild(textFragment);
                    }
                } else if (child instanceof WmiCompositeModel) {
                    int length = ((WmiCompositeModel)child).getChildCount() - 1;
                    int end = index == -1 ? length : index;
                    WmiTransferModel childTransfer = new WmiTransferModel((WmiCompositeModel)child, 0, end);
                    if (child instanceof WmiMathModel) {
                        childTransfer.setSemantics(((WmiMathModel)child).getSemantics());
                    }
                    transferModel.replaceLastChild(childTransfer);
                }
            } else if (child instanceof WmiAbstractMathTokenModel) {
                if (transferModel.getChildCount() == 1) {
                    index -= startIndex;
                }
                WmiAbstractMathTokenModel mathToken = (WmiAbstractMathTokenModel)child;
                if (index != -1 && index < mathToken.getLength()) {
                    WmiTextModel newModel = WmiTransfer.normalizeMathTextModel(mathToken, index, false);
                    newModel.setParent(mathToken.getParent());
                    transferModel.replaceLastChild(newModel);
                }
            }
        }
    }

    private static WmiTextModel normalizeMathTextModel(WmiAbstractMathTokenModel mathToken, int index, boolean trimStart) throws WmiNoReadAccessException {
        String text = mathToken.getAllText();
        WmiAttributeSet set = mathToken.getAttributesForRead();
        if (set instanceof WmiMathStringModel.WmiMathStringAttributeSet) {
            Object left = set.getAttribute("lquote");
            Object right = set.getAttribute("rquote");
            if (left == null) {
                left = "\"";
            }
            if (right == null) {
                right = "\"";
            }
            text = left + text + right;
            set = set.copyAttributes();
            set.addAttribute("lquote", "");
            set.addAttribute("rquote", "");
            mathToken = new WmiMathTextModel(mathToken.getDocument(), text, set);
        }
        int startIndex = index;
        int endIndex = mathToken.getLength();
        if (!trimStart) {
            startIndex = 0;
            endIndex = index;
        }
        return MathInsertUtil.createModel(mathToken, text, startIndex, endIndex);
    }

    public static DataFlavor getFlavor(String name) {
        FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
        Map<String, DataFlavor> map = flavorMap.getFlavorsForNatives(null);
        return map.get(name);
    }

    protected static boolean isValidTransferModelRoot(WmiModel model) {
        WmiModelTag tag = model.getTag();
        return !invalidTransferModelTags.contains(tag);
    }

    protected static boolean isOwnTransferModel(WmiModel model) {
        WmiModelTag tag = model.getTag();
        return selfreturningTransferModelTags.contains(tag);
    }
}

