/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.controller.format.WmiFormatMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.ActionEvent;

public abstract class WmiFormatMathModelAttributeCommand
extends WmiFormatMathCommand {
    private Class targetModelClass;

    protected WmiFormatMathModelAttributeCommand(String name, Class targetModel) {
        super(name);
        this.targetModelClass = targetModel;
    }

    @Override
    public void doCommand(ActionEvent e) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentView docView = WmiFormatMathModelAttributeCommand.getDocumentView(e);
        if (docView != null && this.isEnabled(docView)) {
            WmiPositionMarker marker = docView.getPositionMarker();
            WmiMathModel model = null;
            model = this.findTargetModel(marker);
            if (model != null) {
                WmiAttributeSet attrs = model.getAttributes();
                attrs = this.modifyAttribute(attrs);
                model.setAttributes(attrs);
                model.setSemantics(null);
                WmiModel parent = model;
                while (!(parent instanceof WmiMathWrapperModel)) {
                    if (!((parent = parent.getParent()) instanceof WmiMathModel)) continue;
                    parent.setSemantics(null);
                }
                try {
                    model.getDocument().update(this.getResource(5));
                }
                catch (WmiNoUpdateAccessException nua) {
                    WmiErrorLog.log(nua);
                }
            }
        }
    }

    public abstract WmiAttributeSet modifyAttribute(WmiAttributeSet var1);

    protected WmiMathModel findTargetModel(WmiPositionMarker marker) throws WmiNoReadAccessException {
        WmiPositionedView viewAtMarker;
        WmiMathModel model = null;
        if (marker != null && (viewAtMarker = marker.getView()) != null) {
            WmiModel modelAtView = viewAtMarker.getModel();
            model = this.getTargetModel(modelAtView);
        }
        return model;
    }

    protected WmiMathModel getTargetModel(WmiModel target) throws WmiNoReadAccessException {
        WmiMathModel model = null;
        model = target.getClass().equals(this.targetModelClass) ? (WmiMathModel)target : (WmiMathModel)((Object)WmiModelUtil.findAncestorOfClass(target, this.targetModelClass));
        return model;
    }

    @Override
    public boolean isEnabled(WmiView view) {
        WmiMathDocumentView docView;
        boolean isEnabled = false;
        WmiMathDocumentView wmiMathDocumentView = docView = view != null ? view.getDocumentView() : null;
        if (docView != null) {
            WmiPositionMarker marker = docView.getPositionMarker();
            if (WmiModelLock.readLock(view.getModel(), false)) {
                try {
                    try {
                        WmiMathModel model = this.findTargetModel(marker);
                        isEnabled = model != null && !marker.isReadOnly();
                    }
                    catch (WmiNoReadAccessException nra) {
                        WmiErrorLog.log(nra);
                        WmiModelLock.readUnlock(view.getModel());
                    }
                }
                finally {
                    WmiModelLock.readUnlock(view.getModel());
                }
            }
        }
        return isEnabled;
    }
}

