/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.format;

import com.maplesoft.mathdoc.components.WmiComboBox;
import com.maplesoft.mathdoc.controller.format.WmiFormatMathCommand;
import com.maplesoft.mathdoc.controller.format.WmiFormatMathModelAttributeCommand;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class WmiFormatMathStringQuoteCommand
extends WmiFormatMathModelAttributeCommand {
    public WmiFormatMathStringQuoteCommand() {
        super("format.ms.quotes", WmiMathStringModel.class);
    }

    @Override
    public WmiAttributeSet modifyAttribute(WmiAttributeSet attrs) {
        String lquote = (String)attrs.getAttribute("lquote");
        String rquote = (String)attrs.getAttribute("rquote");
        WmiQuoteDialog modQuotes = new WmiQuoteDialog(null, lquote, rquote);
        modQuotes.show();
        if (modQuotes.wasChangeApproved()) {
            lquote = modQuotes.getLeft();
            rquote = modQuotes.getRight();
            attrs.addAttribute("lquote", lquote);
            attrs.addAttribute("rquote", rquote);
        }
        return attrs;
    }

    public class WmiQuoteDialog
    extends WmiFormatMathCommand.WmiFormatDialog {
        private static final String TITLE_KEY = "format.string.title";
        private static final String OPEN_QUOTE_LABEL = "format.string.open.label";
        private static final String CLOSE_QUOTE_LABEL = "format.string.close.label";
        private static final String OPEN_CHAR_LIST_KEY = "format.string.open.characters";
        private static final String CLOSE_CHAR_LIST_KEY = "format.string.close.characters";
        private String leftQuote;
        private String rightQuote;
        private WmiComboBox cbLeftQuote;
        private WmiComboBox cbRightQuote;
        private String[] openChars;
        private String[] closeChars;

        public WmiQuoteDialog(JFrame frame, String leftQut, String rightQut) {
            super(frame);
            this.leftQuote = leftQut;
            this.rightQuote = rightQut;
            this.setTitle(TITLE_KEY, null);
            this.layoutDialog();
        }

        @Override
        public void addComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.mapItemLists();
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.getContentPane().add((Component)new JLabel(this.mapResourceKey(OPEN_QUOTE_LABEL)), gbc);
            this.cbLeftQuote = this.createFormatComboBox(this.openChars);
            gbc.gridx = 1;
            gbc.gridy = 0;
            this.getContentPane().add((Component)this.cbLeftQuote, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.getContentPane().add((Component)new JLabel(this.mapResourceKey(CLOSE_QUOTE_LABEL)), gbc);
            this.cbRightQuote = this.createFormatComboBox(this.closeChars);
            gbc.gridx = 1;
            gbc.gridy = 1;
            this.getContentPane().add((Component)this.cbRightQuote, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            this.getContentPane().add((Component)this.createDefaultButtonsPanel(), gbc);
        }

        public void mapItemLists() {
            this.openChars = this.mapItemList(OPEN_CHAR_LIST_KEY, this.leftQuote);
            this.closeChars = this.mapItemList(CLOSE_CHAR_LIST_KEY, this.rightQuote);
        }

        public String getLeft() {
            Object item = this.cbLeftQuote.getSelectedItem();
            return item != null ? item.toString() : "";
        }

        public String getRight() {
            Object item = this.cbRightQuote.getSelectedItem();
            return item != null ? item.toString() : "";
        }
    }
}

