/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import java.util.ArrayList;

public class MathInsertUtil {
    public static final char BS_ESCAPE_CHAR = '\\';
    public static final int NO_BIAS = 0;
    public static final int LEFT_BIAS = -1;
    public static final int RIGHT_BIAS = 1;

    public static WmiModelPosition deleteMathSelection(WmiMathDocumentView docView) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModelPosition pos = null;
        WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
        WmiSelection selection = docView.getSelection();
        if (selection != null) {
            try {
                WmiModel model;
                pos = MathInsertUtil.wrapSelection(docView);
                WmiModel wmiModel = model = pos != null ? pos.getModel() : null;
                if (model != null) {
                    int index;
                    WmiCompositeModel parent = model.getParent();
                    int n = index = parent != null ? parent.indexOf(model) : -1;
                    if (index >= 0) {
                        WmiFontAttributeSet activeAttr = MathInsertUtil.getInsertAttributes(model);
                        WmiIdentifierModel replacement = new WmiIdentifierModel(docModel, "", "", activeAttr, false);
                        parent.replaceChild(replacement, index);
                        WmiInsertGenericMathCommand.refreshSemantics(parent);
                        pos = new WmiModelPosition(replacement, 0);
                    }
                }
            }
            catch (WmiModelIndexOutOfBoundsException e) {
                WmiErrorLog.log(e);
            }
        }
        return pos;
    }

    public static WmiModelPosition updateInsertionPoint(WmiPositionMarker marker, int bias) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel targetModel;
        WmiModelPosition pos = null;
        WmiPositionedView view = marker != null ? marker.getView() : null;
        WmiModel wmiModel = targetModel = view != null ? view.getModel() : null;
        if (targetModel != null) {
            int targetOffset = marker.getOffset();
            if (view instanceof WmiTextView) {
                targetOffset += ((WmiTextView)view).getStartOffset();
            }
            pos = MathInsertUtil.updateInsertionPoint(new WmiModelPosition(targetModel, targetOffset), bias);
        }
        return pos;
    }

    public static WmiModelPosition updateInsertionPoint(WmiModelPosition pos, int bias) throws WmiNoReadAccessException {
        WmiModelTag targetTag;
        WmiModel targetModel = pos.getModel();
        WmiCompositeModel parent = targetModel != null ? targetModel.getParent() : null;
        int targetIndex = parent != null ? parent.indexOf(targetModel) : -1;
        WmiModelTag parentTag = parent != null ? parent.getTag() : null;
        WmiModelTag wmiModelTag = targetTag = targetModel != null ? targetModel.getTag() : null;
        if (bias == 0) {
            WmiCompositeModel semanticModel;
            WmiAttributeSet set;
            if (targetTag == WmiModelTag.MATH_OPERATOR && (set = targetModel.getAttributesForRead()) instanceof WmiMathOperatorModel.WmiMathOperatorAttributeSet && ((WmiMathOperatorModel.WmiMathOperatorAttributeSet)set).isLargeOp() && parentTag != WmiModelTag.MATH_ROW) {
                pos = new WmiModelPosition(parent, pos.getOffset() == 0 ? 0 : -1);
            }
            if ((semanticModel = MathInsertUtil.findAncestorWithSemantics(targetModel, pos.getOffset())) != null) {
                WmiModel candidate = targetModel;
                while (candidate != null && candidate.getParent() != semanticModel) {
                    candidate = candidate.getParent();
                }
                int index = semanticModel.indexOf(candidate);
                pos = new WmiModelPosition(semanticModel, index == 0 ? 0 : -1);
            }
        } else if (bias == -1 && pos != null && pos.getOffset() == 0) {
            boolean continueSearch;
            targetModel = pos.getModel();
            parent = targetModel != null ? targetModel.getParent() : null;
            boolean bl = continueSearch = parentTag != null;
            if (parentTag != WmiModelTag.MATH_ROW && continueSearch) {
                boolean bl2 = continueSearch = parent.indexOf(targetModel) == 0;
                if (parentTag == WmiModelTag.MATH_MULTISCRIPTS || parentTag == WmiModelTag.MATH_FENCED || parentTag == WmiModelTag.MATH) {
                    continueSearch = false;
                } else if (parentTag == WmiModelTag.MATH_SQUARE_ROOT || parentTag == WmiModelTag.MATH_NROOT) {
                    continueSearch = false;
                    pos = new WmiModelPosition(parent, 0);
                }
            }
            if (continueSearch) {
                targetIndex = parent.indexOf(targetModel);
                if (targetIndex > 0) {
                    WmiModel child = parent.getChild(targetIndex - 1);
                    boolean updateRequired = false;
                    while (child.getTag() == WmiModelTag.MATH_ROW) {
                        WmiCompositeModel comp = (WmiCompositeModel)child;
                        int size = comp.getChildCount();
                        if (size <= 0) break;
                        updateRequired = true;
                        child = comp.getChild(size - 1);
                    }
                    int offset = -1;
                    if (child instanceof WmiTextModel) {
                        offset = ((WmiTextModel)child).getLength();
                    }
                    pos = new WmiModelPosition(child, offset);
                    if (updateRequired) {
                        pos = MathInsertUtil.updateInsertionPoint(pos, bias);
                    }
                } else {
                    pos = MathInsertUtil.updateInsertionPoint(new WmiModelPosition(parent, 0), bias);
                }
            }
        } else if (bias == 1 && pos != null) {
            targetModel = pos.getModel();
            boolean reposition = false;
            if (targetModel instanceof WmiTextModel) {
                int length = ((WmiTextModel)targetModel).getLength();
                boolean isEmpty = false;
                if (length == 0) {
                    if (parentTag == WmiModelTag.MATH_ROW) {
                        if (parent.getChildCount() == 1) {
                            WmiModelTag wmiModelTag2 = parentTag = (parent = parent.getParent()) != null ? parent.getTag() : null;
                            if (parentTag != WmiModelTag.MATH_ROW) {
                                isEmpty = true;
                            }
                        }
                    } else {
                        isEmpty = true;
                    }
                }
                if (pos.getOffset() == length && !isEmpty && parentTag != WmiModelTag.MATH_MULTISCRIPTS) {
                    reposition = true;
                }
            } else if (targetModel instanceof WmiCompositeModel) {
                boolean bl = reposition = pos.getOffset() != 0;
            }
            if (reposition) {
                parent = targetModel.getParent();
                if (parentTag != null && parentTag != WmiModelTag.MATH_FENCED && parentTag != WmiModelTag.MATH) {
                    int n = targetIndex = parent != null ? parent.indexOf(targetModel) : -1;
                    if (targetIndex >= 0 && targetIndex < parent.getChildCount() - 1) {
                        pos = new WmiModelPosition(parent.getChild(targetIndex + 1), 0);
                    } else if (parent != null) {
                        pos = MathInsertUtil.updateInsertionPoint(new WmiModelPosition(parent, -1), bias);
                    }
                }
            }
        }
        pos = MathInsertUtil.testForFenceBoundary(pos);
        return pos;
    }

    private static WmiModelPosition testForFenceBoundary(WmiModelPosition pos) throws WmiNoReadAccessException {
        int targetIndex;
        WmiCompositeModel parent;
        WmiModel targetModel;
        WmiModel wmiModel = targetModel = pos != null ? pos.getModel() : null;
        if (targetModel != null && (parent = targetModel.getParent()) != null && parent.getTag() == WmiModelTag.MATH_FENCED && (targetIndex = parent.indexOf(targetModel)) < 0) {
            WmiMathFencedModel fence = (WmiMathFencedModel)parent;
            WmiAttributeSet set = parent.getAttributesForRead();
            if (set instanceof WmiMathFencedModel.WmiFencedAttributeSet) {
                WmiMathModel left = fence.getModelForLeft();
                WmiMathModel right = fence.getModelForRight();
                if (left == targetModel) {
                    pos = new WmiModelPosition(parent, 0);
                } else if (right == targetModel) {
                    pos = new WmiModelPosition(parent, -1);
                }
            }
        }
        return pos;
    }

    private static WmiCompositeModel findAncestorWithSemantics(WmiModel targetModel, int offset) throws WmiNoReadAccessException {
        WmiCompositeModel parent = targetModel.getParent();
        WmiCompositeModel semanticModel = null;
        WmiCompositeModel candidate = null;
        while (parent != null && parent.getTag() == WmiModelTag.MATH_ROW) {
            Object value;
            candidate = null;
            int targetIndex = parent.indexOf(targetModel);
            int limit = targetModel instanceof WmiCompositeModel ? ((WmiCompositeModel)targetModel).getChildCount() : (targetModel instanceof WmiTextModel ? ((WmiTextModel)targetModel).getLength() : 1);
            WmiAttributeSet set = parent.getAttributesForRead();
            if (set instanceof WmiMathAttributeSet && (value = set.getAttribute("Typesetting:-msemantics")) != null) {
                candidate = parent;
            }
            if ((offset < 0 || offset == limit) && targetIndex == parent.getChildCount() - 1) {
                offset = targetIndex;
                if (candidate != null) {
                    semanticModel = candidate;
                }
            } else {
                if (offset != 0 || targetIndex != 0) break;
                if (candidate != null) {
                    semanticModel = candidate;
                }
            }
            targetModel = parent;
            parent = targetModel.getParent();
        }
        return semanticModel;
    }

    public static void ensureParentMathRow(WmiModelPosition pos) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int targetIndex;
        WmiModel targetModel = pos.getModel();
        WmiMathDocumentModel doc = targetModel.getDocument();
        WmiCompositeModel parent = targetModel.getParent();
        int n = targetIndex = parent != null ? parent.indexOf(targetModel) : -1;
        if (parent != null && parent.getTag() != WmiModelTag.MATH_ROW && targetIndex >= 0) {
            WmiInlineMathModel inline = new WmiInlineMathModel(doc);
            parent.replaceChild(inline, targetIndex);
            inline.addChild(targetModel, 0);
        }
    }

    public static WmiModelPosition insertEmptyPlaceholder(WmiModelPosition pos) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        return MathInsertUtil.insertEmptyPlaceholder(pos, null);
    }

    public static WmiModelPosition insertEmptyPlaceholder(WmiModelPosition pos, ArrayList retokenizeList) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiAttributeSet set;
        WmiTextModel placeholder = null;
        boolean placeholderParent = false;
        WmiModel targetModel = pos.getModel();
        WmiModelTag tag = targetModel.getTag();
        if ((tag == WmiModelTag.MATH_IDENTIFIER || tag == WmiModelTag.MATH_TEXT) && ((WmiTextModel)targetModel).getLength() == 0 && (set = (placeholder = (WmiTextModel)targetModel).getAttributesForRead()) instanceof WmiFontAttributeSet) {
            if (((WmiFontAttributeSet)set).hasStyle(2048)) {
                placeholder = null;
            } else {
                WmiCompositeModel parent = placeholder.getParent();
                set = parent.getAttributesForRead();
                if (((WmiFontAttributeSet)set).hasStyle(2048)) {
                    placeholder = null;
                    placeholderParent = true;
                }
            }
        }
        if (placeholder == null) {
            int targetOffset = pos.getOffset();
            WmiMathDocumentModel doc = targetModel.getDocument();
            WmiCompositeModel parent = targetModel.getParent();
            int targetIndex = parent.indexOf(targetModel);
            WmiFontAttributeSet activeAttr = MathInsertUtil.getInsertAttributes(targetModel);
            if (activeAttr.hasStyle(2048) || placeholderParent) {
                WmiCompositeModel wrapper = WmiModelUtil.findAncestorOfTag(targetModel, WmiModelTag.MATH);
                if (wrapper != null) {
                    activeAttr = (WmiFontAttributeSet)wrapper.getAttributes();
                    int style = activeAttr.getExtendedStyle();
                    style &= 0xFFFFFFFE;
                    activeAttr.setExtendedStyle(style &= 0xFFFFFFFD);
                }
            } else {
                WmiStyleAttributeSet styleSet;
                int style = activeAttr.getExtendedStyle();
                int proto = WmiAbstractMathTokenModel.getPrototype(targetModel, style);
                int styleDeviation = style ^ proto;
                WmiMathDocumentModel docModel = targetModel.getDocument();
                Object styleName = activeAttr.getAttribute(WmiFontAttributeSet.STYLE_KEY);
                if (styleName != null && (styleSet = docModel.getStyle(0, styleName.toString())) instanceof WmiFontAttributeSet) {
                    proto = ((WmiFontAttributeSet)styleSet).getExtendedStyle();
                }
                activeAttr = (WmiFontAttributeSet)activeAttr.copyAttributes();
                if (styleDeviation != 0) {
                    proto &= ~styleDeviation;
                    proto |= style & styleDeviation;
                }
                activeAttr.setExtendedStyle(proto);
            }
            placeholder = new WmiTextModel(doc, "", activeAttr);
            if (targetModel instanceof WmiTextModel) {
                WmiTextModel textModel = (WmiTextModel)targetModel;
                if (targetOffset == textModel.getLength()) {
                    parent.addChild(placeholder, targetIndex + 1);
                } else if (targetOffset == 0) {
                    parent.addChild(placeholder, targetIndex);
                } else {
                    textModel.splitModel(targetOffset, retokenizeList);
                    parent.addChild(placeholder, targetIndex + 1);
                }
            } else {
                if (targetOffset == 0) {
                    parent.addChild(placeholder, targetIndex);
                } else {
                    parent.addChild(placeholder, targetIndex + 1);
                }
                targetModel = placeholder;
                targetOffset = 0;
            }
        }
        return new WmiModelPosition(placeholder, 0);
    }

    private static WmiFontAttributeSet getInsertAttributes(WmiModel targetModel) throws WmiNoReadAccessException {
        WmiMathDocumentModel doc = targetModel.getDocument();
        WmiFontAttributeSet activeAttr = doc.getActiveEditAttributes();
        if (activeAttr != null) {
            WmiCompositeModel wrapper;
            boolean resetAttributes = false;
            if ((activeAttr.getExtendedStyle() & 0x800) != 0) {
                resetAttributes = true;
            } else {
                WmiAttributeSet set = targetModel.getAttributes();
                if (set instanceof WmiFontAttributeSet && (((WmiFontAttributeSet)set).getExtendedStyle() & 0x800) != 0) {
                    resetAttributes = true;
                }
            }
            int prototype = 0;
            boolean resetPrototypeAttributes = false;
            if (resetAttributes && (wrapper = WmiModelUtil.findAncestorOfTag(targetModel, WmiModelTag.MATH)) != null) {
                activeAttr = (WmiFontAttributeSet)wrapper.getAttributesForRead();
                WmiAttributeSet targetSet = targetModel.getAttributesForRead();
                if (targetSet instanceof WmiFontAttributeSet) {
                    int targetStyle = ((WmiFontAttributeSet)targetSet).getExtendedStyle();
                    prototype = WmiAbstractMathTokenModel.getPrototype(targetModel, targetStyle);
                    prototype &= 0xFFFFE7FF;
                    resetPrototypeAttributes = true;
                }
            }
            activeAttr = (WmiFontAttributeSet)activeAttr.copyAttributes();
            if (resetPrototypeAttributes) {
                activeAttr.setExtendedStyle(prototype);
            }
        }
        return activeAttr;
    }

    public static WmiModelPosition splitModel(WmiModelPosition pos, int bias) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel targetModel = pos.getModel();
        int targetOffset = pos.getOffset();
        if (targetModel instanceof WmiTextModel) {
            WmiTextModel textModel = (WmiTextModel)targetModel;
            if (targetOffset < 0) {
                targetOffset = textModel.getLength();
            }
            WmiTextModel newModel = textModel.splitModel(targetOffset);
            targetModel = bias == -1 ? textModel : newModel;
            targetOffset = bias == -1 ? textModel.getLength() : 0;
        }
        return new WmiModelPosition(targetModel, targetOffset);
    }

    public static boolean isEscapedInsert(WmiMathDocumentView docView) throws WmiNoReadAccessException {
        boolean escaped = false;
        if (docView != null && docView.getSelection() == null && docView.getPositionMarker() != null) {
            WmiTextModel text;
            WmiModelTag tag;
            WmiPositionMarker marker = docView.getPositionMarker();
            WmiModelPosition modelPos = marker.getModelPosition();
            WmiModel markerModel = modelPos.getModel();
            int markerOffset = modelPos.getOffset();
            WmiModelTag wmiModelTag = tag = markerModel != null ? markerModel.getTag() : null;
            if ((tag == WmiModelTag.MATH_IDENTIFIER || tag == WmiModelTag.MATH_OPERATOR) && (text = (WmiTextModel)markerModel).getLength() > 0 && markerOffset > 0 && text.getText().charAt(markerOffset - 1) == '\\') {
                escaped = true;
            }
        }
        return escaped;
    }

    public static WmiModelPosition wrapSelection(WmiMathDocumentView docView) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        return MathInsertUtil.wrapSelection(docView, 0);
    }

    public static WmiModelPosition wrapSelection(WmiMathDocumentView docView, int bias) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiSelection selection = docView.getSelection();
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiModelPosition pos = null;
        if (selection != null) {
            WmiModel[] models = new WmiModel[2];
            int[] offsets = new int[2];
            selection.getModelInterval(models, offsets);
            if (models[0] instanceof WmiMathTableModel.WmiMathTableDataModel) {
                models[0] = ((WmiCompositeModel)models[0]).getChild(0);
                offsets[0] = 0;
            }
            if (models[1] instanceof WmiMathTableModel.WmiMathTableDataModel) {
                models[1] = ((WmiCompositeModel)models[1]).getChild(((WmiCompositeModel)models[1]).getChildCount() - 1);
                offsets[1] = -1;
            }
            WmiModelPosition startPosition = new WmiModelPosition(models[0], offsets[0]);
            WmiModelPosition endPosition = new WmiModelPosition(models[1], offsets[1]);
            startPosition = MathInsertUtil.updateInsertionPoint(startPosition, 1);
            endPosition = MathInsertUtil.updateInsertionPoint(endPosition, -1);
            pos = MathInsertUtil.wrapSelection(startPosition, endPosition);
        } else {
            pos = MathInsertUtil.updateInsertionPoint(marker, bias);
            if (pos != null && !(pos.getModel() instanceof WmiCompositeModel) && pos.getOffset() == 0) {
                pos = MathInsertUtil.updateInsertionPoint(marker, -1);
            }
            pos = MathInsertUtil.wrapSelection(pos, pos);
        }
        return pos;
    }

    public static WmiModelPosition wrapSelection(WmiModelPosition startPos, WmiModelPosition endPos) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPosition pos = null;
        if (startPos == null || endPos == null) {
            return null;
        }
        WmiModel startModel = startPos.getModel();
        WmiModel endModel = endPos.getModel();
        WmiMathDocumentModel docModel = startModel.getDocument();
        if (!docModel.isMutableModel(startModel)) {
            return null;
        }
        pos = startModel == endModel ? (startModel instanceof WmiTextModel ? MathInsertUtil.singleTextModel(startPos, endPos) : MathInsertUtil.singleNonTextModel(startPos, endPos)) : MathInsertUtil.multipleModels(startPos, endPos);
        return pos;
    }

    private static WmiModelPosition singleTextModel(WmiModelPosition startPos, WmiModelPosition endPos) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel sibling;
        boolean deleteInline;
        WmiAbstractMathTokenModel mathModel;
        WmiModel startModel = startPos.getModel();
        int startOffset = startPos.getOffset();
        WmiModel endModel = endPos.getModel();
        int endOffset = endPos.getOffset();
        ArrayList<WmiAbstractModel> replacementsList = new ArrayList<WmiAbstractModel>();
        ArrayList<WmiTextModel> retokenizeList = new ArrayList<WmiTextModel>();
        MathInsertUtil.ensureParentMathRow(startPos);
        WmiCompositeModel parent = startModel.getParent();
        int indexInParent = parent.indexOf(startModel);
        String text = ((WmiTextModel)startModel).getText();
        if (text.length() == 0) {
            return startPos;
        }
        String semantics = text;
        boolean fullModel = false;
        if (startModel instanceof WmiAbstractMathTokenModel && (endOffset - startOffset == (mathModel = (WmiAbstractMathTokenModel)startModel).getLength() || startOffset == mathModel.getLength())) {
            semantics = mathModel.getSemanticLabel();
            fullModel = true;
        }
        WmiTextModel prefix = null;
        if (startOffset > 0) {
            prefix = MathInsertUtil.createModel((WmiTextModel)startModel, text, semantics, !fullModel, 0, startOffset);
            retokenizeList.add(prefix);
            replacementsList.add(prefix);
        }
        WmiInlineMathModel inline = new WmiInlineMathModel(startModel.getDocument());
        WmiTextModel middle = null;
        if (startOffset != endOffset) {
            middle = MathInsertUtil.createModel((WmiTextModel)endModel, text, semantics, !fullModel, startOffset, endOffset);
            retokenizeList.add(middle);
            inline.addChild(middle, 0);
            deleteInline = false;
        } else {
            inline.addAttribute("Typesetting:-msemantics", "donotprune");
            deleteInline = true;
        }
        replacementsList.add(inline);
        WmiTextModel suffix = null;
        if (endOffset != -1 && endOffset != text.length()) {
            suffix = MathInsertUtil.createModel((WmiTextModel)endModel, text, endOffset, text.length());
            retokenizeList.add(suffix);
            replacementsList.add(suffix);
        }
        WmiModel[] replacements = new WmiModel[replacementsList.size()];
        replacementsList.toArray(replacements);
        parent.replaceChildren(replacements, indexInParent, 1);
        parent.addAttribute("Typesetting:-msemantics", "donotprune");
        boolean prefixExists = prefix != null;
        boolean middleExists = inline != null && inline.getChildCount() != 0;
        int index = prefixExists && middleExists ? 1 : 0;
        WmiModelPosition finalPosition = startPos;
        if (!retokenizeList.isEmpty() && (finalPosition = MathInsertUtil.retokenize(retokenizeList, index, -1)) == null) {
            finalPosition = startPos;
        }
        parent.addAttribute("Typesetting:-msemantics", null);
        WmiModel positionModel = finalPosition.getModel();
        parent = positionModel.getParent();
        if (deleteInline) {
            parent.removeChild(inline);
            inline = null;
        } else if (positionModel instanceof WmiTextModel && (sibling = WmiModelUtil.getPreviousSibling(positionModel)) instanceof WmiMathOperatorModel && ((WmiMathOperatorModel)sibling).getAllText().equals("\u2212")) {
            positionModel = inline;
        }
        return new WmiModelPosition(positionModel, -1);
    }

    private static WmiModelPosition singleNonTextModel(WmiModelPosition startPos, WmiModelPosition endPos) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int startOffset = startPos.getOffset();
        WmiModel endModel = endPos.getModel();
        int endOffset = endPos.getOffset();
        WmiModelPosition pos = null;
        MathInsertUtil.ensureParentMathRow(startPos);
        int bias = endPos != startPos ? 1 : -1;
        pos = MathInsertUtil.splitModel(startPos, bias);
        if (endPos != startPos) {
            endModel = pos.getModel();
            if (endOffset != -1) {
                endOffset -= startOffset;
            }
            endPos = new WmiModelPosition(endModel, endOffset);
            pos = MathInsertUtil.splitModel(endPos, -1);
        }
        return pos;
    }

    private static WmiModelPosition multipleModels(WmiModelPosition startPos, WmiModelPosition endPos) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int index;
        String text;
        WmiCompositeModel parent;
        WmiModelPosition pos = null;
        WmiModel startModel = startPos.getModel();
        int startOffset = startPos.getOffset();
        WmiModel endModel = endPos.getModel();
        int endOffset = endPos.getOffset();
        WmiModel parentModel = WmiModelUtil.commonParent(startModel, endModel);
        if (!(parentModel instanceof WmiCompositeModel)) {
            parentModel = parentModel.getParent();
        }
        WmiCompositeModel commonParent = (WmiCompositeModel)parentModel;
        startModel = startPos.getModel();
        startOffset = startPos.getOffset();
        endModel = endPos.getModel();
        endOffset = endPos.getOffset();
        WmiTextModel prefix = null;
        WmiTextModel suffix = null;
        WmiModel[] retokenizeCandidates = new WmiModel[4];
        if (!commonParent.isCrossBoundarySubselectable()) {
            commonParent = commonParent.getParent();
        }
        int startIndex = 0;
        int endIndex = commonParent.getChildCount() - 1;
        if (startModel != commonParent) {
            parent = startModel.getParent();
            if (startOffset != 0 && parent == commonParent && parent.getTag() == WmiModelTag.MATH_ROW && startModel instanceof WmiTextModel) {
                text = ((WmiTextModel)startModel).getText();
                if (startOffset > 0 && (index = parent.indexOf(startModel)) >= 0) {
                    prefix = MathInsertUtil.createModel((WmiTextModel)startModel, text, 0, startOffset);
                    retokenizeCandidates[0] = prefix;
                    retokenizeCandidates[1] = startModel = MathInsertUtil.createModel((WmiTextModel)startModel, text, startOffset, text.length());
                    parent.replaceChild(startModel, index);
                }
            }
            while (parent != commonParent) {
                startModel = parent;
                parent = parent.getParent();
            }
            startIndex = commonParent.indexOf(startModel);
        }
        if (endModel != commonParent && endModel != startModel) {
            parent = endModel.getParent();
            if (parent == commonParent && parent.getTag() == WmiModelTag.MATH_ROW && endModel instanceof WmiTextModel) {
                text = ((WmiTextModel)endModel).getText();
                if (endOffset > 0 && endOffset < text.length() && (index = parent.indexOf(endModel)) >= 0) {
                    retokenizeCandidates[2] = endModel = MathInsertUtil.createModel((WmiTextModel)endModel, text, 0, endOffset);
                    suffix = MathInsertUtil.createModel((WmiTextModel)endModel, text, endOffset, text.length());
                    retokenizeCandidates[3] = suffix;
                    parent.replaceChild(endModel, index);
                }
            }
            while (parent != null && parent != commonParent) {
                endModel = parent;
                parent = parent.getParent();
            }
            endIndex = commonParent.indexOf(endModel);
        }
        if (startIndex >= 0 && endIndex >= 0) {
            pos = endIndex != startIndex ? MathInsertUtil.wrap(commonParent, startIndex, endIndex, suffix, prefix) : new WmiModelPosition(startModel, 0);
        }
        MathInsertUtil.retokenize(retokenizeCandidates);
        return pos;
    }

    private static WmiModelPosition wrap(WmiCompositeModel commonParent, int startIndex, int endIndex, WmiModel suffix, WmiModel prefix) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int length = endIndex - startIndex + 1;
        WmiModel[] replacement = new WmiModel[length];
        int i = 0;
        while (i < length) {
            replacement[i] = commonParent.getChild(i + startIndex);
            ++i;
        }
        WmiMathDocumentModel doc = commonParent.getDocument();
        WmiInlineMathModel inline = new WmiInlineMathModel(doc);
        inline.setAttributes(commonParent.getAttributes());
        int parentReplaceSize = 1;
        int parentReplaceIndex = 0;
        if (prefix != null) {
            ++parentReplaceSize;
        }
        if (suffix != null) {
            ++parentReplaceSize;
        }
        WmiModel[] parentReplace = new WmiModel[parentReplaceSize];
        if (prefix != null) {
            parentReplace[parentReplaceIndex++] = prefix;
        }
        parentReplace[parentReplaceIndex++] = inline;
        if (suffix != null) {
            parentReplace[parentReplaceIndex++] = suffix;
        }
        commonParent.replaceChildren(parentReplace, startIndex, length);
        WmiInsertGenericMathCommand.refreshSemantics(commonParent);
        inline.replaceChildren(replacement, 0, 0);
        return new WmiModelPosition(inline, -1);
    }

    private static void retokenize(ArrayList candidates) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel[] candidateArray = new WmiModel[candidates.size()];
        candidates.toArray(candidateArray);
        MathInsertUtil.retokenize(candidateArray);
    }

    private static WmiModelPosition retokenize(ArrayList candidates, int position, int offset) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModel[] candidateArray = new WmiModel[candidates.size()];
        candidates.toArray(candidateArray);
        return MathInsertUtil.retokenize(candidateArray, position, offset);
    }

    private static void retokenize(WmiModel[] candidates) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int i = 0;
        while (i < candidates.length) {
            WmiCompositeModel parent;
            int index;
            WmiModel model = candidates[i];
            if (model instanceof WmiTextModel && (index = (parent = model.getParent()).indexOf(model)) >= 0) {
                MathTokenizer.retokenize((WmiTextModel)model, 0, false);
            }
            ++i;
        }
    }

    private static WmiModelPosition retokenize(WmiModel[] candidates, int position, int offset) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPosition modelPosition = null;
        int i = 0;
        while (i < candidates.length) {
            WmiCompositeModel parent;
            int index;
            WmiModel model = candidates[i];
            if (model instanceof WmiTextModel && (index = (parent = model.getParent()).indexOf(model)) >= 0) {
                if (i == position) {
                    modelPosition = MathTokenizer.retokenize((WmiTextModel)model, offset, false);
                } else {
                    MathTokenizer.retokenize((WmiTextModel)model, 0, false);
                }
            }
            ++i;
        }
        return modelPosition;
    }

    public static WmiTextModel createModel(WmiTextModel source, String text, int startOffset, int endOffset) throws WmiNoReadAccessException {
        return MathInsertUtil.createModel(source, text, text, true, startOffset, endOffset);
    }

    public static WmiTextModel createModel(WmiTextModel source, String text, String semantics, boolean trimSemantics, int startOffset, int endOffset) throws WmiNoReadAccessException {
        WmiFontAttributeSet set;
        int extStyle;
        WmiAbstractMathTokenModel model = null;
        WmiModelTag tag = source.getTag();
        text = text.substring(startOffset, endOffset);
        if (trimSemantics) {
            semantics = semantics.substring(startOffset, endOffset);
        }
        boolean isBold = ((extStyle = (set = (WmiFontAttributeSet)source.getAttributes()).getExtendedStyle()) & 1) != 0;
        boolean isItalic = (extStyle & 2) != 0;
        int prototype = WmiAbstractMathTokenModel.getPrototype(source, extStyle);
        int significant = extStyle ^ prototype;
        set.setExtendedStyle(extStyle &= 0xFFFFE7FC);
        WmiMathDocumentModel docModel = source.getDocument();
        if (tag == WmiModelTag.MATH_IDENTIFIER) {
            set.setExtendedStyle(extStyle);
            model = new WmiIdentifierModel(docModel, text, semantics, set, false);
        } else {
            model = tag == WmiModelTag.MATH_OPERATOR ? new WmiMathOperatorModel(docModel, text, semantics, set) : (tag == WmiModelTag.MATH_NUMERIC ? new WmiNumericModel(docModel, text, set) : new WmiMathTextModel(docModel, text, (WmiAttributeSet)set));
        }
        WmiFontAttributeSet postSet = (WmiFontAttributeSet)model.getAttributes();
        int postStyle = postSet.getExtendedStyle();
        int postPrototype = WmiAbstractMathTokenModel.getPrototype(model, postStyle);
        postSet.setExtendedStyle(postPrototype);
        if ((significant & 1) != 0) {
            postSet.setStyle(1, isBold);
        }
        if ((significant & 2) != 0) {
            postSet.setStyle(2, isItalic);
        }
        try {
            model.addAttributes(postSet);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        return model;
    }

    public static WmiMathContext createContext(WmiModel model) throws WmiNoReadAccessException {
        WmiMathContext context = null;
        WmiMathWrapperModel wrapperModel = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag(model, WmiModelTag.MATH);
        if (wrapperModel != null) {
            context = WmiMathWrapperModel.createContext(wrapperModel.getAttributesForRead());
        }
        return context;
    }

    public static WmiModelPosition performModelWrap(WmiModel targetModel, WmiCompositeModel replacement, WmiMathContext context, int replaceIndex, int caretIndex, boolean addBrackets) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int index;
        WmiModelPosition pos = null;
        WmiCompositeModel parent = targetModel.getParent();
        int n = index = parent != null ? parent.indexOf(targetModel) : -1;
        if (replacement == null) {
            WmiErrorLog.log(new Exception("null replacement"));
        }
        if (index >= 0 && replacement != null) {
            parent.replaceChild(replacement, index);
            WmiInsertGenericMathCommand.refreshSemantics(parent);
            if (targetModel instanceof WmiCompositeModel) {
                WmiCompositeModel comp = (WmiCompositeModel)targetModel;
                if (comp.getTag() == WmiModelTag.MATH_ROW) {
                    int nonEmptyChildCount = 0;
                    int i = 0;
                    while (i < comp.getChildCount()) {
                        if (!WmiModelUtil.isEmptyModel(comp.getChild(i))) {
                            ++nonEmptyChildCount;
                        }
                        ++i;
                    }
                    addBrackets &= nonEmptyChildCount > 1;
                }
                if (addBrackets && targetModel.getTag() != WmiModelTag.MATH_FENCED) {
                    targetModel = WmiMathFactory.addBrackets((WmiMathModel)targetModel, context);
                }
            }
            replacement.replaceChild(targetModel, replaceIndex);
            pos = caretIndex >= 0 ? new WmiModelPosition(replacement.getChild(caretIndex), 0) : new WmiModelPosition(replacement, -1);
        }
        return pos;
    }
}

