/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.components.WmiPopupList;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.insert.WmiInsertEntityCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsertMathMLCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiSearchAndSelect;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionUpdateHandler;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionBuilder;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import com.maplesoft.util.MathMLEntityMap;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;

public class WmiEntityListCommand
extends WmiInsertEntityCommand {
    public static final EntityStore AVAILABLE_ENTITIES = new EntityStore();
    public static final HashMap COMMANDS_IN_LIST = new HashMap();
    private static WmiSymbolList symbolList = null;

    static {
        MathMLEntityMap mmlEntityMap = MathMLEntityMap.getInstance();
        for (String entity : mmlEntityMap.keySet()) {
            AVAILABLE_ENTITIES.insert(entity);
        }
        AVAILABLE_ENTITIES.insert("sqrt", "<mrow><msqrt><mi>a</mi></msqrt></mrow>");
        for (String entity : COMMANDS_IN_LIST.keySet()) {
            AVAILABLE_ENTITIES.insert(entity);
        }
    }

    protected static String resolvedDisplayName(Object key) {
        String resolved = key.toString();
        if (resolved.equals("Pi")) {
            resolved = "Pi (uppercase Greek)";
        }
        return resolved;
    }

    public WmiEntityListCommand(String name) {
        super(name);
        Iterator queueIt = COMMANDS_IN_LIST.values().iterator();
        while (queueIt.hasNext()) {
            this.addQueueableCommand((String)queueIt.next());
        }
    }

    public WmiEntityListCommand() {
        this("Insert.Entitylist");
    }

    @Override
    public void doCommand(ActionEvent e) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiPositionMarker marker;
        WmiMathDocumentView docView = WmiEntityListCommand.getDocumentView(e);
        if (docView != null && (marker = docView.getPositionMarker()) != null) {
            Vector results;
            WmiPositionedView markerView = marker.getView();
            WmiModel model = markerView.getModel();
            String data = "";
            if (model instanceof WmiTextModel) {
                data = ((WmiTextModel)model).getText();
            }
            if ((results = AVAILABLE_ENTITIES.lookup(data)).size() == 1 && results.get(0) != null) {
                this.insertFromList(docView, results.get(0), null);
            } else if (results.size() > 0 && symbolList == null) {
                symbolList = this.getSymbolList(docView, results, data, 0, 0, null);
                symbolList.display();
            }
        }
    }

    public static void popDownList() {
        if (symbolList != null) {
            symbolList.setVisible(false);
        }
        symbolList = null;
    }

    protected String[] getData(WmiModel model) throws WmiNoReadAccessException {
        String data = null;
        String prefixes = null;
        if (model instanceof WmiAbstractMathTokenModel) {
            data = ((WmiAbstractMathTokenModel)model).getSemanticLabel();
            int i = data.indexOf(38);
            int j = data.lastIndexOf(59);
            if (i != -1 && j != -1) {
                prefixes = data.substring(i, j + 1);
                data = data.substring(j + 1, data.length());
            }
        }
        String[] both = new String[]{data, prefixes};
        return both;
    }

    protected boolean isAll(String s, char c) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != c) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void insertFromList(WmiMathDocumentView docView, Object listSelection, String prefixes) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiPositionMarker marker;
        if (docView != null && (marker = docView.getPositionMarker()) != null) {
            WmiPositionedView markerView = marker.getView();
            WmiModel model = markerView.getModel();
            WmiSelection docSelection = docView.getSelection();
            WmiModelLock.writeLock(model, true);
            WmiCompositeModel parentModel = model.getParent();
            int oldModelIndex = parentModel.indexOf(model);
            if (marker != null) {
                UpdatePositionAfterInsert updater = new UpdatePositionAfterInsert(marker, parentModel, oldModelIndex, docView);
                docView.setPendingPositionUpdateHandler(updater);
            }
            boolean insertLeadingFence = false;
            if (docSelection == null) {
                if (model instanceof WmiTextModel) {
                    WmiCompositeModel parent;
                    int indexOfModel;
                    WmiMathOperatorModel mathOperatorModel;
                    String text = ((WmiTextModel)model).getText();
                    if (text.equals("[")) {
                        insertLeadingFence = true;
                    }
                    if (parentModel.getTag() != WmiModelTag.MATH_ROW) {
                        WmiAttributeSet modelAttributes = model.getAttributes();
                        WmiInlineMathModel inline = new WmiInlineMathModel(model.getDocument());
                        try {
                            parentModel.replaceChild(inline, oldModelIndex);
                            inline.appendChild(model);
                        }
                        catch (WmiModelIndexOutOfBoundsException e) {
                            WmiErrorLog.log(e);
                        }
                        inline.setAttributes(modelAttributes);
                    }
                    WmiSearchAndSelect.selectTextModel(docView, (WmiTextModel)model);
                    if (model instanceof WmiMathOperatorModel && this.isAll((mathOperatorModel = (WmiMathOperatorModel)model).getAllText(), '@') && (indexOfModel = (parent = mathOperatorModel.getParent()).indexOf(mathOperatorModel)) > 0) {
                        WmiTextModel neighbour = (WmiTextModel)parent.getChild(indexOfModel - 1);
                        WmiViewFactory viewFactory = docView.getViewFactory();
                        WmiSelectionBuilder selectionBuilder = viewFactory.getSelectionBuilder();
                        WmiSelection selection = selectionBuilder.createSelection(neighbour, 0, mathOperatorModel, mathOperatorModel.getLength());
                        docView.setSelection(selection);
                    }
                } else if (model instanceof WmiCompositeModel) {
                    WmiSearchAndSelect.selectCompositeModel(docView, (WmiCompositeModel)model);
                }
            }
            if (listSelection instanceof StoredObjectResult) {
                this.handleStoredObjectInsert(model, (StoredObjectResult)listSelection, docView, prefixes, insertLeadingFence);
            } else {
                String insertString = listSelection.toString();
                if (COMMANDS_IN_LIST.containsKey(insertString)) {
                    String commandName = (String)COMMANDS_IN_LIST.get(insertString);
                    WmiCommand.invokeCommand(commandName);
                } else {
                    if (prefixes == null) {
                        prefixes = "";
                    }
                    if (!insertString.startsWith("<")) {
                        this.insert(docView, String.valueOf(prefixes) + "&" + insertString + ";");
                    } else {
                        WmiInsertMathMLCommand cmd = WmiInsertMathMLCommand.DEFAULT_MATHML_INSERTER;
                        cmd.doInsertionCommand(docView, insertString);
                    }
                }
            }
            WmiModelLock.writeUnlock(model);
        }
    }

    protected void handleStoredObjectInsert(WmiModel target, StoredObjectResult obj, WmiMathDocumentView docView, String prefixes, boolean insertLeadingFence) throws WmiNoReadAccessException, WmiNoWriteAccessException {
    }

    public WmiSymbolList getSymbolList(WmiMathDocumentView docView, Vector data, String currentText, int position, int prefixLength, String prefixes) {
        return new WmiSymbolList(docView, data, currentText, position, prefixLength, prefixes);
    }

    public static class EntityStore {
        private StoreNode root = new StoreNode();

        public void insert(String toStore) {
            this.insert(toStore, toStore);
        }

        public void insert(String key, Object value) {
            StoreNode insertPoint = this.root;
            int loopLen = key.length() - 1;
            int i = 0;
            while (i < loopLen) {
                insertPoint = insertPoint.insert(key.charAt(i), false);
                ++i;
            }
            insertPoint.insert(key.charAt(loopLen), true, value);
        }

        public void remove(String toRemove, Class storedType) {
            this.remove(toRemove, null, storedType);
        }

        public void remove(String toRemove, String ruleName, Class storedType) {
            StoreNode finalNode;
            LinkedList<StoreNode> nodePath = new LinkedList<StoreNode>();
            StoreNode searchNode = this.root;
            int loopLen = toRemove.length() - 1;
            int i = 0;
            while (i < loopLen && searchNode != null) {
                if ((searchNode = searchNode.findChild(toRemove.charAt(i))) != null) {
                    nodePath.add(searchNode);
                }
                ++i;
            }
            if (searchNode != null && (finalNode = searchNode.findChild(toRemove.charAt(loopLen))) != null) {
                int end;
                if (ruleName != null) {
                    finalNode.remove(storedType, ruleName);
                } else {
                    finalNode.remove(storedType);
                }
                if (finalNode.isRemovable()) {
                    this.removeNode(searchNode, finalNode);
                }
                int i2 = end = nodePath.size() - 1;
                while (i2 >= 0) {
                    StoreNode toremove = (StoreNode)nodePath.get(i2);
                    if (toremove.isRemovable()) {
                        StoreNode parent = i2 > 0 ? (StoreNode)nodePath.get(i2 - 1) : this.root;
                        this.removeNode(parent, toremove);
                    }
                    --i2;
                }
            }
        }

        private void removeNode(StoreNode parent, StoreNode target) {
            StoreNode prev = target.previousSibling;
            StoreNode next = target.nextSibling;
            if (prev == null && target == parent.childRoot) {
                parent.childRoot = next;
            }
            if (prev != null) {
                prev.nextSibling = next;
            }
            if (next != null) {
                next.previousSibling = prev;
            }
            target.nextSibling = null;
            target.previousSibling = null;
            target.childRoot = null;
        }

        public boolean contains(String key, Object value) {
            boolean contained = false;
            boolean storedObject = value instanceof StoredObjectResult;
            Vector result = this.lookup(key);
            int vecSize = result.size();
            if (vecSize > 0) {
                int i = 0;
                while (i < vecSize && !contained) {
                    Object vecKid = result.get(i);
                    if (vecKid instanceof StoredObjectResult) {
                        StoredObjectResult sor = (StoredObjectResult)vecKid;
                        contained = sor.equals(value);
                        if (!contained) {
                            if (storedObject) {
                                StoredObjectResult sorParam = (StoredObjectResult)value;
                                if (key.equals(sor.toString()) || sorParam.toString().equals(sor.toString())) {
                                    contained = sor.getStoredObject().equals(sorParam.getStoredObject());
                                }
                            } else {
                                contained = key.equals(sor.toString()) && sor.getStoredObject().equals(value);
                            }
                        }
                    } else {
                        contained = value != null && value.equals(vecKid);
                    }
                    ++i;
                }
            }
            return contained;
        }

        public Vector lookup(String testItem) {
            Vector resultArray = new Vector();
            LinkedList<StoreNode> traversed = new LinkedList<StoreNode>();
            int strLen = testItem.length();
            StoreNode searchPoint = this.root;
            boolean matchesFound = true;
            int i = 0;
            while (i < strLen) {
                char search = testItem.charAt(i);
                StoreNode located = searchPoint.findChild(search);
                if (located == null) {
                    matchesFound = false;
                    break;
                }
                traversed.add(searchPoint);
                searchPoint = located;
                ++i;
            }
            if (searchPoint != this.root && matchesFound) {
                searchPoint.buildResults(traversed, resultArray, strLen);
                Collections.sort(resultArray, new ResultComparator());
            }
            return resultArray;
        }

        private static class StoreNode {
            private char storedChar;
            boolean terminal = false;
            Object storedData = null;
            StoreNode previousSibling = null;
            StoreNode childRoot = null;
            StoreNode nextSibling = null;

            public StoreNode() {
            }

            public StoreNode(char character, boolean terminal, Object storedData) {
                this.storedChar = character;
                this.storedData = storedData;
                this.terminal = terminal;
            }

            public StoreNode findChild(char searchChar) {
                StoreNode foundNode = null;
                StoreNode searchNode = this.childRoot;
                while (searchNode != null && foundNode == null) {
                    if (searchNode.storedChar == searchChar) {
                        foundNode = searchNode;
                    }
                    searchNode = searchNode.nextSibling;
                }
                return foundNode;
            }

            public boolean isRemovable() {
                boolean removeable = !this.terminal && (this.storedData == null || this.storedData instanceof CollisionItems && ((CollisionItems)this.storedData).size() == 0);
                return removeable &= this.childRoot == null;
            }

            public void remove(Class storedType) {
                if (this.storedData instanceof CollisionItems) {
                    CollisionItems colits = (CollisionItems)this.storedData;
                    Iterator cits = colits.iterator();
                    while (cits.hasNext()) {
                        Object obj = cits.next();
                        if (obj instanceof StoredObjectResult) {
                            obj = ((StoredObjectResult)obj).getStoredObject();
                        }
                        if (!storedType.isInstance(obj)) continue;
                        cits.remove();
                        break;
                    }
                    if (colits.size() == 0) {
                        this.terminal = false;
                        this.storedData = null;
                    }
                } else {
                    Object obj = this.storedData;
                    if (this.storedData instanceof StoredObjectResult) {
                        obj = ((StoredObjectResult)this.storedData).getStoredObject();
                    }
                    if (storedType.isInstance(obj)) {
                        this.terminal = false;
                        this.storedData = null;
                    }
                }
            }

            public void remove(Class storedType, String ruleName) {
                StoredObjectResult sor;
                if (this.storedData instanceof CollisionItems) {
                    CollisionItems colits = (CollisionItems)this.storedData;
                    Iterator cits = colits.iterator();
                    while (cits.hasNext()) {
                        StoredObjectResult sor2;
                        Object obj = cits.next();
                        if (!(obj instanceof StoredObjectResult) || !ruleName.equals((sor2 = (StoredObjectResult)obj).getRenderString()) || !storedType.isInstance(sor2.getStoredObject())) continue;
                        cits.remove();
                        break;
                    }
                    if (colits.size() == 0) {
                        this.terminal = false;
                        this.storedData = null;
                    }
                } else if (this.storedData instanceof StoredObjectResult && storedType.isInstance((sor = (StoredObjectResult)this.storedData).getStoredObject()) && ruleName.equals(sor.getRenderString())) {
                    this.terminal = false;
                    this.storedData = null;
                }
            }

            public void buildResults(LinkedList traversed, Vector results, int sizeLimit) {
                StringBuffer resultBuf = new StringBuffer();
                int tlen = traversed.size();
                int i = 1;
                while (i < tlen) {
                    StoreNode node = (StoreNode)traversed.get(i);
                    if (node.storedChar > '\u0000') {
                        resultBuf.append(node.storedChar);
                    }
                    if (node.terminal && resultBuf.length() >= sizeLimit) {
                        this.addNodeToResults(resultBuf.toString(), node, results);
                    }
                    ++i;
                }
                this.completeResults(resultBuf.toString(), results, sizeLimit);
            }

            private void addNodeToResults(String key, StoreNode node, Vector results) {
                if (node.storedData instanceof String) {
                    results.add(node.storedData);
                } else if (node.storedData instanceof CollisionItems) {
                    for (Object obj : (CollisionItems)node.storedData) {
                        if (obj instanceof String) {
                            results.add(obj);
                            continue;
                        }
                        if (obj instanceof StoredObjectResult) {
                            results.add(StoredObjectResult.createStoredObject(key, ((StoredObjectResult)obj).getStoredObject()));
                            continue;
                        }
                        results.add(StoredObjectResult.createStoredObject(key, obj));
                    }
                } else if (node.storedData instanceof StoredObjectResult) {
                    results.add(StoredObjectResult.createStoredObject(key, ((StoredObjectResult)node.storedData).getStoredObject()));
                } else if (node.storedData != null) {
                    results.add(StoredObjectResult.createStoredObject(key, node.storedData));
                }
            }

            private void completeResults(String soFar, Vector results, int sizeLimit) {
                StringBuffer here = new StringBuffer(soFar);
                if (this.storedChar > '\u0000') {
                    here.append(this.storedChar);
                }
                if (this.terminal && here.length() >= sizeLimit) {
                    this.addNodeToResults(here.toString(), this, results);
                }
                StoreNode child = this.childRoot;
                while (child != null) {
                    child.completeResults(here.toString(), results, sizeLimit);
                    child = child.nextSibling;
                }
            }

            public StoreNode insert(char character, boolean terminal) {
                return this.insert(character, terminal, null);
            }

            public StoreNode insert(char character, boolean terminal, Object storedData) {
                StoreNode lastStoredNode = null;
                StoreNode searchNode = this.childRoot;
                while (searchNode != null) {
                    if (character == searchNode.storedChar) {
                        if (terminal) {
                            if (searchNode.terminal) {
                                CollisionItems col;
                                if (searchNode.storedData instanceof CollisionItems) {
                                    col = (CollisionItems)searchNode.storedData;
                                    int size = col.size();
                                    boolean append = true;
                                    String ref = storedData.toString();
                                    int i = 0;
                                    while (i < size) {
                                        Object obj = col.get(i);
                                        String str = obj.toString();
                                        if (this.compareKeys(str, ref) > 0) {
                                            col.insertElementAt(storedData, i);
                                            append = false;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (append) {
                                        col.add(storedData);
                                    }
                                } else {
                                    String s2;
                                    col = new CollisionItems();
                                    String s1 = searchNode.storedData.toString();
                                    if (this.compareKeys(s1, s2 = storedData.toString()) > 0) {
                                        col.add(storedData);
                                        col.add(searchNode.storedData);
                                    } else {
                                        col.add(searchNode.storedData);
                                        col.add(storedData);
                                    }
                                    searchNode.storedData = col;
                                }
                            } else {
                                searchNode.terminal = true;
                                searchNode.storedData = storedData;
                            }
                        }
                        lastStoredNode = searchNode;
                        break;
                    }
                    if (searchNode.storedChar > character) {
                        lastStoredNode = new StoreNode(character, terminal, storedData);
                        lastStoredNode.nextSibling = searchNode;
                        if (searchNode.previousSibling != null) {
                            searchNode.previousSibling.nextSibling = lastStoredNode;
                            lastStoredNode.previousSibling = searchNode.previousSibling;
                        } else {
                            this.childRoot = lastStoredNode;
                        }
                        searchNode.previousSibling = lastStoredNode;
                        break;
                    }
                    searchNode = searchNode.nextSibling;
                }
                if (lastStoredNode == null) {
                    lastStoredNode = new StoreNode(character, terminal, storedData);
                    if (this.childRoot != null) {
                        StoreNode endNode = this.childRoot;
                        while (endNode.nextSibling != null) {
                            endNode = endNode.nextSibling;
                        }
                        endNode.nextSibling = lastStoredNode;
                        lastStoredNode.previousSibling = endNode;
                    } else {
                        this.childRoot = lastStoredNode;
                    }
                }
                return lastStoredNode;
            }

            private int compareKeys(String s1, String s2) {
                int n1 = s1.length();
                int n2 = s2.length();
                int i1 = 0;
                int i2 = 0;
                while (i1 < n1 && i2 < n2) {
                    char c1 = s1.charAt(i1);
                    char c2 = s2.charAt(i2);
                    if (c1 == '(' || c1 == ')') {
                        ++i1;
                        continue;
                    }
                    if (c2 == '(' || c2 == ')') {
                        ++i2;
                        continue;
                    }
                    if (c1 != c2 && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                        return c1 - c2;
                    }
                    ++i1;
                    ++i2;
                }
                return n1 - n2;
            }

            public String toString() {
                StringBuffer buffy = new StringBuffer();
                buffy.append("StoreNode for: ");
                buffy.append(this.storedChar);
                if (this.previousSibling != null) {
                    buffy.append(" preceded by a node for ");
                    buffy.append(this.previousSibling.storedChar);
                }
                if (this.nextSibling != null) {
                    buffy.append(" followed by a node for ");
                    buffy.append(this.nextSibling.storedChar);
                }
                return buffy.toString();
            }

            private class CollisionItems
            extends Vector {
                private CollisionItems() {
                }
            }
        }
    }

    private static class InequalityStoredObjectResult
    extends StoredObjectResult {
        private InequalityStoredObjectResult(String key, Object stored) {
            super(key, stored);
        }

        @Override
        public String getRenderString() {
            return this.key.equals(">") ? "Greater Than" : "Less Than";
        }
    }

    protected static class ResultComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return WmiEntityListCommand.resolvedDisplayName(o1).compareToIgnoreCase(WmiEntityListCommand.resolvedDisplayName(o2));
        }
    }

    public static class StoredObjectResult {
        protected Object stored;
        protected String key;

        public static StoredObjectResult createStoredObject(String key, Object stored) {
            StoredObjectResult object = null;
            object = key.equals("<") || key.equals(">") ? new InequalityStoredObjectResult(key, stored) : new StoredObjectResult(key, stored);
            return object;
        }

        private StoredObjectResult(String key, Object stored) {
            this.key = key;
            this.stored = stored;
        }

        public String toString() {
            return this.key;
        }

        public String getRenderString() {
            return this.key;
        }

        public Object getStoredObject() {
            return this.stored;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof StoredObjectResult) {
                StoredObjectResult other = (StoredObjectResult)obj;
                result = this.key != null && this.key.equals(other.key) && this.stored != null && this.stored.equals(other.stored);
            } else {
                result = super.equals(obj);
            }
            return result;
        }

        public int hashCode() {
            int hash = 0;
            if (this.key != null) {
                hash = this.key.hashCode();
            }
            if (this.stored != null) {
                hash += this.stored.hashCode();
            }
            return hash;
        }
    }

    public class UpdatePositionAfterInsert
    implements WmiPositionUpdateHandler {
        private WmiCompositeModel parentModel;
        private WmiPositionMarker marker;
        private WmiMathDocumentView docView;
        private int lookupIndex = 0;

        public UpdatePositionAfterInsert(WmiPositionMarker marker, WmiCompositeModel parentModel, int lookupIndex, WmiMathDocumentView docView) {
            this.marker = marker;
            this.parentModel = parentModel;
            this.lookupIndex = lookupIndex;
            this.docView = docView;
        }

        @Override
        public void updatePosition() throws WmiNoReadAccessException {
            WmiModel targetModel = this.parentModel.getChild(this.lookupIndex);
            int pos = 0;
            if (targetModel instanceof WmiTextModel) {
                pos = ((WmiTextModel)targetModel).getLength();
            }
            this.docView.setSelection(null);
            this.marker.updateMarkerPosition(targetModel, pos);
        }
    }

    public class UpdatePositionAfterInsertOfCompositeModel
    implements WmiPositionUpdateHandler {
        private WmiModel insertModel;
        private WmiPositionMarker marker;
        private WmiMathDocumentView docView;

        public UpdatePositionAfterInsertOfCompositeModel(WmiModel insertModel, WmiPositionMarker marker, WmiMathDocumentView docView) {
            this.insertModel = insertModel;
            this.marker = marker;
            this.docView = docView;
        }

        @Override
        public void updatePosition() throws WmiNoReadAccessException {
            WmiModel caretModel = this.insertModel;
            while (caretModel instanceof WmiCompositeModel) {
                WmiCompositeModel c = (WmiCompositeModel)caretModel;
                caretModel = c.getChild(c.getChildCount() - 1);
            }
            int pos = 0;
            if (caretModel instanceof WmiTextModel) {
                pos = ((WmiTextModel)caretModel).getLength();
            }
            this.docView.setSelection(null);
            this.marker.updateMarkerPosition(caretModel, pos);
        }
    }

    public class WmiSymbolCellRenderer
    extends JPanel
    implements ListCellRenderer {
        String entity = null;
        protected JLabel label;
        protected JLabel image;
        protected Color focusCol;
        protected Color focusColFG;
        protected Color regularLabel;
        protected Color stripeColor;
        protected WmiMathDocumentView renderView = new WmiMathDocumentView();

        public WmiSymbolCellRenderer() {
            this.setOpaque(true);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(1, 1, 1, 1);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.anchor = 17;
            this.label = new JLabel();
            this.add((Component)this.label, gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.anchor = 13;
            this.image = new JLabel();
            this.add((Component)this.image, gbc);
            this.label.setHorizontalAlignment(2);
            this.image.setHorizontalAlignment(4);
            this.stripeColor = RuntimePlatform.isMac() ? new Color(237, 243, 254) : new Color((int)((double)Color.LIGHT_GRAY.getRed() * 1.1), (int)((double)Color.LIGHT_GRAY.getGreen() * 1.1), (int)((double)Color.LIGHT_GRAY.getBlue() * 1.1));
            this.setBackground(this.stripeColor);
            if (RuntimePlatform.isMac()) {
                this.focusCol = new Color(56, 117, 215);
                this.focusColFG = Color.WHITE;
            } else if (RuntimePlatform.isWindows()) {
                this.focusCol = new Color(121, 121, 178);
                this.focusColFG = Color.WHITE;
            } else {
                this.focusCol = UIManager.getColor("Tree.selectionBackground");
                this.focusColFG = UIManager.getColor("Tree.selectionForeground");
            }
            this.regularLabel = UIManager.getColor("Label.foreground");
        }

        private boolean isListFocusable(JList list) {
            Container p = list.getParent();
            while (p.getParent() != null && !(p instanceof Window)) {
                p = p.getParent();
            }
            if (p instanceof Window) {
                Window w = (Window)p;
                return w.isFocusableWindow();
            }
            return false;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus, false);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus, boolean isCommand) {
            String description = null;
            if (value instanceof StoredObjectResult) {
                this.entity = ((StoredObjectResult)value).getRenderString();
                description = value.toString();
            } else {
                this.entity = value.toString();
                description = WmiEntityListCommand.resolvedDisplayName(value);
            }
            this.label.setText(description);
            Image img = this.prepareImage(this.entity, this.renderView, isSelected, !isCommand);
            if (img != null) {
                this.image.setIcon(new ImageIcon(img));
            }
            if (cellHasFocus || RuntimePlatform.isMac_10_2() && isSelected || !this.isListFocusable(list) && isSelected) {
                this.label.setBackground(this.focusCol);
                this.label.setForeground(this.focusColFG);
                this.setBackground(this.focusCol);
                this.setForeground(this.focusColFG);
            } else {
                Color cbackground = index % 2 == 0 ? this.stripeColor : Color.WHITE;
                this.setBackground(cbackground);
                this.label.setForeground(this.regularLabel);
                this.image.setBackground(this.regularLabel);
            }
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Image prepareImage(String mathMLEname, WmiMathDocumentView renderView, boolean isSelected, boolean renderMathML) {
            Image img = null;
            boolean locked = WmiModelLock.writeLock(renderView.getModel(), true);
            try {
                try {
                    WmiMathOperatorModel op;
                    WmiFontAttributeSet set = this.getRenderFontAttributes(isSelected);
                    if (WmiMathOperatorDictionary.isNameForOperator("&" + mathMLEname + ";") && renderMathML && ((WmiMathOperatorModel.WmiMathOperatorAttributeSet)(op = new WmiMathOperatorModel((WmiMathDocumentModel)renderView.getModel(), "", "&" + mathMLEname + ";", new WmiMathContext(set))).getAttributesForRead()).isLargeOp()) {
                        img = WmiMathViewUtil.renderMathML("<mo>&" + mathMLEname + ";</mo>", renderView, 2, true, set);
                    }
                    if (img != null) return img;
                    img = WmiMathViewUtil.renderMathMLEntity(mathMLEname, 2, set, renderMathML);
                    return img;
                }
                catch (WmiNoReadAccessException nrae) {
                    WmiErrorLog.log(nrae);
                    if (!locked) return img;
                    WmiModelLock.writeUnlock(renderView.getModel());
                    return img;
                }
                catch (WmiNoWriteAccessException nwae) {
                    WmiErrorLog.log(nwae);
                    if (!locked) return img;
                    WmiModelLock.writeUnlock(renderView.getModel());
                    return img;
                }
            }
            finally {
                if (locked) {
                    WmiModelLock.writeUnlock(renderView.getModel());
                }
            }
        }

        protected WmiFontAttributeSet getRenderFontAttributes(boolean isSelected) {
            WmiFontAttributeSet set = new WmiFontAttributeSet();
            if (RuntimePlatform.isMac()) {
                set.setSize(18);
            }
            if (isSelected) {
                set.setForeground(this.focusColFG.getRGB());
            }
            return set;
        }
    }

    protected class WmiSymbolList
    extends WmiPopupList {
        StringBuffer currentText;
        private String prefixes;

        public WmiSymbolList(WmiMathDocumentView docView, Vector data, String currentText, int position, int prefixLength, String prefixes) {
            super(docView, data, position, prefixLength);
            this.currentText = new StringBuffer();
            this.prefixes = prefixes;
            this.currentText.append(currentText);
        }

        @Override
        protected void createList(Vector data) {
            super.createList(data);
            this.list.setCellRenderer(this.getSymbolCellRenderer());
        }

        public ListCellRenderer getSymbolCellRenderer() {
            return new WmiSymbolCellRenderer();
        }

        @Override
        protected void updateCharacter(char ch) {
            this.currentText.append(ch);
            ListModel lmodel = this.list.getModel();
            int listSize = lmodel.getSize();
            String matchStr = this.currentText.toString();
            int i = 0;
            while (i < listSize) {
                Object item = lmodel.getElementAt(i);
                if (item.toString().startsWith(matchStr)) {
                    this.list.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }

        @Override
        protected void selectionFinalized() {
            try {
                super.selectionFinalized();
                WmiEntityListCommand.this.insertFromList(this.docView, this.selection, this.prefixes);
                symbolList = null;
            }
            catch (WmiNoReadAccessException nra) {
                WmiErrorLog.log(nra);
            }
            catch (WmiNoWriteAccessException nwa) {
                WmiErrorLog.log(nwa);
            }
        }
    }
}

