/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.ActionEvent;

public class WmiInsert2DMathCommand
extends WmiCommand {
    private static final String RESOURCE_LOCATION = "com.maplesoft.mathdoc.controller.insert.resources.Insert";

    public WmiInsert2DMathCommand() {
        super("Insert.2DMath");
    }

    public WmiInsert2DMathCommand(String name) {
        super(name);
    }

    public WmiInsert2DMathCommand(String name, boolean replace) {
        super(name, replace);
    }

    @Override
    protected String getResourcePath() {
        return RESOURCE_LOCATION;
    }

    @Override
    public boolean isEnabled(WmiView view) {
        boolean enabledNow = false;
        WmiModel model = null;
        if (view != null) {
            WmiPositionedView viewAtMarker;
            WmiMathDocumentView docView = view.getDocumentView();
            WmiPositionMarker marker = docView.getPositionMarker();
            if (marker != null && (viewAtMarker = marker.getView()) != null) {
                model = viewAtMarker.getModel();
            }
            enabledNow = model instanceof WmiTextModel && docView.getSelection() == null;
        }
        return enabledNow;
    }

    @Override
    public void doCommand(ActionEvent e) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentModel doc = null;
        WmiMathDocumentView docView = null;
        WmiPositionMarker marker = null;
        WmiModel targetModel = null;
        boolean commandActive = true;
        WmiPositionedView view = null;
        docView = WmiInsert2DMathCommand.getDocumentView(e);
        if (docView != null && (marker = docView.getPositionMarker()) != null) {
            view = marker.getView();
            if (view != null) {
                targetModel = view.getModel();
                doc = targetModel.getDocument();
            }
            boolean bl = commandActive = !marker.isReadOnly() && targetModel != null && doc != null;
        }
        if (commandActive) {
            WmiModelPosition mpos = marker.getModelPosition();
            int targetOffset = mpos.getOffset();
            try {
                WmiMathWrapperModel inserted = WmiMathWrapperModel.insert2DMath(targetModel, targetOffset, doc);
                doc.update(this.getResource(5));
                WmiModel caretTarget = inserted.getChild(0);
                if (caretTarget instanceof WmiCompositeModel) {
                    caretTarget = ((WmiCompositeModel)caretTarget).getChild(0);
                    marker.updateMarkerPosition(caretTarget, 0);
                }
            }
            catch (WmiNoUpdateAccessException nua) {
                WmiErrorLog.log(nua);
            }
            catch (WmiModelIndexOutOfBoundsException miob) {
                WmiErrorLog.log(miob);
            }
        }
    }

    public static WmiMathContext createContext(WmiAttributeSet attrs) {
        return WmiMathWrapperModel.createContext(attrs);
    }

    public static WmiMathContext createAppropriateContextForModel(WmiModel model) throws WmiNoReadAccessException {
        WmiModel placeholderAncestor;
        WmiMathDocumentModel docModel;
        WmiStyleAttributeSet style;
        WmiFontAttributeSet targetAttribs = model instanceof WmiTextModel ? (WmiFontAttributeSet)model.getAttributes() : null;
        WmiAttributeSet wrapperAttributeSet = null;
        WmiCompositeModel wrapper = WmiModelUtil.findAncestorOfClass(model, WmiMathWrapperModel.class);
        if (wrapper != null && (wrapperAttributeSet = wrapper.getAttributes()) instanceof WmiFontAttributeSet && targetAttribs == null) {
            targetAttribs = (WmiFontAttributeSet)wrapperAttributeSet;
        }
        if (targetAttribs == null && (style = (docModel = model.getDocument()).getStyle(0, "2D Input")) instanceof WmiFontAttributeSet) {
            targetAttribs = (WmiFontAttributeSet)style;
        }
        if ((placeholderAncestor = WmiModelUtil.findAncestorWithAttribute(model, "placeholder", "true")) != null || targetAttribs != null && targetAttribs.hasStyle(2048)) {
            Object foreground = wrapperAttributeSet.getAttribute("foreground");
            targetAttribs.addAttribute("foreground", foreground);
            int extendedStyle = targetAttribs.getExtendedStyle();
            targetAttribs.setExtendedStyle(extendedStyle &= 0xFFFFF7FF);
        }
        return WmiInsert2DMathCommand.createContext(targetAttribs);
    }

    public static final WmiMathModel createDefaultEmptyStructure(WmiMathDocumentModel doc, WmiAttributeSet attrs) throws WmiNoWriteAccessException {
        return WmiMathWrapperModel.createDefaultEmptyStructure(doc, attrs);
    }

    public WmiMathModel createPlaceHolder(WmiMathDocumentModel doc, WmiMathContext context) {
        return WmiMathWrapperModel.createPlaceHolder(doc, context);
    }

    public static final WmiMathWrapperModel insert2DMath(WmiModel targetModel, int targetOffset, WmiMathDocumentModel doc) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiMathWrapperModel.insert2DMath(targetModel, targetOffset, doc);
    }

    public static final void addStyleMapping(String sourceName, String targetName) {
        WmiMathWrapperModel.addStyleMapping(sourceName, targetName);
    }
}

