/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.WmiSimpleMathInsertCommand;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.util.WmiMathEntityNameMapper;

public class WmiInsertEntityCommand
extends WmiSimpleMathInsertCommand {
    public static final WmiInsertEntityCommand DEFAULT_ENTITY_INSERTER = new WmiInsertEntityCommand("Insert.Entity");

    public WmiInsertEntityCommand(String name) {
        super(name);
    }

    @Override
    protected String getInsertedText() {
        return "";
    }

    @Override
    public WmiMathModel createInsertedModel(String insertString, WmiModel targetModel, WmiMathContext context) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiMathDocumentModel doc = targetModel.getDocument();
        WmiModelTag finalTag = WmiModelTag.MATH_IDENTIFIER;
        if (WmiMathOperatorDictionary.isNameForOperator(insertString)) {
            finalTag = WmiModelTag.MATH_OPERATOR;
        } else if (insertString != null && insertString.length() > 1 && insertString.charAt(0) == '&' && insertString.charAt(insertString.length() - 1) == ';') {
            char c = '\u0000';
            if (insertString.charAt(1) == '#') {
                try {
                    String value = insertString.substring(2, insertString.length() - 1);
                    c = (char)Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                c = WmiMathEntityNameMapper.getUnicodeCharacter(insertString.substring(1, insertString.length() - 1));
            }
            if (c != '\u0000' && MathTokenizer.isOperator(c)) {
                finalTag = WmiModelTag.MATH_OPERATOR;
                insertString = Character.toString(c);
            }
        }
        return WmiMathFactory.createMathToken(doc, finalTag, insertString, context);
    }
}

