/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.insert.WmiInsert2DMathCommand;
import com.maplesoft.mathdoc.controller.insert.WmiInsertTokenCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiGenericCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathMultiscriptModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionBuilder;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPathInterval;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.StringReader;
import java.util.Hashtable;

public abstract class WmiInsertGenericMathCommand
extends WmiInsert2DMathCommand {
    protected static final char NAME_ESCAPE_CHAR = '`';
    protected static final char STRING_ESCAPE_CHAR = '\"';
    protected static final char BS_ESCAPE_CHAR = '\\';
    private static Hashtable operators = null;

    static {
        operators = new Hashtable();
        operators.put("limit", new char[0]);
        operators.put("lim", new char[]{'i'});
        operators.put("&Sum;", new char[0]);
        operators.put("&sum;", new char[0]);
        operators.put("&Product;", new char[0]);
        operators.put("&prod;", new char[0]);
        operators.put("&Integral;", new char[0]);
        operators.put("&int;", new char[0]);
    }

    public WmiInsertGenericMathCommand(String name) {
        super(name);
    }

    public WmiInsertGenericMathCommand(String name, boolean replace) {
        super(name, replace);
    }

    protected String getInsertedText() {
        return null;
    }

    @Override
    public boolean isEnabled(WmiView view) {
        WmiMathDocumentView docView;
        boolean enabled = false;
        WmiMathDocumentView wmiMathDocumentView = docView = view != null ? view.getDocumentView() : null;
        if (docView != null) {
            WmiPositionMarker marker = docView.getPositionMarker();
            WmiSelection selection = docView.getSelection();
            WmiPositionedView markView = null;
            if (marker != null || selection != null) {
                block21: {
                    if (selection != null && !selection.isCompoundSelection()) {
                        WmiModel[] models = new WmiModel[2];
                        int[] offsets = new int[2];
                        selection.getModelInterval(models, offsets);
                        if (models[0] != null && models[1] != null) {
                            WmiModelLock.readLock(models[0], true);
                            try {
                                try {
                                    WmiCompositeModel wrapper1 = WmiModelUtil.findAncestorOfTag(models[0], WmiModelTag.MATH);
                                    WmiCompositeModel wrapper2 = WmiModelUtil.findAncestorOfTag(models[1], WmiModelTag.MATH);
                                    if (wrapper1 == null || wrapper2 != wrapper1) {
                                        marker = null;
                                    }
                                }
                                catch (WmiNoReadAccessException e) {
                                    WmiErrorLog.log(e);
                                    WmiModelLock.readUnlock(models[0]);
                                    break block21;
                                }
                            }
                            catch (Throwable throwable) {
                                WmiModelLock.readUnlock(models[0]);
                                throw throwable;
                            }
                            WmiModelLock.readUnlock(models[0]);
                        }
                    }
                }
                if (marker != null) {
                    markView = marker.getView();
                }
                WmiModel markModel = null;
                if (markView != null) {
                    markModel = markView.getModel();
                    enabled = markModel instanceof WmiMathModel;
                }
                if (markModel != null) {
                    boolean locked = WmiModelLock.readLock(markView.getModel(), false);
                    try {
                        try {
                            if (!enabled) {
                                enabled = (markModel = markModel.getParent()) != null ? markModel instanceof WmiMathModel : false;
                            }
                            enabled &= !marker.isReadOnly();
                        }
                        catch (WmiNoReadAccessException e) {
                            enabled = false;
                            if (locked) {
                                WmiModelLock.readUnlock(markView.getModel());
                            }
                        }
                    }
                    finally {
                        if (locked) {
                            WmiModelLock.readUnlock(markView.getModel());
                        }
                    }
                }
            }
        }
        return enabled;
    }

    protected boolean performInsert(WmiMathDocumentView docView, WmiMathContext context) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        return false;
    }

    public static void refreshSemantics(WmiModel baseModel) throws WmiNoReadAccessException {
        baseModel.getDocument().refreshSemantics(baseModel);
    }

    public boolean doInsertionCommand(WmiMathDocumentView docView, String text) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success = false;
        if (WmiInsertGenericMathCommand.isStringInsert(docView)) {
            if (!this.isMathML(docView, text)) {
                WmiResourcePackage rb = WmiResourcePackage.getResourcePackage("com.maplesoft.mathdoc.view.resources.View");
                String undoInsertText = rb.getStringForKey("InsertText.undo");
                WmiMathDocumentModel doc = (WmiMathDocumentModel)docView.getModel();
                doc.startUndoableEdit(undoInsertText);
                success = WmiInsertGenericMathCommand.performStringInsert(docView, text);
                try {
                    docView.getModel().update(undoInsertText);
                }
                catch (WmiNoUpdateAccessException e) {
                    WmiErrorLog.log(e);
                }
                doc.endUndoableEdit();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            success = this.isEscapedInsert(docView) ? this.performEscapedInsert(docView, text) : (this.isHelpLookup(docView) ? this.performHelpInsert(docView, text) : this.insert(docView, text));
        }
        return success;
    }

    private boolean isMathML(WmiMathDocumentView docView, String text) {
        WmiMathModel result = null;
        if ((text = text.trim()) != null && text.length() > 2 && text.charAt(0) == '<' && text.charAt(text.length() - 1) == '>') {
            WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
            WmiMathMLImportParser parser = new WmiMathMLImportParser();
            WmiGenericCompositeModel parent = new WmiGenericCompositeModel(docModel, null);
            String escapedInsertString = text.replaceAll("&", "&amp;");
            StringReader reader = new StringReader(escapedInsertString);
            try {
                parser.parse(reader, (WmiCompositeModel)parent, 0);
                result = (WmiMathModel)parent.getChild(0);
            }
            catch (WmiNoReadAccessException nrae) {
                WmiErrorLog.log(nrae);
            }
            catch (WmiModelIndexOutOfBoundsException mioobe) {
                WmiErrorLog.log(mioobe);
            }
            catch (WmiNoWriteAccessException mwae) {
                WmiErrorLog.log(mwae);
            }
            catch (WmiParseException wmiParseException) {
                // empty catch block
            }
        }
        return result != null;
    }

    protected boolean insert(WmiMathDocumentView docView, String text) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentModel doc = null;
        WmiPositionMarker marker = null;
        WmiModel targetModel = null;
        WmiSelection selection = null;
        boolean success = false;
        if (docView != null && this.isEnabled(docView)) {
            marker = docView.getPositionMarker();
            boolean writable = true;
            if (marker != null) {
                writable = !marker.isReadOnly();
            }
            selection = docView.getSelection();
            targetModel = this.getTargetModel(marker, selection, docView);
            selection = docView.getSelection();
            if (targetModel != null && targetModel.getParent() != null && writable) {
                doc = targetModel.getDocument();
                WmiMathContext context = WmiInsertGenericMathCommand.createAppropriateContextForModel(targetModel);
                try {
                    success = this.performInsert(docView, context);
                }
                catch (WmiNoUpdateAccessException nua) {
                    WmiErrorLog.log(nua);
                }
                catch (WmiModelIndexOutOfBoundsException miob) {
                    WmiErrorLog.log(miob);
                }
            }
        }
        return success;
    }

    @Override
    public void doCommand(ActionEvent e) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathDocumentView docView = WmiInsertGenericMathCommand.getDocumentView(e);
        if (docView != null && this.isEnabled(docView)) {
            this.doInsertionCommand(WmiInsertGenericMathCommand.getDocumentView(e), this.getInsertedText());
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public static WmiModel splitModelIfRequired(WmiModel targetModel, int targetOffset) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel returnedModel = targetModel;
        return returnedModel;
    }

    public static boolean shouldSplitOutside(WmiModel target) throws WmiNoReadAccessException {
        WmiCompositeModel parent = target.getParent();
        return parent.indexOf(target) == 0 && (parent instanceof WmiSubscriptModel || parent instanceof WmiSuperscriptModel || parent instanceof WmiSubSupModel);
    }

    public static void addMathChild(WmiCompositeModel parent, WmiMathModel insert, WmiPositionMarker marker, int index, WmiMathDocumentModel doc) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel newTarget;
        WmiModelPosition mpos = marker.getModelPosition();
        int targetOffset = 0;
        WmiModel target = null;
        if (mpos != null) {
            target = mpos.getModel();
            targetOffset = mpos.getOffset();
        }
        if ((newTarget = WmiInsertGenericMathCommand.restrictedInsertionCheck(target, targetOffset)) != null) {
            target = newTarget;
            parent = target.getParent();
            index = parent.indexOf(target);
            targetOffset = targetOffset == 0 && target instanceof WmiTextModel ? ((WmiTextModel)target).getText().length() : 0;
            marker.updateMarkerPosition(target, targetOffset);
        }
        if (WmiMathModelUtil.requiresMRow(parent)) {
            WmiInlineMathModel mrow = new WmiInlineMathModel(doc);
            int targetIndex = parent.indexOf(target);
            WmiModelPosition pos = marker.getModelPosition();
            if (pos.getModel() == target) {
                mrow.appendChild(target);
                int caretOffs = pos.getOffset();
                int indexModifier = 0;
                if (target instanceof WmiTextModel) {
                    indexModifier = caretOffs == ((WmiTextModel)(target = ((WmiTextModel)target).splitModel(caretOffs))).getLength() ? 1 : 0;
                }
                int insertIndex = mrow.indexOf(target) + indexModifier;
                mrow.addChild(insert, insertIndex);
            } else {
                mrow.appendChild(target);
                mrow.appendChild(insert);
            }
            parent.replaceChild(mrow, targetIndex);
            MathTokenizer.retokenize(new WmiModelPosition(mrow, 0));
        } else {
            parent.addChild(insert, index);
            MathTokenizer.retokenize(new WmiModelPosition(insert, 0));
        }
    }

    protected WmiModel getTargetModel(WmiPositionMarker marker, WmiSelection selection, WmiMathDocumentView docView) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModelPosition modelPosition = marker.getModelPosition();
        WmiModel targetModel = modelPosition.getModel();
        if (selection != null) {
            WmiModel[] models = new WmiModel[2];
            int[] offsets = new int[2];
            selection.getModelInterval(models, offsets);
        }
        return targetModel;
    }

    protected boolean isEscapedInsert(WmiMathDocumentView docView) throws WmiNoReadAccessException {
        String insertText = this.getInsertedText();
        return WmiInsertGenericMathCommand.isEscapedInsert(docView, insertText);
    }

    public static boolean isEscapedInsert(WmiMathDocumentView docView, String insertText) throws WmiNoReadAccessException {
        boolean escaped = false;
        if (insertText != null && insertText.length() > 0 && docView != null && docView.getSelection() == null && docView.getPositionMarker() != null) {
            WmiModelTag tag;
            WmiPositionMarker marker = docView.getPositionMarker();
            WmiModelPosition modelPos = marker.getModelPosition();
            WmiModel markerModel = modelPos.getModel();
            int markerOffset = modelPos.getOffset();
            WmiModelTag wmiModelTag = tag = markerModel != null ? markerModel.getTag() : null;
            if (tag == WmiModelTag.MATH_IDENTIFIER || tag == WmiModelTag.MATH_OPERATOR) {
                WmiTextModel text = (WmiTextModel)markerModel;
                if (text.getLength() == 0) {
                    WmiModelTag parentTag;
                    WmiCompositeModel parent = text.getParent();
                    WmiModelTag wmiModelTag2 = parentTag = parent != null ? parent.getTag() : null;
                    if (parentTag != null && parentTag != WmiModelTag.MATH_ROW) {
                        escaped = true;
                    } else if (parentTag == WmiModelTag.MATH_ROW) {
                        escaped = parent.getChildCount() == 1;
                    }
                } else if (text.getLength() > 0) {
                    String idText = text.getText();
                    int length = idText.length();
                    if (idText.charAt(0) == '`' && (length == 1 || idText.charAt(length - 1) != '`')) {
                        escaped = true;
                    } else if (idText.charAt(0) == '\"' && (length == 1 || idText.charAt(length - 1) != '\"')) {
                        escaped = true;
                    } else if (markerOffset > 0 && markerOffset <= text.getLength() && idText.charAt(markerOffset - 1) == '\\') {
                        escaped = true;
                    } else if (idText.startsWith("_")) {
                        escaped = true;
                    }
                }
            }
        }
        return escaped;
    }

    protected boolean performEscapedInsert(WmiMathDocumentView docView, String text) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success = false;
        try {
            if (text.equals("_")) {
                this.consumeBackslash(docView);
            }
            WmiInsertTokenCommand.insertAndUpdate(text.charAt(0), docView, null);
            success = true;
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoUpdateAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        return success;
    }

    private void consumeBackslash(WmiMathDocumentView docView) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (docView != null && docView.getSelection() == null && docView.getPositionMarker() != null) {
            WmiModelTag tag;
            WmiPositionMarker marker = docView.getPositionMarker();
            WmiModelPosition modelPos = marker.getModelPosition();
            WmiModel markerModel = modelPos.getModel();
            int markerOffset = modelPos.getOffset();
            WmiModelTag wmiModelTag = tag = markerModel != null ? markerModel.getTag() : null;
            if (tag == WmiModelTag.MATH_IDENTIFIER || tag == WmiModelTag.MATH_OPERATOR) {
                WmiTextModel text = (WmiTextModel)markerModel;
                String idText = text.getText();
                int len = text.getLength();
                if (len > 0 && markerOffset > 0 && markerOffset <= len && idText.charAt(markerOffset - 1) == '\\') {
                    try {
                        modelPos = new WmiModelPosition(markerModel, markerOffset - 1);
                        docView.updatePosition(modelPos, 0);
                        text.replaceText("", markerOffset - 1, 1);
                    }
                    catch (WmiModelIndexOutOfBoundsException e) {
                        WmiErrorLog.log(e);
                    }
                }
            }
        }
    }

    public boolean isEscapedInsertAllowed(WmiModel model) {
        return model instanceof WmiIdentifierModel || model instanceof WmiMathStringModel;
    }

    protected static WmiModel restrictedInsertionCheck(WmiModel target, int targetOffset) throws WmiNoReadAccessException {
        return WmiInsertGenericMathCommand.restrictedInsertionCheck(target, targetOffset, '\u0000');
    }

    protected static WmiModel restrictedInsertionCheck(WmiModel target, int targetOffset, char insertChar) throws WmiNoReadAccessException {
        WmiModel returnModel = null;
        WmiCompositeModel parent = target.getParent();
        if (WmiInsertGenericMathCommand.isOperatorNotForEdit(target, targetOffset, insertChar)) {
            WmiCompositeModel grandparent = parent.getParent();
            int x = targetOffset == 0 ? -1 : 1;
            int newIndex = grandparent.indexOf(parent) + x;
            if (newIndex >= 0 && newIndex < grandparent.getChildCount()) {
                returnModel = grandparent.getChild(newIndex);
                parent = grandparent;
                while (true) {
                    if (WmiModelUtil.isEmptyIdentifierModel(returnModel)) {
                        if ((newIndex += x) < 0 || newIndex >= parent.getChildCount()) break;
                        returnModel = parent.getChild(newIndex);
                        if (!(returnModel instanceof WmiCompositeModel) && !(returnModel instanceof WmiMathSpaceModel)) continue;
                        returnModel = parent.getChild(newIndex - x);
                        break;
                    }
                    if (!(returnModel instanceof WmiCompositeModel)) break;
                    if (x == 1) {
                        returnModel = WmiModelUtil.findFirstDescendantLeaf((WmiCompositeModel)returnModel);
                    } else if (x == -1) {
                        returnModel = WmiModelUtil.findLastDescendantLeaf((WmiCompositeModel)returnModel);
                    }
                    parent = returnModel.getParent();
                    newIndex = parent.indexOf(returnModel);
                }
            }
        }
        return returnModel;
    }

    private static boolean isOperatorNotForEdit(WmiModel target, int targetOffset, char insertChar) throws WmiNoReadAccessException {
        boolean result = false;
        WmiCompositeModel parent = target.getParent();
        if (parent instanceof WmiUnderOverModel || parent instanceof WmiUnderModel || parent instanceof WmiOverModel || parent instanceof WmiSubSupModel || parent instanceof WmiSubscriptModel || parent instanceof WmiSuperscriptModel || parent instanceof WmiMathMultiscriptModel) {
            WmiMathOperatorModel operator;
            WmiMathOperatorModel.WmiMathOperatorAttributeSet attrs;
            if (target instanceof WmiIdentifierModel) {
                char[] allowableChars;
                String text = ((WmiIdentifierModel)target).getText();
                if (operators.containsKey(text) && (targetOffset == 0 || targetOffset == text.length()) && !WmiInsertGenericMathCommand.containsChar(allowableChars = (char[])operators.get(text), insertChar)) {
                    result = true;
                }
            } else if (target instanceof WmiMathOperatorModel && (attrs = (WmiMathOperatorModel.WmiMathOperatorAttributeSet)(operator = (WmiMathOperatorModel)target).getAttributes()).isLargeOp()) {
                result = true;
            }
        }
        return result;
    }

    private static boolean containsChar(char[] array, char ch) {
        boolean result = false;
        if (array != null) {
            int i = 0;
            while (i < array.length && !result) {
                result = array[i] == ch;
                ++i;
            }
        }
        return result;
    }

    protected boolean performHelpInsert(WmiMathDocumentView docView, String text) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (text == null) {
            text = this.getInsertedText();
        }
        if (text != null) {
            WmiInsertTokenCommand command = WmiInsertTokenCommand.INSTANCE;
            String undoName = command.getResource(5);
            WmiInsertTokenCommand.insertMathToken(text, docView, undoName, false);
        }
        return true;
    }

    private boolean isHelpLookup(WmiMathDocumentView docView) throws WmiNoReadAccessException {
        boolean forHelp = false;
        WmiPositionMarker marker = docView.getPositionMarker();
        if (marker != null) {
            WmiView firstChild;
            WmiCompositeView parent;
            WmiPositionedView view = marker.getView();
            WmiCompositeView wmiCompositeView = parent = view != null ? view.getParentView() : null;
            if (parent instanceof WmiInlineView && (firstChild = parent.getChild(0)) instanceof WmiTextView) {
                String contents = ((WmiTextView)firstChild).getText();
                forHelp = contents.startsWith("?");
            }
        }
        return forHelp;
    }

    protected static boolean performStringInsert(WmiMathDocumentView docView, String text) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (text != null) {
            WmiSelection selection = docView.getSelection();
            if (selection != null) {
                WmiModel[] models = new WmiModel[2];
                int[] offsets = new int[2];
                selection.getModelInterval(models, offsets);
                if (models[0] != null && models[1] != null) {
                    boolean updateSelection = false;
                    WmiModelPosition startPos = new WmiModelPosition(models[0], offsets[0]);
                    WmiModelPosition endPos = new WmiModelPosition(models[1], offsets[1]);
                    if (models[0] instanceof WmiMathStringModel) {
                        startPos = ((WmiMathStringModel)models[0]).convertToMathText(offsets[0]);
                        updateSelection = true;
                    }
                    if (models[1] instanceof WmiMathStringModel) {
                        endPos = models[1] != models[0] ? ((WmiMathStringModel)models[1]).convertToMathText(offsets[1]) : new WmiModelPosition(startPos.getModel(), offsets[1]);
                        updateSelection = true;
                    }
                    WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
                    boolean compoundEdit = false;
                    if (updateSelection) {
                        compoundEdit = true;
                        docModel.startUndoableEdit(WmiViewPathInterval.undoReplaceSelectionText);
                        try {
                            docModel.update(null);
                        }
                        catch (WmiNoUpdateAccessException e) {
                            WmiErrorLog.log(e);
                        }
                        WmiViewFactory factory = docView.getViewFactory();
                        WmiSelectionBuilder builder = factory.getSelectionBuilder();
                        selection = builder.createSelection(startPos.getModel(), startPos.getOffset(), endPos.getModel(), endPos.getOffset());
                    }
                    if (selection != null) {
                        selection.replaceSelection(text);
                    }
                    if (compoundEdit) {
                        docModel.endUndoableEdit();
                    }
                }
            } else {
                WmiPositionedView view;
                WmiPositionMarker marker = docView.getPositionMarker();
                WmiPositionedView wmiPositionedView = view = marker != null ? marker.getView() : null;
                if (view instanceof WmiTextView) {
                    WmiAbstractMathTokenModel mathModel;
                    String encodedContent;
                    WmiTextModel textModel = (WmiTextModel)view.getModel();
                    int insertOffset = marker.getOffset();
                    WmiInsertGenericMathCommand.refreshSemantics(textModel);
                    String rawContent = textModel.getText();
                    rawContent = insertOffset == 0 ? String.valueOf(text) + rawContent : (insertOffset >= rawContent.length() ? String.valueOf(rawContent) + text : String.valueOf(rawContent.substring(0, insertOffset)) + text + rawContent.substring(insertOffset));
                    ((WmiTextView)view).insertString(text, insertOffset);
                    int targetOffset = insertOffset + text.length();
                    if (textModel instanceof WmiAbstractMathTokenModel && !rawContent.equals(encodedContent = (mathModel = (WmiAbstractMathTokenModel)textModel).getText())) {
                        targetOffset = WmiInsertGenericMathCommand.alignStrings(encodedContent, rawContent, targetOffset);
                        docView.setPendingPosition(new WmiModelPosition(textModel, targetOffset));
                    }
                }
            }
        }
        return true;
    }

    private static int alignStrings(String encoded, String raw, int offset) {
        if (!encoded.startsWith(raw.substring(0, offset)) && encoded.endsWith(raw.substring(offset))) {
            int delta = raw.length() - offset;
            offset = encoded.length() - delta;
        }
        return offset;
    }

    protected static boolean isStringInsert(WmiMathDocumentView docView) throws WmiNoReadAccessException {
        boolean stringInsert = false;
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiSelection selection = docView.getSelection();
        if (selection != null) {
            WmiModel[] models = new WmiModel[2];
            int[] offsets = new int[2];
            selection.getModelInterval(models, offsets);
            if (models[0] == models[1] && models[0] != null && (models[0].getTag() == WmiModelTag.MATH_STRING || models[0].getTag() == WmiModelTag.MATH_TEXT)) {
                stringInsert = true;
            }
        } else if (marker != null) {
            WmiModelTag tag;
            WmiPositionedView view = marker.getView();
            WmiModel model = view != null ? view.getModel() : null;
            WmiModelTag wmiModelTag = tag = model != null ? model.getTag() : null;
            if (tag == WmiModelTag.MATH_STRING || tag == WmiModelTag.MATH_TEXT) {
                int offset = marker.getOffset();
                int limit = ((WmiTextModel)model).getLength();
                stringInsert = offset > 0 && offset < limit;
            }
        }
        return stringInsert;
    }
}

