/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.insert.InsertMathStructureCommand;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionBuilder;
import com.maplesoft.mathdoc.view.WmiTextView;
import java.util.HashSet;

public class WmiInsertMFracCommand
extends InsertMathStructureCommand {
    private static final HashSet TERM_COLLECTION_MODELS = new HashSet();
    private static final HashSet ALLOWED_OPERATORS = new HashSet();
    private static final HashSet ALLOWED_PREFIX_OPERATORS = new HashSet();

    static {
        TERM_COLLECTION_MODELS.add(WmiModelTag.MATH_SUPERSCRIPT);
        TERM_COLLECTION_MODELS.add(WmiModelTag.MATH_SUBSCRIPT);
        TERM_COLLECTION_MODELS.add(WmiModelTag.MATH_SUB_SUP);
        TERM_COLLECTION_MODELS.add(WmiModelTag.MATH_SQUARE_ROOT);
        TERM_COLLECTION_MODELS.add(WmiModelTag.MATH_FENCED);
        TERM_COLLECTION_MODELS.add(WmiModelTag.LABEL);
        TERM_COLLECTION_MODELS.add(WmiModelTag.MATH_IDENTIFIER);
        TERM_COLLECTION_MODELS.add(WmiModelTag.MATH_NUMERIC);
        TERM_COLLECTION_MODELS.add(WmiModelTag.MATH_SPACE);
        ALLOWED_OPERATORS.add("&InvisibleTimes;");
        ALLOWED_OPERATORS.add(".");
        ALLOWED_OPERATORS.add("&DifferentialD;");
        ALLOWED_OPERATORS.add("d");
        ALLOWED_OPERATORS.add("&sdot;");
        ALLOWED_OPERATORS.add("d");
        ALLOWED_OPERATORS.add("!");
        ALLOWED_OPERATORS.add("'");
        ALLOWED_OPERATORS.add("&prime;");
        ALLOWED_OPERATORS.add("&part;");
        ALLOWED_OPERATORS.add("&PartialD;");
        ALLOWED_OPERATORS.add("\u22c5");
        ALLOWED_OPERATORS.add("\u2202");
        ALLOWED_OPERATORS.add(" ");
        ALLOWED_PREFIX_OPERATORS.add("&DifferentialD;");
        ALLOWED_PREFIX_OPERATORS.add("d");
        ALLOWED_PREFIX_OPERATORS.add("&part;");
        ALLOWED_PREFIX_OPERATORS.add("&PartialD;");
        ALLOWED_PREFIX_OPERATORS.add("\u2202");
    }

    public WmiInsertMFracCommand() {
        super("Insert.Mfrac");
    }

    public WmiInsertMFracCommand(String name) {
        super(name);
    }

    public WmiInsertMFracCommand(String name, boolean replace) {
        super(name, replace);
    }

    @Override
    public WmiCompositeModel createCompositeInsertModel(WmiMathDocumentModel doc, WmiMathContext context) throws WmiNoWriteAccessException {
        WmiMathModel placeholder = this.createPlaceHolder(doc, context);
        WmiMathModel placeholder2 = this.createPlaceHolder(doc, context);
        WmiFractionModel mfrac = new WmiFractionModel(doc, placeholder, placeholder2, context);
        return mfrac;
    }

    @Override
    protected boolean performInsert(WmiMathDocumentView docView, WmiMathContext context) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoUpdateAccessException, WmiNoWriteAccessException {
        boolean success = false;
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiSelection selection = docView.getSelection();
        if (marker != null && selection == null) {
            this.createSelectionForNumerator(docView);
        }
        success = super.performInsert(docView, context);
        return success;
    }

    private void createSelectionForNumerator(WmiMathDocumentView docView) throws WmiNoReadAccessException {
        WmiModel child;
        String text;
        int index;
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiPositionedView view = marker.getView();
        WmiModel endModel = view != null ? view.getModel() : null;
        int endOffset = marker.getOffset();
        endOffset = view instanceof WmiTextView && endOffset >= 0 ? (endOffset += ((WmiTextView)view).getStartOffset()) : -1;
        WmiCompositeModel parent = endModel != null ? endModel.getParent() : null;
        int start = index = parent != null ? parent.indexOf(endModel) : -1;
        int lastSpace = -1;
        if (parent != null && parent.getTag() == WmiModelTag.MATH_ROW) {
            int i = index - 1;
            while (i >= 0) {
                WmiModel child2 = parent.getChild(i);
                WmiModelTag tag = child2.getTag();
                if (tag == WmiModelTag.MATH_OPERATOR) {
                    String text2 = ((WmiTextModel)child2).getText();
                    if (text2.equals(" ")) {
                        if (lastSpace == i + 1) {
                            start = lastSpace + 1;
                            break;
                        }
                        lastSpace = i;
                    }
                    if (!ALLOWED_OPERATORS.contains(text2)) {
                        break;
                    }
                } else {
                    if (!TERM_COLLECTION_MODELS.contains(tag)) break;
                    if (tag == WmiModelTag.MATH_SUB_SUP || tag == WmiModelTag.MATH_SUBSCRIPT || tag == WmiModelTag.MATH_SUPERSCRIPT) {
                        String text3;
                        WmiModel base = ((WmiCompositeModel)child2).getChild(0);
                        if (base.getTag() == WmiModelTag.MATH_STYLE) {
                            base = ((WmiCompositeModel)base).getChild(0);
                        }
                        if (base.getTag() == WmiModelTag.MATH_OPERATOR && !ALLOWED_OPERATORS.contains(text3 = ((WmiTextModel)base).getText())) break;
                    }
                }
                start = i--;
            }
        }
        if (start >= 0) {
            WmiModel child3 = parent.getChild(start);
            while (child3.getTag() == WmiModelTag.MATH_OPERATOR) {
                text = ((WmiTextModel)child3).getText();
                if (ALLOWED_PREFIX_OPERATORS.contains(text) || start >= index) break;
                child3 = parent.getChild(++start);
            }
        }
        if (start > 0 && start < index && (child = parent.getChild(start - 1)) instanceof WmiTextModel && (text = ((WmiTextModel)child).getText()).equals("proc")) {
            ++start;
        }
        if (start >= 0) {
            WmiViewFactory factory = docView.getViewFactory();
            WmiSelectionBuilder builder = factory.getSelectionBuilder();
            WmiModel startModel = parent.getChild(start);
            if (start > 0 && parent.getTag() == WmiModelTag.MATH_ROW && startModel == endModel && endModel instanceof WmiTextModel && ((WmiTextModel)endModel).getLength() == 0) {
                startModel = parent.getChild(start - 1);
            }
            WmiSelection selection = builder.createSelection(startModel, 0, endModel, endOffset);
            docView.setPositionMarker(null);
            docView.setSelection(selection);
        }
    }

    @Override
    protected boolean addBrackets(WmiModel target) {
        return false;
    }

    @Override
    protected String getInsertedText() {
        return "/";
    }
}

