/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.InsertMathStructureCommand;
import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.controller.insert.WmiInsertGenericMathCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiGenericCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.MathTokenizer;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.util.WmiSearchVisitor;
import java.io.StringReader;

public class WmiInsertMathMLCommand
extends InsertMathStructureCommand {
    public static final String INSERT_COMMAND_NAME = "Insert.Mathml";
    public static final WmiInsertMathMLCommand DEFAULT_MATHML_INSERTER = new WmiInsertMathMLCommand("Insert.Mathml");

    public WmiInsertMathMLCommand() {
        this(INSERT_COMMAND_NAME);
    }

    public WmiInsertMathMLCommand(String name) {
        super(name);
    }

    public WmiInsertMathMLCommand(String name, boolean replace) {
        super(name, replace);
    }

    @Override
    public boolean insert(WmiMathDocumentView docView, String text) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return this.insert(docView, text, false);
    }

    public boolean insert(WmiMathDocumentView docView, String text, boolean completion) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel targetModel;
        boolean success = false;
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiSelection selection = docView.getSelection();
        WmiPositionedView view = marker != null ? marker.getView() : null;
        WmiModel wmiModel = targetModel = view != null ? view.getModel() : null;
        if (targetModel != null) {
            WmiMathContext context = WmiInsertMathMLCommand.createAppropriateContextForModel(targetModel);
            WmiMathModel insertModel = this.createInsertedModel(text, targetModel, context);
            String undoName = this.getResource(5);
            success = selection == null ? WmiInsertMathMLCommand.insertAtPositionMarker(docView, insertModel, undoName) : WmiInsertMathMLCommand.selectionWrapInsert(docView, insertModel, true, undoName, completion);
        }
        return success;
    }

    public static boolean insert(WmiMathDocumentView docView, WmiModel insertModel, String undoName) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        return WmiInsertMathMLCommand.insert(docView, insertModel, undoName, false);
    }

    public static boolean insert(WmiMathDocumentView docView, WmiModel insertModel, String undoName, boolean completion) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel targetModel;
        boolean success = false;
        WmiPositionMarker marker = docView.getPositionMarker();
        WmiSelection selection = docView.getSelection();
        WmiPositionedView view = marker != null ? marker.getView() : null;
        WmiModel wmiModel = targetModel = view != null ? view.getModel() : null;
        if (targetModel != null) {
            success = selection == null ? WmiInsertMathMLCommand.insertAtPositionMarker(docView, insertModel, undoName) : WmiInsertMathMLCommand.selectionWrapInsert(docView, insertModel, false, undoName, completion);
        }
        return success;
    }

    private static boolean insertAtPositionMarker(WmiMathDocumentView docView, WmiModel insertModel, String undoName) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success = false;
        WmiPositionMarker marker = docView.getPositionMarker();
        try {
            WmiModelPosition pos = MathInsertUtil.updateInsertionPoint(marker, 0);
            MathInsertUtil.ensureParentMathRow(pos);
            WmiModel targetModel = pos.getModel();
            if (targetModel != null && targetModel.getTag() == WmiModelTag.MATH_STRING) {
                if (insertModel instanceof WmiTextModel) {
                    String insertText = ((WmiTextModel)insertModel).getText();
                    int insertOffset = pos.getOffset();
                    ((WmiTextModel)targetModel).insertText(insertText, insertOffset);
                    pos = new WmiModelPosition(targetModel, insertOffset + insertText.length());
                    docView.setPendingPosition(pos);
                    WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
                    docModel.update(undoName);
                    success = true;
                }
            } else {
                pos = MathInsertUtil.insertEmptyPlaceholder(pos);
                targetModel = pos.getModel();
                WmiCompositeModel parent = targetModel.getParent();
                int targetIndex = parent.indexOf(targetModel);
                parent.replaceChild(insertModel, targetIndex);
                WmiInsertGenericMathCommand.refreshSemantics(parent);
                WmiModel placeholder = WmiInsertMathMLCommand.findPlaceholder(insertModel);
                if (placeholder != null) {
                    WmiInsertMathMLCommand.selectModel(docView, placeholder);
                } else {
                    int offset = insertModel instanceof WmiTextModel ? ((WmiTextModel)insertModel).getLength() : -1;
                    pos = insertModel instanceof WmiTextModel ? MathTokenizer.retokenize((WmiTextModel)insertModel, offset) : new WmiModelPosition(insertModel, offset);
                    docView.setPendingPosition(pos);
                }
                WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
                docModel.update(undoName);
                success = true;
            }
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoUpdateAccessException e) {
            WmiErrorLog.log(e);
        }
        return success;
    }

    private static boolean selectionWrapInsert(WmiMathDocumentView docView, WmiModel insertModel, boolean substitutePlaceholder, String undoName, boolean completion) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success = false;
        try {
            WmiModelPosition pos = MathInsertUtil.wrapSelection(docView);
            WmiModel targetModel = pos != null ? pos.getModel() : null;
            WmiModel placeholder = WmiInsertMathMLCommand.findSelectionPlaceholder(insertModel);
            if (completion) {
                placeholder = WmiInsertMathMLCommand.findPlaceholder(insertModel);
            }
            if (targetModel != null) {
                WmiMathDocumentModel docModel = targetModel.getDocument();
                WmiCompositeModel parent = targetModel.getParent();
                int targetIndex = parent.indexOf(targetModel);
                parent.replaceChild(insertModel, targetIndex);
                WmiInsertGenericMathCommand.refreshSemantics(parent);
                if (placeholder != null) {
                    if (substitutePlaceholder) {
                        parent = placeholder.getParent();
                        targetIndex = parent.indexOf(placeholder);
                        parent.replaceChild(targetModel, targetIndex);
                        WmiInsertGenericMathCommand.refreshSemantics(parent);
                        WmiInsertMathMLCommand.selectModel(docView, targetModel);
                    } else {
                        WmiInsertMathMLCommand.selectModel(docView, placeholder);
                    }
                } else if (insertModel instanceof WmiTextModel) {
                    pos = MathTokenizer.retokenize((WmiTextModel)insertModel, ((WmiTextModel)insertModel).getLength());
                    docView.setPendingPosition(pos);
                } else {
                    docView.setPendingPosition(insertModel, -1);
                }
                docModel.update(undoName);
                success = true;
            }
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoUpdateAccessException e) {
            WmiErrorLog.log(e);
        }
        return success;
    }

    public WmiMathModel createInsertedModel(String insertString, WmiModel targetModel, WmiMathContext context) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        return WmiInsertMathMLCommand.convertMathMLToModel(insertString, targetModel, context);
    }

    public static WmiMathModel convertMathMLToModel(String insertString, WmiModel targetModel, WmiMathContext context) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiMathModel result = null;
        WmiMathDocumentModel docModel = targetModel.getDocument();
        WmiGenericCompositeModel parent = new WmiGenericCompositeModel(docModel, null);
        WmiMathMLImportParser parser = new WmiMathMLImportParser();
        String escapedInsertString = insertString.replaceAll("&", "&amp;");
        StringReader reader = new StringReader(escapedInsertString);
        try {
            parser.parse(reader, (WmiCompositeModel)parent, 0);
            result = (WmiMathModel)parent.getChild(0);
            WmiInsertMathMLCommand.replaceMactions(result);
            WmiInsertMathMLCommand.updateAttributes(result, targetModel, context != null ? context.getStyle() : null);
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
        catch (WmiModelIndexOutOfBoundsException mioobe) {
            WmiErrorLog.log(mioobe);
        }
        catch (WmiParseException pe) {
            System.err.println("*** parse exception dealing with:");
            System.err.println(insertString);
            System.err.println("===");
            System.err.println(escapedInsertString);
            WmiErrorLog.log(pe);
        }
        return result;
    }

    public static WmiModel findSelectionPlaceholder(WmiModel insertedModel) throws WmiNoReadAccessException {
        WmiModel placeholder = WmiModelUtil.findFirstTraversalOrderedDescendantWithAttribute(insertedModel, "selection-placeholder", "true");
        return placeholder;
    }

    public static WmiModel findPlaceholder(WmiModel insertedModel) throws WmiNoReadAccessException {
        WmiModel firstPlaceholder = WmiModelUtil.findFirstTraversalOrderedDescendantWithAttribute(insertedModel, "placeholder", "true");
        boolean isEmpty = false;
        if (firstPlaceholder instanceof WmiTextModel) {
            boolean bl = isEmpty = ((WmiTextModel)firstPlaceholder).getLength() == 0;
            if (isEmpty && WmiModelLock.ownsWriteLock(insertedModel)) {
                try {
                    firstPlaceholder.addAttribute("placeholder", "false");
                    firstPlaceholder = WmiInsertMathMLCommand.findPlaceholder(insertedModel);
                }
                catch (WmiNoWriteAccessException e) {
                    WmiErrorLog.log(e);
                }
            }
        }
        return firstPlaceholder;
    }

    public static boolean replaceMactions(WmiModel mathModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean replaced = false;
        boolean placeholder = false;
        boolean selectionPlaceholder = false;
        WmiModel reference = WmiModelUtil.findFirstDescendantOfTag(mathModel, WmiModelTag.MATH_ACTION);
        while (reference != null) {
            WmiModel placeholderChild = null;
            if (WmiInsertMathMLCommand.isSelectionPlaceholder(reference)) {
                placeholderChild = ((WmiCompositeModel)reference).getChild(0);
                selectionPlaceholder = true;
            } else if (WmiInsertMathMLCommand.isPlaceholder(reference)) {
                placeholderChild = ((WmiCompositeModel)reference).getChild(0);
                placeholder = true;
            } else if (WmiInsertMathMLCommand.isAtomic(reference)) {
                placeholderChild = ((WmiCompositeModel)reference).getChild(0);
                placeholderChild.addAttribute("Typesetting:-msemantics", "atomic");
            }
            if (placeholderChild != null) {
                WmiCompositeModel parent = reference.getParent();
                int indexOfReference = parent.indexOf(reference);
                try {
                    parent.replaceChild(placeholderChild, indexOfReference);
                }
                catch (WmiModelIndexOutOfBoundsException mioobe) {
                    WmiErrorLog.log(mioobe);
                }
                if (placeholder || selectionPlaceholder) {
                    reference = placeholderChild;
                    reference.addAttribute("placeholder", "true");
                }
                if (selectionPlaceholder) {
                    reference = placeholderChild;
                    reference.addAttribute("selection-placeholder", "true");
                    selectionPlaceholder = false;
                }
                replaced = true;
            }
            reference = WmiModelUtil.findNextModel(mathModel, reference, WmiModelTag.MATH_ACTION);
        }
        return replaced;
    }

    private static boolean isSelectionPlaceholder(WmiModel model) throws WmiNoReadAccessException {
        boolean isPlaceholder;
        boolean bl = isPlaceholder = model instanceof WmiCompositeModel && WmiInsertMathMLCommand.containsActionTypeValue(model, "maplesoft:selection-placeholder");
        if (!isPlaceholder) {
            WmiAttributeSet set = model.getAttributesForRead();
            isPlaceholder = set.getAttribute("selection-placeholder") == "true";
        }
        return isPlaceholder;
    }

    private static boolean isAtomic(WmiModel model) throws WmiNoReadAccessException {
        return model instanceof WmiCompositeModel && WmiInsertMathMLCommand.containsActionTypeValue(model, "maplesoft:atomic");
    }

    private static boolean isPlaceholder(WmiModel model) throws WmiNoReadAccessException {
        return model instanceof WmiCompositeModel && WmiInsertMathMLCommand.containsActionTypeValue(model, "maplesoft:placeholder");
    }

    private static boolean containsActionTypeValue(WmiModel model, String actionTypeValue) throws WmiNoReadAccessException {
        Object actionType;
        WmiAttributeSet set;
        boolean isPlaceholder = false;
        if (model != null && (set = model.getAttributesForRead()) != null && (actionType = set.getAttribute("actiontype")) != null && actionType.equals(actionTypeValue)) {
            isPlaceholder = true;
        }
        return isPlaceholder;
    }

    private static void updateAttributes(WmiModel inserted, WmiModel targetModel, WmiAttributeSet attribs) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiCompositeModel root = WmiModelUtil.findAncestorOfClass(targetModel, WmiMathWrapperModel.class);
        if (root != null) {
            attribs = root.getAttributes();
        }
        if (attribs != null && inserted != null) {
            WmiMathMLAttributeUpdateVisitor visitor = new WmiMathMLAttributeUpdateVisitor(attribs);
            WmiModelUtil.visitModels(inserted, visitor);
        }
    }

    private static class WmiMathMLAttributeUpdateVisitor
    implements WmiSearchVisitor {
        private WmiAttributeSet attributeSet = null;

        private WmiMathMLAttributeUpdateVisitor(WmiAttributeSet attributes) {
            this.attributeSet = attributes;
        }

        @Override
        public int visitMatch(Object match) {
            int success = 2;
            if (this.attributeSet != null) {
                try {
                    if (match instanceof WmiModel) {
                        this.update((WmiModel)match);
                        success = 0;
                    }
                }
                catch (WmiNoWriteAccessException writeE) {
                    WmiErrorLog.log(writeE);
                }
                catch (WmiNoReadAccessException readE) {
                    WmiErrorLog.log(readE);
                }
            }
            return success;
        }

        private void update(WmiModel model) throws WmiNoWriteAccessException, WmiNoReadAccessException {
            WmiAttributeSet oldAttributes = model.getAttributes();
            if (!(oldAttributes instanceof WmiMathTableModel.WmiMathTableAttributeSet)) {
                WmiModel placeholderAncestor = WmiModelUtil.findAncestorWithAttribute(model, "placeholder", "true");
                if (placeholderAncestor == null && oldAttributes.getAttribute("placeholder") != "true") {
                    long mods;
                    WmiAttributeSet newAttribs = oldAttributes.copyAttributes();
                    boolean assignForeground = true;
                    if (model instanceof WmiAbstractMathTokenModel && ((mods = ((WmiAbstractMathTokenModel)model).getModified()) & 1L) != 0L) {
                        assignForeground = false;
                    }
                    if (assignForeground) {
                        Object foreground = this.attributeSet.getAttribute("foreground");
                        newAttribs.addAttribute("foreground", foreground);
                    }
                    Object executable = this.attributeSet.getAttribute("executable");
                    newAttribs.addAttribute("executable", executable);
                    Object readonly = this.attributeSet.getAttribute("readonly");
                    newAttribs.addAttribute("readonly", readonly);
                    Object size = this.attributeSet.getAttribute("size");
                    newAttribs.addAttribute("size", size);
                    model.addAttributes(newAttribs);
                } else {
                    WmiAttributeSet newAttribs = oldAttributes.copyAttributes();
                    Object executable = this.attributeSet.getAttribute("executable");
                    newAttribs.addAttribute("executable", executable);
                    model.addAttributes(newAttribs);
                }
            }
        }
    }
}

