/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.client.BlockingEvaluation;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.controller.insert.WmiInsertMathMLCommand;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiAssignedSemantics;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import java.awt.Color;

public class WmiInsertMatrixCommand
extends WmiInsertMathMLCommand {
    public static final WmiInsertMatrixCommand DEFAULT_MATRIX_INSERTER = new WmiInsertMatrixCommand("Insert.Matrix");
    private String command = null;
    private int kernelId = -1;
    private KernelListener parentListener = null;
    private boolean updateSelection = false;
    private boolean treatOnesAsPlaceholders = false;

    public WmiInsertMatrixCommand(String name) {
        super(name);
    }

    @Override
    protected String getInsertedText() {
        return "";
    }

    @Override
    public WmiMathModel createInsertedModel(String insertString, WmiModel targetModel, WmiMathContext context) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        if (this.kernelId == -1) {
            throw new IllegalStateException("Invalid kernel id. Specify a kernel id to use via the insert( WmiMathDocumentView, String, int, KernelListener ) method.");
        }
        WmiMathModel model = null;
        WmiMathDocumentModel doc = targetModel.getDocument();
        WmiMatrixPaletteEvaluator eval = new WmiMatrixPaletteEvaluator();
        eval.process();
        Object result = eval.getResult();
        if (result instanceof Dag) {
            Dag mpslshDag = (Dag)result;
            try {
                mpslshDag = DagBuilder.normalize(mpslshDag);
                Dag semanticDag = DagUtil.getSemanticDataFromPrintslash(mpslshDag);
                model = WmiMathFactory.createMath(doc, mpslshDag, context);
                this.modifyPlaceHolders(model);
                if (model != null) {
                    WmiMathModel semanticAttachModel = (WmiMathModel)WmiModelUtil.findFirstDescendantOfTag((WmiModel)model, WmiModelTag.MATH_ACTION);
                    if (semanticAttachModel == null) {
                        semanticAttachModel = model;
                    }
                    EnteredMatrixSemantics semantics = new EnteredMatrixSemantics(semanticDag);
                    semanticAttachModel.setSemantics(semantics);
                }
            }
            catch (WmiNoReadAccessException nrae) {
                WmiErrorLog.log(nrae);
            }
        }
        return model;
    }

    public boolean insert(WmiMathDocumentView docView, String command, boolean treatOnesAsPlaceholders, int kernelId, KernelListener parentListener) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean success = false;
        WmiModel model = docView.getModel();
        if (WmiModelLock.ownsWriteLock(model)) {
            this.command = command;
            this.kernelId = kernelId;
            this.parentListener = parentListener;
            try {
                this.treatOnesAsPlaceholders = treatOnesAsPlaceholders;
                success = super.doInsertionCommand(docView, command);
            }
            finally {
                this.command = null;
                this.kernelId = -1;
                this.parentListener = null;
                this.treatOnesAsPlaceholders = false;
            }
        } else {
            throw new WmiNoWriteAccessException(model);
        }
        this.updateSelection = false;
        return success;
    }

    private void processMatch(WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        boolean isPlaceHolder = this.isPlaceholder(model);
        if (isPlaceHolder) {
            Color purple = Color.decode(WmiMathAttributeSet.getColour("ph_purple"));
            model.addAttribute("placeholder", "true");
            if (model instanceof WmiCompositeModel) {
                WmiCompositeModel c = (WmiCompositeModel)model;
                WmiModel ident = c.getChild(0);
                ident.addAttribute("foreground", purple);
                if (c.getChild(1) instanceof WmiInlineMathModel) {
                    WmiInlineMathModel inline = (WmiInlineMathModel)c.getChild(1);
                    int i = 0;
                    while (i < inline.getChildCount()) {
                        WmiModel child = inline.getChild(i);
                        child.addAttribute("foreground", purple);
                        ++i;
                    }
                }
            } else {
                model.addAttribute("foreground", purple);
            }
        }
    }

    private boolean isPlaceholder(WmiModel model) throws WmiNoReadAccessException {
        boolean p = false;
        if (this.treatOnesAsPlaceholders) {
            if (model instanceof WmiNumericModel) {
                p = ((WmiNumericModel)model).getText().equals("1");
            }
        } else if (model instanceof WmiSubscriptModel) {
            WmiIdentifierModel ident;
            WmiSubscriptModel subscript = (WmiSubscriptModel)model;
            if (subscript.getChild(0) instanceof WmiIdentifierModel && (ident = (WmiIdentifierModel)subscript.getChild(0)).getText().equals("m")) {
                p = subscript.getChild(1) instanceof WmiInlineMathModel;
            }
        } else if (model instanceof WmiInlineMathModel) {
            WmiInlineMathModel inline = (WmiInlineMathModel)model;
            int i = 0;
            while (i < inline.getChildCount() && !p) {
                WmiModel child = inline.getChild(i);
                WmiAttributeSet attributeSet = child.getAttributesForRead();
                Object attribute = attributeSet.getAttribute("placeholder");
                if (attribute != null) {
                    p |= attribute.equals("true");
                }
                ++i;
            }
        }
        return p;
    }

    private void modifyPlaceHolders(WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (model instanceof WmiCompositeModel) {
            WmiCompositeModel composite = (WmiCompositeModel)model;
            int i = 0;
            while (i < composite.getChildCount()) {
                this.modifyPlaceHolders(composite.getChild(i));
                ++i;
            }
        }
        this.processMatch(model);
    }

    public static class EnteredMatrixSemantics
    extends WmiAssignedSemantics {
        public EnteredMatrixSemantics(Dag mpslshDag) {
            super(EnteredMatrixSemantics.configureDag(mpslshDag));
        }

        private static Dag configureDag(Dag mpslshDag) {
            Dag display = DagUtil.getDisplayDataFromPrintslash(mpslshDag);
            return display;
        }
    }

    private class WmiMatrixPaletteEvaluator
    extends BlockingEvaluation {
        public WmiMatrixPaletteEvaluator() {
            super(WmiInsertMatrixCommand.this.kernelId, WmiInsertMatrixCommand.this.parentListener);
        }

        @Override
        protected String getCommand() {
            return WmiInsertMatrixCommand.this.command;
        }

        @Override
        protected void update() {
        }
    }
}

