/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.insert;

import com.maplesoft.mathdoc.controller.insert.InsertMathStructureCommand;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;

public class WmiInsertTableColumnCommand
extends InsertMathStructureCommand {
    public WmiInsertTableColumnCommand() {
        super("Insert.Tablecolumn");
    }

    public WmiInsertTableColumnCommand(String name) {
        super(name);
    }

    public WmiInsertTableColumnCommand(String name, boolean replace) {
        super(name, replace);
    }

    @Override
    protected boolean performInsert(WmiMathDocumentView docView, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoUpdateAccessException {
        boolean success = false;
        WmiMathDocumentModel doc = (WmiMathDocumentModel)docView.getModel();
        WmiPositionMarker marker = docView.getPositionMarker();
        if (marker != null) {
            docView.setSelection(null);
            int offset = marker.getOffset();
            WmiPositionedView view = marker.getView();
            WmiModel targetModel = view.getModel();
            WmiCompositeModel tableCellModel = WmiModelUtil.findAncestorOfTag(targetModel, WmiModelTag.MATH_TABLE_CELL);
            if (tableCellModel == null) {
                WmiMathTableModel table = new WmiMathTableModel(doc);
                WmiMathTableModel.WmiMathTableRowModel row = new WmiMathTableModel.WmiMathTableRowModel(doc);
                WmiMathTableModel.WmiMathTableDataModel data1 = new WmiMathTableModel.WmiMathTableDataModel(doc);
                WmiMathTableModel.WmiMathTableDataModel data2 = new WmiMathTableModel.WmiMathTableDataModel(doc);
                if (offset == 0) {
                    row.appendChild(data2);
                    row.appendChild(data1);
                } else {
                    row.appendChild(data1);
                    row.appendChild(data2);
                }
                WmiMathModel placeholder = this.createTablePlaceholder(doc, context);
                data2.appendChild(placeholder);
                table.appendChild(row);
                WmiCompositeModel parent = targetModel.getParent();
                int targetIndex = parent.indexOf(targetModel);
                if (targetIndex >= 0) {
                    parent.replaceChild(table, targetIndex);
                    data1.appendChild(targetModel);
                    WmiInsertTableColumnCommand.selectModel(docView, placeholder);
                    doc.update(this.getResource(5));
                    success = true;
                }
            } else {
                success = this.insertColumn(docView, tableCellModel, context, offset == 0);
            }
        }
        return success;
    }

    private boolean insertColumn(WmiMathDocumentView docView, WmiModel tableCellModel, WmiMathContext context, boolean insertBefore) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoUpdateAccessException {
        boolean success = true;
        WmiCompositeModel row = tableCellModel.getParent();
        WmiCompositeModel table = row.getParent();
        WmiMathDocumentModel doc = tableCellModel.getDocument();
        int tableSize = table.getChildCount();
        int rowSize = row.getChildCount();
        int i = 0;
        while (i < tableSize) {
            WmiCompositeModel child = (WmiCompositeModel)table.getChild(i);
            if (child.getChildCount() != rowSize) {
                success = false;
                break;
            }
            ++i;
        }
        if (success) {
            int columnIndex = row.indexOf(tableCellModel);
            if (!insertBefore) {
                ++columnIndex;
            }
            WmiModel[] placeholders = new WmiModel[tableSize];
            int i2 = 0;
            while (i2 < tableSize) {
                placeholders[i2] = this.createTablePlaceholder(doc, context);
                WmiCompositeModel child = (WmiCompositeModel)table.getChild(i2);
                WmiMathTableModel.WmiMathTableDataModel data = new WmiMathTableModel.WmiMathTableDataModel(doc);
                data.addChild(placeholders[i2], 0);
                child.addChild(data, columnIndex);
                ++i2;
            }
            WmiInsertTableColumnCommand.selectModel(docView, placeholders[0]);
            doc.update(this.getResource(5));
        }
        return success;
    }
}

