/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.components.WmiTable;
import com.maplesoft.mathdoc.dialog.WmiMessageDialog;
import com.maplesoft.mathdoc.model.WmiMetadataContainer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;

class WmiMetatagAttributeTable
extends WmiTable {
    protected static final String RESOURCE_PATH = "com.maplesoft.mathdoc.controller.metadata.resources.Metadata";
    private static final int TABLE_COLUMNS = 2;
    private static final String[] COLUMN_HEADINGS = new String[]{"Attribute Name", "Value"};
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static final String NEW_ATTRIBUTE_NAME = "New Attribute";
    private WmiMetatagAttributeTableModel myModel = (WmiMetatagAttributeTableModel)this.getModel();
    private WmiMetadataContainer myData;
    private int nextUnamedCounter;
    private JButton addButton = null;
    private JButton deleteButton = null;

    public WmiMetatagAttributeTable(WmiMetadataContainer source, JButton add, JButton del) {
        super(new WmiMetatagAttributeTableModel());
        this.getColumnModel().getColumn(0).setCellEditor(new WmiMetatagAttributeNameCellEditor());
        this.setRowSelectionAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAddButton(add);
        this.setDeleteButton(del);
        this.nextUnamedCounter = 0;
        this.myData = source;
        this.reloadTable();
    }

    public WmiMetatagAttributeTable(WmiMetadataContainer source) {
        this(source, null, null);
    }

    public WmiMetatagAttributeTable() {
        this((WmiMetadataContainer)null, (JButton)null, (JButton)null);
    }

    public void setAddButton(JButton theButton) {
        if (theButton != null) {
            this.addButton = theButton;
            if (this.addButton.getActionListeners().length == 0) {
                this.addButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WmiMetatagAttributeTable.this.addAttribute();
                    }
                });
            }
        }
    }

    public void setDeleteButton(JButton theButton) {
        if (theButton != null) {
            this.deleteButton = theButton;
            if (this.deleteButton.getActionListeners().length == 0) {
                this.deleteButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WmiMetatagAttributeTable.this.deleteSelectedAttribute();
                    }
                });
            }
            this.deleteButton.setEnabled(false);
        }
    }

    public void addAttribute(String attrKey, String attrValue) {
        String key = WmiMetadataContainer.getMetadataSafeString(attrKey);
        String value = WmiMetadataContainer.getMetadataSafeString(attrValue);
        this.myModel.insertRow(this.myModel.getRowCount(), new Object[]{key, value});
    }

    public void addAttribute() {
        String name = NEW_ATTRIBUTE_NAME;
        boolean nameIsUnique = false;
        block0: while (!nameIsUnique) {
            name = this.nextUnamedCounter == 0 ? NEW_ATTRIBUTE_NAME : "New Attribute " + this.nextUnamedCounter;
            ++this.nextUnamedCounter;
            nameIsUnique = true;
            int i = 0;
            while (i < this.getRowCount()) {
                String rowKey = this.getValueAt(i, 0).toString();
                if (rowKey.equals(name)) {
                    nameIsUnique = false;
                    continue block0;
                }
                ++i;
            }
        }
        this.addAttribute(name, null);
    }

    public void deleteSelectedAttribute() {
        int rowToDelete = this.getSelectedRow();
        if (rowToDelete >= 0) {
            this.myModel.removeRow(rowToDelete);
            if (this.myModel.getRowCount() > 0) {
                int selectRow = rowToDelete < this.myModel.getRowCount() ? rowToDelete : this.myModel.getRowCount() - 1;
                this.setRowSelectionInterval(selectRow, selectRow);
            }
        }
    }

    public void reloadTable() {
        int rows = this.myModel.getRowCount();
        int r = 0;
        while (r < rows) {
            this.myModel.removeRow(0);
            ++r;
        }
        if (this.myData != null) {
            for (String key : new TreeSet(this.myData.getAttributeKeySet())) {
                String value = this.myData.getAttribute(key);
                this.addAttribute(key, value);
            }
        }
    }

    public void unloadTable() {
        if (this.myData != null) {
            this.myData.removeAllAttributes();
            int i = 0;
            while (i < this.getRowCount()) {
                String key = (String)this.getValueAt(i, 0);
                String val = (String)this.getValueAt(i, 1);
                this.myData.addAttribute(key, val);
                ++i;
            }
        }
    }

    public WmiMetadataContainer getMetadata() {
        return this.myData;
    }

    public void setMetadata(WmiMetadataContainer data) {
        if (this.myData != data) {
            this.myData = data;
            this.reloadTable();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int col = e.getColumn();
        int type = e.getType();
        if (type == 0 && row >= 0 && col >= 0) {
            String keyChanged = this.getValueAt(row, 0).toString();
            String newValue = this.getValueAt(row, 1).toString();
            if (keyChanged != null) {
                this.myData.changeAttribute(keyChanged, newValue);
            }
        }
        super.tableChanged(e);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(this.getSelectedRow() >= 0);
        }
        super.valueChanged(e);
    }

    private WmiMessageDialog getDuplicateAttributeWarning() {
        WmiMessageDialog attrNameWarning = new WmiMessageDialog(RESOURCE_PATH);
        attrNameWarning.setModal(true);
        attrNameWarning.setMessageType(102);
        attrNameWarning.setOptionType(0);
        attrNameWarning.setMessage("MTTE_Warn_Duplicate_Attr_Name");
        return attrNameWarning;
    }

    private WmiMessageDialog getEmptyAttributeNameWarning() {
        WmiMessageDialog warning = new WmiMessageDialog(RESOURCE_PATH);
        warning.setModal(true);
        warning.setMessageType(102);
        warning.setOptionType(0);
        warning.setMessage("MTTE_Warn_Empty_Attr_Name");
        return warning;
    }

    protected class WmiMetatagAttributeNameCellEditor
    extends DefaultCellEditor {
        public WmiMetatagAttributeNameCellEditor() {
            super(new JTextField());
        }

        @Override
        public boolean stopCellEditing() {
            boolean compStatus;
            String s = (String)this.getCellEditorValue();
            boolean isEmpty = s == null ? true : s.length() == 0;
            boolean isDuplicate = false;
            if (!isEmpty) {
                int i = 0;
                while (i < WmiMetatagAttributeTable.this.getRowCount()) {
                    String rowKey;
                    if (i != WmiMetatagAttributeTable.this.getSelectedRow() && (rowKey = WmiMetatagAttributeTable.this.getValueAt(i, 0).toString()).equals(s)) {
                        isDuplicate = true;
                    }
                    ++i;
                }
            }
            if (isEmpty) {
                WmiMetatagAttributeTable.this.getEmptyAttributeNameWarning().showDialog();
                compStatus = false;
            } else if (isDuplicate) {
                WmiMetatagAttributeTable.this.getDuplicateAttributeWarning().showDialog();
                compStatus = false;
            } else {
                compStatus = super.stopCellEditing();
            }
            return compStatus;
        }
    }

    protected static class WmiMetatagAttributeTableModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < 2) {
                return COLUMN_HEADINGS[columnIndex];
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }
}

