/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.components.WmiTable;
import com.maplesoft.mathdoc.controller.metadata.WmiMetadataManager;
import com.maplesoft.mathdoc.controller.metadata.WmiMetatagAttributeTable;
import com.maplesoft.mathdoc.dialog.WmiDialog;
import com.maplesoft.mathdoc.dialog.WmiDialogButton;
import com.maplesoft.mathdoc.model.WmiMetatagCategory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class WmiMetatagCategoriesDialog
extends WmiDialog
implements TableModelListener {
    protected static final String RESOURCE_PATH = "com.maplesoft.mathdoc.controller.metadata.resources.Metadata";
    protected static final int CATEGORY_COLUMN_WIDTH = 200;
    protected static final int CATEGORY_COLUMN_INDEX = 0;
    private WmiTable mtCategoryTable = null;
    private JScrollPane mtCategoryScrollPane = null;
    private WmiMetatagAttributeTable mtAttributesTable = null;
    private JScrollPane mtAttributesScrollPane = null;
    private WmiDialogButton mtAddCategoryBtn = null;
    private WmiDialogButton mtRemoveCategoryBtn = null;
    private WmiDialogButton mtAddAttributeBtn = null;
    private WmiDialogButton mtRemoveAttributeBtn = null;
    private WmiDialogButton mtCancelBtn = null;
    private WmiDialogButton mtOKBtn = null;
    private WmiMetadataManager dMgr = null;
    private HashMap categoryTableCopy = null;
    private boolean applyEdits = false;

    public WmiMetatagCategoriesDialog(JFrame frame, WmiMetadataManager mgr) {
        super(frame);
        this.dMgr = mgr;
        this.categoryTableCopy = this.dMgr.getCategoryListCopy();
        this.setTitle("MTCD_Title");
        this.createDialogComponents();
        this.layoutDialog();
    }

    public boolean editCategories() {
        this.show();
        return this.applyEdits;
    }

    @Override
    protected void addComponents() {
        Container pane = this.getContentPane();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.add(this.createCategoryPanel());
        pane.add(Box.createHorizontalStrut(10));
        pane.add(this.createAttributePanel());
    }

    @Override
    protected String getResourcePath() {
        return RESOURCE_PATH;
    }

    protected void createDialogComponents() {
        WmiCatListTableModel catModel = new WmiCatListTableModel();
        this.mtCategoryTable = new WmiTable(catModel);
        this.mtCategoryTable.getColumnModel().getColumn(0).setCellEditor(new WmiMetatagCategoryNameCellEditor());
        this.mtCategoryTable.getTableHeader().setReorderingAllowed(false);
        this.mtCategoryTable.setSelectionMode(0);
        this.mtCategoryTable.getSelectionModel().addListSelectionListener(new WmiCatListSelectionListener());
        Dimension dC = this.mtCategoryTable.getPreferredScrollableViewportSize();
        dC.width = 200;
        this.mtCategoryTable.setPreferredScrollableViewportSize(dC);
        this.mtCategoryScrollPane = new JScrollPane(this.mtCategoryTable, 22, 31);
        this.mtAttributesTable = new WmiMetatagAttributeTable();
        this.mtAttributesScrollPane = new JScrollPane(this.mtAttributesTable, 22, 31);
        Dimension dA = this.mtAttributesTable.getPreferredScrollableViewportSize();
        dA.height = dC.height + 20;
        this.mtAttributesTable.setPreferredScrollableViewportSize(dA);
        this.mtAddCategoryBtn = this.createButton("MTCD_AddCategory");
        this.mtAddCategoryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WmiMetatagCategoriesDialog.this.addCategoryAction();
            }
        });
        this.mtRemoveCategoryBtn = this.createButton("MTCD_RemoveCategory");
        this.mtRemoveCategoryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WmiMetatagCategoriesDialog.this.removeCategoryAction();
            }
        });
        this.mtAddAttributeBtn = this.createButton("MTCD_AddAttribute");
        this.mtAttributesTable.setAddButton(this.mtAddAttributeBtn);
        this.mtAddAttributeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WmiMetatagCategoriesDialog.this.stopCategoryEdit();
            }
        });
        this.mtRemoveAttributeBtn = this.createButton("MTCD_RemoveAttribute");
        this.mtAttributesTable.setDeleteButton(this.mtRemoveAttributeBtn);
        this.mtRemoveAttributeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WmiMetatagCategoriesDialog.this.stopCategoryEdit();
            }
        });
        this.mtCancelBtn = this.createCancelButton();
        this.mtOKBtn = this.createOKButton();
        for (WmiMetatagCategory cat : new TreeSet(this.categoryTableCopy.values())) {
            catModel.insertRow(catModel.getRowCount(), new Object[]{cat});
        }
        this.mtCategoryTable.setRowSelectionInterval(0, 0);
        this.mtCategoryTable.getModel().addTableModelListener(this);
    }

    private JPanel createCategoryPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.mtCategoryScrollPane.setAlignmentX(0.0f);
        this.mtCategoryScrollPane.setAlignmentY(0.0f);
        panel.add(this.mtCategoryScrollPane);
        panel.add(this.createCategoryEditButtonPanel());
        return panel;
    }

    private JPanel createAttributePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.mtAttributesScrollPane.setAlignmentX(0.0f);
        this.mtAttributesScrollPane.setAlignmentY(0.0f);
        panel.add(this.mtAttributesScrollPane);
        panel.add(this.createAttributeButtonPanel());
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.createCategoryEditButtonPanel());
        panel.add(Box.createHorizontalGlue());
        panel.add(this.createAttributeButtonPanel());
        panel.add(Box.createHorizontalGlue());
        panel.add(this.createOkCancelButtonPanel());
        return panel;
    }

    private JPanel createAttributeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel.add(this.createAttributeEditButtonPanel());
        panel.add(Box.createHorizontalGlue());
        panel.add(this.createOkCancelButtonPanel());
        panel.setAlignmentX(0.0f);
        panel.setAlignmentY(1.0f);
        return panel;
    }

    private JPanel createCategoryEditButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.mtAddCategoryBtn);
        panel.add(this.mtRemoveCategoryBtn);
        panel.setAlignmentX(0.0f);
        panel.setAlignmentY(1.0f);
        return panel;
    }

    private JPanel createAttributeEditButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.mtAddAttributeBtn);
        panel.add(this.mtRemoveAttributeBtn);
        return panel;
    }

    private JPanel createOkCancelButtonPanel() {
        JPanel panel = this.createDefaultButtonsPanel();
        return panel;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getSource() == this.mtCategoryTable.getModel()) {
            int row = e.getFirstRow();
            int col = e.getColumn();
            int type = e.getType();
            if (type == 0 && row >= 0 && col == 0) {
                String newName;
                WmiMetatagCategory cat;
                Object o = this.mtCategoryTable.getValueAt(row, col);
                WmiMetatagCategory wmiMetatagCategory = cat = o instanceof WmiMetatagCategory ? (WmiMetatagCategory)o : null;
                if (cat != null && (newName = this.mtCategoryTable.getValueAt(row, col).toString()) != null) {
                    cat.setName(newName);
                }
            }
        }
    }

    protected void addCategoryAction() {
        WmiMetatagCategory newCat = new WmiMetatagCategory();
        WmiCatListTableModel catModel = (WmiCatListTableModel)this.mtCategoryTable.getModel();
        catModel.insertRow(catModel.getRowCount(), new Object[]{newCat});
        int selRow = catModel.getRowCount() - 1;
        this.mtCategoryTable.setRowSelectionInterval(selRow, selRow);
        this.mtCategoryTable.requestFocus();
        this.mtCategoryTable.editCellAt(selRow, 0);
    }

    protected void removeCategoryAction() {
        this.stopCategoryEdit();
    }

    protected void newSelectionAction(int rowIndex) {
        this.mtAttributesTable.unloadTable();
        WmiMetatagCategory cat = (WmiMetatagCategory)this.mtCategoryTable.getValueAt(rowIndex, 0);
        if (cat != null) {
            this.mtAttributesTable.setMetadata(cat);
        }
    }

    protected void stopCategoryEdit() {
        TableCellEditor tce = this.mtCategoryTable.getCellEditor();
        if (tce != null) {
            tce.stopCellEditing();
        }
    }

    @Override
    protected void okAction() {
        this.stopCategoryEdit();
        this.mtAttributesTable.unloadTable();
        this.applyEdits = true;
        this.categoryTableCopy.clear();
        int i = 0;
        while (i < this.mtCategoryTable.getRowCount()) {
            Object o = this.mtCategoryTable.getValueAt(i, 0);
            WmiMetatagCategory cat = o instanceof WmiMetatagCategory ? (WmiMetatagCategory)o : null;
            this.categoryTableCopy.put(cat.getName(), cat);
            ++i;
        }
        this.dMgr.replaceCategoryList(this.categoryTableCopy);
        super.okAction();
    }

    @Override
    protected void cancelAction() {
        this.applyEdits = false;
        super.cancelAction();
    }

    protected class WmiCatListSelectionListener
    implements ListSelectionListener {
        protected WmiCatListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm;
            if (!e.getValueIsAdjusting() && !(lsm = (ListSelectionModel)e.getSource()).isSelectionEmpty()) {
                WmiMetatagCategoriesDialog.this.newSelectionAction(lsm.getMinSelectionIndex());
            }
        }
    }

    protected static class WmiCatListTableModel
    extends DefaultTableModel {
        private static final int TABLE_COLUMNS = 1;
        private static final String[] COLUMN_HEADINGS = new String[]{"Category"};

        protected WmiCatListTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < 1) {
                return COLUMN_HEADINGS[columnIndex];
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }

    protected class WmiMetatagCategoryNameCellEditor
    extends DefaultCellEditor {
        public JTextField fld;
        private WmiMetatagCategory activeEditValue;
        private JTable activeEditTable;
        private int activeEditRow;
        private int activeEditCol;

        public WmiMetatagCategoryNameCellEditor() {
            super(new JTextField());
            this.fld = null;
            this.activeEditValue = null;
            this.activeEditTable = null;
            this.fld = (JTextField)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof WmiMetatagCategory) {
                this.activeEditValue = (WmiMetatagCategory)value;
                this.activeEditTable = table;
                this.activeEditRow = row;
                this.activeEditCol = column;
            }
            this.fld.setText(value.toString());
            return this.fld;
        }

        @Override
        public boolean stopCellEditing() {
            boolean compStatus = super.stopCellEditing();
            if (compStatus) {
                Object done = this.getCellEditorValue();
                if (this.activeEditValue != null) {
                    this.activeEditValue.setName(done.toString());
                    this.activeEditTable.setValueAt(this.activeEditValue, this.activeEditRow, this.activeEditCol);
                }
                this.activeEditValue = null;
            }
            return compStatus;
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            this.activeEditValue = null;
        }
    }
}

