/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.metadata;

import com.maplesoft.mathdoc.controller.WmiMouseInputAdapter;
import com.maplesoft.mathdoc.controller.metadata.WmiMetadataManager;
import com.maplesoft.mathdoc.controller.metadata.WmiMetatagInfoPopup;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMetatag;
import com.maplesoft.mathdoc.model.WmiMetatagWrapperModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiMetatagWrapperView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Timer;

public class WmiMetatagMouseListener
extends WmiMouseInputAdapter
implements ActionListener {
    private static final int TIMER_FIRING_INTERVAL = 50;
    private static final long POPUP_DELAY_TIME = 750L;
    private Timer tagDisplayTimer = new Timer(50, this);
    private long popupTime;
    private WmiMetatagInfoPopup infoPanel = null;
    private int popupLocX;
    private int popupLocY;

    public WmiMetatagMouseListener() {
        this.tagDisplayTimer.setRepeats(true);
        this.tagDisplayTimer.stop();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        WmiMetatag tag = WmiMetatagMouseListener.getTagUnderMouse(e);
        if (tag != null) {
            WmiMetadataManager mgr;
            WmiMathDocumentView rootView = null;
            Object src = e.getSource();
            if (src instanceof WmiView) {
                rootView = ((WmiView)src).getDocumentView();
            }
            if (rootView != null && (mgr = rootView.getModel().getDocument().getMetadataManager()).getPopupVisibility()) {
                Object o = e.getSource();
                WmiPositionedView v = o instanceof WmiPositionedView ? (WmiPositionedView)o : null;
                Point p = null;
                if (v != null) {
                    p = WmiViewUtil.getAbsoluteOffset(v);
                }
                if (p != null) {
                    this.infoPanel = new WmiMetatagInfoPopup((Container)rootView, tag);
                    this.infoPanel.setLocation(p.x + e.getX() - v.getHorizontalOffset(), p.y + e.getY());
                    this.rescheduleTimer();
                }
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.infoPanel != null) {
            this.infoPanel.setVisible(false);
            this.infoPanel = null;
        }
        this.cancelTimer();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.cancelPopup();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.cancelPopup();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.rescheduleTimer();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.cancelPopup();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (System.currentTimeMillis() > this.popupTime) {
            this.tagDisplayTimer.stop();
            if (this.infoPanel != null) {
                this.infoPanel.setVisible(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleTimer() {
        Timer timer = this.tagDisplayTimer;
        synchronized (timer) {
            this.popupTime = System.currentTimeMillis() + 750L;
            if (!this.tagDisplayTimer.isRunning()) {
                this.tagDisplayTimer.start();
            }
        }
    }

    private void cancelPopup() {
        this.cancelTimer();
        if (this.infoPanel != null) {
            this.infoPanel.setVisibleImmediately(false);
            this.infoPanel = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimer() {
        Timer timer = this.tagDisplayTimer;
        synchronized (timer) {
            this.tagDisplayTimer.stop();
        }
    }

    protected static WmiMetatag getTagUnderMouse(MouseEvent e) {
        boolean locked;
        WmiMetadataManager mgr;
        WmiMetatagWrapperModel model;
        WmiMetatagWrapperView srcWrapper;
        WmiMetatag tag = null;
        Object src = e.getSource();
        WmiMetatagWrapperView wmiMetatagWrapperView = srcWrapper = src instanceof WmiMetatagWrapperView ? (WmiMetatagWrapperView)src : null;
        if (srcWrapper != null && (model = (WmiMetatagWrapperModel)srcWrapper.getModel()) != null && (mgr = model.getDocument().getMetadataManager()) != null && (locked = WmiModelLock.readLock(model.getDocument(), false))) {
            try {
                try {
                    tag = mgr.findMetatag(model.getMetatagId());
                }
                catch (WmiNoReadAccessException nrae) {
                    WmiErrorLog.log(nrae);
                    WmiModelLock.readUnlock(model.getDocument());
                }
            }
            finally {
                WmiModelLock.readUnlock(model.getDocument());
            }
        }
        return tag;
    }
}

