/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.navigation.WmiNavigationCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiViewNavigator;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionBuilder;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.event.ActionEvent;

public abstract class WmiSearchAndSelect
extends WmiNavigationCommand {
    protected WmiSearchAndSelect(String name) {
        super(name);
    }

    @Override
    public void doCommand(ActionEvent event) throws WmiNoReadAccessException {
        WmiView view = WmiSearchAndSelect.getView(event);
        if (view != null) {
            this.updatePosition(view);
        }
    }

    @Override
    public boolean updatePosition(WmiViewNavigator navigator) throws WmiNoReadAccessException {
        return this.updatePosition(navigator.getReferenceView());
    }

    public boolean updatePosition(WmiView view) throws WmiNoReadAccessException {
        boolean handled = false;
        WmiMathDocumentView docView = view.getDocumentView();
        WmiModel selection = null;
        WmiView currentView = null;
        int currentOffset = 0;
        WmiCaret caret = docView.getCaret();
        if (caret != null) {
            currentView = caret.getView();
            currentOffset = caret.getOffset();
        } else {
            currentView = view;
            currentOffset = 0;
        }
        try {
            try {
                WmiModelLock.readLock(docView.getModel(), true);
                int[] offsets = new int[2];
                selection = this.searchForSelection(currentView, currentOffset, offsets);
                if (selection instanceof WmiTextModel) {
                    WmiSearchAndSelect.selectTextModel(docView, (WmiTextModel)selection, offsets[0], offsets[1]);
                    handled = true;
                } else if (selection instanceof WmiCompositeModel) {
                    WmiSearchAndSelect.selectCompositeModel(docView, (WmiCompositeModel)selection);
                    handled = true;
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
                WmiModelLock.readUnlock(docView.getModel());
            }
        }
        finally {
            WmiModelLock.readUnlock(docView.getModel());
        }
        return handled;
    }

    protected abstract WmiModel searchForSelection(WmiView var1, int var2, int[] var3) throws WmiNoReadAccessException;

    public static void selectTextModel(WmiMathDocumentView docView, WmiTextModel selectedModel) throws WmiNoReadAccessException {
        WmiSearchAndSelect.selectTextModel(docView, selectedModel, 0, selectedModel.getText().length());
    }

    public static void selectCompositeModel(WmiMathDocumentView docView, WmiCompositeModel selectedModel) throws WmiNoReadAccessException {
        WmiCompositeView view = (WmiCompositeView)WmiViewUtil.modelToView(docView, selectedModel, 0);
        if (view == null) {
            return;
        }
        WmiViewFactory factory = docView.getViewFactory();
        WmiSelectionBuilder builder = factory.getSelectionBuilder();
        WmiSelection selection = builder.selectModel(view.getModel());
        docView.setSelection(selection);
        WmiView target = view;
        while (target instanceof WmiCompositeView) {
            WmiCompositeView comp = target;
            int size = comp.getChildCount();
            if (size <= 0) break;
            target = comp.getChild(size - 1);
        }
        WmiModelPosition endPosition = new WmiModelPosition(target.getModel(), -1);
        docView.updatePosition(endPosition, 1);
        docView.repaint();
    }

    public static void selectTextModel(WmiMathDocumentView docView, WmiTextModel selectedModel, int start, int length) throws WmiNoReadAccessException {
        WmiView startView = WmiViewUtil.modelToView(docView, selectedModel, start);
        WmiView endView = WmiViewUtil.modelToView(docView, selectedModel, start + length);
        if (startView != null && endView != null) {
            int offset;
            WmiViewPath startPath = new WmiViewPath(startView);
            WmiViewPath endPath = new WmiViewPath(endView);
            if (startView instanceof WmiTextView) {
                offset = start - ((WmiTextView)startView).getStartOffset();
                startPath.push(offset);
            }
            if (endView instanceof WmiTextView) {
                offset = start + length - ((WmiTextView)endView).getStartOffset();
                endPath.push(offset);
            }
            WmiViewFactory factory = docView.getViewFactory();
            WmiSelection selection = factory.createSelection(startPath, endPath);
            docView.setSelection(selection);
            try {
                WmiModelPosition position = endPath.createModelPosition(docView);
                docView.updatePosition(position, 1);
            }
            catch (WmiInvalidModelInitializationException imie) {
                WmiErrorLog.log(imie);
            }
            docView.repaint();
        }
    }

    @Override
    public boolean isSelectionCommand() {
        return true;
    }
}

