/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.controller.navigation.WmiNavigationCommand;
import com.maplesoft.mathdoc.controller.navigation.WmiViewNavigator;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.view.WmiContainerView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.util.StringTools;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;

public class WmiSelectWord
extends WmiNavigationCommand {
    public WmiSelectWord() {
        super("select.word");
    }

    @Override
    public void doCommand(ActionEvent event) throws WmiNoReadAccessException {
        WmiMathDocumentView docView;
        WmiPositionMarker marker;
        WmiView view;
        WmiView recordedView = view = WmiSelectWord.getView(event);
        int recordedOffset = -1;
        if (view != null && (marker = (docView = view.getDocumentView()).getPositionMarker()) != null) {
            int offset;
            recordedView = view = marker.getView();
            recordedOffset = offset = marker.getOffset();
            WmiViewNavigator navigator = new WmiViewNavigator(view, offset, this.isSelectionCommand());
            if (!this.updatePosition(navigator)) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean updatePosition(WmiViewNavigator navigator) throws WmiNoReadAccessException {
        WmiMathDocumentView docView;
        WmiViewFactory factory;
        int pos;
        boolean updateCompleted = true;
        WmiView refView = navigator.getReferenceView();
        WmiModel refModel = refView.getModel();
        WmiCompositeModel mathParent = WmiModelUtil.findAncestorOfTag(refModel, WmiModelTag.MATH);
        if (mathParent != null || refView instanceof WmiContainerView) {
            navigator.select(refView);
            return updateCompleted;
        }
        int start = -1;
        int end = -1;
        if (!(refView instanceof WmiTextView)) return false;
        String text = ((WmiTextView)refView).getText();
        start = pos = navigator.getViewOffset();
        end = pos;
        int limit = text.length();
        if (limit > 0) {
            while (start >= 0 && start < limit) {
                if (StringTools.isWordDelimiter(text.charAt(start))) {
                    ++start;
                    break;
                }
                --start;
            }
            if (start < 0) {
                start = 0;
            }
            if (start == limit) {
                start = pos - 1;
                while (start >= 0) {
                    if (StringTools.isWordDelimiter(text.charAt(start))) {
                        ++start;
                        break;
                    }
                    --start;
                }
                if (start < 0) {
                    start = 0;
                }
            }
            end = start;
            while (end < limit) {
                if (StringTools.isWordDelimiter(text.charAt(end))) break;
                ++end;
            }
        }
        WmiViewPath lowerBound = new WmiViewPath(refView);
        if (start >= 0) {
            lowerBound.push(start);
        }
        WmiViewPath upperBound = new WmiViewPath(refView);
        if (end >= 0) {
            upperBound.push(end);
        }
        WmiViewFactory wmiViewFactory = factory = (docView = refView.getDocumentView()) != null ? docView.getViewFactory() : null;
        if (factory != null) {
            factory.createSelection(lowerBound, upperBound);
        }
        WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
        try {
            WmiModelLock.readLock(docModel, true);
            WmiSelection selection = docView.getSelection();
            WmiHighlightPainter painter = selection.getSelectionHighlighter();
            if (painter == null) return updateCompleted;
            Rectangle bounds = painter.getBounds();
            if (bounds != null) {
                if (bounds.width > 1) return updateCompleted;
            }
            docView.setSelection(null);
            ((WmiPositionedView)refView).setPositionMarker(start);
            return updateCompleted;
        }
        finally {
            WmiModelLock.readUnlock(docModel);
        }
    }

    @Override
    public boolean isSelectionCommand() {
        return true;
    }
}

