/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.controller.navigation;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSelectionBuilder;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiViewNavigator {
    private WmiView reference;
    private int offset;
    private WmiRowView parentRowView = null;
    private WmiInlineView parentInlineView = null;
    private int rowIndex = -1;
    private int lineOffset = -1;
    private String text = null;
    private boolean selectionCommand;

    public WmiViewNavigator(WmiView reference, int offset, boolean selectionCommand) {
        this.reference = reference;
        this.offset = offset;
        this.selectionCommand = selectionCommand;
        this.extractParentRowView();
    }

    public void extractParentRowView() {
        WmiCompositeView parent = this.reference.getParentView();
        WmiView child = this.reference;
        while (parent != null) {
            if (parent instanceof WmiRowView) break;
            child = parent;
            parent = parent.getParentView();
        }
        if (parent != null) {
            this.parentRowView = (WmiRowView)parent;
            this.rowIndex = parent.indexOf(child);
            if (this.rowIndex >= 0) {
                WmiView view = parent.getChild(this.rowIndex);
                this.parentInlineView = view instanceof WmiInlineView ? (WmiInlineView)view : null;
            }
        } else {
            this.parentRowView = null;
            this.parentInlineView = null;
            this.rowIndex = -1;
        }
        this.text = null;
    }

    public void updatePosition(WmiView view, int newOffset) {
        this.reference = view;
        this.offset = newOffset;
    }

    public WmiView getReferenceView() {
        return this.reference;
    }

    public int getViewOffset() {
        return this.offset;
    }

    public WmiInlineView getLine() {
        return this.parentInlineView;
    }

    private void getText(WmiCompositeView composite, StringBuffer output) throws WmiNoReadAccessException {
        int i = 0;
        while (i < composite.getChildCount()) {
            WmiView child = composite.getChild(i);
            if (child instanceof WmiTextView) {
                WmiTextView textChild = (WmiTextView)child;
                output.append(textChild.getText());
            } else if (child instanceof WmiCompositeView) {
                this.getText((WmiCompositeView)child, output);
            }
            ++i;
        }
    }

    public String getText() throws WmiNoReadAccessException {
        if (this.parentInlineView == null) {
            this.text = null;
        } else if (this.text == null) {
            StringBuffer sb = new StringBuffer();
            int size = this.parentInlineView.getChildCount();
            int i = 0;
            while (i < size) {
                WmiView child = this.parentInlineView.getChild(i);
                if (child instanceof WmiTextView) {
                    WmiTextView textView = (WmiTextView)child;
                    sb.append(textView.getText());
                } else if (child instanceof WmiCompositeView) {
                    this.getText((WmiCompositeView)child, sb);
                } else {
                    sb.append("x");
                }
                ++i;
            }
            this.text = sb.toString();
        }
        if (this.text == null) {
            this.text = new String();
        }
        return this.text;
    }

    public int getOffset() throws WmiNoReadAccessException {
        if (this.parentInlineView == null) {
            this.lineOffset = -1;
        } else if (this.lineOffset < 0) {
            int childOffset;
            this.lineOffset = 0;
            WmiCompositeView parent = this.reference.getParentView();
            WmiView child = this.reference;
            while (parent != this.parentInlineView) {
                childOffset = this.getOffset(parent, child);
                if (childOffset >= 0) {
                    this.lineOffset += childOffset;
                    child = parent;
                    parent = child.getParentView();
                    continue;
                }
                this.lineOffset = -1;
                break;
            }
            if (this.lineOffset >= 0) {
                childOffset = this.getOffset(this.parentInlineView, child);
                if (childOffset >= 0) {
                    this.lineOffset += childOffset;
                    this.lineOffset += this.offset;
                } else {
                    this.lineOffset = -1;
                }
            }
        }
        return this.lineOffset;
    }

    public int getOffset(WmiCompositeView parent, WmiView child) throws WmiNoReadAccessException {
        int childOffset = -1;
        int index = parent.indexOf(child);
        if (index >= 0) {
            childOffset = 0;
            int i = 0;
            while (i < index) {
                child = parent.getChild(i);
                childOffset += WmiViewNavigator.getWidth(child);
                ++i;
            }
        }
        return childOffset;
    }

    public int getHorizontalOffset() {
        int pos = -1;
        WmiMathDocumentView docView = this.reference.getDocumentView();
        WmiPositionMarker marker = docView.getPositionMarker();
        if (marker != null) {
            Rectangle bounds = marker.getBounds();
            pos = bounds.x;
        }
        return pos;
    }

    public void setNearest(int pos) throws WmiNoReadAccessException {
        this.setNearest((WmiPositionedView)this.parentInlineView, pos);
    }

    public void setNearest(WmiPositionedView view, int pos) throws WmiNoReadAccessException {
        Point pt = WmiViewUtil.getAbsoluteOffset(view);
        if (pt.x > pos) {
            this.updatePosition(view, 0);
        } else if (pos > pt.x + view.getWidth()) {
            this.reference = view;
            this.offset = WmiViewNavigator.getWidth(view);
        } else if (WmiViewUtil.isTraversableView(view)) {
            pt.x = pos - pt.x;
            pt.y = view.getHeight() / 2;
            int coffset = ((WmiTraversableView)view).getOffset(pt);
            if (coffset >= 0) {
                this.reference = view;
                this.offset = coffset;
            }
        } else {
            this.reference = view;
            this.offset = 0;
        }
    }

    public boolean setNearest(WmiPositionedView view, Point pt) {
        boolean success = false;
        WmiViewPosition pos = WmiViewUtil.findNearestView(view, pt);
        if (pos != null) {
            this.reference = pos.getView();
            this.offset = pos.getOffset();
            success = true;
        }
        return success;
    }

    public static int getWidth(WmiView view) throws WmiNoReadAccessException {
        int width = 1;
        if (view instanceof WmiTextView) {
            width = ((WmiTextView)view).getEndOffset() - ((WmiTextView)view).getStartOffset();
        } else if (WmiViewUtil.isTraversableView(view)) {
            width = ((WmiTraversableView)view).getTraversableCount();
        }
        return width;
    }

    public void updateOffset(int pos) throws WmiNoReadAccessException {
        if (this.parentInlineView != null) {
            WmiView view = null;
            int size = this.parentInlineView.getChildCount();
            int nextOffset = 0;
            int lastOffset = 0;
            WmiView child = null;
            int i = 0;
            while (i < size) {
                child = this.parentInlineView.getChild(i);
                if ((nextOffset += WmiViewNavigator.getWidth(child)) >= pos) {
                    view = child;
                    break;
                }
                lastOffset = nextOffset;
                ++i;
            }
            if (view == null) {
                this.reference = child;
                this.offset = WmiViewNavigator.getWidth(this.reference);
            } else {
                this.reference = view;
                this.offset = pos - lastOffset;
            }
            this.lineOffset = pos;
        }
    }

    public boolean updateRow(int direction) throws WmiNoReadAccessException {
        boolean success = false;
        WmiView view = this.getReferenceView();
        WmiPositionedView nextView = null;
        while (view instanceof WmiPositionedView) {
            WmiTraversableView traverse;
            int type;
            WmiPositionedView posView = (WmiPositionedView)view;
            nextView = posView.getNextView(direction > 0 ? 1 : 0);
            if (nextView != null) break;
            if (!((view = view.getParentView()) instanceof WmiTraversableView) || ((type = (traverse = (WmiTraversableView)view).getTraversalType()) & 0x10) == 0) continue;
            return false;
        }
        WmiPositionedView referenceView = (WmiPositionedView)this.getReferenceView();
        Point pt = WmiViewUtil.getAbsoluteOffset(referenceView);
        int xOffset = pt.x = referenceView.getDocumentView().getLastHorizontalPosition();
        if (nextView != null) {
            Point base = WmiViewUtil.getAbsoluteOffset(nextView);
            int yOffset = direction > 0 ? -pt.y : nextView.getHeight() - pt.y;
            pt.translate(-base.x, yOffset);
        }
        while (nextView != null) {
            WmiTraversableView traversible;
            int type;
            if (WmiViewUtil.isTraversableView(nextView) && (type = (traversible = (WmiTraversableView)nextView).getTraversalType()) == 8) {
                this.setNearest(nextView, xOffset);
                this.extractParentRowView();
                success = true;
                break;
            }
            WmiPositionedView child = nextView.getViewForNavigation(direction > 0 ? -2 : -1, pt);
            if (child != null) {
                nextView = child;
                pt.translate(-child.getHorizontalOffset(), -child.getVerticalOffset());
                continue;
            }
            this.setNearest(nextView, xOffset);
            this.extractParentRowView();
            success = true;
            break;
        }
        return success;
    }

    public boolean updateLeftRightSelectionEndpoint(int direction) throws WmiNoReadAccessException {
        WmiView view = this.getReferenceView();
        WmiMathDocumentView docView = view.getDocumentView();
        WmiSelection selection = docView.getSelection();
        int[] myOffset = new int[1];
        boolean success = false;
        if (selection != null) {
            WmiViewPath path;
            WmiViewPath wmiViewPath = path = direction == -1 ? selection.getSelectionStartPath() : selection.getSelectionEndPath();
            if (path != null && WmiViewUtil.isTraversableView(view = path.extractView(docView, myOffset))) {
                myOffset[0] = myOffset[0] + direction;
                int limit = ((WmiTraversableView)view).getTraversableCount();
                if (myOffset[0] >= 0 && myOffset[0] < limit) {
                    this.updatePosition(view, myOffset[0]);
                    success = true;
                }
            }
        }
        return success;
    }

    public boolean updateLeftRight(int direction) throws WmiNoReadAccessException {
        int type;
        boolean success = false;
        WmiView view = this.getReferenceView();
        WmiPositionedView nextView = null;
        while (view instanceof WmiPositionedView) {
            WmiPositionedView posView = (WmiPositionedView)view;
            nextView = posView.getNextView(direction > 0 ? 3 : 2);
            if (nextView != null) break;
            if (!WmiViewUtil.isTraversableView(view = view.getParentView())) continue;
            WmiTraversableView traverse = (WmiTraversableView)view;
            type = traverse.getTraversalType();
            if ((type & 0x10) != 0) {
                return false;
            }
            if (direction == 1 && (type & 4) != 0) {
                this.updatePosition(view, -1);
                success = true;
                break;
            }
            if (direction != -1 || (type & 2) == 0) continue;
            this.updatePosition(view, 0);
            success = true;
            break;
        }
        if (nextView instanceof WmiResizableContainerView) {
            this.updatePosition(nextView, 0);
            success = true;
        }
        if (!success) {
            Point pt = new Point(0, 0);
            while (nextView instanceof WmiPositionedView) {
                WmiPositionedView child;
                WmiTraversableView traversible;
                if (WmiViewUtil.isTraversableView(nextView) && (type = (traversible = (WmiTraversableView)nextView).getTraversalType()) == 8) {
                    this.updatePosition(nextView, direction < 0 ? -1 : 0);
                    success = true;
                    break;
                }
                if (direction < 0) {
                    pt = new Point(nextView.getWidth(), nextView.getHeight());
                }
                if (WmiViewUtil.isTraversableView(child = nextView.getViewForNavigation(direction > 0 ? -4 : -3, pt))) {
                    WmiTraversableView traverse = (WmiTraversableView)child;
                    int type2 = traverse.getTraversalType();
                    if (direction == 1 && (type2 & 2) != 0) {
                        this.updatePosition(child, 0);
                        success = true;
                    } else if (direction == -1 && (type2 & 4) != 0) {
                        this.updatePosition(child, -1);
                        success = true;
                    } else if (type2 == 8) {
                        this.updatePosition(child, 0);
                        success = true;
                    }
                    if (success) break;
                }
                if (child != null) {
                    nextView = child;
                    continue;
                }
                Point base = WmiViewUtil.getAbsoluteOffset(nextView);
                this.setNearest(nextView, pt.x + base.x);
                success = true;
                break;
            }
        }
        return success;
    }

    public void moveToParagraphStart() {
        this.parentInlineView = (WmiInlineView)this.parentRowView.getChild(0);
        this.reference = this.parentInlineView.getChild(0);
        this.rowIndex = 0;
        this.offset = 0;
    }

    public void select(int from, int to) throws WmiNoReadAccessException {
        WmiViewFactory factory;
        this.updateOffset(from);
        WmiViewPath lowerBound = new WmiViewPath(this.reference);
        lowerBound.push(this.offset);
        this.updateOffset(to);
        WmiViewPath upperBound = new WmiViewPath(this.reference);
        upperBound.push(this.offset);
        WmiMathDocumentView docView = this.reference.getDocumentView();
        WmiViewFactory wmiViewFactory = factory = docView != null ? docView.getViewFactory() : null;
        if (factory != null) {
            factory.createSelection(lowerBound, upperBound);
        }
        WmiMathDocumentModel docModel = (WmiMathDocumentModel)docView.getModel();
        try {
            Rectangle bounds;
            WmiModelLock.readLock(docModel, true);
            WmiSelection selection = docView.getSelection();
            WmiHighlightPainter painter = selection.getSelectionHighlighter();
            if (painter != null && ((bounds = painter.getBounds()) == null || bounds.width <= 1)) {
                docView.setSelection(null);
                ((WmiPositionedView)this.reference).setPositionMarker(this.offset);
            }
        }
        finally {
            WmiModelLock.readUnlock(docModel);
        }
    }

    public void select(WmiView view) throws WmiNoReadAccessException {
        this.reference = view;
        this.offset = -1;
        WmiMathDocumentView docView = view.getDocumentView();
        WmiViewFactory factory = docView.getViewFactory();
        WmiSelectionBuilder builder = factory.getSelectionBuilder();
        builder.selectModel(view.getModel());
    }

    public void moveToParagraphEnd() throws WmiNoReadAccessException {
        this.rowIndex = this.parentRowView.getChildCount() - 1;
        WmiView inline = this.parentRowView.getChild(this.rowIndex);
        this.parentInlineView = inline instanceof WmiInlineView ? (WmiInlineView)inline : null;
        String rowText = this.getText();
        this.updateOffset(rowText.length());
    }

    public void updateMarker() {
        WmiMathDocumentView docView = this.reference.getDocumentView();
        if (this.selectionCommand) {
            this.updateSelection();
        } else if (docView != null && docView.getSelection() != null) {
            docView.setSelection(null);
            docView.repaint();
        }
        WmiPositionMarker marker = null;
        boolean resolved = false;
        while (!resolved) {
            WmiCompositeView comp;
            int size;
            if (WmiViewUtil.isTraversableView(this.reference)) {
                ((WmiPositionedView)this.reference).setPositionMarker(this.offset);
                resolved = true;
                continue;
            }
            if (this.reference instanceof WmiResizableContainerView) {
                ((WmiResizableContainerView)this.reference).setPositionMarker(this.offset);
                resolved = true;
                continue;
            }
            if (!(this.reference instanceof WmiCompositeView) || (size = (comp = (WmiCompositeView)this.reference).getChildCount()) <= 0) break;
            this.reference = this.offset == 0 ? comp.getChild(0) : comp.getChild(size - 1);
        }
        if (!resolved && this.reference instanceof WmiPositionedView) {
            ((WmiPositionedView)this.reference).setPositionMarker(this.offset);
            if (docView != null) {
                marker = docView.getPositionMarker();
            }
        }
        if (docView != null) {
            marker = docView.getPositionMarker();
        }
        if (marker != null && resolved) {
            marker.show();
            marker.scrollVisible();
        }
    }

    private void updateSelection() {
        WmiMathDocumentView docView = this.reference.getDocumentView();
        if (docView != null) {
            WmiViewFactory factory = docView.getViewFactory();
            factory.updateSelection(this.reference, this.offset);
        }
    }

    public boolean viewRepeatable() {
        boolean ret = false;
        if (this.reference != null && WmiViewUtil.isTraversableView(this.reference) && ((WmiTraversableView)this.reference).isRepeatable()) {
            ret = true;
        }
        return ret;
    }
}

