/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.dialog;

import com.maplesoft.mathdoc.dialog.WmiDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public abstract class WmiConfirmationDialog
extends WmiDialog {
    private static final String DO_NOT_ASK_KEY = "DO_NOT_ASK";
    private static final String RESET_INFO_KEY = "RESET_INFO";
    private static final int MIN_BUTTON_OFFSET = 48;
    private static final int SEPERATOR_OFFSET = 5;
    private JComponent seperatorReference;

    public WmiConfirmationDialog(JFrame frame) {
        super(frame);
    }

    public WmiConfirmationDialog(JDialog dialog) {
        super(dialog);
    }

    @Override
    protected void initializeDialog() {
        this.seperatorReference = null;
        super.initializeDialog();
        this.layoutDialog();
    }

    @Override
    protected void addComponents() {
        SpringLayout dlgLayout = new SpringLayout();
        this.getContentPane().setLayout(dlgLayout);
        JPanel content = this.createContentPanel();
        Dimension dContent = content.getPreferredSize();
        this.getContentPane().add(content);
        dlgLayout.putConstraint("North", (Component)content, 0, "North", (Component)this.getContentPane());
        dlgLayout.putConstraint("West", (Component)content, 0, "West", (Component)this.getContentPane());
        Dimension dCommon = this.createCommonComponentSet(this.getContentPane(), dlgLayout);
        int correction = 0;
        if (dCommon.width > dContent.width) {
            correction = dCommon.width - dContent.width;
        }
        dlgLayout.putConstraint("East", (Component)this.getContentPane(), correction, "East", (Component)content);
        dlgLayout.putConstraint("South", (Component)this.getContentPane(), dCommon.height + 32, "South", (Component)content);
    }

    protected abstract JPanel createContentPanel();

    protected Dimension createCommonComponentSet(Container cp, SpringLayout cpLayout) {
        JLabel rl = new JLabel(this.mapResourceKey(RESET_INFO_KEY));
        Font fnt = rl.getFont();
        Font newFont = fnt.deriveFont((float)((double)fnt.getSize() - 2.0));
        rl.setFont(newFont);
        cp.add(rl);
        cpLayout.putConstraint("West", (Component)rl, 25, "West", (Component)cp);
        cpLayout.putConstraint("South", (Component)rl, -5, "South", (Component)cp);
        JCheckBox cb = new JCheckBox();
        cb.setText(this.mapResourceKey(DO_NOT_ASK_KEY));
        cp.add(cb);
        cpLayout.putConstraint("West", (Component)cb, -25, "West", (Component)rl);
        cpLayout.putConstraint("South", (Component)cb, 3, "North", (Component)rl);
        this.seperatorReference = cb;
        JPanel btPanel = this.createDismissalButtons();
        cp.add(btPanel);
        cpLayout.putConstraint("East", (Component)btPanel, 0, "East", (Component)cp);
        cpLayout.putConstraint("North", (Component)btPanel, 0, "North", (Component)cb);
        cpLayout.layoutContainer(cp);
        Rectangle cbRect = cb.getBounds();
        Rectangle rlRect = rl.getBounds();
        Rectangle btRect = btPanel.getBounds();
        int width = rlRect.width + 48 + btRect.width;
        Rectangle boundingRect = new Rectangle();
        Rectangle.union(cbRect, rlRect, boundingRect);
        Rectangle.union(boundingRect, btRect, boundingRect);
        return new Dimension(width, boundingRect.height);
    }

    protected JPanel createDismissalButtons() {
        this.createOKButton();
        this.createCancelButton();
        JPanel panel = this.createDefaultButtonsPanel();
        return panel;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.seperatorReference != null) {
            Rectangle contentRect = g.getClipBounds();
            Insets ins = this.getRootPane().getInsets();
            Point panelLoc = this.seperatorReference.getLocation();
            int x1 = contentRect.x + ins.left;
            int x2 = contentRect.x + contentRect.width - ins.right;
            int y = panelLoc.y + contentRect.y + ins.top - 5;
            g.setColor(Color.GRAY);
            g.drawLine(x1, y, x2, y);
        }
    }
}

