/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.dialog;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.util.StringTools;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class WmiDialogButton
extends JButton {
    private static final String ACTION_NAME_CLICK = "click";

    public WmiDialogButton(String text) {
        String mnemonic = WmiComponentUtil.getMnemonic(text);
        String newLabel = StringTools.removeTilde(text);
        this.setText(newLabel);
        if (mnemonic != null && mnemonic.length() == 1) {
            this.setMnemonic((int)mnemonic.toUpperCase().charAt(0));
        }
    }

    public void activateHotKey(String hotKey) {
        if (hotKey != null) {
            AbstractAction click = new AbstractAction(ACTION_NAME_CLICK){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WmiDialogButton.this.doClick();
                }
            };
            ActionMap am = this.getActionMap();
            am.put(click.getValue("Name"), click);
            InputMap im = this.getInputMap(2);
            im.put(KeyStroke.getKeyStroke(hotKey), click.getValue("Name"));
            im = this.getInputMap(0);
            im.put(KeyStroke.getKeyStroke(hotKey), click.getValue("Name"));
        }
    }
}

