/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.dialog;

import com.maplesoft.mathdoc.dialog.WmiDialogButton;
import com.maplesoft.mathdoc.dialog.WmiDialogUpdateLink;
import com.maplesoft.mathdoc.dialog.WmiDialogUpdateListener;
import com.maplesoft.mathdoc.dialog.WmiMapleColorChooser;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;

public class WmiDialogColorSelectButton
extends WmiDialogButton
implements WmiDialogUpdateLink {
    private Color colour = Color.black;
    private ArrayList updateListeners = new ArrayList();

    public WmiDialogColorSelectButton(String text) {
        super(text);
        if (RuntimePlatform.isMac()) {
            this.putClientProperty("JButton.buttonType", "toolbar");
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColour = WmiDialogColorSelectButton.this.chooseColour();
                if (newColour != null) {
                    WmiDialogColorSelectButton.this.updateValue(newColour);
                }
            }
        });
    }

    private Color chooseColour() {
        return WmiMapleColorChooser.show(null, "Select Color", this.colour);
    }

    private void setColour(Color newColour) {
        this.colour = newColour;
        this.setIcon(new WmiColourIcon());
    }

    public Color getColour() {
        return this.colour;
    }

    @Override
    public void addDialogUpdateListener(WmiDialogUpdateListener listener) {
        if (listener != null) {
            this.updateListeners.add(listener);
        }
    }

    @Override
    public void updateValue(Object newValue) {
        int index;
        Color newColour = null;
        if (newValue instanceof Color) {
            newColour = (Color)newValue;
        } else if (newValue instanceof String && (index = WmiColorAttributeKey.createColorIndexFromRGBString((String)newValue)) > -1) {
            newColour = new Color(index);
        }
        if (newColour != null && !this.colour.equals(newValue)) {
            this.setColour(newColour);
            int u = 0;
            while (u < this.updateListeners.size()) {
                ((WmiDialogUpdateListener)this.updateListeners.get(u)).update();
                ++u;
            }
        }
    }

    private class WmiColourIcon
    implements Icon {
        private static final int ICON_HEIGHT = 5;
        private static final int ICON_WIDTH = 10;

        private WmiColourIcon() {
        }

        @Override
        public int getIconHeight() {
            if (RuntimePlatform.isMac()) {
                return 10;
            }
            return 5;
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(WmiDialogColorSelectButton.this.colour);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        }
    }
}

