/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.dialog;

import com.maplesoft.mathdoc.dialog.WmiDialogUpdateLink;
import com.maplesoft.util.RuntimePlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WmiDialogListBoxPanel
extends JPanel {
    private static final int PANEL_BORDER = 5;
    protected JList list;
    protected WmiDialogUpdateLink link = null;

    public WmiDialogListBoxPanel(int rows, Object[] items) {
        this(rows, items, null);
    }

    public WmiDialogListBoxPanel(int rows, Object[] items, WmiDialogUpdateLink link) {
        this.link = link;
        this.addComponents(rows, items);
    }

    protected void addComponents(int rows, Object[] items) {
        this.list = new JList<Object>(items);
        this.list.setVisibleRowCount(rows);
        JScrollPane scroller = new JScrollPane(this.list);
        if (RuntimePlatform.isMac()) {
            scroller.setVerticalScrollBarPolicy(22);
            BorderLayout layout = new BorderLayout();
            this.setLayout(layout);
            layout.setVgap(5);
            this.add((Component)scroller, "South");
        } else {
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.fill = 1;
            c.gridx = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            layout.setConstraints(scroller, c);
            this.add(scroller);
        }
        if (this.link != null) {
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!WmiDialogListBoxPanel.this.list.isSelectionEmpty()) {
                        WmiDialogListBoxPanel.this.link.updateValue(WmiDialogListBoxPanel.this.list.getSelectedValue());
                    }
                }
            });
        }
    }

    public void addListSelectionListener(ListSelectionListener listen) {
        this.list.addListSelectionListener(listen);
    }

    public void addListMouseListener(MouseListener listen) {
        this.list.addMouseListener(listen);
    }

    public Object[] getListData() {
        ListModel model = this.list.getModel();
        int size = model.getSize();
        Object[] data = new Object[size];
        int e = 0;
        while (e < size) {
            data[e] = model.getElementAt(e);
            ++e;
        }
        return data;
    }

    public Object getSelection() {
        return this.list.getSelectedValue();
    }

    public void setListData(Object[] items) {
        this.list.removeAll();
        if (items != null) {
            this.list.setListData(items);
        }
    }

    public void setListRenderer(ListCellRenderer renderer) {
        this.list.setCellRenderer(renderer);
    }

    public void setSelection(Object newValue, boolean scroll) {
        this.list.setSelectedValue(newValue, scroll);
    }
}

