/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.dialog;

import com.maplesoft.mathdoc.dialog.WmiDialog;
import com.maplesoft.mathdoc.io.WmiFileFilter;
import com.maplesoft.mathdoc.platform.mac.WmiMacNativeFileChooserSheet;
import com.maplesoft.mathdoc.platform.mac.WmiMacNativeUIProxy;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.util.MapleFileChooser;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public abstract class WmiFileChooser
extends MapleFileChooser {
    protected WmiResourcePackage chooserResources = null;

    protected WmiFileChooser(String key) {
        this.setDialogTitle(this.mapResourceKey(key));
    }

    public abstract String getResourcePath();

    public String mapResourceKey(String key) {
        String file;
        if (this.chooserResources == null && (file = this.getResourcePath()) != null) {
            this.chooserResources = WmiResourcePackage.getResourcePackage(file);
        }
        return WmiDialog.mapResource(this.chooserResources, key);
    }

    @Override
    public int showOpenDialog(Component parent) {
        int res = 0;
        res = this.shouldUseSheet(parent) ? this.showNativeFileChooserSheet(parent, 0) : super.showOpenDialog(parent);
        return res;
    }

    @Override
    public int showSaveDialog(Component parent) {
        int res = 0;
        res = this.shouldUseSheet(parent) ? this.showNativeFileChooserSheet(parent, 1) : super.showSaveDialog(parent);
        return res;
    }

    private boolean shouldUseSheet(Component parent) {
        boolean useSheet = false;
        if (RuntimePlatform.isMac() && WmiMacNativeUIProxy.isMacNativeUILibraryAvailable()) {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window ancestor = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
            Window active = kfm.getActiveWindow();
            useSheet = ancestor == active && !(active instanceof Dialog);
        }
        return useSheet;
    }

    private int showNativeFileChooserSheet(Component parent, int type) {
        WmiMacNativeFileChooserSheet sheet;
        int result = 1;
        String title = this.getDialogTitle();
        String approveButtonLabel = this.getApproveButtonText();
        FileFilter filter = this.getFileFilter();
        String[] allowedTypes = filter instanceof WmiFileFilter ? ((WmiFileFilter)filter).getAllowedTypes() : null;
        String startingDir = null;
        String startingFile = null;
        if (this.macSelectedFiles != null && this.macSelectedFiles[0] != null) {
            startingDir = this.macSelectedFiles[0].getAbsolutePath();
            startingFile = this.macSelectedFiles[0].getName();
        }
        Container ancestor = null;
        if (parent instanceof JComponent) {
            ancestor = ((JComponent)parent).getTopLevelAncestor();
        } else if (parent instanceof Window) {
            ancestor = (Container)parent;
        }
        if (ancestor != null && (result = (sheet = new WmiMacNativeFileChooserSheet(ancestor)).show(type, startingDir, startingFile, title, approveButtonLabel, allowedTypes)) == 0) {
            String[] filenames = sheet.getFilenames();
            this.macSelectedFiles = new File[filenames.length];
            int i = 0;
            while (i < this.macSelectedFiles.length) {
                this.macSelectedFiles[i] = new File(filenames[i]);
                ++i;
            }
            this.setCurrentDirectory(this.macSelectedFiles[0]);
            this.approveSelection();
        }
        return result;
    }
}

