/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.exception;

import com.maplesoft.util.WmiException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class WmiErrorLog
extends JDialog {
    private static final int DEFAULT_TIMESTAMP_WIDTH = 70;
    private static final int DEFAULT_ERROR_WIDTH = 500;
    private static final int DEFAULT_ROW_HEIGHT = 20;
    private static final int DEFAULT_ROW_COUNT = 5;
    public static final int POPUP_ON_ERROR = 0;
    public static final int DUMP_STACK_ON_ERROR = 1;
    public static final int CONSUME_ON_ERROR = 2;
    private static boolean displayError = false;
    private JScrollPane listPane;
    private JScrollPane exceptionPane;
    private JSplitPane splitter;
    private JTable exceptionList;
    private JTextArea exceptionDescription;
    private JPanel buttonPanel;
    private int nRows = 5;
    private static WmiErrorLog instance = null;
    private static ArrayList logData = new ArrayList();
    private static int verbosity = 0;

    private WmiErrorLog() {
        this.createTable();
        this.createDescriptionField();
        this.createButtonPanel();
        this.splitter = new JSplitPane(0, this.listPane, this.exceptionPane);
        this.getContentPane().add((Component)this.splitter, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.validate();
        this.pack();
        this.setModal(true);
    }

    private void createTable() {
        this.listPane = new JScrollPane();
        this.exceptionList = new WmiExceptionListTable();
        this.listPane.getViewport().add(this.exceptionList);
        this.exceptionList.setAutoCreateColumnsFromModel(false);
        this.exceptionList.getTableHeader().setReorderingAllowed(false);
        this.exceptionList.setAutoResizeMode(3);
        WmiErrorLogModel tableModel = new WmiErrorLogModel();
        this.exceptionList.setModel(tableModel);
        this.exceptionList.setRowHeight(20);
        TableColumn timestampColumn = new TableColumn(0);
        timestampColumn.setHeaderValue("timestamp");
        timestampColumn.setPreferredWidth(70);
        timestampColumn.setCellRenderer(new DefaultTableCellRenderer());
        TableColumn errorColumn = new TableColumn(1);
        errorColumn.setHeaderValue("error");
        errorColumn.setPreferredWidth(500);
        errorColumn.setCellRenderer(new DefaultTableCellRenderer());
        this.exceptionList.addColumn(timestampColumn);
        this.exceptionList.addColumn(errorColumn);
        this.listPane.setPreferredSize(new Dimension(570, 120));
        this.exceptionList.setSelectionMode(0);
    }

    private void createDescriptionField() {
        this.exceptionPane = new JScrollPane();
        this.exceptionDescription = new JTextArea(15, 60);
        this.exceptionPane.getViewport().add(this.exceptionDescription);
        this.exceptionDescription.setEditable(false);
    }

    private void createButtonPanel() {
        this.buttonPanel = new JPanel();
        JButton continueButton = new JButton("continue");
        JButton abortButton = new JButton("abort");
        continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WmiErrorLog.this.dispose();
            }
        });
        abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.buttonPanel.add(abortButton);
        this.buttonPanel.add(continueButton);
    }

    public static WmiErrorLog getInstance() {
        if (instance == null) {
            instance = new WmiErrorLog();
        }
        return instance;
    }

    public static void log(Exception e) {
        if (displayError) {
            if (verbosity == 0) {
                SwingUtilities.invokeLater(new WmiPendingLog(e));
            } else if (verbosity == 1) {
                e.printStackTrace();
            }
        } else {
            e.printStackTrace();
        }
    }

    private static void logPopup(Exception e) {
        WmiErrorLog log = WmiErrorLog.getInstance();
        WmiLogData entry = new WmiLogData(e);
        if (logData.size() >= log.nRows) {
            ++log.nRows;
        }
        logData.add(entry);
        int index = logData.size() - 1;
        log.exceptionList.changeSelection(index, 1, false, false);
        log.pack();
        log.show();
    }

    public static void setVerbosity(int mode) {
        verbosity = mode;
    }

    public static void enableLogging(boolean state) {
        displayError = state;
    }

    protected class WmiErrorLogModel
    extends AbstractTableModel {
        private static final int FIXED_COLUMN_COUNT = 2;

        protected WmiErrorLogModel() {
        }

        @Override
        public int getRowCount() {
            return WmiErrorLog.this.nRows;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WmiLogData entry;
            String data = null;
            if (rowIndex < logData.size() && (entry = (WmiLogData)logData.get(rowIndex)) != null) {
                switch (columnIndex) {
                    case 0: {
                        data = entry.time;
                        break;
                    }
                    case 1: {
                        data = entry.exception;
                        break;
                    }
                }
            }
            return data;
        }

        @Override
        public String getColumnName(int index) {
            return WmiErrorLog.this.exceptionList.getColumnName(index);
        }
    }

    protected class WmiExceptionListTable
    extends JTable {
        protected WmiExceptionListTable() {
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            WmiLogData entry;
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
            WmiLogData wmiLogData = entry = rowIndex < logData.size() ? (WmiLogData)logData.get(rowIndex) : null;
            if (entry != null) {
                WmiErrorLog.this.exceptionDescription.setText(entry.description);
            } else {
                WmiErrorLog.this.exceptionDescription.setText("");
            }
        }
    }

    protected static class WmiLogData {
        protected String time;
        protected String exception;
        protected String description;

        protected WmiLogData(Exception e) {
            String second;
            Calendar now = Calendar.getInstance();
            String hour = Integer.toString(now.get(10));
            String minute = Integer.toString(now.get(12));
            if (minute.length() < 2) {
                minute = "0" + minute;
            }
            if ((second = Integer.toString(now.get(13))).length() < 2) {
                second = "0" + second;
            }
            String cycle = now.get(9) == 0 ? " AM" : " PM";
            this.time = String.valueOf(hour) + ":" + minute + ":" + second + cycle;
            this.exception = e instanceof WmiException ? e.getMessage() : e.toString();
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            e.printStackTrace(printer);
            this.description = writer.toString();
        }
    }

    protected static class WmiPendingLog
    implements Runnable {
        private Exception e;

        protected WmiPendingLog(Exception e) {
            this.e = e;
        }

        @Override
        public void run() {
            WmiErrorLog.logPopup(this.e);
        }
    }
}

