/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import java.awt.Font;

public class WmiFontCache {
    private Font source;
    private Font[] cache;
    private int style;

    public WmiFontCache(Font font) {
        this(font, 0);
    }

    public WmiFontCache(Font font, int style) {
        this.source = font;
        this.style = style;
        this.cache = this.createFontCacheArray();
    }

    private int fontSizeToCacheIndex(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("font size cannot be less than 1");
        }
        int index = -1;
        if (8 <= size && size < 18) {
            index = size - 8;
        } else if ((size & 1) == 0) {
            index = (size + 2) / 2;
        }
        return index;
    }

    private Font[] createFontCacheArray() {
        return new Font[20];
    }

    public Font getFont(int style, int size) {
        int index;
        Font result = null;
        if (style == this.style && (index = this.fontSizeToCacheIndex(size)) >= 0 && index < this.cache.length && (result = this.cache[index]) == null) {
            this.cache[index] = result = this.source.deriveFont(style, size);
        }
        if (result == null) {
            result = this.source.deriveFont(style, size);
        }
        return result;
    }

    public Font getFont() {
        return this.source;
    }

    public int getStyle() {
        return this.style;
    }
}

