/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.WmiUnicodeMapper;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class WmiFontMetrics {
    public static final int LINE_LEADER = 0;
    public static final int LOWERCASE_HEIGHT = 1;
    public static final int MAXIMUM_WIDTH = 2;
    public static final int MAXIMUM_ASCENT = 3;
    public static final int MAXIMUM_DESCENT = 4;
    public static final int FONT_HEIGHT = 5;
    public static final int FONT_PROPERTY_COUNT = 6;
    public static final int CHARACTER_WIDTH = 0;
    public static final int CHARACTER_PREKERN = 1;
    public static final int CHARACTER_ADVANCE = 2;
    public static final int CHARACTER_POSTKERN = 3;
    public static final int CHARACTER_ASCENT = 4;
    public static final int CHARACTER_DESCENT = 5;
    public static final int CHARACTER_GLYPHCODE = 6;
    public static final int CHARACTER_PROPERTY_COUNT = 7;
    public static final int BASE_CHARSET_SIZE = 256;
    private static WmiFontMetricComposer metricComposer = RuntimePlatform.isMac() && !RuntimePlatform.isJava15() ? new WmiMacFontMetricComposer() : new WmiDefaultFontMetricComposer();
    public static final AffineTransform DEFAULT_TRANSFORM = new AffineTransform();
    public static final boolean USE_ANTIALIASING = RuntimePlatform.isMac() || RuntimeLocale.isJapanese();
    public static final boolean USE_FRACTIONAL_METRICS = false;
    public static final int ANTI_ALIASING_DEFAULT = 0;
    public static final int ANTI_ALIASING_ENABLED = 1;
    public static final int ANTI_ALIASING_DISABLED = 2;
    private static FontRenderContext DEFAULT_PRINT_FRC = new FontRenderContext(DEFAULT_TRANSFORM, USE_ANTIALIASING, true);
    private static FontRenderContext SCREEN_ANTI_ALIAS_DEFAULT_FRC = new FontRenderContext(DEFAULT_TRANSFORM, USE_ANTIALIASING, false);
    private static FontRenderContext SCREEN_ANTI_ALIAS_ENABLED_FRC = new FontRenderContext(DEFAULT_TRANSFORM, true, false);
    private static FontRenderContext SCREEN_ANTI_ALIAS_DISABLED_FRC = new FontRenderContext(DEFAULT_TRANSFORM, false, false);
    private static FontRenderContext DEFAULT_SCREEN_FRC = SCREEN_ANTI_ALIAS_DEFAULT_FRC;
    public static final float LOWERCASE_HEIGHT_RATIO = 0.65f;
    private static final float LINE_LEADER_RATIO = 0.1f;
    private WmiUnicodeMapper charsetScreenMetrics = new WmiUnicodeMapper();
    private WmiUnicodeMapper charsetPrintMetrics = new WmiUnicodeMapper();
    private float[] fontScreenMetrics = new float[6];
    private float[] fontPrintMetrics = new float[6];
    protected Font font;

    protected static WmiFontMetrics createFontMetrics(Font font) {
        WmiFontMetrics metrics = null;
        if (font != null) {
            metrics = font.getName().equals("MaplePi") ? new WmiMaplePiFontMetrics(font) : new WmiFontMetrics(font);
        }
        return metrics;
    }

    protected WmiFontMetrics(Font font) {
        this.font = font;
        this.fontScreenMetrics = metricComposer.buildFontMetrics(font, this, DEFAULT_SCREEN_FRC);
        this.fontPrintMetrics = metricComposer.buildFontMetrics(font, this, DEFAULT_PRINT_FRC);
    }

    public static void setFontAntiAliasing(int value) {
        switch (value) {
            case 0: {
                DEFAULT_SCREEN_FRC = SCREEN_ANTI_ALIAS_DEFAULT_FRC;
                break;
            }
            case 1: {
                DEFAULT_SCREEN_FRC = SCREEN_ANTI_ALIAS_ENABLED_FRC;
                break;
            }
            case 2: {
                DEFAULT_SCREEN_FRC = SCREEN_ANTI_ALIAS_DISABLED_FRC;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid value for anti-aliasing:" + value);
            }
        }
    }

    public static FontRenderContext getScreenContext() {
        return DEFAULT_SCREEN_FRC;
    }

    public static FontRenderContext getPrintContext() {
        return DEFAULT_PRINT_FRC;
    }

    public static boolean isScreenContext(FontRenderContext c) {
        return c == DEFAULT_SCREEN_FRC || c == SCREEN_ANTI_ALIAS_DEFAULT_FRC || c == SCREEN_ANTI_ALIAS_ENABLED_FRC || c == SCREEN_ANTI_ALIAS_DISABLED_FRC;
    }

    public int getFontProperty(int key) {
        return this.getFontProperty(key, false);
    }

    public int getFontProperty(int key, boolean printView) {
        int result = printView ? (int)this.fontPrintMetrics[key] : (int)this.fontScreenMetrics[key];
        return result;
    }

    public int getFontProperty(int key, FontRenderContext frc) {
        return this.getFontProperty(key, frc == DEFAULT_PRINT_FRC);
    }

    public float getPreciseFontProperty(int key, FontRenderContext frc) {
        float result = WmiFontMetrics.isScreenContext(frc) ? this.fontScreenMetrics[key] : this.fontPrintMetrics[key];
        return result;
    }

    public int getCharacterProperty(int key, char ch, boolean forPrint) {
        return this.getCharacterProperty(key, ch, forPrint ? DEFAULT_PRINT_FRC : DEFAULT_SCREEN_FRC);
    }

    public int getCharacterProperty(int key, char ch, FontRenderContext frc) {
        return (int)this.getPreciseCharacterProperty(key, ch, frc);
    }

    public float getPreciseCharacterProperty(int key, char ch, FontRenderContext frc) {
        float value = -1.0f;
        float[] metrics = this.getCharacterMetrics(ch, frc);
        if (metrics != null) {
            value = metrics[key];
        }
        return value;
    }

    protected float[] getCharacterMetrics(char ch, FontRenderContext frc) {
        float[] metrics;
        if (WmiFontMetrics.isScreenContext(frc)) {
            metrics = (float[])this.charsetScreenMetrics.get(ch);
            if (metrics == null) {
                metrics = this.buildCharacterMetric(ch, DEFAULT_SCREEN_FRC);
                this.charsetScreenMetrics.put(ch, metrics);
            }
        } else {
            metrics = (float[])this.charsetPrintMetrics.get(ch);
            if (metrics == null) {
                metrics = this.buildCharacterMetric(ch, DEFAULT_PRINT_FRC);
                this.charsetPrintMetrics.put(ch, metrics);
            }
        }
        return metrics;
    }

    public int getStringProperty(int key, String str, boolean forPrint) {
        return this.getStringProperty(key, str, forPrint ? DEFAULT_PRINT_FRC : DEFAULT_SCREEN_FRC);
    }

    public int getStringProperty(int key, String str, FontRenderContext frc) {
        int value = 0;
        int size = str.length();
        if (key == 2) {
            int i = 0;
            while (i < size) {
                value += this.getCharacterProperty(key, str.charAt(i), frc);
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                int chValue = this.getCharacterProperty(key, str.charAt(i), frc);
                value = Math.max(value, chValue);
                ++i;
            }
        }
        return value;
    }

    private float[] buildCharacterMetric(char ch, FontRenderContext frc) {
        return metricComposer.buildCharacterMetrics(this.font, ch, frc);
    }

    static class WmiDefaultFontMetricComposer
    implements WmiFontMetricComposer {
        WmiDefaultFontMetricComposer() {
        }

        @Override
        public float[] buildCharacterMetrics(Font font, char ch, FontRenderContext frc) {
            float[] metrics = new float[7];
            GlyphVector v = font.createGlyphVector(frc, Character.toString(ch));
            GlyphMetrics m = v.getGlyphMetrics(0);
            Rectangle2D mr = this.getBounds(v, m);
            this.computeMetrics(metrics, v, m, mr);
            return metrics;
        }

        protected void computeMetrics(float[] metrics, GlyphVector v, GlyphMetrics m, Rectangle2D mr) {
            metrics[2] = m.getAdvance();
            metrics[5] = (float)(mr.getMinY() + mr.getHeight());
            metrics[4] = (float)(-mr.getY());
            metrics[0] = (float)mr.getWidth();
            metrics[6] = v.getGlyphCode(0);
            float kern = (float)(-mr.getMinX());
            if (kern < 0.0f) {
                kern = 0.0f;
            }
            metrics[1] = kern;
            kern = (float)(mr.getWidth() + mr.getMinX() - (double)m.getAdvance());
            if (kern < 0.0f) {
                kern = 0.0f;
            }
            metrics[3] = kern;
        }

        protected Rectangle2D getBounds(GlyphVector v, GlyphMetrics m) {
            return m.getBounds2D();
        }

        @Override
        public float[] buildFontMetrics(Font font, WmiFontMetrics target, FontRenderContext frc) {
            float[] fontMetrics = new float[6];
            Rectangle2D maxBounds = font.getMaxCharBounds(frc);
            fontMetrics[3] = (float)(-maxBounds.getMinY());
            fontMetrics[2] = (float)maxBounds.getWidth();
            fontMetrics[4] = (float)(maxBounds.getHeight() + maxBounds.getMinY());
            fontMetrics[5] = (float)maxBounds.getHeight();
            fontMetrics[1] = 0.65f * fontMetrics[3];
            fontMetrics[0] = 0.1f * fontMetrics[3];
            return fontMetrics;
        }
    }

    public static interface WmiFontMetricComposer {
        public float[] buildCharacterMetrics(Font var1, char var2, FontRenderContext var3);

        public float[] buildFontMetrics(Font var1, WmiFontMetrics var2, FontRenderContext var3);
    }

    static class WmiMacFontMetricComposer
    extends WmiDefaultFontMetricComposer {
        WmiMacFontMetricComposer() {
        }

        protected Rectangle2D getPixelBounds(GlyphVector v, GlyphMetrics m) {
            return this.getBounds(v, m);
        }

        @Override
        protected void computeMetrics(float[] metrics, GlyphVector v, GlyphMetrics m, Rectangle2D mr) {
            super.computeMetrics(metrics, v, m, mr);
            metrics[4] = (float)(mr.getHeight() + mr.getMinY());
            metrics[5] = (float)(-mr.getMinY());
        }
    }

    private static class WmiMaplePiFontMetrics
    extends WmiFontMetrics {
        protected WmiMaplePiFontMetrics(Font font) {
            super(font);
        }

        @Override
        protected float[] getCharacterMetrics(char ch, FontRenderContext frc) {
            ch = WmiFontResolver.mapCharacterForFont(ch, this.font);
            return super.getCharacterMetrics(ch, frc);
        }
    }
}

