/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.font.FontIndexer;
import com.maplesoft.mathdoc.font.MaplePiIndexer;
import com.maplesoft.mathdoc.font.WmiFontCache;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.util.ResourceLoader;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringToolsJapanese;
import com.maplesoft.util.StringToolsSimplifiedChinese;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class WmiFontResolver {
    public static float DPI_SCALE_FACTOR = 1.0f;
    public static final String SYMBOL_FONT = "ESSTIXOne";
    public static final String ESSTIX_SYMBOL_FONT = "ESSTIXOne";
    public static final String FONT_RESOURCES_PACKAGE = "/com/maplesoft/mathdoc/font/resources/";
    private static final String MAPLE_PI_FONT_FILE_NAME = "MaplePi.ttf";
    public static final String FONT_KEY_POSTFIX = ".font";
    private static final String REQUIRED_SYMBOL_CHARACTERS = "\u23a7\u23ab\u23aa\u239b\u239e\u23a4";
    public static final String MAPLE_PI_FONT_NAME = "MaplePi";
    public static final String ESSTIX_ONE_FONT_FILE_NAME = "ESSTIX1_.TTF";
    private static FontIndexer maplePiIndexer = null;
    private static Font maplePiFont;
    private static Font esstixSourceFont;
    private static final int MAX_ZOOM_FACTOR = 1000;
    private static final int MAX_FONT_SIZE = 50;
    private static final Map fontName2IndexerClassName;
    private static final Map fontIndexerMap;
    protected static HashSet monospacedFamilySet;
    private static String[] indexedFonts;
    private static HashMap[][] fontCache;
    private static HashMap[][] printFontCache;
    private static HashMap fontFamilyCache;
    private static HashMap metricsCache;
    private static String[] availableFontFamilies;
    private static String defaultSerifFontFamily;
    private static Font[] asianFonts;
    private static String defaultAsianFontName;
    private static final String FONT_DEFAULT_MONOSPACED = "Lucida Sans Typewriter";
    private static final String FONT_DEFAULT_SANSSERIF = "Lucida Sans";
    private static final String FONT_DEFAULT_SERIF = "Lucida Bright";
    private static final String FONT_TIMES_NEW_ROMAN = "Times New Roman";
    private static final String FONT_DEFAULT_MONOSPACED_JAPANESE;
    private static final String FONT_DEFAULT_SANSSERIF_JAPANESE;
    private static final String FONT_DEFAULT_SERIF_JAPANESE;
    public static final String FONT_DEFAULT_JAPANESE;
    public static final String FONT_DEFAULT_KOREAN = "\ubc14\ud0d5\uccb4";
    public static final String FONT_DEFAULT_CHINESE_SIMPLIFIED = "SimSun";
    public static final String FONT_DEFAULT_CHINESE_TRADITIONAL = "MingLiU";
    private static final String[] FONT_FAMILIES_MONOSPACED;
    private static final String[] FONT_FAMILIES_SERIF;
    private static final String[] FONT_FAMILIES_SANSSERIF;
    private static Map fontFamilyMap;
    public static final int MAP_ALL_CHARS = -1;
    public static final int MAP_ONE_CHAR = 1;
    private static WmiFontCache esstixCache;
    private static WmiFontCache maplePiCache;

    static {
        fontName2IndexerClassName = new HashMap();
        fontIndexerMap = new HashMap();
        monospacedFamilySet = new HashSet();
        indexedFonts = new String[]{"ESSTIXOne", "ESSTIXTwo", "ESSTIXThree", "ESSTIXFour", "ESSTIXFive", "ESSTIXSix", "ESSTIXSeven", "ESSTIXEight", "ESSTIXNine", "ESSTIXTen", "ESSTIXEleven", "ESSTIXTwelve", "ESSTIXThirteen", "ESSTIXFourteen", "ESSTIXFifteen"};
        if (!GraphicsEnvironment.isHeadless()) {
            String prefix = "com.maplesoft.mathdoc.font.";
            String suffix = "Indexer";
            int i = 0;
            while (i < indexedFonts.length) {
                String camelCase = indexedFonts[i];
                if (camelCase.startsWith("ESSTIX")) {
                    camelCase = "Esstix" + camelCase.substring(6);
                }
                String cname = String.valueOf(prefix) + camelCase + suffix;
                String key = indexedFonts[i];
                fontName2IndexerClassName.put(key, cname);
                ++i;
            }
            try {
                esstixSourceFont = ResourceLoader.getResourceAsFont("/com/maplesoft/mathdoc/font/resources/ESSTIX1_.TTF");
                maplePiFont = ResourceLoader.getResourceAsFont("/com/maplesoft/mathdoc/font/resources/MaplePi.ttf");
            }
            catch (FontFormatException ffe) {
                WmiErrorLog.log(ffe);
            }
            catch (IOException ie) {
                WmiErrorLog.log(ie);
            }
            DPI_SCALE_FACTOR = (float)((double)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0);
        }
        fontCache = new HashMap[1000][];
        printFontCache = new HashMap[1000][];
        fontFamilyCache = new HashMap();
        metricsCache = new HashMap();
        availableFontFamilies = null;
        defaultSerifFontFamily = null;
        asianFonts = null;
        defaultAsianFontName = null;
        FONT_DEFAULT_MONOSPACED_JAPANESE = RuntimePlatform.isMac() ? "MS Gothic" : "MS Gothic";
        FONT_DEFAULT_SANSSERIF_JAPANESE = WmiFontResolver.getDefaultJapaneseSansSerifFont();
        FONT_DEFAULT_SERIF_JAPANESE = RuntimePlatform.isMac() ? "Hiragino Mincho Pro" : "MS Mincho";
        FONT_DEFAULT_JAPANESE = FONT_DEFAULT_SANSSERIF_JAPANESE;
        FONT_FAMILIES_MONOSPACED = new String[]{"American Typewriter", "Andale Mono", "Courier", "Courier New", FONT_DEFAULT_MONOSPACED, "MS Gothic", "Monaco", "Monospaced", FONT_DEFAULT_CHINESE_SIMPLIFIED};
        FONT_FAMILIES_SERIF = new String[]{"Apple Chancery", "AppleMyungjo", "Baskeville", "Baskeville Old Face", "Batang", "Bell MT", "Bernard MT Condensed", "BiauKai", "Book Antiqua", "Bookman Old Style", "Calisto MT", "Century", "Century Schoolbook", "Cochin", "Colonna MT", "Copper Black", "Curiz MT", "Didot", "Edwardian Script ITC", "Engravers MT", "Footlight MT Light", "Garamond", "Georgia", "Goudy Old Style", "Harrington", "Hoefler Text", "Imprint MT Shadow", "LiSong Pro", "Lucida Blackletter", FONT_DEFAULT_SERIF, "Lucida Fax", "MS Mincho", "MS PMincho", "Matura MT Script Capitals", "Mistral", "Modern No. 20", "Monotype Corsiva", "Onyx", "PMingLiU", "Papyrus", "Playbil", "Rockwell", "Rockwell Extra Bold", "STFangsong", "STKaiti", "STSong", "Serif", "Stencil", "Times", FONT_TIMES_NEW_ROMAN, "Wide Latin", "Zapfino"};
        FONT_FAMILIES_SANSSERIF = new String[]{"#GungSeo", "#HeadLineA", "#PCMyungjo", "#PilGi", "Abadi MT Condensed Extra Bold", "Abadi MT Condensed Light", "Apple Gothic", "Apple LiGothic", "Apple LiSung", "Arial", "Arial Black", "Arial Narrow", "Arial Rounded MT Bold", "Bauhaus 93", "Big Caslon", "Braggadocio", "Britannic Bold", "Brush Script MT", "Century Gothic", "Chalkboard", "Comic Sans MS", "Copperplate", "Copperplate Gothic Bold", "Copperplate Gothic Light", "Default", "Desdemona", "Dialog", "Dialog Input", "Eurostile", "Fang Song", "Futura", "Geneva", "Gill Sans", "Gill Sans Ultra Bold", "Gloucester MT Extra Condensed", "Gulim", "Haettenschweiler", "Hei", "Helvetica", "Helvetica Neue", "Herculanum", "Hiragino Kaku Gothic Pro", "Hiragino Kaku Gothic Std", "Hiragino Maru Gothic Pro", "Hiragino Mincho Pro", "Impact", "Kai", "Kino MT", "LiHei Pro", "Lucida Calligraphy", "Lucida Grande", "Lucida Handwriting", FONT_DEFAULT_SANSSERIF, "MS PGothic", "MT Extra", "Marker Felt", "News Gothic MT", "Optima", "Osaka", "Perpetua Titling MT", "STHeiti", "SansSerif", "Skia", "Song", "Tahoma", "Trebuchet MS", "Verdana"};
        fontFamilyMap = WmiFontResolver.buildFontFamilyMap();
        esstixCache = new WmiFontCache(esstixSourceFont);
        maplePiCache = new WmiFontCache(maplePiFont);
    }

    private static FontIndexer getFontIndexer(String fontName) {
        if (!fontIndexerMap.containsKey(fontName)) {
            String className = (String)fontName2IndexerClassName.get(fontName);
            if (className == null) {
                return null;
            }
            try {
                Class<?> encoderClass = Class.forName(className);
                fontIndexerMap.put(fontName, encoderClass.newInstance());
            }
            catch (Exception e) {
                WmiErrorLog.log(e);
            }
        }
        return (FontIndexer)fontIndexerMap.get(fontName);
    }

    private static String getDefaultJapaneseSansSerifFont() {
        String fontName = null;
        fontName = RuntimePlatform.isMac() ? (RuntimePlatform.getMacOSVersion() <= 3 ? "Osaka" : "Hiragino Kaku Gothic Pro") : "MS Gothic";
        return fontName;
    }

    private static Map buildFontFamilyMap() {
        HashMap<String, String> fontMap = new HashMap<String, String>();
        WmiFontResolver.addFontFamilyMappings(fontMap, FONT_FAMILIES_MONOSPACED, WmiFontResolver.getDefaultMonospacedFontFamily());
        WmiFontResolver.addFontFamilyMappings(fontMap, FONT_FAMILIES_SANSSERIF, WmiFontResolver.getDefaultSansSerifFontFamily());
        WmiFontResolver.addFontFamilyMappings(fontMap, FONT_FAMILIES_SERIF, WmiFontResolver.getDefaultSerifFontFamily());
        WmiFontResolver.getAvailableFontFamilyNames();
        int i = 0;
        while (i < availableFontFamilies.length) {
            fontMap.put(availableFontFamilies[i], availableFontFamilies[i]);
            ++i;
        }
        fontMap.put("ESSTIXOne", MAPLE_PI_FONT_NAME);
        if (RuntimeLocale.isJapanese()) {
            WmiFontResolver.addFontFamilyMappingIfNecessary(StringToolsJapanese.JAPANESE_FONT_NAMES, StringToolsJapanese.JAPANESE_FONT_ALTERNATE_NAMES, fontMap);
        } else {
            Locale locale = Locale.getDefault();
            if (RuntimeLocale.areLocalesEqual(locale, Locale.SIMPLIFIED_CHINESE)) {
                WmiFontResolver.addFontFamilyMappingIfNecessary(StringToolsSimplifiedChinese.SIMPLIFIED_CHINESE_FONT_NAMES, StringToolsSimplifiedChinese.SIMPLIFIED_CHINESE_FONT_ALTERNATE_NAMES, fontMap);
            }
        }
        return fontMap;
    }

    private static void addFontFamilyMappingIfNecessary(String[] preferred, String[] alternate, Map fontMap) {
        int i = 0;
        while (i < preferred.length) {
            String preferredFontName = preferred[i];
            String alternateFontName = alternate[i];
            int r = WmiFontResolver.binarySearch(availableFontFamilies, 0, availableFontFamilies.length, preferredFontName);
            if (r < 0) {
                fontMap.put(preferredFontName, alternateFontName);
            }
            ++i;
        }
    }

    private static void addFontFamilyMappings(Map fontMap, String[] families, String mapping) {
        int i = 0;
        while (i < families.length) {
            fontMap.put(families[i], mapping);
            ++i;
        }
    }

    private static String getFontFamily(Font font) {
        String fm = (String)fontFamilyCache.get(font);
        if (fm == null) {
            fm = font.getFamily();
            fontFamilyCache.put(font, fm);
        }
        return fm;
    }

    private WmiFontResolver() {
    }

    private static String[] getAllFontNames(GraphicsEnvironment env) {
        Font[] fonts = env.getAllFonts();
        String[] items = new String[fonts.length];
        int i = 0;
        while (i < fonts.length) {
            items[i] = fonts[i].getName();
            ++i;
        }
        return items;
    }

    private static String[] getFontFamilyNames(GraphicsEnvironment env) {
        String[] items = env.getAvailableFontFamilyNames();
        return items;
    }

    public static String[] getAvailableFontFamilyNames() {
        if (availableFontFamilies == null) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                availableFontFamilies = WmiFontResolver.getFontFamilyNames(env);
            }
            catch (NullPointerException e1) {
                try {
                    availableFontFamilies = WmiFontResolver.getAllFontNames(env);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (availableFontFamilies != null) {
                int position;
                int monoPosition = -1;
                if (RuntimeLocale.isJapanese() || RuntimeLocale.isKorean()) {
                    monoPosition = WmiFontResolver.binarySearch(availableFontFamilies, 0, availableFontFamilies.length, "Monospaced");
                }
                if ((position = Arrays.binarySearch(availableFontFamilies, "ESSTIXOne")) > -1) {
                    ArrayList<String> newItems = new ArrayList<String>(availableFontFamilies.length);
                    int i = 0;
                    while (i < availableFontFamilies.length) {
                        if (i != position && (monoPosition == -1 || i != monoPosition)) {
                            newItems.add(availableFontFamilies[i]);
                        }
                        ++i;
                    }
                    availableFontFamilies = newItems.toArray(new String[newItems.size()]);
                }
            }
        }
        return availableFontFamilies;
    }

    private static int binarySearch(String[] array, int start, int end, String key) {
        int i = -1;
        if (start < end) {
            i = (end - start) / 2 + start;
            int res = array[i].compareToIgnoreCase(key);
            if (res > 0) {
                i = WmiFontResolver.binarySearch(array, start, i, key);
            } else if (res < 0) {
                i = WmiFontResolver.binarySearch(array, i + 1, end, key);
            }
        }
        return i;
    }

    public static int canDisplayUpTo(Font font, String characters) {
        int renderLimit = -1;
        FontIndexer indexer = WmiFontResolver.getFontIndexer(WmiFontResolver.getFontFamily(font));
        if (indexer != null) {
            int size;
            renderLimit = size = characters.length();
            int i = 0;
            while (i < size) {
                char ch = indexer.get(characters.charAt(i));
                if (ch == '\u0000') {
                    renderLimit = i;
                    break;
                }
                ++i;
            }
        }
        if (renderLimit == -1) {
            int i = 0;
            while (i < characters.length()) {
                if (characters.charAt(i) != '\n' && !font.canDisplay(characters.charAt(i))) {
                    renderLimit = i;
                    break;
                }
                ++i;
            }
        }
        return renderLimit;
    }

    public static boolean isMonospacedFont(Font font) {
        String family = WmiFontResolver.getFontFamily(font);
        return monospacedFamilySet.contains(family.toLowerCase());
    }

    public static String findExistingFontFamily(String family) {
        if ((family = (String)fontFamilyMap.get(family)) == null) {
            family = WmiFontResolver.getDefaultSerifFontFamily();
        }
        return family;
    }

    public static String getDefaultMonospacedFontFamily() {
        String family = FONT_DEFAULT_MONOSPACED;
        if (RuntimeLocale.isJapanese()) {
            family = FONT_DEFAULT_MONOSPACED_JAPANESE;
        } else if (RuntimeLocale.isKorean()) {
            family = FONT_DEFAULT_KOREAN;
        }
        return family;
    }

    public static String getDefaultSerifFontFamily() {
        if (fontFamilyMap == null) {
            return FONT_DEFAULT_SERIF;
        }
        if (defaultSerifFontFamily == null) {
            defaultSerifFontFamily = fontFamilyMap == null || fontFamilyMap.get(FONT_TIMES_NEW_ROMAN) == null ? FONT_DEFAULT_SERIF : (String)fontFamilyMap.get(FONT_TIMES_NEW_ROMAN);
            if (RuntimeLocale.isJapanese()) {
                defaultSerifFontFamily = FONT_DEFAULT_SERIF_JAPANESE;
            } else if (RuntimeLocale.isKorean()) {
                defaultSerifFontFamily = FONT_DEFAULT_KOREAN;
            }
        }
        return defaultSerifFontFamily;
    }

    public static String getDefaultSansSerifFontFamily() {
        String family = FONT_DEFAULT_SANSSERIF;
        if (RuntimeLocale.isJapanese()) {
            family = FONT_DEFAULT_SANSSERIF_JAPANESE;
        } else if (RuntimeLocale.isKorean()) {
            family = FONT_DEFAULT_KOREAN;
        }
        return family;
    }

    public static String getDefaultStyleFontFamily() {
        String family = FONT_TIMES_NEW_ROMAN;
        Locale locale = RuntimeLocale.getEncodingLocale();
        if (RuntimeLocale.areLocalesEqual(locale, Locale.JAPANESE)) {
            family = FONT_DEFAULT_JAPANESE;
        }
        return family;
    }

    public static Font getFontForCharacter(String characters, Font font) {
        boolean found = false;
        Font rfont = font;
        if (characters != null && characters.length() > 0) {
            char targetChar = characters.charAt(0);
            if (WmiFontResolver.shouldUseMaplePi(targetChar)) {
                rfont = maplePiCache.getFont(font.getStyle(), font.getSize());
            } else {
                char ch;
                FontIndexer indexer = WmiFontResolver.getFontIndexer(WmiFontResolver.getFontFamily(font));
                if (indexer != null && (ch = indexer.get(targetChar)) != '\u0000') {
                    found = true;
                }
                if (!found) {
                    int style = font.getStyle();
                    int i = 0;
                    while (i < indexedFonts.length) {
                        indexer = WmiFontResolver.getFontIndexer(indexedFonts[i]);
                        char ch2 = indexer.get(targetChar, style);
                        if (ch2 != '\u0000') {
                            rfont = indexer.getFont(style, font.getSize());
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        return rfont;
    }

    public static char mapCharacterForFont(char character, Font font) {
        char ch;
        char nchar = character;
        FontIndexer indexer = WmiFontResolver.getIndexer(font, character);
        if (indexer != null && (ch = indexer.get(character)) != '\u0000') {
            nchar = ch;
        }
        return nchar;
    }

    public static String mapCharactersForFont(String characters, Font font, int limit) {
        FontIndexer indexer = WmiFontResolver.getIndexer(font, characters.charAt(0));
        if (indexer != null) {
            int size = characters.length();
            if (size > limit) {
                size = limit;
            }
            char[] data = new char[size];
            int i = 0;
            while (i < size) {
                char source = characters.charAt(i);
                data[i] = indexer.get(source);
                if (data[i] == '\u0000') {
                    data[i] = source;
                }
                ++i;
            }
            characters = new String(data);
        }
        return characters;
    }

    private static FontIndexer getIndexer(Font font, char c) {
        FontIndexer indexer = null;
        if (WmiFontResolver.shouldUseMaplePi(c)) {
            if (maplePiIndexer == null) {
                maplePiIndexer = new MaplePiIndexer();
            }
            indexer = maplePiIndexer;
        } else {
            indexer = WmiFontResolver.getFontIndexer(WmiFontResolver.getFontFamily(font));
        }
        return indexer;
    }

    private static boolean shouldUseMaplePi(char c) {
        return '\u0391' <= c && c <= '\u03c9' && c != '\u03c2' && !RuntimeLocale.isGreek();
    }

    public static Font getFont(WmiFontAttributeSet attributes, int zoomFactor, boolean forPrint) {
        HashMap[] cache = null;
        HashMap map = null;
        int size = attributes.getSize();
        if (zoomFactor < fontCache.length) {
            if (forPrint) {
                cache = printFontCache[zoomFactor];
                if (cache == null) {
                    WmiFontResolver.printFontCache[zoomFactor] = new HashMap[50];
                    cache = WmiFontResolver.printFontCache[zoomFactor];
                }
            } else {
                cache = fontCache[zoomFactor];
                if (cache == null) {
                    WmiFontResolver.fontCache[zoomFactor] = new HashMap[50];
                    cache = WmiFontResolver.fontCache[zoomFactor];
                }
            }
            if (size > 0 && size < 50 && (map = cache[size]) == null) {
                cache[size] = new HashMap();
            }
        }
        Font font = null;
        String family = attributes.getFamily();
        if (map != null) {
            font = (Font)map.get(attributes);
        }
        if (font == null) {
            int baseStyle = 0;
            if (attributes.hasStyle(1)) {
                baseStyle |= 1;
            }
            if (attributes.hasStyle(2)) {
                baseStyle |= 2;
            }
            int adjustedSize = zoomFactor * size / 100;
            if (family.equals(MAPLE_PI_FONT_NAME)) {
                font = maplePiFont.deriveFont((float)adjustedSize);
            }
            if (font == null) {
                font = new Font(WmiFontResolver.findExistingFontFamily(family), baseStyle, adjustedSize);
            }
            if (map != null) {
                map.put(attributes, font);
            }
        }
        return font;
    }

    public static Font getOperatorRendererFont(int size) {
        return esstixCache.getFont(0, size);
    }

    public static Font getFont(String name, int style, int size) {
        Font returnFont = null;
        returnFont = new Font(name, style, size);
        if (name.equals("ESSTIXOne") && (returnFont == null || returnFont.canDisplayUpTo(REQUIRED_SYMBOL_CHARACTERS) != -1)) {
            returnFont = maplePiFont.deriveFont(style, size);
        }
        if (name.equals("ESSTIXOne")) {
            returnFont = esstixSourceFont.deriveFont(style, size);
        }
        return returnFont;
    }

    public static WmiFontMetrics getFontMetrics(Font font) {
        WmiFontMetrics metrics = (WmiFontMetrics)metricsCache.get(font);
        if (metrics == null) {
            metrics = WmiFontMetrics.createFontMetrics(font);
            metricsCache.put(font, metrics);
        }
        return metrics;
    }

    public static String getCJKFontForText(String text) {
        if (asianFonts == null) {
            asianFonts = new Font[]{WmiFontResolver.createFont(FONT_DEFAULT_JAPANESE), WmiFontResolver.createFont(FONT_DEFAULT_KOREAN), WmiFontResolver.createFont(FONT_DEFAULT_CHINESE_SIMPLIFIED), WmiFontResolver.createFont(FONT_DEFAULT_CHINESE_TRADITIONAL)};
        }
        String fontName = null;
        int i = 0;
        while (i < asianFonts.length) {
            if (asianFonts[i].canDisplayUpTo(text) < 0) {
                fontName = asianFonts[i].getFamily();
                break;
            }
            ++i;
        }
        if (fontName == null) {
            if (defaultAsianFontName == null) {
                Locale l = Locale.getDefault();
                defaultAsianFontName = RuntimeLocale.areLocalesEqual(l, Locale.KOREAN) ? FONT_DEFAULT_KOREAN : (RuntimeLocale.areLocalesEqual(l, Locale.SIMPLIFIED_CHINESE) ? FONT_DEFAULT_CHINESE_SIMPLIFIED : (RuntimeLocale.areLocalesEqual(l, Locale.TRADITIONAL_CHINESE) ? FONT_DEFAULT_CHINESE_TRADITIONAL : FONT_DEFAULT_JAPANESE));
            }
            fontName = defaultAsianFontName;
        }
        return fontName;
    }

    private static Font createFont(String fontName) {
        String mappedFontName = (String)fontFamilyMap.get(fontName);
        if (mappedFontName == null) {
            mappedFontName = fontName;
        }
        return new Font(mappedFontName, 0, 12);
    }
}

