/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.font.tests;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WmiESSTIXFontTest
extends JPanel {
    public static final String ESSTIX_FONT_TEST_TITLE = "ESSTIX Font Tester";
    public static final String ESSTIX_FONT_PATH_PREFIX = "com.maplesoft.mathdoc.font.resources.ESSTIX";
    public static final String ESSTIX_FONT_PATH_END = ".TTF";
    public static final String ESSTIX_FONT_PATH_SINGLE_DIGIT_INFIX = "_";
    public static final String ESSTIX_1_FONTPATH = "ESSTIX1_.TTF";
    public static final int LAST_ESSTIX_FONT_INDEX = 17;
    private static final int YSTART_POS = 25;
    private Font[] esstixFonts = new Font[17];
    private int[] approxFontWidths = new int[17];
    private int[] approxFontHeights = new int[17];
    private boolean fontsFetched = false;
    private int totalHeight = 300000;

    public static void main(String[] argc) {
        WmiESSTIXFontTest instance = new WmiESSTIXFontTest();
        instance.run();
    }

    public void run() {
        JFrame frame = new JFrame(ESSTIX_FONT_TEST_TITLE);
        frame.getContentPane().setLayout(new BorderLayout());
        JScrollPane scroller = new JScrollPane(this);
        frame.getContentPane().add((Component)scroller, "Center");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setSize(640, 480);
        frame.setVisible(true);
    }

    private String getFontName(int index) {
        return ESSTIX_FONT_PATH_PREFIX + Integer.toString(index + 1) + (index + 1 < 10 ? ESSTIX_FONT_PATH_SINGLE_DIGIT_INFIX : "") + ESSTIX_FONT_PATH_END;
    }

    private void loadFont(Graphics g, int index) {
        try {
            String fontName = this.getFontName(index);
            InputStream fs = this.getClass().getResourceAsStream(fontName);
            this.esstixFonts[index] = Font.createFont(0, fs);
            this.esstixFonts[index] = this.esstixFonts[index].deriveFont(15.0f);
            FontMetrics fm = g.getFontMetrics(this.esstixFonts[index]);
            this.approxFontWidths[index] = fm.getMaxAdvance();
            this.approxFontHeights[index] = fm.getMaxAscent() + fm.getMaxDescent();
        }
        catch (FontFormatException ffe) {
            System.err.println("Problem with Font Format.");
            ffe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            System.err.println("Input Problem loading Font Resource.");
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    public void loadFonts(Graphics g) {
        int i = 0;
        while (i < 17) {
            this.loadFont(g, i);
            ++i;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.fontsFetched) {
            this.loadFonts(g);
            this.fontsFetched = true;
        }
        Font textFont = g.getFont();
        Graphics pg = g.create();
        pg.setColor(this.getBackground());
        pg.fillRect(0, 0, this.getWidth(), this.getHeight());
        pg.setColor(this.getForeground());
        int xpos = 0;
        int ypos = 25;
        int j = 0;
        while (j < 17) {
            xpos = 0;
            pg.setFont(textFont);
            pg.drawString(this.getFontName(j), xpos, ypos);
            ypos += this.approxFontHeights[j];
            pg.setFont(this.esstixFonts[j]);
            int i = 0;
            while (i < 256) {
                if (xpos >= this.getWidth() - 2 * this.approxFontWidths[j]) {
                    ypos += this.approxFontHeights[j];
                    xpos = 0;
                }
                pg.drawString(Character.toString((char)i), xpos += this.approxFontWidths[j], ypos);
                ++i;
            }
            ypos += 2 * this.approxFontHeights[j];
            ++j;
        }
        if (this.totalHeight == 0 || this.totalHeight >= 200000) {
            this.totalHeight = ypos += 2 * this.approxFontHeights[16];
        }
    }

    @Override
    public int getHeight() {
        return this.totalHeight;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public Dimension getSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

