/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.util.MapleFileChooser;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;

public class WmiFileFilter
extends FileFilter {
    private ArrayList extensionSet = new ArrayList();
    private StringBuffer fullDescription = new StringBuffer();

    public WmiFileFilter(String extension, String description) {
        this(new String[]{extension}, description);
    }

    public WmiFileFilter(String[] extensions, String description) {
        int e = 0;
        while (e < extensions.length) {
            this.extensionSet.add(extensions[e]);
            ++e;
        }
        this.setDescription(description);
    }

    public static String getFileExtension(File file) {
        String filename;
        int n;
        String extension = null;
        if (file != null && (n = (filename = file.getName()).lastIndexOf(46)) > 0 && n < filename.length() - 1) {
            extension = filename.substring(n + 1).toLowerCase();
        }
        return extension;
    }

    private void setDescription(String shortDescription) {
        if (shortDescription != null) {
            this.fullDescription.append(shortDescription);
        }
        this.fullDescription.append(" (");
        Iterator extIt = this.extensionSet.iterator();
        if (extIt.hasNext()) {
            this.fullDescription.append("." + (String)extIt.next());
            while (extIt.hasNext()) {
                this.fullDescription.append(", ." + (String)extIt.next());
            }
            this.fullDescription.append(")");
        }
    }

    @Override
    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            if (MapleFileChooser.isWindowsShortcut(file)) {
                return true;
            }
            String extension = WmiFileFilter.getFileExtension(file);
            if (extension != null && this.extensionSet.contains(extension)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.fullDescription.toString();
    }

    public String[] getAllowedTypes() {
        return this.extensionSet.toArray(new String[0]);
    }
}

