/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.util.Base64Encoder;
import com.maplesoft.util.WheelerCompression;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;

public class WmiIOUtilities {
    public static void decodeAndDecompressData(String data, ByteArrayOutputStream outStream) {
        StringBuffer contentBuf = new StringBuffer();
        Base64Encoder.decode(data, contentBuf);
        WheelerCompression.decompress(contentBuf.toString(), outStream);
    }

    public static void compressAndEncodeData(byte[] data, StringBuffer outBuf) {
        ByteArrayInputStream bstream = new ByteArrayInputStream(data);
        StringBuffer content = new StringBuffer();
        WheelerCompression.compress(bstream, content);
        Base64Encoder.slashify(content);
        Base64Encoder.encode(content.toString(), outBuf);
    }

    public static void encodeStringArray(String[] data, StringBuffer outBuf) {
        boolean prependSep = false;
        int i = 0;
        while (i < data.length) {
            if (prependSep) {
                outBuf.append(",");
            }
            outBuf.append(WmiIOUtilities.escapeSeperators(data[i]));
            prependSep = true;
            ++i;
        }
    }

    public static String[] decodeStringArray(String data) {
        ArrayList<String> output = new ArrayList<String>();
        StringBuffer currentString = new StringBuffer();
        boolean isEscaped = false;
        int i = 0;
        while (i < data.length()) {
            char c = data.charAt(i);
            if (isEscaped) {
                currentString.append(c);
                isEscaped = false;
            } else if (c == '\\') {
                isEscaped = true;
            } else if (c == ',') {
                output.add(currentString.toString());
                currentString.delete(0, currentString.length());
            } else {
                currentString.append(c);
            }
            ++i;
        }
        if (currentString.length() > 0) {
            output.add(currentString.toString());
        }
        int items = output.size();
        String[] stringArray = new String[items];
        int i2 = 0;
        while (i2 < items) {
            stringArray[i2] = output.get(i2).toString();
            ++i2;
        }
        return stringArray;
    }

    private static String escapeSeperators(String input) {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == ',' || c == '\\') {
                output.append('\\');
            }
            output.append(c);
            ++i;
        }
        return output.toString();
    }
}

