/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.util.GifExport;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class WmiImageUtilities {
    private WmiImageUtilities() {
    }

    public static BufferedImage convertToRGBImage(BufferedImage img) {
        BufferedImage im = img;
        if (img.getType() != 1) {
            im = new BufferedImage(img.getWidth(), img.getHeight(), 1);
            im.createGraphics().drawImage((Image)img, 0, 0, null);
        }
        return im;
    }

    public static boolean exportToFormat(BufferedImage img, OutputStream out, String fmt) {
        boolean success = false;
        if (RuntimePlatform.isMac()) {
            img = WmiImageUtilities.convertToRGBImage(img);
        }
        try {
            success = ImageIO.write((RenderedImage)img, fmt, out);
        }
        catch (IOException e) {
            WmiErrorLog.log(e);
        }
        return success;
    }

    public static boolean exportToFormat(BufferedImage img, String filename, String fmt) {
        boolean success = false;
        try {
            FileOutputStream fout = new FileOutputStream(filename);
            success = WmiImageUtilities.exportToFormat(img, fout, fmt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return success;
    }

    public static Rectangle exportToJPG(BufferedImage image, String filename) {
        boolean success;
        Rectangle size = null;
        if (image != null && (success = WmiImageUtilities.exportToFormat(image, filename, "JPEG"))) {
            size = new Rectangle(image.getWidth(), image.getHeight());
        }
        return size;
    }

    public static Rectangle exportToBMP(BufferedImage image, String filename) {
        boolean success;
        Rectangle size = null;
        if (image != null && (success = WmiImageUtilities.exportToFormat(image, filename, "BMP"))) {
            size = new Rectangle(image.getWidth(), image.getHeight());
        }
        return size;
    }

    public static boolean exportToGIF(BufferedImage[] images, int direction, int delay, OutputStream os) {
        return WmiImageUtilities.exportToGIF(images, direction, delay, os, 256);
    }

    public static boolean exportToGIF(BufferedImage[] images, int direction, int delay, OutputStream os, int colors) {
        if (images == null) {
            return false;
        }
        if (images.length < 1) {
            return false;
        }
        return WmiImageUtilities.exportToGIF(images, delay, os);
    }

    public static boolean exportToGIF(BufferedImage[] images, int delay, String filename) {
        FileOutputStream fos = null;
        boolean success = false;
        try {
            fos = new FileOutputStream(filename);
            success = WmiImageUtilities.exportToGIF(images, delay, fos);
        }
        catch (FileNotFoundException e) {
            WmiErrorLog.log(e);
        }
        return success;
    }

    public static boolean exportToGIF(BufferedImage[] images, int delay, OutputStream out) {
        return WmiImageUtilities.exportToGIF(images, delay, out, 256);
    }

    public static boolean exportToGIF(BufferedImage[] images, int delay, OutputStream out, int colors) {
        if (images == null || images.length < 1) {
            return false;
        }
        if (RuntimePlatform.isMac()) {
            int i = 0;
            while (i < images.length) {
                images[i] = WmiImageUtilities.convertToRGBImage(images[i]);
                ++i;
            }
        }
        GifExport gifx = new GifExport(images, delay, colors);
        return gifx.export(out);
    }

    public static boolean exportToGIF(BufferedImage image, OutputStream out) {
        return WmiImageUtilities.exportToGIF(new BufferedImage[]{image}, 0, out);
    }

    public static boolean exportToGIF(BufferedImage image, String filename) {
        return WmiImageUtilities.exportToGIF(new BufferedImage[]{image}, 0, filename);
    }

    public static BufferedImage createImageObject(int width, int height) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        int type = RuntimePlatform.isMac() ? 1 : 13;
        return new BufferedImage(width, height, type);
    }

    public static void renderImageToPostscript(RenderedImage image, String filename) {
    }

    public static void renderImageToPostscript(RenderedImage image, File file) {
    }

    public static BufferedImage createBufferedImage(byte[] data) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(data));
    }
}

