/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiStyleAttributeSet;
import java.io.IOException;
import java.util.Iterator;

public abstract class WmiStyleExporter {
    protected void processAttributes(WmiStyleAttributeSet attrSet, WmiExportFormatter formatter, String[] keys) throws IOException {
        int a = 0;
        while (a < keys.length) {
            String key = keys[a];
            Object value = attrSet.getAttribute(key);
            if (value != null) {
                formatter.writeAttribute(key, value);
            }
            ++a;
        }
    }

    public void writeStyles(WmiMathDocumentModel doc, WmiExportFormatter formatter) throws WmiNoReadAccessException, IOException {
        int[] families = this.getExportableStyleFamilies();
        this.beginStyleDefinitions(formatter);
        int i = 0;
        while (i < families.length) {
            Iterator it = doc.getStyleNames(families[i]);
            while (it.hasNext()) {
                String name = (String)it.next();
                WmiStyleAttributeSet style = doc.getStyle(families[i], name);
                if (style == null) continue;
                this.beginStyle(formatter, name, families[i]);
                String[] keys = this.getRelevantKeysForStyleFamily(families[i]);
                if (families[i] == 2) {
                    this.exportGraphicsStyles(doc, style, formatter);
                } else {
                    this.processAttributes(style, formatter, keys);
                }
                this.endStyle(formatter, name, families[i]);
            }
            ++i;
        }
        this.endStyleDefinitions(formatter);
    }

    protected abstract void exportGraphicsStyles(WmiMathDocumentModel var1, WmiStyleAttributeSet var2, WmiExportFormatter var3) throws WmiNoReadAccessException, IOException;

    protected abstract int[] getExportableStyleFamilies();

    protected abstract String[] getRelevantKeysForStyleFamily(int var1);

    protected abstract void beginStyleDefinitions(WmiExportFormatter var1) throws IOException;

    protected abstract void endStyleDefinitions(WmiExportFormatter var1) throws IOException;

    protected abstract void beginStyle(WmiExportFormatter var1, String var2, int var3) throws IOException;

    protected abstract void endStyle(WmiExportFormatter var1, String var2, int var3) throws IOException;
}

