/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.html;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.dialog.WmiMessageDialog;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportAction;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.WmiGenericGraphicExportAction;
import com.maplesoft.mathdoc.io.WmiGenericMathExportAction;
import com.maplesoft.mathdoc.io.WmiGenericTextExportAction;
import com.maplesoft.mathdoc.io.WmiGraphicExportFormatter;
import com.maplesoft.mathdoc.io.WmiImageUtilities;
import com.maplesoft.mathdoc.io.html.WmiHTMLDocumentElementExportAction;
import com.maplesoft.mathdoc.io.html.WmiHTMLParagraphExportAction;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLTransferExportAction;
import com.maplesoft.mathdoc.model.WmiAttributeComparator;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiGenericAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiMathExportParagraphView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.ShiftJISEncoder;
import com.maplesoft.util.encoder.UTF8Encoder;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Stack;
import javax.media.jai.JAI;

public class WmiHTMLFormatter
extends WmiExportFormatter
implements WmiGraphicExportFormatter {
    public static final int EXPRESSION_GIF = 0;
    public static final int EXPRESSION_MATHML_PRESENTATION = 1;
    public static final int EXPRESSION_MATHML_CONTENT = 2;
    public static final int EXPRESSION_DOTM = 3;
    private static final String HTML_LINE_BREAK = "\n<br>";
    public static final String DLG_RESOURCES = "com.maplesoft.mathdoc.io.html.resources.HTMLFormatter";
    public static final String EXISTING_MESSAGE_KEY = "REPLACE_EXISTING_FILE_MESSAGE";
    public static final String EXISTING_TITLE_KEY = "REPLACE_EXISTING_FILE_TITLE";
    private static final Object[] HTML_FONT_KEYS = new Object[]{"family", "size", "bold", "italic", "underline", "foreground", "background", "subscript", "superscript"};
    private static final String ESCAPE_SEQUENCE_START = "&#";
    private static final String ESCAPE_SEQUENCE_END = ";";
    protected static final int ALT_TEXT_MAX_LENGTH = 200;
    protected static final int IMAGE_GIF = 0;
    protected static final int IMAGE_JPG = 1;
    private static HashMap htmlActionTable = new HashMap();
    protected WmiMathDocumentView docView = null;
    protected Stack fontStack = new Stack();
    protected int gifCounter = 0;
    protected int jpgCounter = 0;
    protected static int maxWidth;
    private boolean replaceAllImages = false;
    private boolean exportCancelled = false;
    private String directory = null;
    private String imageDirectory = null;

    static {
        htmlActionTable.put(WmiModelTag.DOCUMENT, new WmiHTMLDocumentElementExportAction());
        htmlActionTable.put(WmiModelTag.MATH, new WmiGenericMathExportAction());
        htmlActionTable.put(WmiModelTag.PARAGRAPH, new WmiHTMLParagraphExportAction());
        htmlActionTable.put(WmiModelTag.PLOT, new WmiGenericGraphicExportAction());
        htmlActionTable.put(WmiModelTag.TEXT, new WmiGenericTextExportAction());
        maxWidth = -1;
    }

    public WmiHTMLFormatter(WmiMathDocumentView docView) {
        this.docView = docView;
    }

    public static void makeHTMLSafe(String data, StringBuffer result) {
        if (data != null && result != null) {
            int start = 0;
            StringBuffer safe = new StringBuffer(data);
            boolean lastWasBlank = false;
            while (start < safe.length()) {
                char ch = safe.charAt(start);
                switch (ch) {
                    case '\n': {
                        safe.deleteCharAt(start);
                        safe.insert(start, HTML_LINE_BREAK);
                        start += HTML_LINE_BREAK.length();
                        lastWasBlank = false;
                        break;
                    }
                    case '>': {
                        safe.deleteCharAt(start);
                        safe.insert(start, "&gt;");
                        start += "&gt;".length();
                        lastWasBlank = false;
                        break;
                    }
                    case '<': {
                        safe.deleteCharAt(start);
                        safe.insert(start, "&lt;");
                        start += "&lt;".length();
                        lastWasBlank = false;
                        break;
                    }
                    case ' ': {
                        if (lastWasBlank) {
                            safe.deleteCharAt(start);
                            safe.insert(start, "&nbsp;");
                            start += "&nbsp;".length();
                        } else {
                            ++start;
                        }
                        lastWasBlank = true;
                        break;
                    }
                    default: {
                        ++start;
                        lastWasBlank = false;
                    }
                }
            }
            result.append(safe.toString());
        }
    }

    public static int scaleFontSize(int ptSize) {
        int htmlSize = ptSize;
        htmlSize = ptSize < 4 ? 0 : (ptSize - 3) / 3;
        return htmlSize;
    }

    public static String translateAttribute(Object value) {
        String htmlValue = null;
        if (value instanceof Color) {
            htmlValue = "#" + WmiColorAttributeKey.createRGBHexStringFromColor((Color)value);
        } else if (value != null) {
            if (value.toString().matches(".[0-9]+,[0-9]+,[0-9]+.")) {
                String[] colors = value.toString().split("[^0-9]");
                int[] c = new int[]{Integer.parseInt(colors[1]), Integer.parseInt(colors[2]), Integer.parseInt(colors[3])};
                htmlValue = "#" + WmiColorAttributeKey.createRGBHexStringFromColorTriplet(c[0], c[1], c[2]);
            } else {
                htmlValue = value.toString();
            }
        }
        return htmlValue;
    }

    public static WmiGenericAttributeSet translateFontAttributes(WmiModel model) throws WmiNoReadAccessException {
        WmiAttributeSet font;
        WmiGenericAttributeSet extraFont = new WmiGenericAttributeSet();
        if (model != null && (font = model.getAttributesForRead()) != null) {
            int k = 0;
            while (k < HTML_FONT_KEYS.length) {
                Object key = HTML_FONT_KEYS[k];
                Object value = font.getAttribute(key);
                if (value != null) {
                    extraFont.addAttribute(key, value);
                }
                ++k;
            }
            Object opaque = font.getAttribute("opaque");
            if (opaque == null || !opaque.equals("true")) {
                extraFont.removeAttribute("background");
                WmiHTMLFormatter.transformColor("foreground", extraFont);
            } else {
                WmiHTMLFormatter.transformColor("foreground", extraFont);
                WmiHTMLFormatter.transformColor("background", extraFont);
            }
            Object sizeObj = extraFont.getAttribute("size");
            if (sizeObj instanceof Integer) {
                int sizeVal = WmiHTMLFormatter.scaleFontSize((Integer)sizeObj);
                extraFont.addAttribute("size", new Integer(sizeVal));
            }
        }
        return extraFont;
    }

    private static void transformColor(String key, WmiAttributeSet set) {
        Object value = set.getAttribute(key);
        if (value instanceof String) {
            int colorIndex = WmiColorAttributeKey.createColorIndexFromRGBString(value.toString());
            value = WmiColorAttributeKey.createRGBHexStringFromColorIndex(colorIndex);
            set.addAttribute(key, "#" + value);
        }
    }

    public static int getMaxWidth() {
        return maxWidth;
    }

    public static void setMaxWidth(int width) {
        maxWidth = width;
    }

    protected void closeCharacterTags(WmiGenericAttributeSet fontAttr) throws IOException {
        Object bold;
        Object italic;
        Object underline;
        Object superscript;
        Object subscript = fontAttr.getAttribute("subscript");
        if (subscript != null && subscript.equals("true")) {
            this.writeBinary("</sub>");
        }
        if ((superscript = fontAttr.getAttribute("superscript")) != null && superscript.equals("true")) {
            this.writeBinary("</sup>");
        }
        if ((underline = fontAttr.getAttribute("underline")) != null && underline.equals("true")) {
            this.writeBinary("</u>");
        }
        if ((italic = fontAttr.getAttribute("italic")) != null && italic.equals("true")) {
            this.writeBinary("</em>");
        }
        if ((bold = fontAttr.getAttribute("bold")) != null && bold.equals("true")) {
            this.writeBinary("</strong>");
        }
        Object family = fontAttr.getAttribute("family");
        Object size = fontAttr.getAttribute("size");
        Object foreground = fontAttr.getAttribute("foreground");
        Object background = fontAttr.getAttribute("background");
        if (family != null || size != null || foreground != null || background != null) {
            this.writeBinary("</font>");
        }
    }

    protected boolean createImageFile(BufferedImage image, String altText) throws WmiCancelException, IOException {
        File imgFile = this.getNextImageFile(0);
        boolean success = WmiImageUtilities.exportToGIF(image, imgFile.getAbsolutePath());
        if (!success) {
            imgFile = this.getNextImageFile(1);
            try {
                BufferedImage renderImage = image;
                JAI.create((String)"filestore", (RenderedImage)renderImage, (Object)imgFile.getPath(), (Object)"JPEG");
                success = true;
            }
            catch (Exception tE) {
                WmiErrorLog.log(tE);
            }
        }
        if (success) {
            success = this.writeImage(imgFile.getName(), altText, image.getWidth(), image.getHeight());
        }
        return success;
    }

    protected void formatLinebrokenMathView(WmiParagraphView paragraph, String altText) throws WmiCancelException, WmiNoReadAccessException, IOException {
        int numKids = paragraph.getChildCount();
        WmiRenderPath path = new WmiRenderPath(this.docView);
        if (numKids > 0) {
            int k = 0;
            do {
                WmiPositionedView childView = (WmiPositionedView)paragraph.getChild(k);
                path.push(-childView.getHorizontalOffset(), -childView.getVerticalOffset());
                this.exportPositionedView(childView, path, altText);
                path.pop();
                if (++k >= numKids) continue;
                this.writeBinary("<br>");
            } while (k < numKids);
        }
    }

    protected void exportPositionedView(WmiPositionedView view, WmiRenderPath path, String altText) throws WmiCancelException, WmiNoReadAccessException, IOException {
        if (view.getHeight() < view.getBaseline() * 2) {
            view.setHeight(view.getBaseline() * 2);
        } else {
            float baseline = view.getBaseline();
            float origHeight = view.getHeight();
            int newHeight = Math.round(2.0f * (origHeight - baseline));
            view.setHeight(newHeight);
            int offsetChange = Math.round((float)newHeight - origHeight);
            view.setVerticalOffset(view.getVerticalOffset() - offsetChange);
            path.translateOrigin(0, offsetChange);
        }
        view.markInvalid(1);
        view.layoutView();
        BufferedImage image = WmiViewUtil.drawViewToImage(view, path, WmiHTMLFormatter.getMaxWidth());
        this.createImageFile(image, altText);
    }

    protected String getAltText(WmiMathModel math) throws WmiNoReadAccessException {
        StringBuffer output = new StringBuffer();
        try {
            Dag dag = math.toDag();
            output.append(DagBuilder.lPrint(dag));
            if (output.length() > 200) {
                output.setLength(200);
                output.append("...");
            }
        }
        catch (NullPointerException nE) {
            WmiErrorLog.log(nE);
        }
        return output.toString();
    }

    protected String getDirectory() {
        if (this.directory == null) {
            File file = new File(this.getFilename());
            this.directory = file.getAbsolutePath();
            int lastSep = this.directory.lastIndexOf(File.separatorChar);
            if (lastSep > -1) {
                this.directory = this.directory.substring(0, lastSep);
            }
        }
        return this.directory;
    }

    protected WmiExportAction getFormatAction(WmiModelTag tag) {
        return (WmiExportAction)htmlActionTable.get(tag);
    }

    protected String getImageDirectory() {
        return "";
    }

    protected String getNextImageFilename(int type) {
        String shortName = this.getShortFilename();
        int nExt = shortName.lastIndexOf(".");
        if (nExt < 1) {
            nExt = shortName.length();
        }
        StringBuffer imgFilename = null;
        imgFilename = new StringBuffer(shortName.substring(0, nExt));
        if (type == 0) {
            ++this.gifCounter;
            imgFilename.append("_" + this.gifCounter);
            imgFilename.append(".gif");
        } else {
            ++this.jpgCounter;
            imgFilename.append("_" + this.jpgCounter);
            imgFilename.append(".jpg");
        }
        return imgFilename.toString();
    }

    protected File getNextImageFile(int type) throws WmiCancelException {
        if (this.imageDirectory == null) {
            this.imageDirectory = String.valueOf(this.getDirectory()) + File.separatorChar + this.getImageDirectory();
        }
        File dir = new File(this.imageDirectory);
        dir.mkdirs();
        File newFile = null;
        boolean acceptFilename = this.replaceAllImages;
        do {
            String filename;
            if (!(newFile = new File(filename = String.valueOf(this.imageDirectory) + this.getNextImageFilename(type))).exists() || this.replaceAllImages) continue;
            WmiMessageDialog dialog = new WmiMessageDialog(DLG_RESOURCES);
            dialog.setOptionType(4);
            dialog.setMessage(EXISTING_MESSAGE_KEY, filename);
            dialog.setTitle(EXISTING_TITLE_KEY);
            int choice = dialog.showDialog();
            switch (choice) {
                case 2: {
                    acceptFilename = true;
                    break;
                }
                case 4: {
                    acceptFilename = true;
                    this.replaceAllImages = true;
                    break;
                }
                case 3: {
                    acceptFilename = false;
                    break;
                }
                case 1: {
                    throw new WmiCancelException();
                }
            }
        } while (!acceptFilename && newFile.exists());
        return newFile;
    }

    protected String getShortFilename() {
        File temp = new File(this.getFilename());
        return temp.getName();
    }

    protected void nestFontTags(WmiTextModel text) throws WmiNoReadAccessException, IOException {
        WmiGenericAttributeSet extraFont = WmiHTMLFormatter.translateFontAttributes(text);
        WmiAttributeSet parentFont = null;
        WmiGenericAttributeSet stackAttributes = new WmiGenericAttributeSet();
        while (!this.fontStack.empty()) {
            if (WmiAttributeComparator.subtract((WmiAttributeSet)this.fontStack.peek(), extraFont) == null) {
                parentFont = (WmiAttributeSet)this.fontStack.peek();
                stackAttributes.addAttributes(parentFont);
                break;
            }
            this.endFontDefinition();
        }
        extraFont = WmiAttributeComparator.subtract(extraFont, parentFont);
        if (extraFont != null && extraFont.getAttributeCount() > 0) {
            stackAttributes.addAttributes(extraFont);
            this.fontStack.add(stackAttributes);
            this.openCharacterTags(extraFont);
        }
        if (text.getLength() > 0) {
            this.writeText(text.getText());
        }
    }

    protected void openCharacterTags(WmiGenericAttributeSet fontAttr) throws IOException {
        Object subscript;
        Object superscript;
        Object underline;
        Object italic;
        Object bold;
        Object family = fontAttr.getAttribute("family");
        Object size = fontAttr.getAttribute("size");
        Object foreground = fontAttr.getAttribute("foreground");
        Object background = fontAttr.getAttribute("background");
        if (family != null || size != null || foreground != null || background != null) {
            this.writeBinary("<font");
            if (foreground != null) {
                this.writeAttribute("color", foreground);
            }
            if (size != null) {
                this.writeAttribute("size", size);
            }
            if (family != null) {
                if (family.equals("Monospaced")) {
                    family = "monospace";
                }
                this.writeAttribute("face", family);
            }
            if (background != null) {
                String value = "background-color: " + background.toString();
                this.writeAttribute("style", value);
            }
            this.writeBinary(">");
        }
        if ((bold = fontAttr.getAttribute("bold")) != null && bold.equals("true")) {
            this.writeBinary("<strong>");
        }
        if ((italic = fontAttr.getAttribute("italic")) != null && italic.equals("true")) {
            this.writeBinary("<em>");
        }
        if ((underline = fontAttr.getAttribute("underline")) != null && underline.equals("true")) {
            this.writeBinary("<u>");
        }
        if ((superscript = fontAttr.getAttribute("superscript")) != null && superscript.equals("true")) {
            this.writeBinary("<sup>");
        }
        if ((subscript = fontAttr.getAttribute("subscript")) != null && subscript.equals("true")) {
            this.writeBinary("<sub>");
        }
    }

    protected void postFormat() throws IOException {
        this.writeFooterInfo();
    }

    protected void preFormat() throws IOException, WmiNoReadAccessException {
        this.writeHeaderInfo();
    }

    public void processModel(WmiModel model) throws IOException, WmiNoReadAccessException {
        if (model == null || !model.isVisible() && this.ignoreHiddenModels()) {
            return;
        }
        WmiModelTag tag = model.getTag();
        if (tag != null) {
            boolean processChildren = false;
            WmiExportAction action = model instanceof WmiTransferModel ? new WmiMathMLTransferExportAction() : this.getFormatAction(tag);
            if (action != null) {
                action.openModel(this, model);
                processChildren = action.processChildModels();
            }
            if (processChildren && !this.exportCancelled && model instanceof WmiCompositeModel) {
                WmiCompositeModel parent = (WmiCompositeModel)model;
                int c = 0;
                while (c < parent.getChildCount()) {
                    this.processModel(parent.getChild(c));
                    ++c;
                }
            }
            if (action != null) {
                action.closeModel(this, model);
            }
        }
    }

    protected void writeFooterInfo() throws IOException {
        this.writeBinary("\n</html>");
    }

    protected void writeHeaderInfo() throws IOException {
        this.writeBinary("<html>\n<head>\n");
        this.writeBinary("<meta http-equiv=\"content-type\" content=\"text/html; charset=");
        AbstractStringEncoder encoder = this.getEncoder();
        if (encoder instanceof UTF8Encoder) {
            this.writeBinary("utf-8");
        } else if (encoder instanceof ShiftJISEncoder) {
            this.writeBinary("Shift_JIS");
        } else {
            this.writeBinary(encoder.getName());
        }
        this.writeBinary("\">\n");
        this.writeBinary("<title>");
        File temp = new File(this.getFilename());
        this.writeText(temp.getName());
        this.writeBinary("</title>\n");
        this.writeBinary("<!-- Created by Maple 10");
        String platform = System.getProperty("os.name");
        if (platform != null) {
            this.writeBinary(", " + platform);
        }
        this.writeBinary(" -->\n");
        this.writeBinary("</head>\n");
    }

    protected boolean writeImage(String imgFile, String altText, int width, int height) throws IOException {
        boolean success = true;
        this.writeBinary("<img src=\"");
        int max = WmiHTMLFormatter.getMaxWidth();
        if (width > max) {
            height = (int)Math.round((double)height / ((double)width * 1.0) * (double)max);
            width = max;
        }
        String subDirectory = this.getImageDirectory();
        String directory = String.valueOf(this.getDirectory()) + subDirectory;
        File dir = new File(directory);
        dir.mkdirs();
        if (altText.startsWith("\"")) {
            altText = altText.substring(1);
        }
        if (altText.endsWith("\"")) {
            altText = altText.substring(0, altText.length() - 1);
        }
        this.writeText(String.valueOf(subDirectory) + imgFile);
        this.writeBinary("\"");
        this.writeBinary(" width=\"" + width + "\"");
        this.writeBinary(" height=\"" + height + "\"");
        this.writeBinary(" alt=\"" + altText + "\"");
        this.writeBinary(" align=\"center\" border=\"0\">");
        return success;
    }

    protected void cancelExport() {
        this.exportCancelled = true;
    }

    public void clearFontStack() throws IOException {
        while (!this.fontStack.empty()) {
            this.endFontDefinition();
        }
        this.fontStack.clear();
    }

    public void endFontDefinition() throws IOException {
        if (!this.fontStack.isEmpty()) {
            this.closeCharacterTags((WmiGenericAttributeSet)this.fontStack.pop());
        }
    }

    public void startFontDefinition(WmiGenericAttributeSet fontAttr) throws IOException {
        this.openCharacterTags(fontAttr);
        this.fontStack.push(fontAttr);
    }

    @Override
    public boolean ignoreHiddenModels() {
        return true;
    }

    @Override
    public boolean canSetEncoder() {
        return true;
    }

    @Override
    protected int format() throws WmiFormatException, WmiNoReadAccessException {
        int oldZoom = 100;
        WmiModel model = this.getRootModel();
        if (this.docView != null) {
            oldZoom = this.docView.getZoomFactor();
            this.docView.setTemporaryZoomFactor(133);
        }
        int result = -1;
        try {
            try {
                this.preFormat();
                this.processModel(model);
                this.postFormat();
                this.flushBuffer();
                result = 0;
            }
            catch (IOException ioE) {
                this.throwFormatException(ioE);
                if (this.docView != null) {
                    this.docView.setTemporaryZoomFactor(oldZoom);
                }
            }
        }
        finally {
            if (this.docView != null) {
                this.docView.setTemporaryZoomFactor(oldZoom);
            }
        }
        return result;
    }

    @Override
    protected void beginFormat(Writer writer, WmiModel model) throws WmiNoReadAccessException, WmiFormatException {
        if (this.docView != null && this.docView.getModel().getDocument() != model.getDocument()) {
            throw new IllegalArgumentException("Model must be part ofthe same hierarchy as the MathDocumentView used forformatter initialization.");
        }
        super.beginFormat(writer, model);
    }

    @Override
    protected String transformForTextOutput(String unicodeText) {
        StringBuffer buffy = new StringBuffer();
        AbstractStringEncoder encoder = this.getEncoder();
        int i = 0;
        while (i < unicodeText.length()) {
            char ch = unicodeText.charAt(i);
            if (encoder.canEncodeCharacter(ch)) {
                String encodedChar = encoder.fromUnicode(Character.toString(ch));
                buffy.append(encodedChar);
            } else {
                buffy.append(ESCAPE_SEQUENCE_START);
                buffy.append((int)ch);
                buffy.append(ESCAPE_SEQUENCE_END);
            }
            ++i;
        }
        String encoded = buffy.toString();
        buffy = new StringBuffer();
        WmiHTMLFormatter.makeHTMLSafe(encoded, buffy);
        return buffy.toString();
    }

    @Override
    public void writeAttribute(Object key, Object value) throws IOException {
        if (key != null && value != null) {
            this.writeBinary(" ");
            this.writeText(key.toString());
            this.writeBinary("=\"");
            this.writeText(WmiHTMLFormatter.translateAttribute(value));
            this.writeBinary("\"");
        }
    }

    @Override
    public void writeMathModel(WmiMathModel math) throws WmiNoReadAccessException, IOException {
        try {
            if (this.docView != null) {
                WmiView view = this.modelToView(math, this.docView);
                if (view instanceof WmiPositionedView) {
                    WmiPositionedView mathView = (WmiPositionedView)view;
                    int mathWidth = mathView.getWidth();
                    if (mathWidth > WmiHTMLFormatter.getMaxWidth()) {
                        WmiCompositeModel paragraph = math.getParent();
                        WmiMathExportParagraphView parentView = new WmiMathExportParagraphView((WmiModel)paragraph, this.docView, WmiHTMLFormatter.getMaxWidth());
                        this.formatLinebrokenMathView(parentView, this.getAltText(math));
                        parentView.release();
                    } else {
                        this.exportPositionedView(mathView, new WmiRenderPath(this.docView), this.getAltText(math));
                    }
                }
                if (view != null) {
                    view.release();
                }
            }
        }
        catch (WmiCancelException ce) {
            this.cancelExport();
        }
    }

    @Override
    public void writeTextModel(WmiTextModel text) throws WmiNoReadAccessException, IOException {
        if (text.getLength() > 0) {
            this.nestFontTags(text);
        }
    }

    @Override
    public void writeGraphic(WmiModel model) throws WmiNoReadAccessException, IOException {
        try {
            if (this.docView != null) {
                WmiView view = this.modelToView(model, this.docView);
                if (view instanceof WmiResizableContainerView) {
                    this.exportPositionedView((WmiResizableContainerView)view, new WmiRenderPath(this.docView), model.getTag().toString());
                }
                if (view != null) {
                    view.release();
                }
            }
        }
        catch (WmiCancelException ce) {
            this.cancelExport();
        }
    }

    public static class WmiCancelException
    extends Exception {
    }
}

