/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.html;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportAction;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.html.WmiHTMLFormatter;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import java.io.IOException;

public class WmiHTMLParagraphExportAction
implements WmiExportAction {
    private static final String HTML_ALIGNMENT_CENTRED = "center";

    @Override
    public void openModel(WmiExportFormatter formatter, WmiModel model) throws WmiNoReadAccessException, IOException {
        if (formatter != null && model != null) {
            Object bullet;
            formatter.openCompositeModel(model.getTag());
            WmiAttributeSet attrs = model.getAttributesForRead();
            Object alignment = null;
            if (attrs != null && "centred".equals(alignment = attrs.getAttribute("alignment"))) {
                alignment = HTML_ALIGNMENT_CENTRED;
            }
            formatter.writeBinary("<p");
            if (alignment != null) {
                formatter.writeBinary(" align=\"" + alignment + "\"");
            }
            formatter.writeBinary(">");
            if (attrs != null && (bullet = attrs.getAttribute("bullet")) != null && !"none".equals(bullet)) {
                formatter.writeBinary("<ul><li>");
            }
        }
    }

    @Override
    public void closeModel(WmiExportFormatter formatter, WmiModel model) throws WmiNoReadAccessException, IOException {
        if (formatter != null && model != null) {
            Object bullet;
            WmiAttributeSet attrs;
            if (formatter instanceof WmiHTMLFormatter) {
                ((WmiHTMLFormatter)formatter).clearFontStack();
            }
            if ((attrs = model.getAttributesForRead()) != null && (bullet = attrs.getAttribute("bullet")) != null && !"none".equals(bullet)) {
                formatter.writeBinary("</li></ul>");
            }
            formatter.writeBinary("&nbsp;");
            formatter.writeBinary("</p>\n");
            formatter.closeCompositeModel(model.getTag());
        }
    }

    @Override
    public boolean processChildModels() {
        return true;
    }
}

